/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.cp;

import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.BeanBuilder;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.commons.collections.FluentMap;
import org.apache.juneau.commons.function.Tuple2;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.ResourceBundleUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.marshaller.Json5;
import org.apache.juneau.parser.ParseException;

public class Messages
extends ResourceBundle {
    private ResourceBundle rb;
    private Class<?> c;
    private Messages parent;
    private Locale locale;
    private final ConcurrentHashMap<Locale, Messages> localizedMessages = new ConcurrentHashMap();
    private final Map<String, String> keyMap;
    private final Set<String> rbKeys;

    public static final Builder create(Class<?> forClass) {
        return new Builder(forClass);
    }

    public static final Messages of(Class<?> forClass) {
        return (Messages)Messages.create(forClass).build();
    }

    public static final Messages of(Class<?> forClass, String name) {
        return (Messages)Messages.create(forClass).name(name).build();
    }

    protected Messages(Builder builder) {
        this(builder.forClass, builder.getBundle(), builder.locale, builder.parent);
    }

    Messages(Class<?> forClass, ResourceBundle rb, Locale locale, Messages parent) {
        this.c = forClass;
        this.rb = rb;
        this.parent = parent;
        if (Utils.nn(parent)) {
            this.setParent(parent);
        }
        this.locale = locale == null ? Locale.getDefault() : locale;
        TreeMap keyMap = new TreeMap();
        String cn = Utils.cns(this.c) + ".";
        if (Utils.nn(rb)) {
            rb.keySet().forEach(x -> {
                keyMap.put(x, x);
                if (x.startsWith(cn)) {
                    String shortKey = x.substring(cn.length());
                    keyMap.put(shortKey, x);
                }
            });
        }
        if (Utils.nn(parent)) {
            parent.keySet().forEach(x -> {
                keyMap.put(x, x);
                if (x.startsWith(cn)) {
                    String shortKey = x.substring(cn.length());
                    keyMap.put(shortKey, x);
                }
            });
        }
        this.keyMap = CollectionUtils.u(CollectionUtils.copyOf(keyMap));
        this.rbKeys = rb == null ? Collections.emptySet() : rb.keySet();
    }

    @Override
    public boolean containsKey(String key) {
        return this.keyMap.containsKey(key);
    }

    public String findFirstString(String ... keys) {
        for (String k : keys) {
            if (!this.containsKey(k)) continue;
            return this.getString(k);
        }
        return null;
    }

    public Messages forLocale(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (this.locale.equals(locale)) {
            return this;
        }
        Messages mb = this.localizedMessages.get(locale);
        if (mb == null) {
            Messages parent = this.parent == null ? null : this.parent.forLocale(locale);
            ResourceBundle rb = this.rb == null ? null : ResourceBundleUtils.findBundle(this.rb.getBaseBundleName(), locale, this.c.getClassLoader());
            mb = new Messages(this.c, rb, locale, parent);
            this.localizedMessages.put(locale, mb);
        }
        return mb;
    }

    @Override
    public Enumeration<String> getKeys() {
        return Collections.enumeration(this.keySet());
    }

    public String getString(String key, Object ... args) {
        String s = this.getString(key);
        if (s.startsWith("{!")) {
            return s;
        }
        return Utils.f(s, args);
    }

    @Override
    public Set<String> keySet() {
        return this.keyMap.keySet();
    }

    public Set<String> keySet(String prefix) {
        LinkedHashSet<String> set = CollectionUtils.set(new String[0]);
        this.keySet().forEach(x -> {
            if (x.equals(prefix) || x.startsWith(prefix) && x.charAt(prefix.length()) == '.') {
                set.add((String)x);
            }
        });
        return set;
    }

    protected FluentMap<String, Object> properties() {
        FluentMap<String, Object> m = CollectionUtils.filteredBeanPropertyMap();
        this.keySet().stream().forEach(x -> m.a((String)x, this.getString((String)x)));
        return m;
    }

    public String toString() {
        return Utils.r(this.properties());
    }

    @Override
    protected Object handleGetObject(String key) {
        String k = this.keyMap.get(key);
        if (k == null) {
            return "{!" + key + "}";
        }
        try {
            if (this.rbKeys.contains(k)) {
                return this.rb.getObject(k);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return this.parent.handleGetObject(key);
    }

    public static class Builder
    extends BeanBuilder<Messages> {
        Class<?> forClass;
        Locale locale;
        String name;
        Messages parent;
        List<Tuple2<Class<?>, String>> locations;
        private String[] baseNames = new String[]{"{package}.{name}", "{package}.i18n.{name}", "{package}.nls.{name}", "{package}.messages.{name}"};

        protected Builder(Class<?> forClass) {
            super(Messages.class, BeanStore.INSTANCE);
            this.forClass = forClass;
            this.name = Utils.cns(forClass);
            this.locations = CollectionUtils.list(new Tuple2[0]);
            this.locale = Locale.getDefault();
        }

        public Builder baseNames(String ... baseNames) {
            this.baseNames = baseNames == null ? CollectionUtils.a(new String[0]) : baseNames;
            return this;
        }

        public Builder impl(Object value) {
            super.impl(value);
            return this;
        }

        public Builder locale(Locale value) {
            this.locale = value == null ? Locale.getDefault() : value;
            return this;
        }

        public Builder locale(String value) {
            return this.locale(value == null ? null : Locale.forLanguageTag(value));
        }

        public Builder location(Class<?> baseClass, String bundlePath) {
            this.locations.add(0, Tuple2.of(baseClass, bundlePath));
            return this;
        }

        public Builder location(String bundlePath) {
            this.locations.add(0, Tuple2.of(this.forClass, bundlePath));
            return this;
        }

        public Builder name(String value) {
            this.name = StringUtils.isEmpty(value) ? Utils.cns(this.forClass) : value;
            return this;
        }

        public Builder parent(Messages value) {
            this.parent = value;
            return this;
        }

        public Builder type(Class<?> value) {
            super.type(value);
            return this;
        }

        @Override
        protected Messages buildDefault() {
            if (!this.locations.isEmpty()) {
                Tuple2[] mbl = this.locations.toArray(new Tuple2[0]);
                Builder x = null;
                for (int i = mbl.length - 1; i >= 0; --i) {
                    Class c = Utils.firstNonNull((Class)mbl[i].getA(), this.forClass);
                    String value = (String)mbl[i].getB();
                    if (StringUtils.isProbablyJsonObject(value, true)) {
                        MessagesString ms;
                        try {
                            ms = Json5.DEFAULT.read(value, MessagesString.class);
                        }
                        catch (ParseException e) {
                            throw ThrowableUtils.toRex(e);
                        }
                        x = Messages.create(c).name(ms.name).baseNames(StringUtils.splita(ms.baseNames, ',')).locale(ms.locale).parent(x == null ? null : (Messages)x.build());
                        continue;
                    }
                    x = Messages.create(c).name(value).parent(x == null ? null : (Messages)x.build());
                }
                return x == null ? null : (Messages)x.build();
            }
            return new Messages(this);
        }

        ResourceBundle getBundle() {
            ClassLoader cl = this.forClass.getClassLoader();
            JsonMap m = JsonMap.of(new Object[]{"name", this.name, "package", this.forClass.getPackage().getName()});
            for (String bn : this.baseNames) {
                ResourceBundle rb = ResourceBundleUtils.findBundle(bn = StringUtils.formatNamed(bn, m), this.locale, cl);
                if (!Utils.nn(rb)) continue;
                return rb;
            }
            return null;
        }

        private static class MessagesString {
            public String name;
            public String[] baseNames;
            public String locale;

            private MessagesString() {
            }
        }
    }
}

