/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.assignor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.group.api.assignor.GroupAssignment;
import org.apache.kafka.coordinator.group.api.assignor.GroupSpec;
import org.apache.kafka.coordinator.group.api.assignor.PartitionAssignorException;
import org.apache.kafka.coordinator.group.api.assignor.SubscribedTopicDescriber;
import org.apache.kafka.coordinator.group.assignor.AssignorHelpers;
import org.apache.kafka.coordinator.group.modern.MemberAssignmentImpl;
import org.apache.kafka.server.common.TopicIdPartition;

public class SimpleHomogeneousAssignmentBuilder {
    private final Set<Uuid> subscribedTopicIds;
    private final List<String> memberIds;
    private final Map<String, Integer> memberIndices;
    private final List<TopicIdPartition> targetPartitions;
    private final int numGroupMembers;
    private final int desiredSharing;
    private final int[] desiredAssignmentCount;
    private final Map<Integer, Map<Uuid, Set<Integer>>> oldGroupAssignment;
    private final Map<Integer, Map<Uuid, Set<Integer>>> newGroupAssignment;
    private final Map<TopicIdPartition, Set<Integer>> finalAssignmentByPartition;
    private final Map<Integer, Set<TopicIdPartition>> finalAssignmentByMember;
    private final Set<Integer> unfilledMembers;
    private final Set<Integer> overfilledMembers;

    public SimpleHomogeneousAssignmentBuilder(GroupSpec groupSpec, SubscribedTopicDescriber subscribedTopicDescriber) {
        this.subscribedTopicIds = groupSpec.memberSubscription((String)groupSpec.memberIds().iterator().next()).subscribedTopicIds();
        this.numGroupMembers = groupSpec.memberIds().size();
        this.memberIds = new ArrayList<String>(groupSpec.memberIds());
        this.memberIndices = AssignorHelpers.newHashMap(this.numGroupMembers);
        for (int memberIndex = 0; memberIndex < this.numGroupMembers; ++memberIndex) {
            this.memberIndices.put(this.memberIds.get(memberIndex), memberIndex);
        }
        this.targetPartitions = SimpleHomogeneousAssignmentBuilder.computeTargetPartitions(groupSpec, this.subscribedTopicIds, subscribedTopicDescriber);
        int numTargetPartitions = this.targetPartitions.size();
        this.desiredSharing = numTargetPartitions == 0 ? 0 : (this.numGroupMembers + numTargetPartitions - 1) / numTargetPartitions;
        this.desiredAssignmentCount = new int[this.numGroupMembers];
        this.oldGroupAssignment = AssignorHelpers.newHashMap(this.numGroupMembers);
        this.newGroupAssignment = AssignorHelpers.newHashMap(this.numGroupMembers);
        this.finalAssignmentByPartition = AssignorHelpers.newHashMap(numTargetPartitions);
        this.finalAssignmentByMember = AssignorHelpers.newHashMap(this.numGroupMembers);
        this.unfilledMembers = AssignorHelpers.newHashSet(this.numGroupMembers);
        this.overfilledMembers = AssignorHelpers.newHashSet(this.numGroupMembers);
        groupSpec.memberIds().forEach(memberId -> {
            int memberIndex = this.memberIndices.get(memberId);
            this.oldGroupAssignment.put(memberIndex, groupSpec.memberAssignment(memberId).partitions());
        });
        double preciseDesiredAssignmentCount = (double)(this.desiredSharing * numTargetPartitions) / (double)this.numGroupMembers;
        for (int memberIndex = 0; memberIndex < this.numGroupMembers; ++memberIndex) {
            this.desiredAssignmentCount[memberIndex] = (int)Math.ceil(preciseDesiredAssignmentCount * (double)(memberIndex + 1)) - (int)Math.ceil(preciseDesiredAssignmentCount * (double)memberIndex);
        }
    }

    public GroupAssignment build() {
        if (this.subscribedTopicIds.isEmpty()) {
            return new GroupAssignment(Map.of());
        }
        this.revokeUnassignablePartitions();
        this.revokeOverfilledMembers();
        this.revokeOversharedPartitions();
        this.targetPartitions.forEach(topicPartition -> this.finalAssignmentByPartition.computeIfAbsent((TopicIdPartition)topicPartition, k -> new HashSet()));
        this.assignRemainingPartitions();
        HashMap<String, MemberAssignmentImpl> targetAssignment = AssignorHelpers.newHashMap(this.numGroupMembers);
        for (int memberIndex = 0; memberIndex < this.numGroupMembers; ++memberIndex) {
            Map<Uuid, Set<Integer>> memberAssignment = this.newGroupAssignment.get(memberIndex);
            if (memberAssignment == null) {
                targetAssignment.put(this.memberIds.get(memberIndex), new MemberAssignmentImpl(this.oldGroupAssignment.get(memberIndex)));
                continue;
            }
            targetAssignment.put(this.memberIds.get(memberIndex), new MemberAssignmentImpl(memberAssignment));
        }
        return new GroupAssignment(targetAssignment);
    }

    private void revokeUnassignablePartitions() {
        for (Map.Entry<Integer, Map<Uuid, Set<Integer>>> entry : this.oldGroupAssignment.entrySet()) {
            Integer memberIndex = entry.getKey();
            Map<Uuid, Set<Integer>> oldMemberAssignment = entry.getValue();
            Map<Uuid, Set<Integer>> newMemberAssignment = null;
            int memberAssignedPartitions = 0;
            int desiredAssignmentCountForMember = this.desiredAssignmentCount[memberIndex];
            for (Map.Entry<Uuid, Set<Integer>> oldMemberPartitions : oldMemberAssignment.entrySet()) {
                Uuid topicId = oldMemberPartitions.getKey();
                Set<Integer> assignedPartitions = oldMemberPartitions.getValue();
                if (this.subscribedTopicIds.contains(topicId)) {
                    for (int partition : assignedPartitions) {
                        TopicIdPartition topicPartition = new TopicIdPartition(topicId, partition);
                        this.finalAssignmentByPartition.computeIfAbsent(topicPartition, k -> new HashSet()).add(memberIndex);
                        this.finalAssignmentByMember.computeIfAbsent(memberIndex, k -> new HashSet()).add(topicPartition);
                        if (++memberAssignedPartitions < desiredAssignmentCountForMember || newMemberAssignment != null) continue;
                        newMemberAssignment = AssignorHelpers.deepCopyAssignment(oldMemberAssignment);
                    }
                    continue;
                }
                if (newMemberAssignment == null) {
                    newMemberAssignment = AssignorHelpers.deepCopyAssignment(oldMemberAssignment);
                }
                newMemberAssignment.remove(topicId);
            }
            if (newMemberAssignment != null) {
                this.newGroupAssignment.put(memberIndex, newMemberAssignment);
            }
            if (memberAssignedPartitions < desiredAssignmentCountForMember) {
                this.unfilledMembers.add(memberIndex);
                continue;
            }
            if (memberAssignedPartitions <= desiredAssignmentCountForMember) continue;
            this.overfilledMembers.add(memberIndex);
        }
    }

    private void revokeOverfilledMembers() {
        if (this.overfilledMembers.isEmpty()) {
            return;
        }
        this.overfilledMembers.forEach(memberIndex -> {
            int memberDesiredAssignmentCount = this.desiredAssignmentCount[memberIndex];
            Set<TopicIdPartition> memberFinalAssignment = this.finalAssignmentByMember.get(memberIndex);
            if (memberFinalAssignment.size() > memberDesiredAssignmentCount) {
                Iterator<TopicIdPartition> iterator = memberFinalAssignment.iterator();
                while (iterator.hasNext()) {
                    TopicIdPartition topicPartition = iterator.next();
                    this.newGroupAssignment.get(memberIndex).get(topicPartition.topicId()).remove(topicPartition.partitionId());
                    this.finalAssignmentByPartition.get(topicPartition).remove(memberIndex);
                    iterator.remove();
                    if (memberFinalAssignment.size() != memberDesiredAssignmentCount) continue;
                    break;
                }
            }
        });
    }

    private void revokeOversharedPartitions() {
        this.finalAssignmentByPartition.forEach((topicPartition, assignedMembers) -> {
            int assignedMemberCount = assignedMembers.size();
            if (assignedMemberCount > this.desiredSharing) {
                Iterator assignedMemberIterator = assignedMembers.iterator();
                while (assignedMemberIterator.hasNext()) {
                    Set<Integer> partitions;
                    Integer memberIndex = (Integer)assignedMemberIterator.next();
                    Map<Uuid, Set<Integer>> newMemberAssignment = this.newGroupAssignment.get(memberIndex);
                    if (newMemberAssignment == null) {
                        newMemberAssignment = AssignorHelpers.deepCopyAssignment(this.oldGroupAssignment.get(memberIndex));
                        this.newGroupAssignment.put(memberIndex, newMemberAssignment);
                    }
                    if ((partitions = newMemberAssignment.get(topicPartition.topicId())) != null && partitions.remove(topicPartition.partitionId())) {
                        --assignedMemberCount;
                        assignedMemberIterator.remove();
                        this.finalAssignmentByMember.get(memberIndex).remove(topicPartition);
                        this.unfilledMembers.add(memberIndex);
                    }
                    if (assignedMemberCount > this.desiredSharing) continue;
                    break;
                }
            }
        });
    }

    private void assignRemainingPartitions() {
        if (this.unfilledMembers.isEmpty()) {
            return;
        }
        Iterator<Integer> memberIterator = this.unfilledMembers.iterator();
        boolean partitionAssignedForThisIterator = false;
        for (Map.Entry<TopicIdPartition, Set<Integer>> partitionAssignment : this.finalAssignmentByPartition.entrySet()) {
            TopicIdPartition topicPartition = partitionAssignment.getKey();
            Set<Integer> membersAssigned = partitionAssignment.getValue();
            if (membersAssigned.size() < this.desiredSharing) {
                int assignmentsToMake = this.desiredSharing - membersAssigned.size();
                while (assignmentsToMake > 0) {
                    int memberIndex;
                    if (!memberIterator.hasNext()) {
                        if (!partitionAssignedForThisIterator) break;
                        memberIterator = this.unfilledMembers.iterator();
                        partitionAssignedForThisIterator = false;
                    }
                    if (membersAssigned.contains(memberIndex = memberIterator.next().intValue())) continue;
                    Map<Uuid, Set<Integer>> newMemberAssignment = this.newGroupAssignment.get(memberIndex);
                    if (newMemberAssignment == null) {
                        newMemberAssignment = AssignorHelpers.deepCopyAssignment(this.oldGroupAssignment.get(memberIndex));
                        this.newGroupAssignment.put(memberIndex, newMemberAssignment);
                    }
                    newMemberAssignment.computeIfAbsent(topicPartition.topicId(), k -> new HashSet()).add(topicPartition.partitionId());
                    this.finalAssignmentByMember.computeIfAbsent(memberIndex, k -> new HashSet()).add(topicPartition);
                    --assignmentsToMake;
                    partitionAssignedForThisIterator = true;
                    if (this.finalAssignmentByMember.get(memberIndex).size() < this.desiredAssignmentCount[memberIndex]) continue;
                    memberIterator.remove();
                }
            }
            if (!this.unfilledMembers.isEmpty()) continue;
            break;
        }
    }

    private static List<TopicIdPartition> computeTargetPartitions(GroupSpec groupSpec, Set<Uuid> subscribedTopicIds, SubscribedTopicDescriber subscribedTopicDescriber) {
        ArrayList<TopicIdPartition> targetPartitions = new ArrayList<TopicIdPartition>();
        subscribedTopicIds.forEach(topicId -> {
            int numPartitions = subscribedTopicDescriber.numPartitions(topicId);
            if (numPartitions == -1) {
                throw new PartitionAssignorException("Members are subscribed to topic " + String.valueOf(topicId) + " which doesn't exist in the topic metadata.");
            }
            for (int partition = 0; partition < numPartitions; ++partition) {
                if (!groupSpec.isPartitionAssignable(topicId, partition)) continue;
                targetPartitions.add(new TopicIdPartition(topicId, partition));
            }
        });
        return targetPartitions;
    }
}

