/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.modern.share;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.common.runtime.CoordinatorMetadataImage;
import org.apache.kafka.coordinator.group.modern.Assignment;
import org.apache.kafka.coordinator.group.modern.MemberState;
import org.apache.kafka.coordinator.group.modern.TopicIds;
import org.apache.kafka.coordinator.group.modern.share.ShareGroupMember;

public class ShareGroupAssignmentBuilder {
    private final ShareGroupMember member;
    private CoordinatorMetadataImage metadataImage = CoordinatorMetadataImage.EMPTY;
    private int targetAssignmentEpoch;
    private Assignment targetAssignment;
    private boolean hasSubscriptionChanged;

    public ShareGroupAssignmentBuilder(ShareGroupMember member) {
        this.member = Objects.requireNonNull(member);
    }

    public ShareGroupAssignmentBuilder withMetadataImage(CoordinatorMetadataImage metadataImage) {
        this.metadataImage = metadataImage;
        return this;
    }

    public ShareGroupAssignmentBuilder withTargetAssignment(int targetAssignmentEpoch, Assignment targetAssignment) {
        this.targetAssignmentEpoch = targetAssignmentEpoch;
        this.targetAssignment = Objects.requireNonNull(targetAssignment);
        return this;
    }

    public ShareGroupAssignmentBuilder withHasSubscriptionChanged(boolean hasSubscriptionChanged) {
        this.hasSubscriptionChanged = hasSubscriptionChanged;
        return this;
    }

    public ShareGroupMember build() {
        if (this.targetAssignmentEpoch != this.member.memberEpoch()) {
            return new ShareGroupMember.Builder(this.member).setState(MemberState.STABLE).setAssignedPartitions(this.filterAssignedPartitions(this.targetAssignment.partitions(), this.member.subscribedTopicNames())).updateMemberEpoch(this.targetAssignmentEpoch).build();
        }
        if (this.hasSubscriptionChanged) {
            return new ShareGroupMember.Builder(this.member).setAssignedPartitions(this.filterAssignedPartitions(this.targetAssignment.partitions(), this.member.subscribedTopicNames())).build();
        }
        return this.member;
    }

    private Map<Uuid, Set<Integer>> filterAssignedPartitions(Map<Uuid, Set<Integer>> partitions, Set<String> subscribedTopicNames) {
        TopicIds subscribedTopicIds = new TopicIds(subscribedTopicNames, this.metadataImage);
        Map<Uuid, Set<Integer>> filteredPartitions = partitions;
        for (Map.Entry<Uuid, Set<Integer>> entry : partitions.entrySet()) {
            if (subscribedTopicIds.contains(entry.getKey())) continue;
            if (filteredPartitions == partitions) {
                filteredPartitions = new HashMap<Uuid, Set<Integer>>(partitions);
            }
            filteredPartitions.remove(entry.getKey());
        }
        return filteredPartitions;
    }
}

