/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.streams.assignor;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.coordinator.group.streams.assignor.TaskAssignorException;
import org.apache.kafka.coordinator.group.streams.assignor.TaskId;

public class ProcessState {
    private final String processId;
    private int capacity;
    private double load;
    private int taskCount;
    private final Map<String, Integer> memberToTaskCounts;
    private final Map<String, Set<TaskId>> assignedActiveTasks;
    private final Map<String, Set<TaskId>> assignedStandbyTasks;
    private final Set<TaskId> assignedTasks;
    private PriorityQueue<Map.Entry<String, Integer>> membersByLoad;

    ProcessState(String processId) {
        this.processId = processId;
        this.capacity = 0;
        this.load = Double.MAX_VALUE;
        this.assignedTasks = new HashSet<TaskId>();
        this.assignedActiveTasks = new HashMap<String, Set<TaskId>>();
        this.assignedStandbyTasks = new HashMap<String, Set<TaskId>>();
        this.memberToTaskCounts = new HashMap<String, Integer>();
        this.membersByLoad = null;
    }

    public String processId() {
        return this.processId;
    }

    public int capacity() {
        return this.capacity;
    }

    public double load() {
        return this.load;
    }

    public Map<String, Integer> memberToTaskCounts() {
        return this.memberToTaskCounts;
    }

    public Set<TaskId> assignedActiveTasks() {
        return this.assignedActiveTasks.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public Map<String, Set<TaskId>> assignedActiveTasksByMember() {
        return this.assignedActiveTasks;
    }

    public Set<TaskId> assignedStandbyTasks() {
        return this.assignedStandbyTasks.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public Map<String, Set<TaskId>> assignedStandbyTasksByMember() {
        return this.assignedStandbyTasks;
    }

    public int addTask(String memberId, TaskId taskId, boolean isActive) {
        int newTaskCount = this.addTaskInternal(memberId, taskId, isActive);
        this.membersByLoad = null;
        return newTaskCount;
    }

    private int addTaskInternal(String memberId, TaskId taskId, boolean isActive) {
        ++this.taskCount;
        this.assignedTasks.add(taskId);
        if (isActive) {
            this.assignedActiveTasks.putIfAbsent(memberId, new HashSet());
            this.assignedActiveTasks.get(memberId).add(taskId);
        } else {
            this.assignedStandbyTasks.putIfAbsent(memberId, new HashSet());
            this.assignedStandbyTasks.get(memberId).add(taskId);
        }
        int newTaskCount = this.memberToTaskCounts.get(memberId) + 1;
        this.memberToTaskCounts.put(memberId, newTaskCount);
        this.computeLoad();
        return newTaskCount;
    }

    public int addTaskToLeastLoadedMember(TaskId taskId, boolean isActive) {
        Map.Entry<String, Integer> member;
        if (this.memberToTaskCounts.isEmpty()) {
            return -1;
        }
        if (this.memberToTaskCounts.size() == 1) {
            return this.addTaskInternal(this.memberToTaskCounts.keySet().iterator().next(), taskId, isActive);
        }
        if (this.membersByLoad == null) {
            this.membersByLoad = new PriorityQueue(this.memberToTaskCounts.size(), Map.Entry.comparingByValue());
            for (Map.Entry<String, Integer> entry : this.memberToTaskCounts.entrySet()) {
                this.membersByLoad.add(new AbstractMap.SimpleEntry<String, Integer>(entry.getKey(), entry.getValue()));
            }
        }
        if ((member = this.membersByLoad.poll()) != null) {
            int newTaskCount = this.addTaskInternal(member.getKey(), taskId, isActive);
            member.setValue(newTaskCount);
            this.membersByLoad.add(member);
            return newTaskCount;
        }
        throw new TaskAssignorException("No members available to assign task " + String.valueOf(taskId));
    }

    private void incrementCapacity() {
        ++this.capacity;
        this.computeLoad();
    }

    public void computeLoad() {
        this.load = this.capacity <= 0 ? -1.0 : (double)this.taskCount / (double)this.capacity;
    }

    public void addMember(String member) {
        this.memberToTaskCounts.put(member, 0);
        this.incrementCapacity();
    }

    public boolean hasCapacity() {
        return this.load < 1.0;
    }

    public int compareTo(ProcessState other) {
        int loadCompare = Double.compare(this.load, other.load());
        if (loadCompare == 0) {
            return Integer.compare(other.capacity, this.capacity);
        }
        return loadCompare;
    }

    public boolean hasTask(TaskId taskId) {
        return this.assignedTasks.contains(taskId);
    }

    Set<TaskId> assignedTasks() {
        return this.assignedTasks;
    }
}

