/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigTransformer;
import org.apache.kafka.common.config.provider.ConfigProvider;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.mirror.MirrorCheckpointConfig;
import org.apache.kafka.connect.mirror.MirrorClientConfig;
import org.apache.kafka.connect.mirror.MirrorHeartbeatConfig;
import org.apache.kafka.connect.mirror.MirrorSourceConfig;
import org.apache.kafka.connect.mirror.SourceAndTarget;
import org.apache.kafka.connect.runtime.isolation.Plugins;
import org.apache.kafka.connect.runtime.rest.RestServerConfig;

public final class MirrorMakerConfig
extends AbstractConfig {
    public static final String CLUSTERS_CONFIG = "clusters";
    private static final String CLUSTERS_DOC = "List of cluster aliases.";
    public static final String CONFIG_PROVIDERS_CONFIG = "config.providers";
    private static final String CONFIG_PROVIDERS_DOC = "Names of ConfigProviders to use.";
    private static final String NAME = "name";
    private static final String CONNECTOR_CLASS = "connector.class";
    private static final String SOURCE_CLUSTER_ALIAS = "source.cluster.alias";
    private static final String TARGET_CLUSTER_ALIAS = "target.cluster.alias";
    private static final String GROUP_ID_CONFIG = "group.id";
    private static final String KEY_CONVERTER_CLASS_CONFIG = "key.converter";
    private static final String VALUE_CONVERTER_CLASS_CONFIG = "value.converter";
    private static final String HEADER_CONVERTER_CLASS_CONFIG = "header.converter";
    private static final String BYTE_ARRAY_CONVERTER_CLASS = "org.apache.kafka.connect.converters.ByteArrayConverter";
    static final String SOURCE_CLUSTER_PREFIX = "source.cluster.";
    static final String TARGET_CLUSTER_PREFIX = "target.cluster.";
    static final String SOURCE_PREFIX = "source.";
    static final String TARGET_PREFIX = "target.";
    static final String ENABLE_INTERNAL_REST_CONFIG = "dedicated.mode.enable.internal.rest";
    private static final String ENABLE_INTERNAL_REST_DOC = "Whether to bring up an internal-only REST server that allows multi-node clusters to operate correctly.";
    private final Plugins plugins = new Plugins(this.originalsStrings());
    private final Map<String, String> rawProperties;

    public MirrorMakerConfig(Map<String, String> props) {
        super(MirrorMakerConfig.config(), props, true);
        this.rawProperties = new HashMap<String, String>(props);
    }

    public Set<String> clusters() {
        return new HashSet<String>(this.getList(CLUSTERS_CONFIG));
    }

    public boolean enableInternalRest() {
        return this.getBoolean(ENABLE_INTERNAL_REST_CONFIG);
    }

    public List<SourceAndTarget> clusterPairs() {
        ArrayList<SourceAndTarget> pairs = new ArrayList<SourceAndTarget>();
        Set<String> clusters = this.clusters();
        Map originalStrings = this.originalsStrings();
        boolean globalHeartbeatsEnabled = true;
        if (originalStrings.containsKey("emit.heartbeats.enabled")) {
            globalHeartbeatsEnabled = Boolean.parseBoolean((String)originalStrings.get("emit.heartbeats.enabled"));
        }
        for (String source : clusters) {
            for (String target : clusters) {
                if (source.equals(target)) continue;
                String clusterPairConfigPrefix = source + "->" + target + ".";
                boolean clusterPairEnabled = Boolean.parseBoolean((String)originalStrings.get(clusterPairConfigPrefix + "enabled"));
                boolean clusterPairHeartbeatsEnabled = globalHeartbeatsEnabled;
                if (originalStrings.containsKey(clusterPairConfigPrefix + "emit.heartbeats.enabled")) {
                    clusterPairHeartbeatsEnabled = Boolean.parseBoolean((String)originalStrings.get(clusterPairConfigPrefix + "emit.heartbeats.enabled"));
                }
                if (!clusterPairEnabled && !clusterPairHeartbeatsEnabled) continue;
                pairs.add(new SourceAndTarget(source, target));
            }
        }
        return pairs;
    }

    public MirrorClientConfig clientConfig(String cluster) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.putAll(this.originalsStrings());
        props.putAll(this.clusterProps(cluster));
        return new MirrorClientConfig(this.transform(props));
    }

    Map<String, String> clusterProps(String cluster) {
        String v;
        HashMap<String, String> props = new HashMap<String, String>();
        props.putAll(this.stringsWithPrefixStripped(cluster + "."));
        for (String k : MirrorClientConfig.CLIENT_CONFIG_DEF.names()) {
            v = (String)props.get(k);
            if (v == null) continue;
            props.putIfAbsent("producer." + k, v);
            props.putIfAbsent("consumer." + k, v);
            props.putIfAbsent("admin." + k, v);
        }
        for (String k : MirrorClientConfig.CLIENT_CONFIG_DEF.names()) {
            v = this.rawProperties.get(k);
            if (v == null) continue;
            props.putIfAbsent("producer." + k, v);
            props.putIfAbsent("consumer." + k, v);
            props.putIfAbsent("admin." + k, v);
            props.putIfAbsent(k, v);
        }
        return props;
    }

    public Map<String, String> workerConfig(SourceAndTarget sourceAndTarget) {
        Map<String, String> props = new HashMap<String, String>();
        props.putAll(this.clusterProps(sourceAndTarget.target()));
        props.putAll(this.stringsWithPrefix("offset.storage"));
        props.putAll(this.stringsWithPrefix("config.storage"));
        props.putAll(this.stringsWithPrefix("status.storage"));
        props.putAll(this.stringsWithPrefix(KEY_CONVERTER_CLASS_CONFIG));
        props.putAll(this.stringsWithPrefix(VALUE_CONVERTER_CLASS_CONFIG));
        props.putAll(this.stringsWithPrefix(HEADER_CONVERTER_CLASS_CONFIG));
        props.putAll(this.stringsWithPrefix("task"));
        props.putAll(this.stringsWithPrefix("worker"));
        props.putAll(this.stringsWithPrefix("replication.policy"));
        props = this.transform(props);
        props.putAll(this.stringsWithPrefix(CONFIG_PROVIDERS_CONFIG));
        props.putIfAbsent("client.id", sourceAndTarget.toString());
        props.putIfAbsent(GROUP_ID_CONFIG, sourceAndTarget.source() + "-mm2");
        props.putIfAbsent("offset.storage.topic", "mm2-offsets." + sourceAndTarget.source() + ".internal");
        props.putIfAbsent("status.storage.topic", "mm2-status." + sourceAndTarget.source() + ".internal");
        props.putIfAbsent("config.storage.topic", "mm2-configs." + sourceAndTarget.source() + ".internal");
        props.putIfAbsent(KEY_CONVERTER_CLASS_CONFIG, BYTE_ARRAY_CONVERTER_CLASS);
        props.putIfAbsent(VALUE_CONVERTER_CLASS_CONFIG, BYTE_ARRAY_CONVERTER_CLASS);
        props.putIfAbsent(HEADER_CONVERTER_CLASS_CONFIG, BYTE_ARRAY_CONVERTER_CLASS);
        return props;
    }

    Set<String> allConfigNames() {
        HashSet<String> allNames = new HashSet<String>();
        allNames.addAll(MirrorCheckpointConfig.CONNECTOR_CONFIG_DEF.names());
        allNames.addAll(MirrorSourceConfig.CONNECTOR_CONFIG_DEF.names());
        allNames.addAll(MirrorHeartbeatConfig.CONNECTOR_CONFIG_DEF.names());
        return allNames;
    }

    public Map<String, String> connectorBaseConfig(SourceAndTarget sourceAndTarget, Class<?> connectorClass) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.putAll(this.rawProperties);
        props.keySet().retainAll(this.allConfigNames());
        props.putAll(this.stringsWithPrefix(CONFIG_PROVIDERS_CONFIG));
        props.putAll(this.stringsWithPrefix("replication.policy"));
        Map<String, String> sourceClusterProps = this.clusterProps(sourceAndTarget.source());
        props.putAll(MirrorMakerConfig.clusterConfigsWithPrefix(SOURCE_CLUSTER_PREFIX, sourceClusterProps));
        props.putAll(MirrorMakerConfig.clientConfigsWithPrefix(SOURCE_PREFIX, sourceClusterProps));
        Map<String, String> targetClusterProps = this.clusterProps(sourceAndTarget.target());
        props.putAll(MirrorMakerConfig.clusterConfigsWithPrefix(TARGET_CLUSTER_PREFIX, targetClusterProps));
        props.putAll(MirrorMakerConfig.clientConfigsWithPrefix(TARGET_PREFIX, targetClusterProps));
        props.putIfAbsent(NAME, connectorClass.getSimpleName());
        props.putIfAbsent(CONNECTOR_CLASS, connectorClass.getName());
        props.putIfAbsent(SOURCE_CLUSTER_ALIAS, sourceAndTarget.source());
        props.putIfAbsent(TARGET_CLUSTER_ALIAS, sourceAndTarget.target());
        props.putAll(this.stringsWithPrefixStripped(sourceAndTarget.source() + "->" + sourceAndTarget.target() + "."));
        props.putIfAbsent("enabled", "false");
        return props;
    }

    List<String> configProviders() {
        return this.getList(CONFIG_PROVIDERS_CONFIG);
    }

    Map<String, String> transform(Map<String, String> props) {
        List<String> providerNames = this.configProviders();
        HashMap<String, ConfigProvider> providers = new HashMap<String, ConfigProvider>();
        for (String name : providerNames) {
            ConfigProvider configProvider = this.plugins.newConfigProvider((AbstractConfig)this, "config.providers." + name, Plugins.ClassLoaderUsage.PLUGINS);
            providers.put(name, configProvider);
        }
        ConfigTransformer transformer = new ConfigTransformer(providers);
        Map transformed = transformer.transform(props).data();
        providers.values().forEach(x -> Utils.closeQuietly((AutoCloseable)x, (String)"config provider"));
        return transformed;
    }

    private static ConfigDef config() {
        ConfigDef result = new ConfigDef().define(CLUSTERS_CONFIG, ConfigDef.Type.LIST, ConfigDef.NO_DEFAULT_VALUE, (ConfigDef.Validator)ConfigDef.ValidList.anyNonDuplicateValues((boolean)true, (boolean)false), ConfigDef.Importance.HIGH, CLUSTERS_DOC).define(ENABLE_INTERNAL_REST_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.HIGH, ENABLE_INTERNAL_REST_DOC).define(CONFIG_PROVIDERS_CONFIG, ConfigDef.Type.LIST, List.of(), (ConfigDef.Validator)ConfigDef.ValidList.anyNonDuplicateValues((boolean)true, (boolean)false), ConfigDef.Importance.LOW, CONFIG_PROVIDERS_DOC).define("security.protocol", ConfigDef.Type.STRING, (Object)"PLAINTEXT", (ConfigDef.Validator)ConfigDef.CaseInsensitiveValidString.in((String[])Utils.enumOptions(SecurityProtocol.class)), ConfigDef.Importance.MEDIUM, "Protocol used to communicate with brokers.").withClientSslSupport().withClientSaslSupport();
        RestServerConfig.addInternalConfig((ConfigDef)result);
        return result;
    }

    private Map<String, String> stringsWithPrefixStripped(String prefix) {
        return Utils.entriesWithPrefix(this.rawProperties, (String)prefix);
    }

    private Map<String, String> stringsWithPrefix(String prefix) {
        return Utils.entriesWithPrefix(this.rawProperties, (String)prefix, (boolean)false, (boolean)true);
    }

    static Map<String, String> clusterConfigsWithPrefix(String prefix, Map<String, String> props) {
        return props.entrySet().stream().filter(x -> !((String)x.getKey()).matches("(^consumer.*|^producer.*|^admin.*)")).collect(Collectors.toMap(x -> prefix + (String)x.getKey(), Map.Entry::getValue));
    }

    static Map<String, String> clientConfigsWithPrefix(String prefix, Map<String, String> props) {
        return props.entrySet().stream().filter(x -> ((String)x.getKey()).matches("(^consumer.*|^producer.*|^admin.*)")).collect(Collectors.toMap(x -> prefix + (String)x.getKey(), Map.Entry::getValue));
    }
}

