/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.kafka.clients.admin.AbortTransactionSpec;
import org.apache.kafka.clients.admin.internals.AdminApiHandler;
import org.apache.kafka.clients.admin.internals.AdminApiLookupStrategy;
import org.apache.kafka.clients.admin.internals.PartitionLeaderCache;
import org.apache.kafka.clients.admin.internals.PartitionLeaderStrategy;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.InvalidProducerEpochException;
import org.apache.kafka.common.errors.TransactionCoordinatorFencedException;
import org.apache.kafka.common.message.WriteTxnMarkersRequestData;
import org.apache.kafka.common.message.WriteTxnMarkersResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.requests.WriteTxnMarkersResponse;
import org.apache.kafka.common.utils.LogContext;
import org.slf4j.Logger;

public class AbortTransactionHandler
extends AdminApiHandler.Batched<TopicPartition, Void> {
    private final Logger log;
    private final AbortTransactionSpec abortSpec;
    private final PartitionLeaderStrategy lookupStrategy;

    public AbortTransactionHandler(AbortTransactionSpec abortSpec, LogContext logContext) {
        this.abortSpec = abortSpec;
        this.log = logContext.logger(AbortTransactionHandler.class);
        this.lookupStrategy = new PartitionLeaderStrategy(logContext);
    }

    public static PartitionLeaderStrategy.PartitionLeaderFuture<Void> newFuture(Set<TopicPartition> topicPartitions, PartitionLeaderCache partitionLeaderCache) {
        return new PartitionLeaderStrategy.PartitionLeaderFuture<Void>(topicPartitions, partitionLeaderCache);
    }

    @Override
    public String apiName() {
        return "abortTransaction";
    }

    @Override
    public AdminApiLookupStrategy<TopicPartition> lookupStrategy() {
        return this.lookupStrategy;
    }

    public WriteTxnMarkersRequest.Builder buildBatchedRequest(int brokerId, Set<TopicPartition> topicPartitions) {
        this.validateTopicPartitions(topicPartitions);
        WriteTxnMarkersRequestData.WritableTxnMarker marker = new WriteTxnMarkersRequestData.WritableTxnMarker().setCoordinatorEpoch(this.abortSpec.coordinatorEpoch()).setProducerEpoch(this.abortSpec.producerEpoch()).setProducerId(this.abortSpec.producerId()).setTransactionResult(false);
        marker.topics().add(new WriteTxnMarkersRequestData.WritableTxnMarkerTopic().setName(this.abortSpec.topicPartition().topic()).setPartitionIndexes(Collections.singletonList(this.abortSpec.topicPartition().partition())));
        WriteTxnMarkersRequestData request = new WriteTxnMarkersRequestData();
        request.markers().add(marker);
        return new WriteTxnMarkersRequest.Builder(request);
    }

    @Override
    public AdminApiHandler.ApiResult<TopicPartition, Void> handleResponse(Node broker, Set<TopicPartition> topicPartitions, AbstractResponse abstractResponse) {
        this.validateTopicPartitions(topicPartitions);
        WriteTxnMarkersResponse response = (WriteTxnMarkersResponse)abstractResponse;
        List<WriteTxnMarkersResponseData.WritableTxnMarkerResult> markerResponses = response.data().markers();
        if (markerResponses.size() != 1 || markerResponses.get(0).producerId() != this.abortSpec.producerId()) {
            return AdminApiHandler.ApiResult.failed(this.abortSpec.topicPartition(), new KafkaException("WriteTxnMarkers response included unexpected marker entries: " + String.valueOf(markerResponses) + "(expected to find exactly one entry with producerId " + this.abortSpec.producerId() + ")"));
        }
        WriteTxnMarkersResponseData.WritableTxnMarkerResult markerResponse = markerResponses.get(0);
        List<WriteTxnMarkersResponseData.WritableTxnMarkerTopicResult> topicResponses = markerResponse.topics();
        if (topicResponses.size() != 1 || !topicResponses.get(0).name().equals(this.abortSpec.topicPartition().topic())) {
            return AdminApiHandler.ApiResult.failed(this.abortSpec.topicPartition(), new KafkaException("WriteTxnMarkers response included unexpected topic entries: " + String.valueOf(markerResponses) + "(expected to find exactly one entry with topic partition " + String.valueOf(this.abortSpec.topicPartition()) + ")"));
        }
        WriteTxnMarkersResponseData.WritableTxnMarkerTopicResult topicResponse = topicResponses.get(0);
        List<WriteTxnMarkersResponseData.WritableTxnMarkerPartitionResult> partitionResponses = topicResponse.partitions();
        if (partitionResponses.size() != 1 || partitionResponses.get(0).partitionIndex() != this.abortSpec.topicPartition().partition()) {
            return AdminApiHandler.ApiResult.failed(this.abortSpec.topicPartition(), new KafkaException("WriteTxnMarkers response included unexpected partition entries for topic " + this.abortSpec.topicPartition().topic() + ": " + String.valueOf(markerResponses) + "(expected to find exactly one entry with partition " + this.abortSpec.topicPartition().partition() + ")"));
        }
        WriteTxnMarkersResponseData.WritableTxnMarkerPartitionResult partitionResponse = partitionResponses.get(0);
        Errors error = Errors.forCode(partitionResponse.errorCode());
        if (error != Errors.NONE) {
            return this.handleError(error);
        }
        return AdminApiHandler.ApiResult.completed(this.abortSpec.topicPartition(), null);
    }

    private AdminApiHandler.ApiResult<TopicPartition, Void> handleError(Errors error) {
        switch (error) {
            case CLUSTER_AUTHORIZATION_FAILED: {
                this.log.error("WriteTxnMarkers request for abort spec {} failed cluster authorization", (Object)this.abortSpec);
                return AdminApiHandler.ApiResult.failed(this.abortSpec.topicPartition(), new ClusterAuthorizationException("WriteTxnMarkers request with " + String.valueOf(this.abortSpec) + " failed due to cluster authorization error"));
            }
            case INVALID_PRODUCER_EPOCH: {
                this.log.error("WriteTxnMarkers request for abort spec {} failed due to an invalid producer epoch", (Object)this.abortSpec);
                return AdminApiHandler.ApiResult.failed(this.abortSpec.topicPartition(), new InvalidProducerEpochException("WriteTxnMarkers request with " + String.valueOf(this.abortSpec) + " failed due an invalid producer epoch"));
            }
            case TRANSACTION_COORDINATOR_FENCED: {
                this.log.error("WriteTxnMarkers request for abort spec {} failed because the coordinator epoch is fenced", (Object)this.abortSpec);
                return AdminApiHandler.ApiResult.failed(this.abortSpec.topicPartition(), new TransactionCoordinatorFencedException("WriteTxnMarkers request with " + String.valueOf(this.abortSpec) + " failed since the provided coordinator epoch " + this.abortSpec.coordinatorEpoch() + " has been fenced by the active coordinator"));
            }
            case NOT_LEADER_OR_FOLLOWER: 
            case REPLICA_NOT_AVAILABLE: 
            case BROKER_NOT_AVAILABLE: 
            case UNKNOWN_TOPIC_OR_PARTITION: {
                this.log.debug("WriteTxnMarkers request for abort spec {} failed due to {}. Will retry after attempting to find the leader again", (Object)this.abortSpec, (Object)error);
                return AdminApiHandler.ApiResult.unmapped(Collections.singletonList(this.abortSpec.topicPartition()));
            }
        }
        this.log.error("WriteTxnMarkers request for abort spec {} failed due to an unexpected error {}", (Object)this.abortSpec, (Object)error);
        return AdminApiHandler.ApiResult.failed(this.abortSpec.topicPartition(), error.exception("WriteTxnMarkers request with " + String.valueOf(this.abortSpec) + " failed due to unexpected error: " + error.message()));
    }

    private void validateTopicPartitions(Set<TopicPartition> topicPartitions) {
        if (!topicPartitions.equals(Collections.singleton(this.abortSpec.topicPartition()))) {
            throw new IllegalArgumentException("Received unexpected topic partitions " + String.valueOf(topicPartitions) + " (expected only " + String.valueOf(Collections.singleton(this.abortSpec.topicPartition())) + ")");
        }
    }
}

