/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.ArrayList;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.common.internals.ClusterResourceListeners;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.utils.LogContext;

public class ShareConsumerMetadata
extends Metadata {
    private final boolean allowAutoTopicCreation;
    private final SubscriptionState subscription;

    public ShareConsumerMetadata(long refreshBackoffMs, long refreshBackoffMaxMs, long metadataExpireMs, boolean allowAutoTopicCreation, SubscriptionState subscription, LogContext logContext, ClusterResourceListeners clusterResourceListeners) {
        super(refreshBackoffMs, refreshBackoffMaxMs, metadataExpireMs, logContext, clusterResourceListeners);
        this.allowAutoTopicCreation = allowAutoTopicCreation;
        this.subscription = subscription;
    }

    public ShareConsumerMetadata(ConsumerConfig config, SubscriptionState subscriptions, LogContext logContext, ClusterResourceListeners clusterResourceListeners) {
        this(config.getLong("retry.backoff.ms"), config.getLong("retry.backoff.max.ms"), config.getLong("metadata.max.age.ms"), config.getBoolean("allow.auto.create.topics"), subscriptions, logContext, clusterResourceListeners);
    }

    public boolean allowAutoTopicCreation() {
        return this.allowAutoTopicCreation;
    }

    @Override
    public synchronized MetadataRequest.Builder newMetadataRequestBuilder() {
        ArrayList<String> topics = new ArrayList<String>();
        topics.addAll(this.subscription.metadataTopics());
        return MetadataRequest.Builder.forTopicNames(topics, this.allowAutoTopicCreation);
    }

    @Override
    public synchronized boolean retainTopic(String topic, boolean isInternal, long nowMs) {
        return this.subscription.needsMetadata(topic);
    }
}

