/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import org.apache.kafka.common.message.AlterShareGroupOffsetsRequestData;
import org.apache.kafka.common.message.AlterShareGroupOffsetsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterShareGroupOffsetsResponse;

public class AlterShareGroupOffsetsRequest
extends AbstractRequest {
    private final AlterShareGroupOffsetsRequestData data;

    private AlterShareGroupOffsetsRequest(AlterShareGroupOffsetsRequestData data, short version) {
        super(ApiKeys.ALTER_SHARE_GROUP_OFFSETS, version);
        this.data = data;
    }

    @Override
    public AlterShareGroupOffsetsResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        return this.getErrorResponse(throttleTimeMs, Errors.forException(e));
    }

    public AlterShareGroupOffsetsResponse getErrorResponse(int throttleTimeMs, Errors error) {
        return this.getErrorResponse(throttleTimeMs, error.code(), error.message());
    }

    public AlterShareGroupOffsetsResponse getErrorResponse(int throttleTimeMs, short errorCode, String message) {
        return new AlterShareGroupOffsetsResponse(new AlterShareGroupOffsetsResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(errorCode).setErrorMessage(message));
    }

    public static AlterShareGroupOffsetsResponseData getErrorResponseData(Errors error) {
        return AlterShareGroupOffsetsRequest.getErrorResponseData(error, null);
    }

    public static AlterShareGroupOffsetsResponseData getErrorResponseData(Errors error, String errorMessage) {
        return new AlterShareGroupOffsetsResponseData().setErrorCode(error.code()).setErrorMessage(errorMessage == null ? error.message() : errorMessage);
    }

    public static AlterShareGroupOffsetsRequest parse(Readable readable, short version) {
        return new AlterShareGroupOffsetsRequest(new AlterShareGroupOffsetsRequestData(readable, version), version);
    }

    @Override
    public AlterShareGroupOffsetsRequestData data() {
        return this.data;
    }

    public static class Builder
    extends AbstractRequest.Builder<AlterShareGroupOffsetsRequest> {
        private final AlterShareGroupOffsetsRequestData data;

        public Builder(AlterShareGroupOffsetsRequestData data) {
            super(ApiKeys.ALTER_SHARE_GROUP_OFFSETS);
            this.data = data;
        }

        @Override
        public AlterShareGroupOffsetsRequest build(short version) {
            return new AlterShareGroupOffsetsRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

