/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.common.runtime;

import java.util.function.BiFunction;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.slf4j.Logger;

public class CoordinatorOperationExceptionHelper {
    public static <IN, OUT> OUT handleOperationException(String operationName, IN operationInput, Throwable exception, BiFunction<Errors, String, OUT> handler, Logger log) {
        ApiError apiError = ApiError.fromThrowable((Throwable)exception);
        return switch (apiError.error()) {
            case Errors.UNKNOWN_SERVER_ERROR -> {
                log.error("Operation {} with {} hit an unexpected exception: {}.", new Object[]{operationName, operationInput, exception.getMessage(), exception});
                yield handler.apply(Errors.UNKNOWN_SERVER_ERROR, null);
            }
            case Errors.NETWORK_EXCEPTION -> handler.apply(Errors.COORDINATOR_LOAD_IN_PROGRESS, null);
            case Errors.UNKNOWN_TOPIC_OR_PARTITION, Errors.NOT_ENOUGH_REPLICAS, Errors.REQUEST_TIMED_OUT -> handler.apply(Errors.COORDINATOR_NOT_AVAILABLE, null);
            case Errors.NOT_LEADER_OR_FOLLOWER, Errors.KAFKA_STORAGE_ERROR -> handler.apply(Errors.NOT_COORDINATOR, null);
            case Errors.MESSAGE_TOO_LARGE, Errors.RECORD_LIST_TOO_LARGE, Errors.INVALID_FETCH_SIZE -> handler.apply(Errors.UNKNOWN_SERVER_ERROR, null);
            default -> handler.apply(apiError.error(), apiError.message());
        };
    }
}

