/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.internals.UpgradeFromValues;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.WrappingNullableSerializer;
import org.apache.kafka.streams.processor.internals.SerdeGetter;

public class ChangedSerializer<T>
implements Serializer<Change<T>>,
WrappingNullableSerializer<Change<T>, Void, T> {
    private static final int ENCODING_FLAG_SIZE = 1;
    private static final int MAX_VARINT_LENGTH = 5;
    private Serializer<T> inner;
    private boolean isUpgrade;

    public ChangedSerializer(Serializer<T> inner) {
        this.inner = inner;
    }

    public Serializer<T> inner() {
        return this.inner;
    }

    @Override
    public void setIfUnset(SerdeGetter getter) {
        if (this.inner == null) {
            this.inner = getter.valueSerde().serializer();
        }
    }

    private static boolean isUpgrade(Map<String, ?> configs) {
        Object upgradeFrom = configs.get("upgrade.from");
        if (upgradeFrom == null) {
            return false;
        }
        switch (UpgradeFromValues.fromString((String)upgradeFrom)) {
            case UPGRADE_FROM_24: 
            case UPGRADE_FROM_25: 
            case UPGRADE_FROM_26: 
            case UPGRADE_FROM_27: 
            case UPGRADE_FROM_28: 
            case UPGRADE_FROM_30: 
            case UPGRADE_FROM_31: 
            case UPGRADE_FROM_32: 
            case UPGRADE_FROM_33: 
            case UPGRADE_FROM_34: {
                return true;
            }
        }
        return false;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.isUpgrade = ChangedSerializer.isUpgrade(configs);
    }

    public byte[] serialize(String topic, Headers headers, Change<T> data) {
        int oldDataLength;
        boolean oldValueIsNotNull = data.oldValue != null;
        boolean newValueIsNotNull = data.newValue != null;
        byte[] newData = this.inner.serialize(topic, headers, data.newValue);
        byte[] oldData = this.inner.serialize(topic, headers, data.oldValue);
        int newDataLength = newValueIsNotNull ? newData.length : 0;
        int n = oldDataLength = oldValueIsNotNull ? oldData.length : 0;
        if (newValueIsNotNull && oldValueIsNotNull) {
            if (this.isUpgrade) {
                throw new StreamsException("Both old and new values are not null (" + String.valueOf(data.oldValue) + " : " + String.valueOf(data.newValue) + ") in ChangeSerializer, which is not allowed unless upgrading.");
            }
            int capacity = 5 + newDataLength + oldDataLength + 1;
            ByteBuffer buf = ByteBuffer.allocate(capacity);
            ByteUtils.writeVarint((int)newDataLength, (ByteBuffer)buf);
            buf.put(newData).put(oldData).put((byte)2);
            byte[] serialized = new byte[buf.position()];
            buf.position(0);
            buf.get(serialized);
            return serialized;
        }
        if (newValueIsNotNull) {
            int capacity = newDataLength + 1;
            ByteBuffer buf = ByteBuffer.allocate(capacity);
            buf.put(newData).put((byte)1);
            return buf.array();
        }
        if (oldValueIsNotNull) {
            int capacity = oldDataLength + 1;
            ByteBuffer buf = ByteBuffer.allocate(capacity);
            buf.put(oldData).put((byte)0);
            return buf.array();
        }
        throw new StreamsException("Both old and new values are null in ChangeSerializer, which is not allowed.");
    }

    public byte[] serialize(String topic, Change<T> data) {
        return this.serialize(topic, null, data);
    }

    public void close() {
        this.inner.close();
    }
}

