/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi;

import aQute.bnd.build.Project;
import aQute.bnd.build.Workspace;
import aQute.bnd.exceptions.SupplierWithException;
import aQute.bnd.header.Attrs;
import aQute.bnd.header.Parameters;
import aQute.bnd.http.HttpClient;
import aQute.bnd.memoize.CloseableMemoize;
import aQute.bnd.memoize.Memoize;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.Resource;
import aQute.bnd.result.Result;
import aQute.bnd.service.Registry;
import aQute.bnd.service.RegistryDonePlugin;
import aQute.bnd.service.url.URLConnectionHandler;
import aQute.lib.hex.Hex;
import aQute.lib.io.IO;
import aQute.lib.strings.Strings;
import aQute.libg.cryptography.SHA1;
import java.io.File;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.URL;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.osgi.annotation.versioning.ProviderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginsContainer
extends AbstractSet<Object>
implements Set<Object>,
Registry {
    private static final Logger logger = LoggerFactory.getLogger(PluginsContainer.class);
    private static final MethodType defaultConstructor = MethodType.methodType(Void.TYPE);
    private final Set<Object> plugins = new CopyOnWriteArraySet<Object>();
    private final Set<String> missingCommand = new HashSet<String>();
    private final Set<AutoCloseable> closeablePlugins = new HashSet<AutoCloseable>();
    Processor processor;

    protected PluginsContainer() {
    }

    protected void init(Processor processor) {
        this.processor = processor;
        String spe = processor.getProperty("-plugin");
        if ("none".equals(spe)) {
            return;
        }
        this.add(processor);
        processor.setTypeSpecificPlugins(this);
        spe = processor.mergeLocalProperties("-plugin");
        String pluginPath = processor.mergeProperties("-pluginpath");
        this.loadPlugins(processor, spe, pluginPath);
    }

    protected void postInit(Processor processor) {
        processor.addExtensions(this);
        for (RegistryDonePlugin rdp : this.getPlugins(RegistryDonePlugin.class)) {
            try {
                rdp.done();
            }
            catch (Exception e) {
                processor.exception(e, "Calling done on %s, gives an exception", rdp);
            }
        }
    }

    protected Set<Object> plugins() {
        return this.plugins;
    }

    protected <T> Stream<T> stream(Class<T> type) {
        return StreamSupport.stream(this.spliterator(type), false);
    }

    protected <T> Spliterator<T> spliterator(Class<T> type) {
        return new PluginsSpliterator<T>(type);
    }

    @Override
    public <T> T getPlugin(Class<T> type) {
        Optional<Object> first = this.stream(type).findFirst();
        return first.orElse(null);
    }

    @Override
    public <T> List<T> getPlugins(Class<T> type) {
        List list = this.stream(type).distinct().collect(Collectors.toList());
        return list;
    }

    @Override
    public boolean add(Object plugin) {
        return this.plugins().add(plugin);
    }

    @Override
    public boolean addAll(Collection<? extends Object> collection) {
        return this.plugins().addAll(collection);
    }

    @Override
    public boolean remove(Object plugin) {
        return this.plugins().remove(plugin);
    }

    @Override
    public Iterator<Object> iterator() {
        return this.stream().iterator();
    }

    @Override
    public Spliterator<Object> spliterator() {
        return this.stream().spliterator();
    }

    @Override
    public Stream<Object> stream() {
        return this.stream(Object.class).distinct();
    }

    @Override
    public int size() {
        return this.plugins().size();
    }

    @Override
    public String toString() {
        return this.plugins().toString();
    }

    protected void loadPlugins(Processor processor, String pluginString, String pluginPathString) {
        Attrs attrs;
        String className;
        Parameters pluginParameters = new Parameters(pluginString, processor, true);
        Processor.CL loader = processor.getLoader();
        pluginParameters.stream().flatMapValue(v -> Strings.splitAsStream(v.get("path:"))).forEachOrdered((key, path) -> {
            try {
                File f = processor.getFile((String)path).getAbsoluteFile();
                loader.add(f);
            }
            catch (Exception e) {
                processor.exception(e, "Problem adding path %s to loader for plugin %s", path, Processor.removeDuplicateMarker(key));
            }
        });
        HashSet<String> loaded = new HashSet<String>();
        for (Map.Entry<String, Attrs> entry : pluginParameters.entrySet()) {
            className = Processor.removeDuplicateMarker(entry.getKey());
            attrs = entry.getValue();
            logger.debug("Trying pre-plugin {}", (Object)className);
            Object plugin = this.loadPlugin(processor, processor.getClass().getClassLoader(), attrs, className, true);
            if (plugin == null) continue;
            loaded.add(entry.getKey());
        }
        pluginParameters.keySet().removeAll(loaded);
        this.loadPluginPath(processor, pluginPathString, loader);
        for (Map.Entry<String, Attrs> entry : pluginParameters.entrySet()) {
            className = Processor.removeDuplicateMarker(entry.getKey());
            attrs = entry.getValue();
            logger.debug("Loading secondary plugin {}", (Object)className);
            String commands = attrs.get("command:");
            Object plugin = this.loadPlugin(processor, loader, attrs, className, commands != null);
            if (plugin != null) continue;
            Strings.splitAsStream(commands).forEach(this.missingCommand::add);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPluginPath(Processor processor, String pluginPath, Processor.CL loader) {
        CloseableMemoize<HttpClient> client = CloseableMemoize.closeableSupplier(SupplierWithException.asSupplier(() -> {
            HttpClient c = new HttpClient();
            c.setRegistry(this);
            c.readSettings(processor);
            this.getPlugins(URLConnectionHandler.class).forEach(c::addURLConnectionHandler);
            return c;
        }));
        Parameters pluginPathParameters = new Parameters(pluginPath, processor);
        try {
            for (Map.Entry<String, Attrs> entry : pluginPathParameters.entrySet()) {
                File f;
                block26: {
                    f = processor.getFile(entry.getKey()).getAbsoluteFile();
                    if (!f.isFile()) {
                        String url = entry.getValue().get("url");
                        if (url != null) {
                            try {
                                logger.debug("downloading {} to {}", (Object)url, (Object)f.getAbsoluteFile());
                                URL u = new URL(url);
                                IO.mkdirs(f.getParentFile());
                                try (Resource resource = Resource.fromURL(u, (HttpClient)client.get());){
                                    try (OutputStream out = IO.outputStream(f);){
                                        resource.write(out);
                                    }
                                    long lastModified = resource.lastModified();
                                    if (lastModified > 0L) {
                                        f.setLastModified(lastModified);
                                    }
                                }
                                String digest = entry.getValue().get("sha1");
                                if (digest == null) break block26;
                                if (Hex.isHex(digest.trim())) {
                                    byte[] filesha1;
                                    byte[] sha1 = Hex.toByteArray(digest);
                                    if (!Arrays.equals(sha1, filesha1 = SHA1.digest(f).digest())) {
                                        processor.error("Plugin path: %s, specified url %s and a sha1 but the file does not match the sha", entry.getKey(), url);
                                    }
                                } else {
                                    processor.error("Plugin path: %s, specified url %s and a sha1 '%s' but this is not a hexadecimal", entry.getKey(), url, digest);
                                }
                                break block26;
                            }
                            catch (Exception e) {
                                processor.exception(e, "Failed to download plugin %s from %s", entry.getKey(), url);
                                continue;
                            }
                        }
                        processor.error("No such file %s from %s and no 'url' attribute on the path so it can be downloaded", entry.getKey(), processor);
                        continue;
                    }
                }
                logger.debug("Adding {} to loader for plugins", (Object)f);
                loader.add(f);
            }
        }
        finally {
            IO.close(client);
        }
    }

    private Object loadPlugin(Processor processor, ClassLoader loader, Attrs attrs, String className, boolean ignoreError) {
        try {
            AbstractPlugin plugin;
            Class<?> c = loader.loadClass(className);
            if (c.isInterface()) {
                plugin = new AbstractPlugin(c, attrs);
            } else {
                plugin = MethodHandles.publicLookup().findConstructor(c, defaultConstructor).invoke();
                processor.customize(plugin, attrs, this);
            }
            this.add(plugin);
            if (plugin instanceof AutoCloseable) {
                this.closeablePlugins.add(plugin);
            }
            return plugin;
        }
        catch (NoClassDefFoundError e) {
            if (!ignoreError) {
                processor.exception(e, "Failed to load plugin %s;%s", className, attrs);
            }
        }
        catch (ClassNotFoundException e) {
            if (!ignoreError) {
                processor.exception(e, "Failed to load plugin %s;%s", className, attrs);
            }
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            processor.exception(e, "Unexpected error loading plugin %s-%s", className, attrs);
        }
        return null;
    }

    boolean isMissingPlugin(String name) {
        return this.missingCommand.contains(name);
    }

    protected void close() {
        this.closeablePlugins.forEach(IO::close);
        this.closeablePlugins.clear();
        this.plugins.clear();
        this.missingCommand.clear();
    }

    final class PluginsSpliterator<T>
    extends Spliterators.AbstractSpliterator<T>
    implements Consumer<Object> {
        private final Class<T> type;
        private final Spliterator<Object> self;
        private Spliterator<T> provider;
        private Spliterator<T> parent;
        private Object plugin;

        PluginsSpliterator(Class<T> type) {
            super(Long.MAX_VALUE, 1296);
            this.type = Objects.requireNonNull(type);
            this.self = PluginsContainer.this.plugins().spliterator();
            this.provider = Spliterators.emptySpliterator();
        }

        private Spliterator<T> parent() {
            Spliterator<T> spliterator = this.parent;
            if (spliterator != null) {
                return spliterator;
            }
            Processor parent = PluginsContainer.this.processor.getParent();
            this.parent = parent != null ? parent.getPlugins().spliterator(this.type) : Spliterators.emptySpliterator();
            return this.parent;
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            if (this.provider.tryAdvance(action)) {
                return true;
            }
            while (this.self.tryAdvance(this)) {
                boolean instance = this.type.isInstance(this.plugin);
                if (this.plugin instanceof PluginProvider) {
                    this.provider = ((PluginProvider)this.plugin).provide(this.type).spliterator();
                    if (!instance && this.provider.tryAdvance(action)) {
                        return true;
                    }
                }
                if (!instance) continue;
                Object p = this.plugin;
                action.accept(p);
                return true;
            }
            return this.parent().tryAdvance(action);
        }

        @Override
        public void forEachRemaining(Consumer<? super T> action) {
            this.provider.forEachRemaining(action);
            while (this.self.tryAdvance(this)) {
                if (this.type.isInstance(this.plugin)) {
                    Object p = this.plugin;
                    action.accept(p);
                }
                if (!(this.plugin instanceof PluginProvider)) continue;
                ((PluginProvider)this.plugin).provide(this.type).forEachOrdered(action);
            }
            this.parent().forEachRemaining(action);
        }

        @Override
        public void accept(Object plugin) {
            this.plugin = plugin;
        }
    }

    final class AbstractPlugin<T>
    implements PluginProvider,
    AutoCloseable {
        private final Class<T> serviceClass;
        private final Memoize<List<T>> externals;
        private final Attrs attrs;
        private volatile Workspace workspace;

        AbstractPlugin(Class<T> type, Attrs attrs) {
            this.serviceClass = type;
            this.attrs = attrs;
            this.workspace = PluginsContainer.this.processor instanceof Workspace ? (Workspace)PluginsContainer.this.processor : (PluginsContainer.this.processor instanceof Project ? ((Project)PluginsContainer.this.processor).getWorkspace() : null);
            this.externals = Memoize.supplier(() -> {
                Workspace ws = this.workspace;
                if (ws == null) {
                    return Collections.emptyList();
                }
                logger.debug("Loading external plugins {}", this.serviceClass);
                Result<List<T>> implementations = ws.getExternalPlugins().getImplementations(this.serviceClass, this.attrs);
                implementations.accept(ok -> ok.forEach(p -> {
                    logger.debug("Customizing external plugin {} with [{}]", p, (Object)this.attrs);
                    PluginsContainer.this.processor.customize(p, this.attrs, PluginsContainer.this);
                }), error -> {
                    logger.debug("Loading external plugins {} failed with error {}", this.serviceClass, error);
                    PluginsContainer.this.processor.error("Loading external plugins %s failed with error %s", this.serviceClass, error);
                });
                return implementations.orElseGet(Collections::emptyList);
            });
        }

        @Override
        public <X> Stream<X> provide(Class<X> type) {
            if (type.isAssignableFrom(this.serviceClass)) {
                Stream stream = this.externals.get().stream();
                return stream;
            }
            return Stream.empty();
        }

        @Override
        public void close() throws Exception {
            this.workspace = null;
            this.externals.accept(list -> list.forEach(p -> {
                if (p instanceof AutoCloseable) {
                    IO.close((AutoCloseable)p);
                }
            }));
        }

        public String toString() {
            return "AbstractPlugin [serviceClass=" + this.serviceClass + ", externals=" + this.externals.peek() + ", attrs=" + this.attrs + ", inited=" + this.externals.isPresent() + "]";
        }
    }

    @ProviderType
    public static interface PluginProvider {
        public <X> Stream<X> provide(Class<X> var1);
    }
}

