/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi;

import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Annotation;
import aQute.bnd.osgi.ClassDataCollector;
import aQute.bnd.osgi.Clazz;
import aQute.bnd.osgi.Descriptors;
import aQute.service.reporter.Reporter;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;

class ClassDataCollectors
extends ClassDataCollector
implements Closeable {
    final List<ClassDataCollector> delegates = new ArrayList<ClassDataCollector>();
    final List<ClassDataCollector> shortlist = new ArrayList<ClassDataCollector>();
    final Reporter reporter;

    public ClassDataCollectors(Analyzer analyzer) {
        this.reporter = analyzer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void with(Clazz clazz, ClassDataCollector cd) throws Exception {
        this.delegates.add(cd);
        try {
            clazz.parseClassFileWithCollector(this);
        }
        finally {
            this.delegates.remove(cd);
        }
    }

    public void parse(Clazz clazz) throws Exception {
        clazz.parseClassFileWithCollector(this);
    }

    public void classBegin(int access, Descriptors.TypeRef name) {
        for (ClassDataCollector cd : this.delegates) {
            try {
                cd.classBegin(access, name);
            }
            catch (Exception e) {
                this.reporter.error("Fail to class classBegin on %s", cd);
            }
        }
    }

    public boolean classStart(int access, Descriptors.TypeRef className) {
        boolean start = false;
        for (ClassDataCollector cd : this.delegates) {
            try {
                if (!cd.classStart(access, className)) continue;
                this.shortlist.add(cd);
                start = true;
            }
            catch (Exception e) {
                this.reporter.error("Fail to class classStart on %s", cd);
            }
        }
        return start;
    }

    public boolean classStart(Clazz clazz) {
        boolean start = false;
        for (ClassDataCollector cd : this.delegates) {
            try {
                if (!cd.classStart(clazz)) continue;
                this.shortlist.add(cd);
                start = true;
            }
            catch (Exception e) {
                this.reporter.error("Fail to class classStart on %s", cd);
            }
        }
        return start;
    }

    public void extendsClass(Descriptors.TypeRef zuper) throws Exception {
        for (ClassDataCollector cd : this.shortlist) {
            try {
                cd.extendsClass(zuper);
            }
            catch (Exception e) {
                this.reporter.error("Fail to class extendsClass on %s", cd);
            }
        }
    }

    public void implementsInterfaces(Descriptors.TypeRef[] interfaces) throws Exception {
        for (ClassDataCollector cd : this.shortlist) {
            try {
                cd.implementsInterfaces(interfaces);
            }
            catch (Exception e) {
                this.reporter.error("Fail to class implementsInterfaces on %s", cd);
            }
        }
    }

    public void addReference(Descriptors.TypeRef ref) {
        for (ClassDataCollector cd : this.shortlist) {
            try {
                cd.addReference(ref);
            }
            catch (Exception e) {
                this.reporter.error("Fail to class addReference on %s", cd);
            }
        }
    }

    public void annotation(Annotation annotation) {
        for (ClassDataCollector cd : this.shortlist) {
            try {
                cd.annotation(annotation);
            }
            catch (Exception e) {
                this.reporter.error("Fail to class annotation on %s", cd);
            }
        }
    }

    public void parameter(int p) {
        for (ClassDataCollector cd : this.shortlist) {
            try {
                cd.parameter(p);
            }
            catch (Exception e) {
                this.reporter.error("Fail to class parameter on %s", cd);
            }
        }
    }

    public void method(Clazz.MethodDef defined) {
        for (ClassDataCollector cd : this.shortlist) {
            try {
                cd.method(defined);
            }
            catch (Exception e) {
                this.reporter.error("Fail to call method on %s", cd);
            }
        }
    }

    public void field(Clazz.FieldDef defined) {
        for (ClassDataCollector cd : this.shortlist) {
            try {
                cd.field(defined);
            }
            catch (Exception e) {
                this.reporter.error("Fail to call field on %s", cd);
            }
        }
    }

    public void classEnd() throws Exception {
        for (ClassDataCollector cd : this.shortlist) {
            try {
                cd.classEnd();
            }
            catch (Exception e) {
                this.reporter.error("Fail to call classEnd on %s", cd);
            }
        }
        this.shortlist.clear();
    }

    public void deprecated() throws Exception {
        for (ClassDataCollector cd : this.shortlist) {
            try {
                cd.deprecated();
            }
            catch (Exception e) {
                this.reporter.error("Fail to call deprecated on %s", cd);
            }
        }
    }

    public void enclosingMethod(Descriptors.TypeRef cName, String mName, String mDescriptor) {
        for (ClassDataCollector cd : this.shortlist) {
            try {
                cd.enclosingMethod(cName, mName, mDescriptor);
            }
            catch (Exception e) {
                this.reporter.error("Fail to call enclosingMethod on %s", cd);
            }
        }
    }

    public void innerClass(Descriptors.TypeRef innerClass, Descriptors.TypeRef outerClass, String innerName, int innerClassAccessFlags) throws Exception {
        for (ClassDataCollector cd : this.shortlist) {
            try {
                cd.innerClass(innerClass, outerClass, innerName, innerClassAccessFlags);
            }
            catch (Exception e) {
                this.reporter.error("Fail to call innerClass on %s", cd);
            }
        }
    }

    public void signature(String signature) {
        for (ClassDataCollector cd : this.shortlist) {
            try {
                cd.signature(signature);
            }
            catch (Exception e) {
                this.reporter.error("Fail to call innerClass on %s", cd);
            }
        }
    }

    public void constant(Object object) {
        for (ClassDataCollector cd : this.shortlist) {
            try {
                cd.constant(object);
            }
            catch (Exception e) {
                this.reporter.error("Fail to call constant on %s", cd);
            }
        }
    }

    public void memberEnd() {
        for (ClassDataCollector cd : this.shortlist) {
            try {
                cd.memberEnd();
            }
            catch (Exception e) {
                this.reporter.error("Fail to call memberEnd on %s", cd);
            }
        }
    }

    public void version(int minor, int major) {
        for (ClassDataCollector cd : this.shortlist) {
            try {
                cd.version(minor, major);
            }
            catch (Exception e) {
                this.reporter.error("Fail to call version on %s", cd);
            }
        }
    }

    public void referenceMethod(int access, Descriptors.TypeRef className, String method, String descriptor) {
        for (ClassDataCollector cd : this.shortlist) {
            try {
                cd.referenceMethod(access, className, method, descriptor);
            }
            catch (Exception e) {
                this.reporter.error("Fail to call referenceMethod on %s", cd);
            }
        }
    }

    public void referTo(Descriptors.TypeRef typeRef, int modifiers) {
        for (ClassDataCollector cd : this.shortlist) {
            try {
                cd.referTo(typeRef, modifiers);
            }
            catch (Exception e) {
                this.reporter.error("Fail to call referTo on %s", cd);
            }
        }
    }

    public void close() {
        for (ClassDataCollector cd : this.delegates) {
            try {
                if (!(cd instanceof Closeable)) continue;
                ((Closeable)((Object)cd)).close();
            }
            catch (Exception e) {
                this.reporter.error("Fail to call close on %s", cd);
            }
        }
        this.delegates.clear();
        this.shortlist.clear();
    }

    public void add(ClassDataCollector cd) {
        this.delegates.add(cd);
    }
}

