/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.dev.failsafe.internal;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.kyuubi.shade.dev.failsafe.BulkheadConfig;
import org.apache.kyuubi.shade.dev.failsafe.BulkheadFullException;
import org.apache.kyuubi.shade.dev.failsafe.ExecutionContext;
import org.apache.kyuubi.shade.dev.failsafe.internal.BulkheadImpl;
import org.apache.kyuubi.shade.dev.failsafe.spi.ExecutionResult;
import org.apache.kyuubi.shade.dev.failsafe.spi.FailsafeFuture;
import org.apache.kyuubi.shade.dev.failsafe.spi.PolicyExecutor;
import org.apache.kyuubi.shade.dev.failsafe.spi.Scheduler;

public class BulkheadExecutor<R>
extends PolicyExecutor<R> {
    private final BulkheadImpl<R> bulkhead;
    private final Duration maxWaitTime;

    public BulkheadExecutor(BulkheadImpl<R> bulkhead, int policyIndex) {
        super(bulkhead, policyIndex);
        this.bulkhead = bulkhead;
        this.maxWaitTime = ((BulkheadConfig)bulkhead.getConfig()).getMaxWaitTime();
    }

    @Override
    protected ExecutionResult<R> preExecute() {
        try {
            return this.bulkhead.tryAcquirePermit(this.maxWaitTime) ? null : ExecutionResult.exception(new BulkheadFullException(this.bulkhead));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return ExecutionResult.exception(e);
        }
    }

    @Override
    protected CompletableFuture<ExecutionResult<R>> preExecuteAsync(Scheduler scheduler, FailsafeFuture<R> future) {
        CompletableFuture promise = new CompletableFuture();
        CompletableFuture<Void> acquireFuture = this.bulkhead.acquirePermitAsync();
        acquireFuture.whenComplete((result, error) -> promise.complete(ExecutionResult.none()));
        if (!promise.isDone()) {
            try {
                ScheduledFuture<?> timeoutFuture = scheduler.schedule(() -> {
                    promise.complete(ExecutionResult.exception(new BulkheadFullException(this.bulkhead)));
                    acquireFuture.cancel(true);
                    return null;
                }, this.maxWaitTime.toNanos(), TimeUnit.NANOSECONDS);
                future.setCancelFn(this, (mayInterrupt, cancelResult) -> {
                    promise.complete((ExecutionResult)cancelResult);
                    acquireFuture.cancel((boolean)mayInterrupt);
                    timeoutFuture.cancel((boolean)mayInterrupt);
                });
            }
            catch (Throwable t) {
                promise.completeExceptionally(t);
            }
        }
        return promise;
    }

    @Override
    public void onSuccess(ExecutionResult<R> result) {
        this.bulkhead.releasePermit();
    }

    @Override
    protected ExecutionResult<R> onFailure(ExecutionContext<R> context, ExecutionResult<R> result) {
        this.bulkhead.releasePermit();
        return result;
    }
}

