/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.session;

import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.operation.OperationManager;
import org.apache.kyuubi.service.CompositeService;
import org.apache.kyuubi.session.Session;
import org.apache.kyuubi.session.SessionHandle;
import org.apache.kyuubi.session.SessionManager$;
import org.apache.kyuubi.session.package$;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.kyuubi.util.ThreadUtils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t=f!\u0002\u001f>\u0003\u00031\u0005\u0002C'\u0001\u0005\u0003\u0005\u000b\u0011\u0002(\t\u000bm\u0003A\u0011\u0001/\t\u000f\u0001\u0004\u0001\u0019!C\u0005C\"9a\r\u0001a\u0001\n\u00139\u0007BB7\u0001A\u0003&!\rC\u0004s\u0001\u0001\u0007I\u0011C:\t\u000f]\u0004\u0001\u0019!C\tq\"1!\u0010\u0001Q!\nQDQa\u001f\u0001\u0005\u0002MDQ\u0001 \u0001\u0005\nuDqA \u0001A\u0002\u0013%q\u0010C\u0005\u0002\b\u0001\u0001\r\u0011\"\u0003\u0002\n!A\u0011Q\u0002\u0001!B\u0013\t\t\u0001\u0003\u0004\u0002\u0012\u0001!\ta \u0005\n\u0003'\u0001!\u0019!C\u0005\u0003+A\u0001\"a\u000e\u0001A\u0003%\u0011q\u0003\u0005\n\u0003s\u0001!\u0019!C\u0005\u0003wA\u0001\"a\u0011\u0001A\u0003%\u0011Q\b\u0005\u0007\u0003\u000b\u0002a\u0011C1\t\u0017\u0005\u001d\u0003\u00011AA\u0002\u0013%\u0011\u0011\n\u0005\f\u0003#\u0002\u0001\u0019!a\u0001\n\u0013\t\u0019\u0006C\u0006\u0002X\u0001\u0001\r\u0011!Q!\n\u0005-\u0003bBA-\u0001\u0011\u0005\u00111\f\u0005\b\u0003\u0017\u0003a\u0011AAG\u0011\u001d\tY\n\u0001D\t\u0003;Cq!a5\u0001\t#\t)\u000eC\u0004\u0002^\u0002!\t!a8\t\u000f\u0005-\b\u0001\"\u0001\u0002n\"9\u00111\u001f\u0001\u0005\n\u0005U\bbBA}\u0001\u0011\u0005\u00111 \u0005\b\u0005\u0003\u0001A\u0011\u0001B\u0002\u0011\u001d\u00119\u0001\u0001C\u000b\u0005\u0013AqAa\u0004\u0001\t\u0003\u0011\t\u0002C\u0004\u0003\u001a\u0001!\tAa\u0007\t\u000f\t=\u0002\u0001\"\u0001\u0003\u0012!9!\u0011\u0007\u0001\u0005\u0002\tE\u0001b\u0002B\u001a\u0001\u0011\u0005!\u0011\u0003\u0005\f\u0005k\u0001\u0001\u0019!a\u0001\n\u0013\u00119\u0004C\u0006\u0003@\u0001\u0001\r\u00111A\u0005\n\t\u0005\u0003b\u0003B#\u0001\u0001\u0007\t\u0011)Q\u0005\u0005sA1Ba\u0012\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u00038!Y!\u0011\n\u0001A\u0002\u0003\u0007I\u0011\u0002B&\u0011-\u0011y\u0005\u0001a\u0001\u0002\u0003\u0006KA!\u000f\t\u0017\tE\u0003\u00011AA\u0002\u0013%!q\u0007\u0005\f\u0005'\u0002\u0001\u0019!a\u0001\n\u0013\u0011)\u0006C\u0006\u0003Z\u0001\u0001\r\u0011!Q!\n\te\u0002B\u0003B.\u0001!\u0015\r\u0011\"\u0003\u00038!Q!Q\f\u0001\t\u0006\u0004%IAa\u000e\t\u0015\t}\u0003\u0001#b\u0001\n\u0013\u00119\u0004C\u0004\u0003b\u0001!\tAa\u0019\t\u000f\tU\u0004\u0001\"\u0001\u0003x!9!Q\u0010\u0001\u0005\u0002\t}\u0004b\u0002BC\u0001\u0011\u0005!q\u0011\u0005\b\u0005\u0017\u0003A\u0011\tBG\u0011\u0019\u0011Y\n\u0001C!{\"1!Q\u0014\u0001\u0005BuDaAa(\u0001\t\u0013i\b\u0002\u0003BQ\u0001\u0011\u0005qHa)\t\u000f\t5\u0006\u0001\"\u0001@C\nq1+Z:tS>tW*\u00198bO\u0016\u0014(B\u0001 @\u0003\u001d\u0019Xm]:j_:T!\u0001Q!\u0002\r-LX/\u001e2j\u0015\t\u00115)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\t\u0006\u0019qN]4\u0004\u0001M\u0011\u0001a\u0012\t\u0003\u0011.k\u0011!\u0013\u0006\u0003\u0015~\nqa]3sm&\u001cW-\u0003\u0002M\u0013\n\u00012i\\7q_NLG/Z*feZL7-Z\u0001\u0005]\u0006lW\r\u0005\u0002P1:\u0011\u0001K\u0016\t\u0003#Rk\u0011A\u0015\u0006\u0003'\u0016\u000ba\u0001\u0010:p_Rt$\"A+\u0002\u000bM\u001c\u0017\r\\1\n\u0005]#\u0016A\u0002)sK\u0012,g-\u0003\u0002Z5\n11\u000b\u001e:j]\u001eT!a\u0016+\u0002\rqJg.\u001b;?)\tiv\f\u0005\u0002_\u00015\tQ\bC\u0003N\u0005\u0001\u0007a*\u0001\u0005tQV$Hm\\<o+\u0005\u0011\u0007CA2e\u001b\u0005!\u0016BA3U\u0005\u001d\u0011un\u001c7fC:\fAb\u001d5vi\u0012|wO\\0%KF$\"\u0001[6\u0011\u0005\rL\u0017B\u00016U\u0005\u0011)f.\u001b;\t\u000f1$\u0011\u0011!a\u0001E\u0006\u0019\u0001\u0010J\u0019\u0002\u0013MDW\u000f\u001e3po:\u0004\u0003FA\u0003p!\t\u0019\u0007/\u0003\u0002r)\nAao\u001c7bi&dW-A\t`_B,'/\u0019;j_:dun\u001a*p_R,\u0012\u0001\u001e\t\u0004GVt\u0015B\u0001<U\u0005\u0019y\u0005\u000f^5p]\u0006)rl\u001c9fe\u0006$\u0018n\u001c8M_\u001e\u0014vn\u001c;`I\u0015\fHC\u00015z\u0011\u001daw!!AA\u0002Q\f!cX8qKJ\fG/[8o\u0019><'k\\8uA\u0005\u0001r\u000e]3sCRLwN\u001c'pOJ{w\u000e^\u0001\u0018S:LGo\u00149fe\u0006$\u0018n\u001c8M_\u001e\u0014vn\u001c;ESJ$\u0012\u0001[\u0001\u0012?2\fG/Z:u\u0019><w.\u001e;US6,WCAA\u0001!\r\u0019\u00171A\u0005\u0004\u0003\u000b!&\u0001\u0002'p]\u001e\fQc\u00187bi\u0016\u001cH\u000fT8h_V$H+[7f?\u0012*\u0017\u000fF\u0002i\u0003\u0017A\u0001\u0002\u001c\u0007\u0002\u0002\u0003\u0007\u0011\u0011A\u0001\u0013?2\fG/Z:u\u0019><w.\u001e;US6,\u0007\u0005\u000b\u0002\u000e_\u0006\u0001B.\u0019;fgRdunZ8viRKW.Z\u0001\u0010Q\u0006tG\r\\3U_N+7o]5p]V\u0011\u0011q\u0003\t\t\u00033\t9#a\u000b\u000225\u0011\u00111\u0004\u0006\u0005\u0003;\ty\"\u0001\u0006d_:\u001cWO\u001d:f]RTA!!\t\u0002$\u0005!Q\u000f^5m\u0015\t\t)#\u0001\u0003kCZ\f\u0017\u0002BA\u0015\u00037\u0011\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1q!\rq\u0016QF\u0005\u0004\u0003_i$!D*fgNLwN\u001c%b]\u0012dW\rE\u0002_\u0003gI1!!\u000e>\u0005\u001d\u0019Vm]:j_:\f\u0001\u0003[1oI2,Gk\\*fgNLwN\u001c\u0011\u0002\u001dQLW.Z8vi\u000eCWmY6feV\u0011\u0011Q\b\t\u0005\u00033\ty$\u0003\u0003\u0002B\u0005m!\u0001G*dQ\u0016$W\u000f\\3e\u000bb,7-\u001e;peN+'O^5dK\u0006yA/[7f_V$8\t[3dW\u0016\u0014\b%\u0001\u0005jgN+'O^3s\u0003!)\u00070Z2Q_>dWCAA&!\u0011\tI\"!\u0014\n\t\u0005=\u00131\u0004\u0002\u0013)\"\u0014X-\u00193Q_>dW\t_3dkR|'/\u0001\u0007fq\u0016\u001c\u0007k\\8m?\u0012*\u0017\u000fF\u0002i\u0003+B\u0001\u0002\\\u000b\u0002\u0002\u0003\u0007\u00111J\u0001\nKb,7\rU8pY\u0002\n\u0011d];c[&$()Y2lOJ|WO\u001c3Pa\u0016\u0014\u0018\r^5p]R!\u0011QLA>a\u0011\ty&!\u001b\u0011\r\u0005e\u0011\u0011MA3\u0013\u0011\t\u0019'a\u0007\u0003\r\u0019+H/\u001e:f!\u0011\t9'!\u001b\r\u0001\u0011Y\u00111N\f\u0002\u0002\u0003\u0005)\u0011AA7\u0005\ryF%M\t\u0005\u0003_\n)\bE\u0002d\u0003cJ1!a\u001dU\u0005\u001dqu\u000e\u001e5j]\u001e\u00042aYA<\u0013\r\tI\b\u0016\u0002\u0004\u0003:L\bbBA?/\u0001\u0007\u0011qP\u0001\u0002eB!\u0011\u0011QAD\u001b\t\t\u0019I\u0003\u0003\u0002\u0006\u0006\r\u0012\u0001\u00027b]\u001eLA!!#\u0002\u0004\nA!+\u001e8oC\ndW-\u0001\tpa\u0016\u0014\u0018\r^5p]6\u000bg.Y4feV\u0011\u0011q\u0012\t\u0005\u0003#\u000b9*\u0004\u0002\u0002\u0014*\u0019\u0011QS \u0002\u0013=\u0004XM]1uS>t\u0017\u0002BAM\u0003'\u0013\u0001c\u00149fe\u0006$\u0018n\u001c8NC:\fw-\u001a:\u0002\u001b\r\u0014X-\u0019;f'\u0016\u001c8/[8o)1\t\t$a(\u0002>\u0006\u0005\u0017QYAe\u0011\u001d\t\t+\u0007a\u0001\u0003G\u000b\u0001\u0002\u001d:pi>\u001cw\u000e\u001c\t\u0005\u0003K\u000bI,\u0004\u0002\u0002(*!\u0011\u0011VAV\u0003\u0019!\bN]5gi*!\u0011QVAX\u0003\r\u0011\bo\u0019\u0006\u0004\u0015\u0006E&\u0002BAZ\u0003k\u000bA\u0001[5wK*\u0019\u0011qW \u0002\rMD\u0017\rZ3e\u0013\u0011\tY,a*\u0003!Q\u0003&o\u001c;pG>dg+\u001a:tS>t\u0007BBA`3\u0001\u0007a*\u0001\u0003vg\u0016\u0014\bBBAb3\u0001\u0007a*\u0001\u0005qCN\u001cxo\u001c:e\u0011\u0019\t9-\u0007a\u0001\u001d\u0006I\u0011\u000e]!eIJ,7o\u001d\u0005\b\u0003\u0017L\u0002\u0019AAg\u0003\u0011\u0019wN\u001c4\u0011\u000b=\u000byM\u0014(\n\u0007\u0005E'LA\u0002NCB\f1\u0003\\8h'\u0016\u001c8/[8o\u0007>,h\u000e^%oM>$R\u0001[Al\u00033DaA\u0010\u000eA\u0002\u0005E\u0002BBAn5\u0001\u0007a*\u0001\u0004bGRLwN\\\u0001\f_B,gnU3tg&|g\u000e\u0006\u0007\u0002,\u0005\u0005\u00181]As\u0003O\fI\u000fC\u0004\u0002\"n\u0001\r!a)\t\r\u0005}6\u00041\u0001O\u0011\u0019\t\u0019m\u0007a\u0001\u001d\"1\u0011qY\u000eA\u00029Cq!a3\u001c\u0001\u0004\ti-\u0001\u0007dY>\u001cXmU3tg&|g\u000eF\u0002i\u0003_Dq!!=\u001d\u0001\u0004\tY#A\u0007tKN\u001c\u0018n\u001c8IC:$G.Z\u0001\u001dI\u0016dW\r^3Pa\u0016\u0014\u0018\r^5p]2{wmU3tg&|g\u000eR5s)\rA\u0017q\u001f\u0005\b\u0003cl\u0002\u0019AA\u0016\u0003A9W\r^*fgNLwN\\(qi&|g\u000e\u0006\u0003\u0002~\u0006}\b\u0003B2v\u0003cAq!!=\u001f\u0001\u0004\tY#\u0001\u0006hKR\u001cVm]:j_:$B!!\r\u0003\u0006!9\u0011\u0011_\u0010A\u0002\u0005-\u0012AC:fiN+7o]5p]R)\u0001Na\u0003\u0003\u000e!9\u0011\u0011\u001f\u0011A\u0002\u0005-\u0002B\u0002 !\u0001\u0004\t\t$A\rhKR\f5\r^5wKV\u001bXM]*fgNLwN\\\"pk:$XC\u0001B\n!\r\u0019'QC\u0005\u0004\u0005/!&aA%oi\u0006Y\u0011\r\u001c7TKN\u001c\u0018n\u001c8t)\t\u0011i\u0002\u0005\u0004\u0003 \t%\u0012\u0011\u0007\b\u0005\u0005C\u0011)CD\u0002R\u0005GI\u0011!V\u0005\u0004\u0005O!\u0016a\u00029bG.\fw-Z\u0005\u0005\u0005W\u0011iC\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\u00119\u0003V\u0001\u0010O\u0016$X\t_3d!>|GnU5{K\u0006qq-\u001a;BGRLg/Z\"pk:$\u0018\u0001E4fi^{'o[)vKV,7+\u001b>f\u0003Ey6m\u001c8g%\u0016\u001cHO]5di2K7\u000f^\u000b\u0003\u0005s\u0001Ba\u0014B\u001e\u001d&\u0019!Q\b.\u0003\u0007M+G/A\u000b`G>tgMU3tiJL7\r\u001e'jgR|F%Z9\u0015\u0007!\u0014\u0019\u0005\u0003\u0005mO\u0005\u0005\t\u0019\u0001B\u001d\u0003Iy6m\u001c8g%\u0016\u001cHO]5di2K7\u000f\u001e\u0011\u0002\u001f}\u001bwN\u001c4JO:|'/\u001a'jgR\f1cX2p]\u001aLuM\\8sK2K7\u000f^0%KF$2\u0001\u001bB'\u0011!a'&!AA\u0002\te\u0012\u0001E0d_:4\u0017j\u001a8pe\u0016d\u0015n\u001d;!\u0003Qy&-\u0019;dQ\u000e{gNZ%h]>\u0014X\rT5ti\u0006ArLY1uG\"\u001cuN\u001c4JO:|'/\u001a'jgR|F%Z9\u0015\u0007!\u00149\u0006\u0003\u0005m[\u0005\u0005\t\u0019\u0001B\u001d\u0003Uy&-\u0019;dQ\u000e{gNZ%h]>\u0014X\rT5ti\u0002\nacX2p]\u001a\u0014Vm\u001d;sS\u000e$X*\u0019;dQ2K7\u000f^\u0001\u0015?\u000e|gNZ%h]>\u0014X-T1uG\"d\u0015n\u001d;\u00023}\u0013\u0017\r^2i\u0007>tg-S4o_J,W*\u0019;dQ2K7\u000f^\u0001\fm\u0006d\u0017\u000eZ1uK.+\u0017\u0010\u0006\u0004\u0003f\t5$\u0011\u000f\t\u0005GV\u00149\u0007E\u0003d\u0005Sre*C\u0002\u0003lQ\u0013a\u0001V;qY\u0016\u0014\u0004B\u0002B8e\u0001\u0007a*A\u0002lKfDaAa\u001d3\u0001\u0004q\u0015!\u0002<bYV,\u0017\u0001\u0007<bY&$\u0017\r^3B]\u0012tuN]7bY&TXmQ8oMR!\u0011Q\u001aB=\u0011\u001d\u0011Yh\ra\u0001\u0003\u001b\faaY8oM&<\u0017\u0001\u0005<bY&$\u0017\r^3CCR\u001c\u0007nS3z)\u0019\u0011)G!!\u0003\u0004\"1!q\u000e\u001bA\u00029CaAa\u001d5\u0001\u0004q\u0015!\u0005<bY&$\u0017\r^3CCR\u001c\u0007nQ8oMR!\u0011Q\u001aBE\u0011\u001d\u0011Y(\u000ea\u0001\u0003\u001b\f!\"\u001b8ji&\fG.\u001b>f)\rA'q\u0012\u0005\b\u0003\u00174\u0004\u0019\u0001BI!\u0011\u0011\u0019Ja&\u000e\u0005\tU%b\u0001B>\u007f%!!\u0011\u0014BK\u0005)Y\u00150^;cS\u000e{gNZ\u0001\u0006gR\f'\u000f^\u0001\u0005gR|\u0007/A\nti\u0006\u0014H\u000fV5nK>,Ho\u00115fG.,'/A\fti\u0006\u0014H\u000fV3s[&t\u0017\r^5oO\u000eCWmY6feR\u0019\u0001N!*\t\u000f\tu%\b1\u0001\u0003(B!1M!+i\u0013\r\u0011Y\u000b\u0016\u0002\n\rVt7\r^5p]B\na#[:F]\u001eLg.Z\"p]R,\u0007\u0010^*u_B\u0004X\r\u001a")
public abstract class SessionManager
extends CompositeService {
    private Set<String> _confRestrictMatchList;
    private Set<String> _confIgnoreMatchList;
    private Set<String> _batchConfIgnoreMatchList;
    private final String name;
    private volatile boolean org$apache$kyuubi$session$SessionManager$$shutdown;
    private Option<String> _operationLogRoot;
    private volatile long _latestLogoutTime;
    private final ConcurrentHashMap<SessionHandle, Session> org$apache$kyuubi$session$SessionManager$$handleToSession;
    private final ScheduledExecutorService timeoutChecker;
    private ThreadPoolExecutor execPool;
    private Set<String> _confRestrictList;
    private Set<String> _confIgnoreList;
    private Set<String> _batchConfIgnoreList;
    private volatile byte bitmap$0;

    public boolean org$apache$kyuubi$session$SessionManager$$shutdown() {
        return this.org$apache$kyuubi$session$SessionManager$$shutdown;
    }

    private void org$apache$kyuubi$session$SessionManager$$shutdown_$eq(boolean x$1) {
        this.org$apache$kyuubi$session$SessionManager$$shutdown = x$1;
    }

    public Option<String> _operationLogRoot() {
        return this._operationLogRoot;
    }

    public void _operationLogRoot_$eq(Option<String> x$1) {
        this._operationLogRoot = x$1;
    }

    public Option<String> operationLogRoot() {
        return this._operationLogRoot();
    }

    private void initOperationLogRootDir() {
        try {
            String logRoot = this.isServer() ? this.conf().get(KyuubiConf$.MODULE$.SERVER_OPERATION_LOG_DIR_ROOT()) : this.conf().get(KyuubiConf$.MODULE$.ENGINE_OPERATION_LOG_DIR_ROOT());
            Path logPath = Files.createDirectories(Utils$.MODULE$.getAbsolutePathFromWork(logRoot, Utils$.MODULE$.getAbsolutePathFromWork$default$2()), new FileAttribute[0]);
            this._operationLogRoot_$eq(new Some<String>(((Object)logPath).toString()));
        }
        catch (IOException e) {
            this.error((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Failed to initialize operation log root directory: ").append(this._operationLogRoot()).toString(), e);
            this._operationLogRoot_$eq(None$.MODULE$);
        }
    }

    private long _latestLogoutTime() {
        return this._latestLogoutTime;
    }

    private void _latestLogoutTime_$eq(long x$1) {
        this._latestLogoutTime = x$1;
    }

    public long latestLogoutTime() {
        return this._latestLogoutTime();
    }

    public ConcurrentHashMap<SessionHandle, Session> org$apache$kyuubi$session$SessionManager$$handleToSession() {
        return this.org$apache$kyuubi$session$SessionManager$$handleToSession;
    }

    private ScheduledExecutorService timeoutChecker() {
        return this.timeoutChecker;
    }

    public abstract boolean isServer();

    private ThreadPoolExecutor execPool() {
        return this.execPool;
    }

    private void execPool_$eq(ThreadPoolExecutor x$1) {
        this.execPool = x$1;
    }

    public Future<?> submitBackgroundOperation(Runnable r) {
        return this.execPool().submit(r);
    }

    public abstract OperationManager operationManager();

    public abstract Session createSession(TProtocolVersion var1, String var2, String var3, String var4, Map<String, String> var5);

    public void logSessionCountInfo(Session session, String action) {
        this.info((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(40).append(session.user()).append("'s ").append(session.getClass().getSimpleName()).append(" with").append(" ").append(session.handle()).append(session.name().map((Function1<String, String> & Serializable & scala.Serializable)x$1 -> new StringBuilder(1).append("/").append((String)x$1).toString()).getOrElse((Function0<String> & Serializable & scala.Serializable)() -> "")).append(" is ").append(action).append(",").append(" current opening sessions ").append(this.getActiveUserSessionCount()).toString());
    }

    public SessionHandle openSession(TProtocolVersion protocol, String user, String password, String ipAddress, Map<String, String> conf) {
        SessionHandle sessionHandle;
        this.info((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Opening session for ").append(user).append("@").append(ipAddress).toString());
        Session session = this.createSession(protocol, user, password, ipAddress, conf);
        SessionHandle handle = session.handle();
        try {
            this.setSession(handle, session);
            session.open();
            this.logSessionCountInfo(session, "opened");
            sessionHandle = handle;
        }
        catch (Exception e) {
            try {
                this.closeSession(handle);
            }
            catch (Throwable t) {
                this.warn((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Error closing session for ").append(user).append(" client ip: ").append(ipAddress).toString(), t);
            }
            throw KyuubiSQLException$.MODULE$.apply(e);
        }
        return sessionHandle;
    }

    public void closeSession(SessionHandle sessionHandle) {
        Session session = this.org$apache$kyuubi$session$SessionManager$$handleToSession().remove(sessionHandle);
        if (session == null) {
            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(8).append("Invalid ").append(sessionHandle).toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        }
        if (!session.isForAliveProbe()) {
            this._latestLogoutTime_$eq(System.currentTimeMillis());
        }
        this.logSessionCountInfo(session, "closed");
        try {
            session.close();
        }
        finally {
            this.deleteOperationLogSessionDir(sessionHandle);
        }
    }

    private void deleteOperationLogSessionDir(SessionHandle sessionHandle) {
        this._operationLogRoot().foreach((Function1<String, Object> & Serializable & scala.Serializable)logRoot -> {
            SessionManager.$anonfun$deleteOperationLogSessionDir$1(this, sessionHandle, logRoot);
            return BoxedUnit.UNIT;
        });
    }

    public Option<Session> getSessionOption(SessionHandle sessionHandle) {
        return Option$.MODULE$.apply(this.org$apache$kyuubi$session$SessionManager$$handleToSession().get(sessionHandle));
    }

    public Session getSession(SessionHandle sessionHandle) {
        return (Session)this.getSessionOption(sessionHandle).getOrElse((Function0<Nothing$> & Serializable & scala.Serializable)() -> {
            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(8).append("Invalid ").append(sessionHandle).toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        });
    }

    public final void setSession(SessionHandle sessionHandle, Session session) {
        this.org$apache$kyuubi$session$SessionManager$$handleToSession().put(sessionHandle, session);
    }

    public int getActiveUserSessionCount() {
        return ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.org$apache$kyuubi$session$SessionManager$$handleToSession().values()).asScala()).count((Function1<Session, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean(SessionManager.$anonfun$getActiveUserSessionCount$1(x$2)));
    }

    public Iterable<Session> allSessions() {
        return JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.org$apache$kyuubi$session$SessionManager$$handleToSession().values()).asScala();
    }

    public int getExecPoolSize() {
        Predef$.MODULE$.assert(this.execPool() != null);
        return this.execPool().getPoolSize();
    }

    public int getActiveCount() {
        Predef$.MODULE$.assert(this.execPool() != null);
        return this.execPool().getActiveCount();
    }

    public int getWorkQueueSize() {
        Predef$.MODULE$.assert(this.execPool() != null);
        return this.execPool().getQueue().size();
    }

    private Set<String> _confRestrictList() {
        return this._confRestrictList;
    }

    private void _confRestrictList_$eq(Set<String> x$1) {
        this._confRestrictList = x$1;
    }

    private Set<String> _confIgnoreList() {
        return this._confIgnoreList;
    }

    private void _confIgnoreList_$eq(Set<String> x$1) {
        this._confIgnoreList = x$1;
    }

    private Set<String> _batchConfIgnoreList() {
        return this._batchConfIgnoreList;
    }

    private void _batchConfIgnoreList_$eq(Set<String> x$1) {
        this._batchConfIgnoreList = x$1;
    }

    private Set<String> _confRestrictMatchList$lzycompute() {
        SessionManager sessionManager = this;
        synchronized (sessionManager) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this._confRestrictMatchList = ((SetLike)this._confRestrictList().filter((Function1<String, Object> & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean(x$3.endsWith(".*")))).map((Function1<String, String> & Serializable & scala.Serializable)x$4 -> new StringOps(Predef$.MODULE$.augmentString((String)x$4)).stripSuffix(".*"), Set$.MODULE$.canBuildFrom());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this._confRestrictMatchList;
    }

    private Set<String> _confRestrictMatchList() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this._confRestrictMatchList$lzycompute();
        }
        return this._confRestrictMatchList;
    }

    private Set<String> _confIgnoreMatchList$lzycompute() {
        SessionManager sessionManager = this;
        synchronized (sessionManager) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this._confIgnoreMatchList = ((SetLike)this._confIgnoreList().filter((Function1<String, Object> & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean(x$5.endsWith(".*")))).map((Function1<String, String> & Serializable & scala.Serializable)x$6 -> new StringOps(Predef$.MODULE$.augmentString((String)x$6)).stripSuffix(".*"), Set$.MODULE$.canBuildFrom());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this._confIgnoreMatchList;
    }

    private Set<String> _confIgnoreMatchList() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this._confIgnoreMatchList$lzycompute();
        }
        return this._confIgnoreMatchList;
    }

    private Set<String> _batchConfIgnoreMatchList$lzycompute() {
        SessionManager sessionManager = this;
        synchronized (sessionManager) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this._batchConfIgnoreMatchList = ((SetLike)this._batchConfIgnoreList().filter((Function1<String, Object> & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean(x$7.endsWith(".*")))).map((Function1<String, String> & Serializable & scala.Serializable)x$8 -> new StringOps(Predef$.MODULE$.augmentString((String)x$8)).stripSuffix(".*"), Set$.MODULE$.canBuildFrom());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this._batchConfIgnoreMatchList;
    }

    private Set<String> _batchConfIgnoreMatchList() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this._batchConfIgnoreMatchList$lzycompute();
        }
        return this._batchConfIgnoreMatchList;
    }

    public Option<Tuple2<String, String>> validateKey(String key, String value) {
        String normalizedKey;
        String string;
        if (key.startsWith(package$.MODULE$.SET_PREFIX())) {
            String newKey = key.substring(package$.MODULE$.SET_PREFIX().length());
            if (newKey.startsWith(package$.MODULE$.ENV_PREFIX())) {
                throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(46).append(key).append(" is forbidden, env:* variables can not be set.").toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
            }
            string = newKey.startsWith(package$.MODULE$.SYSTEM_PREFIX()) ? newKey.substring(package$.MODULE$.SYSTEM_PREFIX().length()) : (newKey.startsWith(package$.MODULE$.HIVECONF_PREFIX()) ? newKey.substring(package$.MODULE$.HIVECONF_PREFIX().length()) : (newKey.startsWith(package$.MODULE$.HIVEVAR_PREFIX()) ? newKey.substring(package$.MODULE$.HIVEVAR_PREFIX().length()) : (newKey.startsWith(package$.MODULE$.METACONF_PREFIX()) ? newKey.substring(package$.MODULE$.METACONF_PREFIX().length()) : newKey)));
        } else {
            string = normalizedKey = key;
        }
        if (this._confRestrictMatchList().exists((Function1<String, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(normalizedKey.startsWith(x$1))) || this._confRestrictList().contains(normalizedKey)) {
            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(112).append(normalizedKey).append(" is a restrict key according to the server-side").append(" configuration, please remove it and retry if you want to proceed").toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        }
        if (this._confIgnoreMatchList().exists((Function1<String, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(normalizedKey.startsWith(x$1))) || this._confIgnoreList().contains(normalizedKey)) {
            this.warn((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(60).append(normalizedKey).append(" is a ignored key according to the server-side configuration").toString());
            return None$.MODULE$;
        }
        return new Some<Tuple2<String, String>>(new Tuple2<String, String>(normalizedKey, value));
    }

    public Map<String, String> validateAndNormalizeConf(Map<String, String> config) {
        return config.flatMap((Function1<Tuple2, Iterable> & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return Option$.MODULE$.option2Iterable(this.validateKey(k, v));
            }
            throw new MatchError(tuple2);
        }, Map$.MODULE$.canBuildFrom());
    }

    public Option<Tuple2<String, String>> validateBatchKey(String key, String value) {
        if (this._batchConfIgnoreMatchList().exists((Function1<String, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(key.startsWith(x$1))) || this._batchConfIgnoreList().contains(key)) {
            this.warn((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(66).append(key).append(" is a ignored batch key according to the server-side configuration").toString());
            return None$.MODULE$;
        }
        return new Some<Tuple2<String, String>>(new Tuple2<String, String>(key, value));
    }

    public Map<String, String> validateBatchConf(Map<String, String> config) {
        return config.flatMap((Function1<Tuple2, Iterable> & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return Option$.MODULE$.option2Iterable(this.validateBatchKey(k, v));
            }
            throw new MatchError(tuple2);
        }, Map$.MODULE$.canBuildFrom());
    }

    @Override
    public synchronized void initialize(KyuubiConf conf) {
        this.conf_$eq(conf);
        this.addService(this.operationManager());
        this.initOperationLogRootDir();
        int poolSize = this.isServer() ? BoxesRunTime.unboxToInt(conf.get(KyuubiConf$.MODULE$.SERVER_EXEC_POOL_SIZE())) : BoxesRunTime.unboxToInt(conf.get(KyuubiConf$.MODULE$.ENGINE_EXEC_POOL_SIZE()));
        int waitQueueSize = this.isServer() ? BoxesRunTime.unboxToInt(conf.get(KyuubiConf$.MODULE$.SERVER_EXEC_WAIT_QUEUE_SIZE())) : BoxesRunTime.unboxToInt(conf.get(KyuubiConf$.MODULE$.ENGINE_EXEC_WAIT_QUEUE_SIZE()));
        long keepAliveMs = this.isServer() ? BoxesRunTime.unboxToLong(conf.get(KyuubiConf$.MODULE$.SERVER_EXEC_KEEPALIVE_TIME())) : BoxesRunTime.unboxToLong(conf.get(KyuubiConf$.MODULE$.ENGINE_EXEC_KEEPALIVE_TIME()));
        this._confRestrictList_$eq(conf.get(KyuubiConf$.MODULE$.SESSION_CONF_RESTRICT_LIST()));
        this._confIgnoreList_$eq((Set)((SetLike)conf.get(KyuubiConf$.MODULE$.SESSION_CONF_IGNORE_LIST())).$plus(String.valueOf(KyuubiConf$.MODULE$.SESSION_USER_SIGN_ENABLED().key())));
        this._batchConfIgnoreList_$eq(conf.get(KyuubiConf$.MODULE$.BATCH_CONF_IGNORE_LIST()));
        this.execPool_$eq(ThreadUtils$.MODULE$.newDaemonQueuedThreadPool(poolSize, waitQueueSize, keepAliveMs, new StringBuilder(10).append(this.name).append("-exec-pool").toString()));
        super.initialize(conf);
    }

    @Override
    public synchronized void start() {
        this.startTimeoutChecker();
        super.start();
    }

    @Override
    public synchronized void stop() {
        super.stop();
        this.org$apache$kyuubi$session$SessionManager$$shutdown_$eq(true);
        long shutdownTimeout = this.isServer() ? BoxesRunTime.unboxToLong(this.conf().get(KyuubiConf$.MODULE$.SERVER_EXEC_POOL_SHUTDOWN_TIMEOUT())) : BoxesRunTime.unboxToLong(this.conf().get(KyuubiConf$.MODULE$.ENGINE_EXEC_POOL_SHUTDOWN_TIMEOUT()));
        ThreadUtils$.MODULE$.shutdown(this.timeoutChecker(), Duration$.MODULE$.apply(shutdownTimeout, TimeUnit.MILLISECONDS));
        ThreadUtils$.MODULE$.shutdown(this.execPool(), Duration$.MODULE$.apply(shutdownTimeout, TimeUnit.MILLISECONDS));
    }

    private void startTimeoutChecker() {
        long interval = BoxesRunTime.unboxToLong(this.conf().get(KyuubiConf$.MODULE$.SESSION_CHECK_INTERVAL()));
        Runnable checkTask = new Runnable(this){
            private final /* synthetic */ SessionManager $outer;

            public void run() {
                this.$outer.info((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Checking sessions timeout, current count: ").append($this.$outer.getActiveUserSessionCount()).toString());
                long current = System.currentTimeMillis();
                if (!this.$outer.org$apache$kyuubi$session$SessionManager$$shutdown()) {
                    ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.$outer.org$apache$kyuubi$session$SessionManager$$handleToSession().values()).asScala()).foreach((Function1<Session, Object> & Serializable & scala.Serializable)session -> {
                        $anon$1.$anonfun$run$2(this, current, session);
                        return BoxedUnit.UNIT;
                    });
                    return;
                }
            }

            public static final /* synthetic */ void $anonfun$run$2($anon$1 $this, long current$1, Session session) {
                try {
                    if (session.lastAccessTime() + session.sessionIdleTimeoutThreshold() <= current$1 && session.getNoOperationTime() > session.sessionIdleTimeoutThreshold()) {
                        $this.$outer.info((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Closing session ").append(session.handle().identifier()).append(" that has been idle for more").append(" than ").append(session.sessionIdleTimeoutThreshold()).append(" ms").toString());
                        $this.$outer.closeSession(session.handle());
                    } else {
                        session.closeExpiredOperations();
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        Throwable e = option.get();
                        $this.$outer.warn((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Error checking session ").append(session.handle()).append(" timeout").toString(), e);
                    }
                    throw throwable;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.kyuubi.session.SessionManager$$anon$1 ), $anonfun$run$2$adapted(org.apache.kyuubi.session.SessionManager$$anon$1 long org.apache.kyuubi.session.Session ), $anonfun$run$3(org.apache.kyuubi.session.Session ), $anonfun$run$4(org.apache.kyuubi.session.Session )}, serializedLambda);
            }
        };
        ThreadUtils$.MODULE$.scheduleTolerableRunnableWithFixedDelay(this.timeoutChecker(), checkTask, interval, interval, TimeUnit.MILLISECONDS);
    }

    public void startTerminatingChecker(Function0<BoxedUnit> stop) {
        if (!this.isServer()) {
            this._latestLogoutTime_$eq(System.currentTimeMillis());
            long interval = BoxesRunTime.unboxToLong(this.conf().get(KyuubiConf$.MODULE$.ENGINE_CHECK_INTERVAL()));
            long idleTimeout = BoxesRunTime.unboxToLong(this.conf().get(KyuubiConf$.MODULE$.ENGINE_IDLE_TIMEOUT()));
            if (idleTimeout > 0L) {
                Runnable checkTask = new Runnable(this, idleTimeout, stop){
                    private final /* synthetic */ SessionManager $outer;
                    private final long idleTimeout$1;
                    private final Function0 stop$1;

                    public void run() {
                        if (!this.$outer.org$apache$kyuubi$session$SessionManager$$shutdown()) {
                            if (System.currentTimeMillis() - this.$outer.latestLogoutTime() > this.idleTimeout$1 && this.$outer.getActiveUserSessionCount() <= 0) {
                                this.$outer.info((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Idled for more than ").append($this.idleTimeout$1).append(" ms, terminating").toString());
                                this.stop$1.apply$mcV$sp();
                                return;
                            }
                            if (this.$outer.isEngineContextStopped()) {
                                this.$outer.error((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "Engine's SparkContext is stopped, terminating");
                                this.stop$1.apply$mcV$sp();
                                return;
                            }
                            return;
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.idleTimeout$1 = idleTimeout$1;
                        this.stop$1 = stop$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$5(org.apache.kyuubi.session.SessionManager$$anon$2 ), $anonfun$run$6()}, serializedLambda);
                    }
                };
                ThreadUtils$.MODULE$.scheduleTolerableRunnableWithFixedDelay(this.timeoutChecker(), checkTask, interval, interval, TimeUnit.MILLISECONDS);
                return;
            }
            return;
        }
    }

    public boolean isEngineContextStopped() {
        return false;
    }

    public static final /* synthetic */ void $anonfun$deleteOperationLogSessionDir$1(SessionManager $this, SessionHandle sessionHandle$1, String logRoot) {
        Path rootPath = Paths.get(logRoot, sessionHandle$1.identifier().toString());
        try {
            Utils$.MODULE$.deleteDirectoryRecursively(rootPath.toFile(), Utils$.MODULE$.deleteDirectoryRecursively$default$2());
        }
        catch (IOException e) {
            $this.error((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Failed to delete session operation log directory ").append(((Object)rootPath).toString()).toString(), e);
        }
    }

    public static final /* synthetic */ boolean $anonfun$getActiveUserSessionCount$1(Session x$2) {
        return !x$2.isForAliveProbe();
    }

    public SessionManager(String name) {
        this.name = name;
        super(name);
        this.org$apache$kyuubi$session$SessionManager$$shutdown = false;
        this._operationLogRoot = None$.MODULE$;
        this._latestLogoutTime = System.currentTimeMillis();
        this.org$apache$kyuubi$session$SessionManager$$handleToSession = new ConcurrentHashMap();
        this.timeoutChecker = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor(new StringBuilder(16).append(name).append("-timeout-checker").toString(), ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor$default$2());
    }
}

