/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.erasurecode.rawcoder;

import java.nio.ByteBuffer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.io.erasurecode.ErasureCoderOptions;
import org.apache.hadoop.io.erasurecode.rawcoder.ByteArrayEncodingState;
import org.apache.hadoop.io.erasurecode.rawcoder.ByteBufferEncodingState;
import org.apache.hadoop.io.erasurecode.rawcoder.CoderUtil;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureEncoder;

@InterfaceAudience.Private
public class XORRawEncoder
extends RawErasureEncoder {
    public XORRawEncoder(ErasureCoderOptions coderOptions) {
        super(coderOptions);
    }

    @Override
    protected void doEncode(ByteBufferEncodingState encodingState) {
        CoderUtil.resetOutputBuffers(encodingState.outputs, encodingState.encodeLength);
        ByteBuffer output = encodingState.outputs[0];
        int iIdx = encodingState.inputs[0].position();
        int oIdx = output.position();
        while (iIdx < encodingState.inputs[0].limit()) {
            output.put(oIdx, encodingState.inputs[0].get(iIdx));
            ++iIdx;
            ++oIdx;
        }
        for (int i = 1; i < encodingState.inputs.length; ++i) {
            iIdx = encodingState.inputs[i].position();
            oIdx = output.position();
            while (iIdx < encodingState.inputs[i].limit()) {
                output.put(oIdx, (byte)(output.get(oIdx) ^ encodingState.inputs[i].get(iIdx)));
                ++iIdx;
                ++oIdx;
            }
        }
    }

    @Override
    protected void doEncode(ByteArrayEncodingState encodingState) {
        int dataLen = encodingState.encodeLength;
        CoderUtil.resetOutputBuffers(encodingState.outputs, encodingState.outputOffsets, dataLen);
        byte[] output = encodingState.outputs[0];
        int iIdx = encodingState.inputOffsets[0];
        int oIdx = encodingState.outputOffsets[0];
        while (iIdx < encodingState.inputOffsets[0] + dataLen) {
            output[oIdx] = encodingState.inputs[0][iIdx];
            ++iIdx;
            ++oIdx;
        }
        for (int i = 1; i < encodingState.inputs.length; ++i) {
            oIdx = encodingState.outputOffsets[0];
            for (iIdx = encodingState.inputOffsets[i]; iIdx < encodingState.inputOffsets[i] + dataLen; ++iIdx) {
                int n = oIdx++;
                output[n] = (byte)(output[n] ^ encodingState.inputs[i][iIdx]);
            }
        }
    }
}

