/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline.hs2connection;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hive.beeline.hs2connection.BeelineHS2ConnectionFileParseException;
import org.apache.hive.beeline.hs2connection.HS2ConnectionFileParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveSiteHS2ConnectionFileParser
implements HS2ConnectionFileParser {
    private Configuration conf;
    private final URL hiveSiteURI;
    private static final String TRUSTSTORE_PASS_PROP = "javax.net.ssl.trustStorePassword";
    private static final String TRUSTSTORE_PROP = "javax.net.ssl.trustStore";
    private static final Logger LOG = LoggerFactory.getLogger(HiveSiteHS2ConnectionFileParser.class);

    private static URL findConfigFile(ClassLoader classLoader, String name, boolean doLog) {
        String nameInConf;
        String homePath;
        String confPath;
        URL result = classLoader.getResource(name);
        if (result == null && (result = HiveSiteHS2ConnectionFileParser.checkConfigFile(new File(confPath = System.getenv("HIVE_CONF_DIR"), name))) == null && (result = HiveSiteHS2ConnectionFileParser.checkConfigFile(new File(homePath = System.getenv("HIVE_HOME"), nameInConf = "conf" + File.separator + name))) == null) {
            URI jarUri = null;
            try {
                URL sourceUrl = HiveSiteHS2ConnectionFileParser.class.getProtectionDomain().getCodeSource().getLocation();
                jarUri = sourceUrl.getProtocol().equalsIgnoreCase("jar") ? new URI(sourceUrl.getPath()) : sourceUrl.toURI();
            }
            catch (Throwable e) {
                LOG.info("Cannot get jar URI", e);
            }
            File parent = new File(jarUri).getParentFile();
            if (parent != null) {
                result = HiveSiteHS2ConnectionFileParser.checkConfigFile(new File(parent.getParentFile(), nameInConf));
            }
        }
        if (doLog) {
            LOG.info("Found configuration file {}", (Object)result);
        }
        return result;
    }

    private static URL checkConfigFile(File f) {
        try {
            return f.exists() && f.isFile() ? f.toURI().toURL() : null;
        }
        catch (Throwable e) {
            LOG.info("Error looking for config {}", (Object)f, (Object)e);
            return null;
        }
    }

    public HiveSiteHS2ConnectionFileParser() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        this.hiveSiteURI = HiveSiteHS2ConnectionFileParser.findConfigFile(classLoader, "hive-site.xml", true);
        this.conf = new Configuration();
        if (this.hiveSiteURI == null) {
            LOG.debug("hive-site.xml not found for constructing the connection URL");
        } else {
            LOG.info("Using hive-site.xml at " + this.hiveSiteURI);
            this.conf.addResource(this.hiveSiteURI);
        }
    }

    @VisibleForTesting
    void setHiveConf(Configuration hiveConf) {
        this.conf = hiveConf;
    }

    @Override
    public Properties getConnectionProperties() throws BeelineHS2ConnectionFileParseException {
        Properties props = new Properties();
        if (!this.configExists()) {
            return props;
        }
        props.setProperty("url_prefix", "jdbc:hive2://");
        this.addHosts(props);
        this.addSSL(props);
        this.addKerberos(props);
        this.addHttp(props);
        return props;
    }

    private void addSSL(Properties props) {
        String saslQop;
        String trustStorePassword;
        if (!this.conf.getBoolean("hive.server2.use.SSL", false)) {
            return;
        }
        props.setProperty("ssl", "true");
        String truststore = System.getenv(TRUSTSTORE_PROP);
        if (truststore != null && truststore.isEmpty()) {
            props.setProperty("sslTruststore", truststore);
        }
        if ((trustStorePassword = System.getenv(TRUSTSTORE_PASS_PROP)) != null && !trustStorePassword.isEmpty()) {
            props.setProperty("trustStorePassword", trustStorePassword);
        }
        if (!"auth".equalsIgnoreCase(saslQop = this.conf.get("hive.server2.thrift.sasl.qop", "auth"))) {
            props.setProperty("sasl.qop", saslQop);
        }
    }

    private void addKerberos(Properties props) {
        if ("KERBEROS".equals(this.conf.get("hive.server2.authentication", "NONE"))) {
            props.setProperty("principal", this.conf.get("hive.server2.authentication.kerberos.principal", ""));
        }
    }

    private void addHttp(Properties props) {
        if (!"http".equalsIgnoreCase(this.conf.get("hive.server2.transport.mode", "binary"))) {
            return;
        }
        props.setProperty("transportMode", "http");
        props.setProperty("httpPath", this.conf.get("hive.server2.thrift.http.path", "cliservice"));
    }

    private void addHosts(Properties props) throws BeelineHS2ConnectionFileParseException {
        if (this.conf.getBoolean("hive.server2.support.dynamic.service.discovery", false)) {
            this.addZKServiceDiscoveryHosts(props);
        } else {
            this.addDefaultHS2Hosts(props);
        }
    }

    private void addZKServiceDiscoveryHosts(Properties props) throws BeelineHS2ConnectionFileParseException {
        props.setProperty("serviceDiscoveryMode", "zooKeeper");
        props.setProperty("zooKeeperNamespace", this.conf.get("hive.server2.zookeeper.namespace", "hiveserver2"));
        props.setProperty("hosts", this.conf.get("hive.zookeeper.quorum", ""));
    }

    private static InetAddress getHostAddress(String hostname) throws UnknownHostException {
        InetAddress serverIPAddress = hostname != null && !hostname.isEmpty() ? InetAddress.getByName(hostname) : InetAddress.getLocalHost();
        return serverIPAddress;
    }

    private void addDefaultHS2Hosts(Properties props) throws BeelineHS2ConnectionFileParseException {
        InetAddress serverIPAddress;
        String hiveHost = System.getenv("HIVE_SERVER2_THRIFT_BIND_HOST");
        if (hiveHost == null) {
            hiveHost = this.conf.get("hive.server2.thrift.bind.host", "");
        }
        try {
            serverIPAddress = HiveSiteHS2ConnectionFileParser.getHostAddress(hiveHost);
        }
        catch (UnknownHostException e) {
            throw new BeelineHS2ConnectionFileParseException(e.getMessage(), e);
        }
        int portNum = this.getPortNum("http".equalsIgnoreCase(this.conf.get("hive.server2.transport.mode", "binary")));
        props.setProperty("hosts", serverIPAddress.getHostName() + ":" + portNum);
    }

    private int getPortNum(boolean isHttp) {
        String portString;
        int portNum = isHttp ? ((portString = System.getenv("HIVE_SERVER2_THRIFT_HTTP_PORT")) != null ? Integer.parseInt(portString) : this.conf.getInt("hive.server2.thrift.http.port", 10001)) : ((portString = System.getenv("HIVE_SERVER2_THRIFT_PORT")) != null ? Integer.parseInt(portString) : this.conf.getInt("hive.server2.thrift.port", 10000));
        return portNum;
    }

    @Override
    public boolean configExists() {
        return this.hiveSiteURI != null;
    }
}

