/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.rpc.message.registry;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.linkis.rpc.message.parser.DefaultServiceParser;
import org.apache.linkis.rpc.message.parser.ServiceMethod;
import org.apache.linkis.rpc.message.parser.ServiceParser;
import org.apache.linkis.rpc.message.registry.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;

public abstract class AbstractServiceRegistry
implements ServiceRegistry {
    private static final Logger logger = LoggerFactory.getLogger(AbstractServiceRegistry.class);
    public final Interner<String> lock = Interners.newWeakInterner();
    private final Map<String, List<ServiceMethod>> serviceMethodCache = new ConcurrentHashMap<String, List<ServiceMethod>>();
    private final Map<String, Object> registedServieMap = new ConcurrentHashMap<String, Object>();
    private final ServiceParser serviceParser = new DefaultServiceParser();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(Object service) {
        String serviceName = AopUtils.getTargetClass((Object)service).getName();
        String string = (String)this.lock.intern((Object)serviceName);
        synchronized (string) {
            Object o = this.registedServieMap.get(serviceName);
            if (o != null) {
                return;
            }
            Map<String, List<ServiceMethod>> serviceMethods = this.serviceParser.parse(service);
            serviceMethods.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() != 1).forEach(entry -> logger.error(String.format("rpc receive method init error! find %s method for the request:%s, this type of rpc request will not be handled!", ((List)entry.getValue()).size(), entry.getKey())));
            serviceMethods.forEach(this::register);
            this.registedServieMap.put(serviceName, service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(String key, List<ServiceMethod> serviceMethods) {
        String string = (String)this.lock.intern((Object)key);
        synchronized (string) {
            this.refreshServiceMethodCache(key, serviceMethods);
        }
    }

    private void refreshServiceMethodCache(String key, List<ServiceMethod> serviceMethods) {
        this.serviceMethodCache.computeIfAbsent(key, k -> new ArrayList()).addAll(serviceMethods);
    }

    public Map<String, List<ServiceMethod>> getServiceMethodCache() {
        return this.serviceMethodCache;
    }
}

