/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.instance.label.service.impl;

import com.google.common.net.InetAddresses;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.common.utils.Utils;
import org.apache.linkis.instance.label.async.AsyncConsumerQueue;
import org.apache.linkis.instance.label.async.GenericAsyncConsumerQueue;
import org.apache.linkis.instance.label.conf.InsLabelConf;
import org.apache.linkis.instance.label.dao.InsLabelRelationDao;
import org.apache.linkis.instance.label.dao.InstanceInfoDao;
import org.apache.linkis.instance.label.dao.InstanceLabelDao;
import org.apache.linkis.instance.label.entity.InsPersistenceLabel;
import org.apache.linkis.instance.label.entity.InstanceInfo;
import org.apache.linkis.instance.label.errorcode.LinkisInstanceLabelErrorCodeSummary;
import org.apache.linkis.instance.label.exception.InstanceErrorException;
import org.apache.linkis.instance.label.service.InsLabelAccessService;
import org.apache.linkis.instance.label.service.annotation.AdapterMode;
import org.apache.linkis.instance.label.vo.InsPersistenceLabelSearchVo;
import org.apache.linkis.manager.label.builder.factory.LabelBuilderFactory;
import org.apache.linkis.manager.label.builder.factory.LabelBuilderFactoryContext;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.utils.LabelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@AdapterMode
@EnableAspectJAutoProxy(proxyTargetClass=true, exposeProxy=true)
@Service
public class DefaultInsLabelService
implements InsLabelAccessService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultInsLabelService.class);
    @Autowired
    private InstanceLabelDao instanceLabelDao;
    @Autowired
    private InstanceInfoDao instanceDao;
    @Autowired
    private InsLabelRelationDao insLabelRelationDao;
    @Autowired
    private InstanceInfoDao instanceInfoDao;
    private AsyncConsumerQueue<InsPersistenceLabel> asyncRemoveLabelQueue;
    private InsLabelAccessService selfService;
    private AtomicBoolean asyncQueueInit = new AtomicBoolean(false);
    private LabelBuilderFactory labelBuilderFactory = LabelBuilderFactoryContext.getLabelBuilderFactory();

    private synchronized void initQueue() {
        if (!this.asyncQueueInit.get()) {
            this.selfService = (InsLabelAccessService)AopContext.currentProxy();
            LOG.info("SelfService: [" + this.getClass().getName() + "]");
            this.asyncRemoveLabelQueue = new GenericAsyncConsumerQueue<InsPersistenceLabel>((Integer)InsLabelConf.ASYNC_QUEUE_CAPACITY.getValue());
            this.asyncRemoveLabelQueue.consumer((Integer)InsLabelConf.ASYNC_QUEUE_CONSUME_BATCH_SIZE.getValue(), (Long)InsLabelConf.ASYNC_QUEUE_CONSUME_INTERVAL.getValue(), TimeUnit.SECONDS, insLabels -> this.selfService.removeLabelsIfNotRelation((List<? extends Label<?>>)insLabels));
            this.asyncQueueInit.set(true);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void attachLabelToInstance(Label<?> label, ServiceInstance serviceInstance) throws InstanceErrorException {
        this.attachLabelsToInstance(Collections.singletonList(label), serviceInstance);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void attachLabelsToInstance(List<? extends Label<?>> labels, ServiceInstance serviceInstance) throws InstanceErrorException {
        List<InsPersistenceLabel> insLabels = this.toInsPersistenceLabels(labels);
        List<InsPersistenceLabel> labelsNeedInsert = this.filterLabelNeededInsert(insLabels, true);
        if (!labelsNeedInsert.isEmpty()) {
            LOG.info("Persist labels: [" + LabelUtils.Jackson.toJson(labels, null) + "]");
            this.doInsertInsLabels(labelsNeedInsert);
        }
        LOG.info("Insert/Update service instance info: [" + serviceInstance + "]");
        this.doInsertInstance(serviceInstance);
        List insLabelIds = insLabels.stream().map(InsPersistenceLabel::getId).collect(Collectors.toList());
        LOG.info("Build relation between labels: " + LabelUtils.Jackson.toJson(insLabelIds, null) + " and instance: [" + serviceInstance.getInstance() + "]");
        this.batchOperation(insLabelIds, subInsLabelIds -> this.insLabelRelationDao.insertRelations(serviceInstance.getInstance(), (List<Integer>)subInsLabelIds), (Integer)InsLabelConf.DB_PERSIST_BATCH_SIZE.getValue());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void refreshLabelsToInstance(List<? extends Label<?>> labels, ServiceInstance serviceInstance) throws InstanceErrorException {
        List<InsPersistenceLabel> insLabels = this.toInsPersistenceLabels(labels);
        LOG.info("Drop relationships related by instance: [" + serviceInstance.getInstance() + "]");
        this.insLabelRelationDao.dropRelationsByInstance(serviceInstance.getInstance());
        this.attachLabelsToInstance(insLabels, serviceInstance);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeLabelsFromInstance(ServiceInstance serviceInstance) {
        List<InsPersistenceLabel> labelsCandidateRemoved = this.insLabelRelationDao.searchLabelsByInstance(serviceInstance.getInstance());
        LOG.info("Drop relationships related by instance: [" + serviceInstance.getInstance() + "]");
        this.insLabelRelationDao.dropRelationsByInstance(serviceInstance.getInstance());
    }

    @Override
    public List<ServiceInstance> searchInstancesByLabels(List<? extends Label<?>> labels) {
        return this.searchInstancesByLabels(labels, Label.ValueRelation.ALL);
    }

    @Override
    public List<ServiceInstance> searchInstancesByLabels(List<? extends Label<?>> labels, Label.ValueRelation relation) {
        List<InsPersistenceLabel> insLabels = this.toInsPersistenceLabels(labels);
        if (!insLabels.isEmpty()) {
            List<InstanceInfo> instanceInfoList = this.insLabelRelationDao.searchInsDirectByLabels(insLabels);
            return instanceInfoList.stream().map(instanceInfo -> instanceInfo).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public List<ServiceInstance> searchUnRelateInstances(ServiceInstance serviceInstance) {
        if (null != serviceInstance) {
            return this.insLabelRelationDao.searchUnRelateInstances(new InstanceInfo(serviceInstance)).stream().map(instanceInfo -> instanceInfo).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public List<ServiceInstance> searchLabelRelatedInstances(ServiceInstance serviceInstance) {
        if (null != serviceInstance) {
            return this.insLabelRelationDao.searchLabelRelatedInstances(new InstanceInfo(serviceInstance)).stream().map(instanceInfo -> instanceInfo).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeLabelsIfNotRelation(List<? extends Label<?>> labels) {
        List<InsPersistenceLabel> insLabels = this.toInsPersistenceLabels(labels);
        insLabels.forEach(insLabel -> {
            Integer exist;
            if (null != (insLabel = Optional.ofNullable(insLabel.getId()).isPresent() ? this.instanceLabelDao.selectForUpdate(insLabel.getId()) : this.instanceLabelDao.searchForUpdate(insLabel.getLabelKey(), insLabel.getStringValue())) && null == (exist = this.insLabelRelationDao.existRelations(insLabel.getId()))) {
                LOG.info("Remove information of instance label: [" + insLabel.toString() + "]");
                this.instanceLabelDao.remove((InsPersistenceLabel)((Object)insLabel));
            }
        });
    }

    @Override
    public List<InstanceInfo> listAllInstanceWithLabel() {
        List<InstanceInfo> instances = this.insLabelRelationDao.listAllInstanceWithLabel();
        return instances;
    }

    @Override
    public List<ServiceInstance> getInstancesByNames(String appName) {
        return this.insLabelRelationDao.getInstancesByNames(appName);
    }

    @Override
    public void removeInstance(ServiceInstance serviceInstance) {
        this.instanceInfoDao.removeInstance(serviceInstance);
    }

    @Override
    public InstanceInfo getInstanceInfoByServiceInstance(ServiceInstance serviceInstance) {
        InstanceInfo instanceInfo = this.instanceInfoDao.getInstanceInfoByServiceInstance(serviceInstance);
        return instanceInfo;
    }

    @Override
    public void updateInstance(InstanceInfo instanceInfo) {
        this.instanceInfoDao.updateInstance(instanceInfo);
    }

    public String getServiceRegistryURL() throws Exception {
        return this.transferToIpAddress((String)InsLabelConf.SERVICE_REGISTRY_ADDRESS.getValue());
    }

    private String transferToIpAddress(String url) throws URISyntaxException, UnknownHostException {
        URI uri = new URI(url);
        String hostname = uri.getHost();
        InetAddress address = InetAddress.getByName(hostname);
        if (InetAddresses.isInetAddress((String)hostname)) {
            if (address.isLoopbackAddress()) {
                return url.replace(hostname, Utils.getLocalHostname());
            }
            return url;
        }
        return url.replace(hostname, address.getHostAddress());
    }

    private List<InsPersistenceLabel> filterLabelNeededInsert(List<InsPersistenceLabel> insLabels, boolean needLock) {
        List<InsPersistenceLabelSearchVo> labelSearchVos = insLabels.stream().map(InsPersistenceLabelSearchVo::new).collect(Collectors.toList());
        List<Object> storedLabels = new ArrayList();
        if (!labelSearchVos.isEmpty()) {
            storedLabels = this.instanceLabelDao.search(labelSearchVos);
        }
        if (!storedLabels.isEmpty()) {
            ArrayList<InsPersistenceLabel> labelsNeedInsert = new ArrayList<InsPersistenceLabel>(insLabels);
            List<Object> finalStoredLabels = storedLabels;
            labelsNeedInsert.removeIf(labelNeedInsert -> {
                for (InsPersistenceLabel storedLabel : finalStoredLabels) {
                    if (!labelNeedInsert.equals((Object)storedLabel)) continue;
                    Integer labelId = storedLabel.getId();
                    labelNeedInsert.setId(labelId);
                    if (needLock) {
                        return this.instanceLabelDao.updateForLock(labelId) >= 0;
                    }
                    return true;
                }
                return false;
            });
            return labelsNeedInsert;
        }
        return insLabels;
    }

    private void doInsertInsLabels(List<InsPersistenceLabel> insLabels) {
        this.batchOperation(insLabels, subInsLabels -> this.instanceLabelDao.insertBatch((List<InsPersistenceLabel>)subInsLabels), (Integer)InsLabelConf.DB_PERSIST_BATCH_SIZE.getValue());
    }

    private void doInsertInstance(ServiceInstance serviceInstance) throws InstanceErrorException {
        try {
            this.instanceDao.insertOne(new InstanceInfo(serviceInstance));
        }
        catch (Exception e) {
            throw new InstanceErrorException(LinkisInstanceLabelErrorCodeSummary.INSERT_SERVICE_INSTANCE.getErrorDesc(), e);
        }
    }

    private List<InsPersistenceLabel> toInsPersistenceLabels(List<? extends Label<?>> labels) {
        LabelBuilderFactory builderFactory = LabelBuilderFactoryContext.getLabelBuilderFactory();
        return labels.stream().map(label -> {
            if (label instanceof InsPersistenceLabel) {
                return (InsPersistenceLabel)((Object)label);
            }
            InsPersistenceLabel insLabel = (InsPersistenceLabel)builderFactory.convertLabel(label, InsPersistenceLabel.class);
            insLabel.setStringValue(label.getStringValue());
            if (StringUtils.isNotBlank((CharSequence)insLabel.getStringValue())) {
                insLabel.setLabelValueSize(((Map)insLabel.getValue()).size());
            }
            return insLabel;
        }).collect(Collectors.toList());
    }

    private <T extends List<?>> void batchOperation(T input, Consumer<T> batchFunc, int batchSize) {
        int listLen = input.size();
        if (listLen > 0) {
            int from = 0;
            while (from < listLen) {
                int to = Math.min(from + batchSize, listLen);
                List<?> subInput = input.subList(from, to);
                batchFunc.accept(subInput);
                from = to;
            }
        }
    }

    public void markInstanceLabel(List<InstanceInfo> instances) {
        Set keyList = LabelUtils.listAllUserModifiableLabel();
        for (InstanceInfo instance : instances) {
            List<InsPersistenceLabel> labels = instance.getLabels();
            if (CollectionUtils.isEmpty(labels)) continue;
            for (InsPersistenceLabel label : labels) {
                if (!keyList.contains(label.getLabelKey())) continue;
                label.setModifiable(true);
            }
        }
    }
}

