/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.monitor.core.scanner;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.monitor.core.pac.BaseScannedData;
import org.apache.linkis.monitor.core.pac.DataFetcher;
import org.apache.linkis.monitor.core.pac.ScanBuffer;
import org.apache.linkis.monitor.core.pac.ScanRule;
import org.apache.linkis.monitor.core.pac.ScannedData;
import org.apache.linkis.monitor.core.scanner.AnomalyScanner;
import org.apache.linkis.monitor.jobhistory.exception.AnomalyScannerException;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005ua!\u0002\f\u0018\u0003\u0003!\u0003\"B\u001c\u0001\t\u0003A\u0004b\u0002\u001e\u0001\u0005\u0004%Ia\u000f\u0005\u0007\u0005\u0002\u0001\u000b\u0011\u0002\u001f\t\u000f\r\u0003!\u0019!C\u0005\t\"1\u0011\u000b\u0001Q\u0001\n\u0015CqA\u0015\u0001C\u0002\u0013%1\u000b\u0003\u0004\\\u0001\u0001\u0006I\u0001\u0016\u0005\b9\u0002\u0011\r\u0011\"\u0003^\u0011\u0019\u0011\u0007\u0001)A\u0005=\")1\r\u0001C!I\")!\u000e\u0001C!W\")!\u000f\u0001C!g\")A\u000f\u0001C!k\")A\u0010\u0001C!{\")a\u0010\u0001C!\u007f\"9\u0011Q\u0001\u0001\u0005B\u0005\u001d\u0001bBA\b\u0001\u0011\u0005\u0013\u0011\u0003\u0005\b\u0003'\u0001A\u0011IA\u000b\u0011\u001d\t9\u0002\u0001C!\u0003+Aq!!\u0007\u0001\t\u0003\n)\u0002C\u0004\u0002\u001c\u0001!\t%!\u0006\u0003\u001f\u0005\u00137\u000f\u001e:bGR\u001c6-\u00198oKJT!\u0001G\r\u0002\u000fM\u001c\u0017M\u001c8fe*\u0011!dG\u0001\u0005G>\u0014XM\u0003\u0002\u001d;\u00059Qn\u001c8ji>\u0014(B\u0001\u0010 \u0003\u0019a\u0017N\\6jg*\u0011\u0001%I\u0001\u0007CB\f7\r[3\u000b\u0003\t\n1a\u001c:h\u0007\u0001\u0019B\u0001A\u0013,_A\u0011a%K\u0007\u0002O)\t\u0001&A\u0003tG\u0006d\u0017-\u0003\u0002+O\t1\u0011I\\=SK\u001a\u0004\"\u0001L\u0017\u000e\u0003]I!AL\f\u0003\u001d\u0005sw.\\1msN\u001b\u0017M\u001c8feB\u0011\u0001'N\u0007\u0002c)\u0011!gM\u0001\u0006kRLGn\u001d\u0006\u0003iu\taaY8n[>t\u0017B\u0001\u001c2\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#A\u001d\u0011\u00051\u0002\u0011A\u00022vM\u001a,'/F\u0001=!\ti\u0004)D\u0001?\u0015\ty\u0014$A\u0002qC\u000eL!!\u0011 \u0003\u0015M\u001b\u0017M\u001c\"vM\u001a,'/A\u0004ck\u001a4WM\u001d\u0011\u0002\u001d\u0011\fG/\u0019$fi\u000eDWM]%eqV\tQ\t\u0005\u0002G\u001f6\tqI\u0003\u0002I\u0013\u00061\u0011\r^8nS\u000eT!AS&\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002M\u001b\u0006!Q\u000f^5m\u0015\u0005q\u0015\u0001\u00026bm\u0006L!\u0001U$\u0003\u001b\u0005#x.\\5d\u0013:$XmZ3s\u0003=!\u0017\r^1GKR\u001c\u0007.\u001a:JIb\u0004\u0013a\u00043bi\u00064U\r^2iKJd\u0015n\u001d;\u0016\u0003Q\u00032!\u0016,Y\u001b\u0005I\u0015BA,J\u0005Q\u0019u\u000e]=P]^\u0013\u0018\u000e^3BeJ\f\u0017\u0010T5tiB\u0011Q(W\u0005\u00035z\u00121\u0002R1uC\u001a+Go\u00195fe\u0006\u0001B-\u0019;b\r\u0016$8\r[3s\u0019&\u001cH\u000fI\u0001\rg\u000e\fgNU;mK2K7\u000f^\u000b\u0002=B\u0019QKV0\u0011\u0005u\u0002\u0017BA1?\u0005!\u00196-\u00198Sk2,\u0017!D:dC:\u0014V\u000f\\3MSN$\b%\u0001\bbI\u0012$\u0015\r^1GKR\u001c\u0007.\u001a:\u0015\u0005\u0015D\u0007C\u0001\u0014g\u0013\t9wE\u0001\u0003V]&$\b\"B5\u000b\u0001\u0004A\u0016a\u00024fi\u000eDWM]\u0001\u0010C\u0012$G)\u0019;b\r\u0016$8\r[3sgR\u0011Q\r\u001c\u0005\u0006[.\u0001\rA\\\u0001\tM\u0016$8\r[3sgB\u0019q\u000e\u001d-\u000e\u0003-K!!]&\u0003\t1K7\u000f^\u0001\u0010O\u0016$H)\u0019;b\r\u0016$8\r[3sgV\ta.\u0001\u0005gK\u0016$G)\u0019;b)\t)g\u000fC\u0003x\u001b\u0001\u0007\u00010\u0001\u0003eCR\f\u0007cA8qsB\u0011QH_\u0005\u0003wz\u00121bU2b]:,G\rR1uC\u0006Iq-\u001a;Ck\u001a4WM\u001d\u000b\u0002y\u0005Y\u0011\r\u001a3TG\u0006t'+\u001e7f)\r)\u0017\u0011\u0001\u0005\u0007\u0003\u0007y\u0001\u0019A0\u0002\tI,H.Z\u0001\rC\u0012$7kY1o%VdWm\u001d\u000b\u0004K\u0006%\u0001bBA\u0006!\u0001\u0007\u0011QB\u0001\u0006eVdWm\u001d\t\u0004_B|\u0016\u0001D4fiN\u001b\u0017M\u001c*vY\u0016\u001cHCAA\u0007\u0003\r\u0011XO\u001c\u000b\u0002K\u0006\u00012oY1o\u001f:,\u0017\n^3sCRLwN\\\u0001\u0014C:\fG.\u001f>f\u001f:,\u0017\n^3sCRLwN\\\u0001\u0006gR\f'\u000f\u001e")
public abstract class AbstractScanner
implements AnomalyScanner,
Logging {
    private final ScanBuffer buffer;
    private final AtomicInteger dataFetcherIdx;
    private final CopyOnWriteArrayList<DataFetcher> dataFetcherList;
    private final CopyOnWriteArrayList<ScanRule> scanRuleList;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        AbstractScanner abstractScanner = this;
        synchronized (abstractScanner) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private ScanBuffer buffer() {
        return this.buffer;
    }

    private AtomicInteger dataFetcherIdx() {
        return this.dataFetcherIdx;
    }

    private CopyOnWriteArrayList<DataFetcher> dataFetcherList() {
        return this.dataFetcherList;
    }

    private CopyOnWriteArrayList<ScanRule> scanRuleList() {
        return this.scanRuleList;
    }

    @Override
    public void addDataFetcher(DataFetcher fetcher) {
        if (fetcher != null) {
            this.dataFetcherList().add(fetcher);
            return;
        }
        this.logger().warn("ignore null DataFetcher");
    }

    @Override
    public void addDataFetchers(List<DataFetcher> fetchers) {
        if (fetchers != null && fetchers.size() != 0) {
            this.dataFetcherList().addAll(fetchers);
            return;
        }
        this.logger().warn("ignore null or empty DataFetcher");
    }

    @Override
    public List<DataFetcher> getDataFetchers() {
        return this.dataFetcherList();
    }

    @Override
    public void feedData(List<ScannedData> data) {
        if (data != null && data.size() != 0) {
            this.buffer().write(data);
            return;
        }
        this.logger().warn("Fed with null or empty data");
    }

    @Override
    public ScanBuffer getBuffer() {
        return this.buffer();
    }

    @Override
    public void addScanRule(ScanRule rule) {
        if (rule != null) {
            this.scanRuleList().add(rule);
            return;
        }
        this.logger().warn("ignore null ScanRule");
    }

    @Override
    public void addScanRules(List<ScanRule> rules) {
        if (rules != null && rules.size() != 0) {
            this.scanRuleList().addAll(rules);
            return;
        }
        this.logger().warn("ignore null or empty ScanRule");
    }

    @Override
    public List<ScanRule> getScanRules() {
        return this.scanRuleList();
    }

    @Override
    public void run() {
        if (this.dataFetcherList().size() == 0) {
            throw new AnomalyScannerException(21304, "attempting to run scanner with empty dataFetchers");
        }
        if (this.buffer() == null) {
            throw new AnomalyScannerException(21304, "attempting to run scanner with null buffer");
        }
        if (this.scanRuleList().size() == 0) {
            throw new AnomalyScannerException(21304, "attempting to run scanner with empty rules");
        }
        while (this.dataFetcherIdx().get() < this.dataFetcherList().size()) {
            this.scanOneIteration();
            this.analyzeOneIteration();
        }
    }

    @Override
    public void scanOneIteration() {
        int idx = this.dataFetcherIdx().getAndIncrement();
        DataFetcher fetcher = this.dataFetcherList().get(idx);
        if (fetcher != null) {
            List<Object> rawData = fetcher.getData();
            this.logger().info(new StringBuilder(21).append("scanned ").append(rawData.size()).append(" data. Rule: ").append(fetcher.getName()).toString());
            if (rawData != null && rawData.size() != 0) {
                this.buffer().write(new BaseScannedData(fetcher.getName(), rawData));
                return;
            }
            return;
        }
        this.logger().warn("ignored null fetcher!!");
    }

    @Override
    public void analyzeOneIteration() {
        List<ScannedData> dataToAnalyze = this.buffer().drain(this.buffer().drain$default$1());
        if (dataToAnalyze != null && dataToAnalyze.size() != 0) {
            int len = this.scanRuleList().size();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).foreach((Function1 & Serializable & scala.Serializable)i -> AbstractScanner.$anonfun$analyzeOneIteration$1(this, dataToAnalyze, BoxesRunTime.unboxToInt((Object)i)));
            return;
        }
        this.logger().info("analyzed 0 data.");
    }

    @Override
    public void start() {
    }

    public static final /* synthetic */ Object $anonfun$analyzeOneIteration$1(AbstractScanner $this, List dataToAnalyze$1, int i) {
        ScanRule scanRule = $this.scanRuleList().get(i);
        if (scanRule != null) {
            $this.logger().info(new StringBuilder(23).append("analyzing ").append(dataToAnalyze$1.size()).append(" data. Rule: ").append(scanRule.getName()).toString());
            return BoxesRunTime.boxToBoolean((boolean)scanRule.triggerIfMatched(dataToAnalyze$1));
        }
        $this.logger().warn("found empty or null ScanRule");
        return BoxedUnit.UNIT;
    }

    public AbstractScanner() {
        Logging.$init$((Logging)this);
        this.buffer = new ScanBuffer();
        this.dataFetcherIdx = new AtomicInteger(0);
        this.dataFetcherList = new CopyOnWriteArrayList();
        this.scanRuleList = new CopyOnWriteArrayList();
    }
}

