/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.monitor.scheduled;

import java.util.ArrayList;
import org.apache.linkis.monitor.bml.cleaner.service.CleanerService;
import org.apache.linkis.monitor.config.MonitorConfig;
import org.apache.linkis.monitor.until.ThreadUtils;
import org.apache.linkis.monitor.utils.log.LogUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.PropertySource;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@PropertySource(value={"classpath:linkis-et-monitor.properties"}, encoding="UTF-8")
public class BmlClear {
    private static final Logger logger = LogUtils.stdOutLogger();
    @Autowired
    private CleanerService cleanerServices;

    @Scheduled(cron="${linkis.monitor.bml.clear.history.version.cron}")
    public void jobHistoryScanTask() {
        logger.info("start to clear bml history version");
        this.cleanerServices.run();
        logger.info("end to clear bml history version");
    }

    @Scheduled(cron="${linkis.monitor.clear.bml.task.cron:0 30 12 * * ?}")
    public void bmlTaskClear() {
        logger.info("Start to clear_bml_resources_task shell");
        ArrayList<String> cmdlist = new ArrayList<String>();
        cmdlist.add("sh");
        cmdlist.add(MonitorConfig.shellPath + "clear_bml_resources_task.sh");
        logger.info("clear_bml_resources_task  shell command {}", cmdlist);
        String exec = ThreadUtils.run(cmdlist, "clear_bml_resources_task.sh");
        logger.info("shell log  {}", (Object)exec);
        logger.info("End to clear_bml_resources_task shell ");
    }
}

