/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.monitor.utils.alert.ims;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.monitor.utils.alert.AlertDesc;
import org.apache.linkis.monitor.utils.alert.PooledAlertSender;
import org.apache.linkis.monitor.utils.alert.ims.ImsAlertDesc;
import org.apache.linkis.monitor.utils.alert.ims.ImsRequest;
import org.apache.linkis.monitor.utils.log.LogUtils$;
import scala.Function0;
import scala.Function1;
import scala.reflect.ScalaSignature;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0001q4Aa\u0003\u0007\u00017!Aq\u0005\u0001B\u0001B\u0003%\u0001\u0006C\u00036\u0001\u0011\u0005a\u0007C\u0004;\u0001\t\u0007I\u0011C\u001e\t\r\u0019\u0003\u0001\u0015!\u0003=\u0011\u001d9\u0005A1A\u0005\n!Ca!\u0016\u0001!\u0002\u0013I\u0005\"\u0002,\u0001\t\u0003:\u0006\"B1\u0001\t\u0003\u0012\u0007bB7\u0001#\u0003%\tA\u001c\u0005\bs\u0002\t\n\u0011\"\u0001{\u0005Q\u0001vn\u001c7fI&k7/\u00117feR\u001cVM\u001c3fe*\u0011QBD\u0001\u0004S6\u001c(BA\b\u0011\u0003\u0015\tG.\u001a:u\u0015\t\t\"#A\u0003vi&d7O\u0003\u0002\u0014)\u00059Qn\u001c8ji>\u0014(BA\u000b\u0017\u0003\u0019a\u0017N\\6jg*\u0011q\u0003G\u0001\u0007CB\f7\r[3\u000b\u0003e\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u000f!!\tib$D\u0001\u000f\u0013\tybBA\tQ_>dW\rZ!mKJ$8+\u001a8eKJ\u0004\"!I\u0013\u000e\u0003\tR!!E\u0012\u000b\u0005\u0011\"\u0012AB2p[6|g.\u0003\u0002'E\t9Aj\\4hS:<\u0017\u0001C1mKJ$XK\u001d7\u0011\u0005%\u0012dB\u0001\u00161!\tYc&D\u0001-\u0015\ti#$\u0001\u0004=e>|GO\u0010\u0006\u0002_\u0005)1oY1mC&\u0011\u0011GL\u0001\u0007!J,G-\u001a4\n\u0005M\"$AB*ue&twM\u0003\u00022]\u00051A(\u001b8jiz\"\"aN\u001d\u0011\u0005a\u0002Q\"\u0001\u0007\t\u000b\u001d\u0012\u0001\u0019\u0001\u0015\u0002\u0015!$H\u000f]\"mS\u0016tG/F\u0001=!\tiD)D\u0001?\u0015\ty\u0004)\u0001\u0004dY&,g\u000e\u001e\u0006\u0003\u0003\n\u000bA![7qY*\u00111IF\u0001\u0005QR$\b/\u0003\u0002F}\t\u00192\t\\8tK\u0006\u0014G.\u001a%uiB\u001cE.[3oi\u0006Y\u0001\u000e\u001e;q\u00072LWM\u001c;!\u0003\u0019i\u0017\r\u001d9feV\t\u0011\n\u0005\u0002K'6\t1J\u0003\u0002M\u001b\u0006AA-\u0019;bE&tGM\u0003\u0002O\u001f\u00069!.Y2lg>t'B\u0001)R\u0003%1\u0017m\u001d;feblGNC\u0001S\u0003\r\u0019w.\\\u0005\u0003).\u0013Ab\u00142kK\u000e$X*\u00199qKJ\fq!\\1qa\u0016\u0014\b%A\u0006e_N+g\u000eZ!mKJ$HC\u0001-]!\tI&,D\u0001/\u0013\tYfFA\u0004C_>dW-\u00198\t\u000bu;\u0001\u0019\u00010\u0002\u0013\u0005dWM\u001d;EKN\u001c\u0007CA\u000f`\u0013\t\u0001gBA\u0005BY\u0016\u0014H\u000fR3tG\u0006A1\u000f[;uI><h\u000eF\u0002dM\"\u0004\"!\u00173\n\u0005\u0015t#\u0001B+oSRDqa\u001a\u0005\u0011\u0002\u0003\u0007\u0001,\u0001\u0007xC&$8i\\7qY\u0016$X\rC\u0004j\u0011A\u0005\t\u0019\u00016\u0002\u0013QLW.Z8vi6\u001b\bCA-l\u0013\tagF\u0001\u0003M_:<\u0017AE:ikR$wn\u001e8%I\u00164\u0017-\u001e7uIE*\u0012a\u001c\u0016\u00031B\\\u0013!\u001d\t\u0003e^l\u0011a\u001d\u0006\u0003iV\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005Yt\u0013AC1o]>$\u0018\r^5p]&\u0011\u0001p\u001d\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AE:ikR$wn\u001e8%I\u00164\u0017-\u001e7uII*\u0012a\u001f\u0016\u0003UB\u0004")
public class PooledImsAlertSender
extends PooledAlertSender {
    private final String alertUrl;
    private final CloseableHttpClient httpClient;
    private final ObjectMapper mapper;

    public CloseableHttpClient httpClient() {
        return this.httpClient;
    }

    private ObjectMapper mapper() {
        return this.mapper;
    }

    @Override
    public boolean doSendAlert(AlertDesc alertDesc) {
        boolean bl;
        Object object = new Object();
        try {
            if (!(alertDesc instanceof ImsAlertDesc)) {
                this.logger().warn(new StringBuilder(26).append("wrong alertDesc dataType: ").append(alertDesc.getClass().getCanonicalName()).toString());
                return false;
            }
            this.logger().info(new StringBuilder(38).append("sending an alert to IMS, information: ").append(alertDesc).toString());
            ImsRequest imsRequest = ((ImsAlertDesc)alertDesc).toImsRequest();
            this.mapper().registerModule((Module)DefaultScalaModule$.MODULE$);
            String paramContent = (String)Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> this.mapper().writeValueAsString((Object)imsRequest), (Function1 & Serializable & scala.Serializable)t -> {
                this.logger().warn(new StringBuilder(14).append("ignore alert: ").append(imsRequest).toString(), t);
                throw new NonLocalReturnControl.mcZ.sp(object, false);
            });
            if (paramContent.isEmpty()) {
                this.logger().warn("alertParams is empty, will not send alarm");
                return false;
            }
            RequestConfig requestConfig = RequestConfig.DEFAULT;
            StringEntity entity = new StringEntity(paramContent, ContentType.create((String)ContentType.APPLICATION_JSON.getMimeType(), (String)"UTF-8"));
            entity.setContentEncoding("UTF-8");
            HttpPost httpPost = new HttpPost(this.alertUrl);
            httpPost.setConfig(requestConfig);
            httpPost.setEntity((HttpEntity)entity);
            CloseableHttpResponse response = (CloseableHttpResponse)Utils$.MODULE$.tryAndErrorMsg((Function0 & Serializable & scala.Serializable)() -> this.httpClient().execute((HttpUriRequest)httpPost), "send alert to IMS failed", this.logger());
            if (response != null) {
                String responseInfo = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                this.logger().info(new StringBuilder(17).append("Alert: ").append(paramContent).append("Response: ").append(responseInfo).toString());
                LogUtils$.MODULE$.stdOutLogger().info(new StringBuilder(17).append("Alert: ").append(paramContent).append("Response: ").append(responseInfo).toString());
                if (response.getStatusLine().getStatusCode() == 200) {
                    return true;
                }
            }
            bl = false;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    @Override
    public void shutdown(boolean waitComplete, long timeoutMs) {
        super.shutdown(waitComplete, timeoutMs);
        this.httpClient().close();
    }

    @Override
    public boolean shutdown$default$1() {
        return true;
    }

    @Override
    public long shutdown$default$2() {
        return -1L;
    }

    public PooledImsAlertSender(String alertUrl) {
        this.alertUrl = alertUrl;
        this.httpClient = HttpClients.createDefault();
        this.mapper = new ObjectMapper().setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ"));
    }
}

