/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.orchestrator.strategy.async;

import java.io.Serializable;
import org.apache.linkis.common.log.LogUtils$;
import org.apache.linkis.governance.common.entity.ExecutionNodeStatus;
import org.apache.linkis.orchestrator.execution.ExecTaskRunner;
import org.apache.linkis.orchestrator.execution.impl.DefaultTaskManager;
import org.apache.linkis.orchestrator.listener.OrchestratorSyncEvent;
import org.apache.linkis.orchestrator.listener.execution.ExecTaskRunnerCompletedEvent;
import org.apache.linkis.orchestrator.listener.task.EngineQuitedUnexpectedlyEvent;
import org.apache.linkis.orchestrator.listener.task.TaskErrorResponseEvent;
import org.apache.linkis.orchestrator.listener.task.TaskInfoEvent;
import org.apache.linkis.orchestrator.listener.task.TaskLogEvent;
import org.apache.linkis.orchestrator.listener.task.TaskResultSetEvent;
import org.apache.linkis.orchestrator.listener.task.TaskResultSetListener;
import org.apache.linkis.orchestrator.listener.task.TaskResultSetSizeEvent;
import org.apache.linkis.orchestrator.listener.task.TaskStatusEvent;
import org.apache.linkis.orchestrator.listener.task.TaskStatusListener;
import org.apache.linkis.orchestrator.plans.physical.ExecTask;
import org.apache.linkis.orchestrator.strategy.async.AsyncExecTask;
import org.apache.linkis.orchestrator.strategy.async.AsyncExecTaskRunner;
import org.apache.linkis.orchestrator.strategy.async.AsyncExecTaskRunnerImpl;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001e4AAC\u0006\u00011!)A\u0006\u0001C\u0001[!)\u0001\u0007\u0001C!c!)a\b\u0001C!\u007f!)Q\t\u0001C!\r\")A\n\u0001C!\u001b\")1\u000b\u0001C!)\")!\f\u0001C\u00057\")q\r\u0001C)Q\")1\u000f\u0001C\u0001i\n\u0001\u0012i]=oGR\u000b7o['b]\u0006<WM\u001d\u0006\u0003\u00195\tQ!Y:z]\u000eT!AD\b\u0002\u0011M$(/\u0019;fOfT!\u0001E\t\u0002\u0019=\u00148\r[3tiJ\fGo\u001c:\u000b\u0005I\u0019\u0012A\u00027j].L7O\u0003\u0002\u0015+\u00051\u0011\r]1dQ\u0016T\u0011AF\u0001\u0004_J<7\u0001A\n\u0005\u0001e\t\u0013\u0006\u0005\u0002\u001b?5\t1D\u0003\u0002\u001d;\u0005!\u0011.\u001c9m\u0015\tqr\"A\u0005fq\u0016\u001cW\u000f^5p]&\u0011\u0001e\u0007\u0002\u0013\t\u00164\u0017-\u001e7u)\u0006\u001c8.T1oC\u001e,'\u000f\u0005\u0002#O5\t1E\u0003\u0002%K\u0005!A/Y:l\u0015\t1s\"\u0001\u0005mSN$XM\\3s\u0013\tA3E\u0001\nUCN\\7\u000b^1ukNd\u0015n\u001d;f]\u0016\u0014\bC\u0001\u0012+\u0013\tY3EA\u000bUCN\\'+Z:vYR\u001cV\r\u001e'jgR,g.\u001a:\u0002\rqJg.\u001b;?)\u0005q\u0003CA\u0018\u0001\u001b\u0005Y\u0011aC8o'ft7-\u0012<f]R$\"A\r\u001d\u0011\u0005M2T\"\u0001\u001b\u000b\u0003U\nQa]2bY\u0006L!a\u000e\u001b\u0003\tUs\u0017\u000e\u001e\u0005\u0006s\t\u0001\rAO\u0001\u0006KZ,g\u000e\u001e\t\u0003wqj\u0011!J\u0005\u0003{\u0015\u0012Qc\u0014:dQ\u0016\u001cHO]1u_J\u001c\u0016P\\2Fm\u0016tG/A\tp]J+7/\u001e7u'\u0016$8I]3bi\u0016$\"A\r!\t\u000b\u0005\u001b\u0001\u0019\u0001\"\u0002%Q\f7o\u001b*fgVdGoU3u\u000bZ,g\u000e\u001e\t\u0003E\rK!\u0001R\u0012\u0003%Q\u000b7o\u001b*fgVdGoU3u\u000bZ,g\u000e^\u0001\u0014_:\u0014Vm];miNK'0Z\"sK\u0006$X\r\u001a\u000b\u0003e\u001dCQ\u0001\u0013\u0003A\u0002%\u000ba\u0003^1tWJ+7/\u001e7u'\u0016$8+\u001b>f\u000bZ,g\u000e\u001e\t\u0003E)K!aS\u0012\u0003-Q\u000b7o\u001b*fgVdGoU3u'&TX-\u0012<f]R\f\u0001d\u001c8UCN\\WI\u001d:peJ+7\u000f]8og\u0016,e/\u001a8u)\t\u0011d\nC\u0003P\u000b\u0001\u0007\u0001+\u0001\fuCN\\WI\u001d:peJ+7\u000f]8og\u0016,e/\u001a8u!\t\u0011\u0013+\u0003\u0002SG\t1B+Y:l\u000bJ\u0014xN\u001d*fgB|gn]3Fm\u0016tG/\u0001\bp]N#\u0018\r^;t+B$\u0017\r^3\u0015\u0005I*\u0006\"\u0002,\u0007\u0001\u00049\u0016a\u0004;bg.\u001cF/\u0019;vg\u00163XM\u001c;\u0011\u0005\tB\u0016BA-$\u0005=!\u0016m]6Ti\u0006$Xo]#wK:$\u0018a\u00064j]\u0012$U-\u00197Fm\u0016tG\u000fV1tWJ+hN\\3s)\ta6\rE\u00024;~K!A\u0018\u001b\u0003\r=\u0003H/[8o!\t\u0001\u0017-D\u0001\u001e\u0013\t\u0011WD\u0001\bFq\u0016\u001cG+Y:l%Vtg.\u001a:\t\u000be:\u0001\u0019\u00013\u0011\u0005\t*\u0017B\u00014$\u00055!\u0016m]6J]\u001a|WI^3oi\u0006!R\r_3d)\u0006\u001c8\u000eV8UCN\\'+\u001e8oKJ$\"aX5\t\u000b)D\u0001\u0019A6\u0002\u0011\u0015DXm\u0019+bg.\u0004\"\u0001\\9\u000e\u00035T!A\\8\u0002\u0011AD\u0017p]5dC2T!\u0001]\b\u0002\u000bAd\u0017M\\:\n\u0005Il'\u0001C#yK\u000e$\u0016m]6\u00025=tWI\\4j]\u0016\fV/\u001b;fIVsW\r\u001f9fGR,G\r\\=\u0015\u0005I*\b\"B\u001d\n\u0001\u00041\bC\u0001\u0012x\u0013\tA8EA\u000fF]\u001eLg.Z)vSR,G-\u00168fqB,7\r^3eYf,e/\u001a8u\u0001")
public class AsyncTaskManager
extends DefaultTaskManager
implements TaskStatusListener,
TaskResultSetListener {
    @Override
    public void onSyncEvent(OrchestratorSyncEvent event) {
        super.onSyncEvent(event);
        OrchestratorSyncEvent orchestratorSyncEvent = event;
        if (orchestratorSyncEvent instanceof TaskStatusEvent) {
            TaskStatusEvent taskStatusEvent = (TaskStatusEvent)orchestratorSyncEvent;
            this.onStatusUpdate(taskStatusEvent);
            return;
        }
        if (orchestratorSyncEvent instanceof TaskResultSetSizeEvent) {
            TaskResultSetSizeEvent taskResultSetSizeEvent = (TaskResultSetSizeEvent)orchestratorSyncEvent;
            this.onResultSizeCreated(taskResultSetSizeEvent);
            return;
        }
        if (orchestratorSyncEvent instanceof TaskResultSetEvent) {
            TaskResultSetEvent taskResultSetEvent = (TaskResultSetEvent)orchestratorSyncEvent;
            this.onResultSetCreate(taskResultSetEvent);
            return;
        }
        if (orchestratorSyncEvent instanceof TaskErrorResponseEvent) {
            TaskErrorResponseEvent taskErrorResponseEvent = (TaskErrorResponseEvent)orchestratorSyncEvent;
            this.onTaskErrorResponseEvent(taskErrorResponseEvent);
            return;
        }
        if (orchestratorSyncEvent instanceof ExecTaskRunnerCompletedEvent) {
            ExecTaskRunnerCompletedEvent execTaskRunnerCompletedEvent = (ExecTaskRunnerCompletedEvent)orchestratorSyncEvent;
            ExecTaskRunner execTaskRunner = execTaskRunnerCompletedEvent.execTaskRunner();
            this.addCompletedTask(execTaskRunner);
            return;
        }
        if (orchestratorSyncEvent instanceof EngineQuitedUnexpectedlyEvent) {
            EngineQuitedUnexpectedlyEvent engineQuitedUnexpectedlyEvent = (EngineQuitedUnexpectedlyEvent)orchestratorSyncEvent;
            this.onEngineQuitedUnexpectedly(engineQuitedUnexpectedlyEvent);
            return;
        }
    }

    @Override
    public void onResultSetCreate(TaskResultSetEvent taskResultSetEvent) {
        this.logger().debug(new StringBuilder(28).append("received taskResultSetEvent ").append(taskResultSetEvent.execTask().getId()).toString());
        this.findDealEventTaskRunner(taskResultSetEvent).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            AsyncTaskManager.$anonfun$onResultSetCreate$1(taskResultSetEvent, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void onResultSizeCreated(TaskResultSetSizeEvent taskResultSetSizeEvent) {
        this.logger().debug(new StringBuilder(32).append("received taskResultSetSizeEvent ").append(taskResultSetSizeEvent).toString());
        this.findDealEventTaskRunner(taskResultSetSizeEvent).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            AsyncTaskManager.$anonfun$onResultSizeCreated$1(taskResultSetSizeEvent, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void onTaskErrorResponseEvent(TaskErrorResponseEvent taskErrorResponseEvent) {
        this.findDealEventTaskRunner(taskErrorResponseEvent).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            AsyncTaskManager.$anonfun$onTaskErrorResponseEvent$1(this, taskErrorResponseEvent, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void onStatusUpdate(TaskStatusEvent taskStatusEvent) {
        this.logger().debug(new StringBuilder(25).append("received taskStatusEvent ").append(taskStatusEvent).toString());
        if (ExecutionNodeStatus.isCompleted((ExecutionNodeStatus)taskStatusEvent.status())) {
            this.findDealEventTaskRunner(taskStatusEvent).foreach((Function1 & Serializable & scala.Serializable)runner -> {
                AsyncTaskManager.$anonfun$onStatusUpdate$1(this, taskStatusEvent, runner);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private Option<ExecTaskRunner> findDealEventTaskRunner(TaskInfoEvent event) {
        ExecTask execTask = event.execTask();
        ExecTask rootExecTask = execTask.getPhysicalContext().getRootTask();
        ExecTaskRunner[] runners = (ExecTaskRunner[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getRunningTask(rootExecTask))).filter((Function1 & Serializable & scala.Serializable)taskRunner -> BoxesRunTime.boxToBoolean((boolean)AsyncTaskManager.$anonfun$findDealEventTaskRunner$1(event, taskRunner)));
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])runners)).headOption();
    }

    @Override
    public ExecTaskRunner execTaskToTaskRunner(ExecTask execTask) {
        return new AsyncExecTaskRunnerImpl(execTask);
    }

    public void onEngineQuitedUnexpectedly(EngineQuitedUnexpectedlyEvent event) {
        this.logger().info(new StringBuilder(39).append("received EngineUnexpectedlyQuitedEvent ").append(event).toString());
        this.findDealEventTaskRunner(event).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            AsyncTaskManager.$anonfun$onEngineQuitedUnexpectedly$1(this, event, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$onResultSetCreate$1(TaskResultSetEvent taskResultSetEvent$1, ExecTaskRunner x0$1) {
        ExecTaskRunner execTaskRunner = x0$1;
        if (execTaskRunner instanceof AsyncExecTaskRunner) {
            AsyncExecTaskRunner asyncExecTaskRunner = (AsyncExecTaskRunner)execTaskRunner;
            asyncExecTaskRunner.addResultSet(taskResultSetEvent$1.resultSet());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$onResultSizeCreated$1(TaskResultSetSizeEvent taskResultSetSizeEvent$1, ExecTaskRunner x0$1) {
        ExecTaskRunner execTaskRunner = x0$1;
        if (execTaskRunner instanceof AsyncExecTaskRunner) {
            AsyncExecTaskRunner asyncExecTaskRunner = (AsyncExecTaskRunner)execTaskRunner;
            asyncExecTaskRunner.setResultSize(taskResultSetSizeEvent$1.resultSize());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$onTaskErrorResponseEvent$1(AsyncTaskManager $this, TaskErrorResponseEvent taskErrorResponseEvent$1, ExecTaskRunner x0$1) {
        ExecTaskRunner execTaskRunner = x0$1;
        if (execTaskRunner instanceof AsyncExecTaskRunner) {
            AsyncExecTaskRunner asyncExecTaskRunner = (AsyncExecTaskRunner)execTaskRunner;
            $this.logger().info(new StringBuilder(32).append("received taskErrorResponseEvent ").append(taskErrorResponseEvent$1).toString());
            asyncExecTaskRunner.markFailed(taskErrorResponseEvent$1.errorMsg(), null);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$onStatusUpdate$1(AsyncTaskManager $this, TaskStatusEvent taskStatusEvent$1, ExecTaskRunner runner) {
        $this.logger().info(new StringBuilder(28).append("Task(").append(taskStatusEvent$1.execTask().getIDInfo()).append(") is completed, status ").append(taskStatusEvent$1.status()).toString());
        runner.transientStatus(taskStatusEvent$1.status());
    }

    public static final /* synthetic */ boolean $anonfun$findDealEventTaskRunner$1(TaskInfoEvent event$1, ExecTaskRunner taskRunner) {
        ExecTask execTask = taskRunner.task();
        if (execTask instanceof AsyncExecTask) {
            AsyncExecTask asyncExecTask = (AsyncExecTask)execTask;
            return asyncExecTask.canDealEvent(event$1);
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$onEngineQuitedUnexpectedly$1(AsyncTaskManager $this, EngineQuitedUnexpectedlyEvent event$2, ExecTaskRunner x0$1) {
        ExecTaskRunner execTaskRunner = x0$1;
        if (execTaskRunner instanceof AsyncExecTaskRunner) {
            AsyncExecTaskRunner asyncExecTaskRunner = (AsyncExecTaskRunner)execTaskRunner;
            if (asyncExecTaskRunner.isCompleted()) {
                $this.logger().warn(new StringBuilder(58).append("task ").append(event$2.execTask().getIDInfo()).append(" already complete, ignore engine ").append(event$2.serviceInstance()).append(" quited unexpectedly").toString());
                return;
            }
            ExecTask execTask = event$2.execTask();
            String errLog = LogUtils$.MODULE$.generateERROR(new StringBuilder(97).append("Your job : ").append(execTask.getIDInfo()).append(" was failed because the engine quited unexpectedly(\u4efb\u52a1").append(execTask.getIDInfo()).append("\u5931\u8d25\uff0c\u539f\u56e0\u662f\u5f15\u64ce\u610f\u5916\u9000\u51fa,\u53ef\u80fd\u662f\u590d\u6742\u4efb\u52a1\u5bfc\u81f4\u5f15\u64ce\u9000\u51fa\uff0c\u5982OOM).").toString());
            TaskLogEvent logEvent = new TaskLogEvent(execTask, errLog);
            execTask.getPhysicalContext().pushLog(logEvent);
            String errorMsg = new StringBuilder(76).append("task ").append(execTask.getIDInfo()).append(" failed\uff0cEngine ").append(event$2.serviceInstance()).append(" quited unexpectedly(\u4efb\u52a1\u8fd0\u884c\u5931\u8d25\u539f\u56e0\u662f\u5f15\u64ce\u610f\u5916\u9000\u51fa,\u53ef\u80fd\u662f\u590d\u6742\u4efb\u52a1\u5bfc\u81f4\u5f15\u64ce\u9000\u51fa\uff0c\u5982OOM)").toString();
            asyncExecTaskRunner.markFailed(errorMsg, null);
            asyncExecTaskRunner.transientStatus(ExecutionNodeStatus.Failed);
            return;
        }
    }
}

