/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.loader.utils;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.manager.engineplugin.common.EngineConnPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EngineConnPluginUtils {
    private static final Logger LOG = LoggerFactory.getLogger(EngineConnPluginUtils.class);
    private static final String JAR_SUF_NAME = ".jar";
    private static final String CLASS_SUF_NAME = ".class";
    public static final String FILE_SCHEMA = "file://";
    private static final Class<EngineConnPlugin> PLUGIN_PARENT_CLASS = EngineConnPlugin.class;

    public static List<URL> getJarsUrlsOfPath(String path) {
        ArrayList<URL> classPathURLs = new ArrayList<URL>();
        return EngineConnPluginUtils.getJarsUrlsOfPathRecurse(path, classPathURLs);
    }

    public static String getEngineConnPluginClass(URLClassLoader engineClassloader) {
        URL[] urlsOfClassLoader;
        for (URL classPath : urlsOfClassLoader = engineClassloader.getURLs()) {
            String path = classPath.getPath();
            String className = EngineConnPluginUtils.getEngineConnPluginClassFromURL(path, classFullName -> EngineConnPluginUtils.isSubEngineConnPluginClass(classFullName, engineClassloader));
            if (null == className) continue;
            return className;
        }
        return null;
    }

    public static EngineConnPlugin loadSubEngineConnPluginInSpi(ClassLoader classLoader) {
        ServiceLoader<EngineConnPlugin> serviceLoader = ServiceLoader.load(PLUGIN_PARENT_CLASS, classLoader);
        Iterator<EngineConnPlugin> subClassIterator = serviceLoader.iterator();
        if (subClassIterator.hasNext()) {
            return subClassIterator.next();
        }
        return null;
    }

    private static List<URL> getJarsUrlsOfPathRecurse(String path, List<URL> classPathURLs) {
        File parentFile = new File(path);
        File[] childFiles = parentFile.listFiles(file -> {
            String name = file.getName();
            return !name.startsWith(".") && (file.isDirectory() || name.endsWith(JAR_SUF_NAME) || name.endsWith(CLASS_SUF_NAME));
        });
        if (null != childFiles && childFiles.length > 0) {
            for (File childFile : childFiles) {
                if (childFile.isDirectory()) {
                    EngineConnPluginUtils.getJarsUrlsOfPathRecurse(childFile.getPath(), classPathURLs);
                    continue;
                }
                try {
                    classPathURLs.add(childFile.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    LOG.warn("url {} cannot be added", (Object)(FILE_SCHEMA + childFile.getPath()));
                }
            }
        }
        return classPathURLs;
    }

    private static String getEngineConnPluginClassFromURL(String url, Function<String, Boolean> acceptedFunction) {
        if (url.endsWith(CLASS_SUF_NAME)) {
            String className = url.substring(0, url.lastIndexOf(CLASS_SUF_NAME));
            int splitIndex = className.lastIndexOf(IOUtils.DIR_SEPARATOR);
            if (splitIndex >= 0) {
                className = className.substring(splitIndex);
            }
            return acceptedFunction.apply(className) != false ? className : null;
        }
        if (url.endsWith(JAR_SUF_NAME)) {
            try {
                JarFile jarFile = new JarFile(new File(url));
                Enumeration<JarEntry> en = jarFile.entries();
                while (en.hasMoreElements()) {
                    String name = en.nextElement().getName();
                    if (!name.endsWith(CLASS_SUF_NAME)) continue;
                    String className = name.substring(0, name.lastIndexOf(CLASS_SUF_NAME));
                    if (!acceptedFunction.apply(className = className.replaceAll(String.valueOf('/'), ".")).booleanValue()) continue;
                    return className;
                }
                return null;
            }
            catch (IOException e) {
                LOG.trace("Fail to parse jar file:[" + url + "] in plugin classpath");
                return null;
            }
        }
        return null;
    }

    private static boolean isSubEngineConnPluginClass(String className, ClassLoader classLoader) {
        Class<?> clazz;
        if (StringUtils.isEmpty((CharSequence)className)) {
            return false;
        }
        try {
            clazz = Class.forName(className, false, classLoader);
            if (Modifier.isAbstract(clazz.getModifiers()) || Modifier.isInterface(clazz.getModifiers())) {
                return false;
            }
        }
        catch (Throwable t) {
            LOG.trace("Class: {} can not be found", (Object)className, (Object)t);
            return false;
        }
        return PLUGIN_PARENT_CLASS.isAssignableFrom(clazz);
    }
}

