/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.rm.domain;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.linkis.governance.common.conf.GovernanceCommonConf;
import org.apache.linkis.manager.common.exception.RMErrorException;
import org.apache.linkis.manager.label.builder.CombinedLabelBuilder;
import org.apache.linkis.manager.label.entity.CombinedLabel;
import org.apache.linkis.manager.label.entity.GenericLabel;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.entity.ResourceLabel;
import org.apache.linkis.manager.label.entity.em.EMInstanceLabel;
import org.apache.linkis.manager.label.entity.engine.EngineInstanceLabel;
import org.apache.linkis.manager.label.entity.engine.EngineTypeLabel;
import org.apache.linkis.manager.label.entity.engine.UserCreatorLabel;
import org.apache.linkis.manager.label.utils.LabelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMLabelContainer {
    private static final Logger logger = LoggerFactory.getLogger(RMLabelContainer.class);
    private static CombinedLabelBuilder combinedLabelBuilder = new CombinedLabelBuilder();
    List<Label<?>> labels;
    List<Label<?>> lockedLabels;
    private EMInstanceLabel EMInstanceLabel;
    private EngineTypeLabel engineTypeLabel;
    private UserCreatorLabel userCreatorLabel;
    private EngineInstanceLabel engineInstanceLabel;
    private CombinedLabel combinedResourceLabel;
    private Label currentLabel;

    public RMLabelContainer(List<Label<?>> labels) {
        this.labels = labels;
        this.lockedLabels = Lists.newArrayList();
        try {
            if (this.getUserCreatorLabel() != null && this.getEngineTypeLabel() != null) {
                this.combinedResourceLabel = (CombinedLabel)combinedLabelBuilder.build("", (Object)Lists.newArrayList((Object[])new GenericLabel[]{this.getUserCreatorLabel(), this.getEngineTypeLabel()}));
                this.labels.add((Label<?>)this.combinedResourceLabel);
            }
        }
        catch (Exception e) {
            logger.warn("failed to get combinedUserCreatorEngineTypeLabel", (Throwable)e);
        }
        this.labels = LabelUtils.distinctLabel(this.labels, labels);
    }

    public List<Label<?>> getLabels() {
        return this.labels;
    }

    public List<Label<?>> getResourceLabels() {
        if (null != this.labels) {
            List<Label<?>> resourceLabels = this.labels.stream().filter(label -> label instanceof ResourceLabel).sorted(new Comparator<Label<?>>(){

                @Override
                public int compare(Label<?> label1, Label<?> label12) {
                    return label1.getLabelKey().compareTo(label12.getLabelKey());
                }
            }).collect(Collectors.toList());
            Collections.reverse(resourceLabels);
            return resourceLabels;
        }
        return new ArrayList();
    }

    public Label find(Class labelClass) {
        for (Label<?> label : this.labels) {
            if (!labelClass.isInstance(label)) continue;
            return label;
        }
        return null;
    }

    public EMInstanceLabel getEMInstanceLabel() throws RMErrorException {
        if (this.EMInstanceLabel == null) {
            for (Label<?> label : this.labels) {
                if (!(label instanceof EMInstanceLabel)) continue;
                return (EMInstanceLabel)label;
            }
        } else {
            return this.EMInstanceLabel;
        }
        logger.warn("EMInstanceLabel not found");
        return null;
    }

    public EngineTypeLabel getEngineTypeLabel() throws RMErrorException {
        if (this.engineTypeLabel == null) {
            for (Label<?> label : this.labels) {
                if (!(label instanceof EngineTypeLabel)) continue;
                return (EngineTypeLabel)label;
            }
        } else {
            return this.engineTypeLabel;
        }
        logger.warn("EngineTypeLabel not found");
        return null;
    }

    public UserCreatorLabel getUserCreatorLabel() throws RMErrorException {
        if (this.userCreatorLabel == null) {
            for (Label<?> label : this.labels) {
                if (!(label instanceof UserCreatorLabel)) continue;
                return (UserCreatorLabel)label;
            }
        } else {
            return this.userCreatorLabel;
        }
        return null;
    }

    public EngineInstanceLabel getEngineInstanceLabel() throws RMErrorException {
        if (this.engineInstanceLabel == null) {
            for (Label<?> label : this.labels) {
                if (!(label instanceof EngineInstanceLabel)) continue;
                return (EngineInstanceLabel)label;
            }
        } else {
            return this.engineInstanceLabel;
        }
        logger.warn("EngineInstanceLabel not found");
        return null;
    }

    public CombinedLabel getCombinedResourceLabel() {
        return this.combinedResourceLabel;
    }

    public Label getCurrentLabel() {
        return this.currentLabel;
    }

    public void setCurrentLabel(Label currentLabel) {
        this.currentLabel = currentLabel;
    }

    public List<Label<?>> getLockedLabels() {
        return this.lockedLabels;
    }

    public String getEngineServiceName() throws RMErrorException {
        return (String)GovernanceCommonConf.ENGINE_CONN_SPRING_NAME().getValue();
    }

    public void sort() {
    }

    public String toString() {
        return "RMLabelContainer{labels=" + this.labels + ", lockedLabels=" + this.lockedLabels + ", EMInstanceLabel=" + this.EMInstanceLabel + ", engineTypeLabel=" + this.engineTypeLabel + ", userCreatorLabel=" + this.userCreatorLabel + ", engineInstanceLabel=" + this.engineInstanceLabel + ", currentLabel=" + this.currentLabel + '}';
    }
}

