/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.rm.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.conf.CommonVars;
import org.apache.linkis.common.conf.CommonVars$;
import org.apache.linkis.common.conf.TimeType;
import org.apache.linkis.common.utils.ByteTimeUtils;
import org.apache.linkis.common.utils.JsonUtils$;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.manager.common.entity.persistence.PersistenceResource;
import org.apache.linkis.manager.common.entity.resource.CommonNodeResource;
import org.apache.linkis.manager.common.entity.resource.DriverAndYarnResource;
import org.apache.linkis.manager.common.entity.resource.LoadInstanceResource;
import org.apache.linkis.manager.common.entity.resource.NodeResource;
import org.apache.linkis.manager.common.entity.resource.Resource;
import org.apache.linkis.manager.common.entity.resource.ResourceType;
import org.apache.linkis.manager.common.entity.resource.UserResource;
import org.apache.linkis.manager.common.entity.resource.YarnResource;
import org.apache.linkis.manager.common.utils.ResourceUtils;
import org.apache.linkis.manager.label.LabelManagerUtils$;
import org.apache.linkis.manager.label.builder.CombinedLabelBuilder;
import org.apache.linkis.manager.label.entity.GenericLabel;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.entity.engine.EngineType$;
import org.apache.linkis.manager.label.entity.engine.EngineTypeLabel;
import org.apache.linkis.manager.label.entity.engine.UserCreatorLabel;
import org.apache.linkis.manager.rm.conf.ResourceStatus;
import org.apache.linkis.manager.rm.restful.vo.UserResourceVo;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.runtime.BoxesRunTime;

public final class RMUtils$
implements Logging {
    public static RMUtils$ MODULE$;
    private final ObjectMapper jacksonUtil;
    private final CommonVars<TimeType> MANAGER_KILL_ENGINE_EAIT;
    private final CommonVars<Object> RM_REQUEST_ENABLE;
    private final CommonVars<Object> RM_RESOURCE_LOCK_WAIT_TIME;
    private final CommonVars<Object> RM_DEBUG_ENABLE;
    private final CommonVars<String> RM_DEBUG_LOG_PATH;
    private final CommonVars<TimeType> EXTERNAL_RESOURCE_REFRESH_TIME;
    private String COMBINED_USERCREATOR_ENGINETYPE;
    private final CommonVars<String> ENGINE_TYPE;
    private final CommonVars<Object> RM_RESOURCE_ACTION_RECORD;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new RMUtils$();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        RMUtils$ rMUtils$ = this;
        synchronized (rMUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public ObjectMapper jacksonUtil() {
        return this.jacksonUtil;
    }

    public CommonVars<TimeType> MANAGER_KILL_ENGINE_EAIT() {
        return this.MANAGER_KILL_ENGINE_EAIT;
    }

    public CommonVars<Object> RM_REQUEST_ENABLE() {
        return this.RM_REQUEST_ENABLE;
    }

    public CommonVars<Object> RM_RESOURCE_LOCK_WAIT_TIME() {
        return this.RM_RESOURCE_LOCK_WAIT_TIME;
    }

    public CommonVars<Object> RM_DEBUG_ENABLE() {
        return this.RM_DEBUG_ENABLE;
    }

    public CommonVars<String> RM_DEBUG_LOG_PATH() {
        return this.RM_DEBUG_LOG_PATH;
    }

    public CommonVars<TimeType> EXTERNAL_RESOURCE_REFRESH_TIME() {
        return this.EXTERNAL_RESOURCE_REFRESH_TIME;
    }

    public String COMBINED_USERCREATOR_ENGINETYPE() {
        return this.COMBINED_USERCREATOR_ENGINETYPE;
    }

    public void COMBINED_USERCREATOR_ENGINETYPE_$eq(String x$1) {
        this.COMBINED_USERCREATOR_ENGINETYPE = x$1;
    }

    public CommonVars<String> ENGINE_TYPE() {
        return this.ENGINE_TYPE;
    }

    public CommonVars<Object> RM_RESOURCE_ACTION_RECORD() {
        return this.RM_RESOURCE_ACTION_RECORD;
    }

    public Resource deserializeResource(String plainResource) {
        return (Resource)this.jacksonUtil().readValue(plainResource, Resource.class);
    }

    public String serializeResource(Resource resource) {
        return this.jacksonUtil().writeValueAsString((Object)resource);
    }

    public UserResourceVo toUserResourceVo(UserResource userResource) {
        UserResourceVo userResourceVo;
        block14: {
            userResourceVo = new UserResourceVo();
            if (userResource.getCreator() != null) {
                userResourceVo.setCreator(userResource.getCreator());
            }
            if (userResource.getEngineType() != null) {
                userResourceVo.setEngineTypeWithVersion(new StringBuilder(1).append(userResource.getEngineType()).append("-").append(userResource.getVersion()).toString());
            }
            if (userResource.getUsername() != null) {
                userResourceVo.setUsername(userResource.getUsername());
            }
            if (userResource.getCreateTime() != null) {
                userResourceVo.setCreateTime(userResource.getCreateTime());
            }
            if (userResource.getUpdateTime() != null) {
                userResourceVo.setUpdateTime(userResource.getUpdateTime());
            }
            if (userResource.getId() != null) {
                userResourceVo.setId(userResource.getId());
            }
            if (userResource.getUsedResource() != null) {
                userResourceVo.setUsedResource((Map)this.jacksonUtil().readValue(this.jacksonUtil().writeValueAsString((Object)userResource.getUsedResource()), Map.class));
            }
            if (userResource.getLeftResource() != null) {
                userResourceVo.setLeftResource((Map)this.jacksonUtil().readValue(this.jacksonUtil().writeValueAsString((Object)userResource.getLeftResource()), Map.class));
            }
            if (userResource.getLockedResource() != null) {
                userResourceVo.setLockedResource((Map)this.jacksonUtil().readValue(this.jacksonUtil().writeValueAsString((Object)userResource.getLockedResource()), Map.class));
            }
            if (userResource.getMaxResource() != null) {
                userResourceVo.setMaxResource((Map)this.jacksonUtil().readValue(this.jacksonUtil().writeValueAsString((Object)userResource.getMaxResource()), Map.class));
            }
            if (userResource.getMinResource() != null) {
                userResourceVo.setMinResource((Map)this.jacksonUtil().readValue(this.jacksonUtil().writeValueAsString((Object)userResource.getMinResource()), Map.class));
            }
            if (userResource.getResourceType() != null) {
                userResourceVo.setResourceType(userResource.getResourceType());
            }
            if (userResource.getLeftResource() == null || userResource.getMaxResource() == null) break block14;
            if (userResource.getResourceType().equals((Object)ResourceType.DriverAndYarn)) {
                LoadInstanceResource leftDriverResource = ((DriverAndYarnResource)userResource.getLeftResource()).getLoadInstanceResource();
                YarnResource leftYarnResource = ((DriverAndYarnResource)userResource.getLeftResource()).getYarnResource();
                LoadInstanceResource maxDriverResource = ((DriverAndYarnResource)userResource.getMaxResource()).getLoadInstanceResource();
                YarnResource maxYarnResource = ((DriverAndYarnResource)userResource.getMaxResource()).getYarnResource();
                userResourceVo.setLoadResourceStatus(ResourceStatus.measure((Resource)leftDriverResource, (Resource)maxDriverResource));
                userResourceVo.setQueueResourceStatus(ResourceStatus.measure((Resource)leftYarnResource, (Resource)maxYarnResource));
            } else {
                userResourceVo.setLoadResourceStatus(ResourceStatus.measure(userResource.getLeftResource(), userResource.getMaxResource()));
            }
        }
        return userResourceVo;
    }

    public PersistenceResource toPersistenceResource(NodeResource nodeResource) {
        PersistenceResource persistenceResource = new PersistenceResource();
        if (nodeResource.getMaxResource() != null) {
            persistenceResource.setMaxResource(this.serializeResource(nodeResource.getMaxResource()));
        }
        if (nodeResource.getMinResource() != null) {
            persistenceResource.setMinResource(this.serializeResource(nodeResource.getMinResource()));
        }
        if (nodeResource.getLockedResource() != null) {
            persistenceResource.setLockedResource(this.serializeResource(nodeResource.getLockedResource()));
        }
        if (nodeResource.getExpectedResource() != null) {
            persistenceResource.setExpectedResource(this.serializeResource(nodeResource.getExpectedResource()));
        }
        if (nodeResource.getLeftResource() != null) {
            persistenceResource.setLeftResource(this.serializeResource(nodeResource.getLeftResource()));
        }
        persistenceResource.setResourceType(nodeResource.getResourceType().toString());
        return persistenceResource;
    }

    public CommonNodeResource aggregateNodeResource(NodeResource firstNodeResource, NodeResource secondNodeResource) {
        if (firstNodeResource != null && secondNodeResource != null) {
            CommonNodeResource aggregatedNodeResource = new CommonNodeResource();
            aggregatedNodeResource.setResourceType(firstNodeResource.getResourceType());
            aggregatedNodeResource.setMaxResource(this.aggregateResource(firstNodeResource.getMaxResource(), secondNodeResource.getMaxResource()));
            aggregatedNodeResource.setMinResource(this.aggregateResource(firstNodeResource.getMinResource(), secondNodeResource.getMinResource()));
            aggregatedNodeResource.setUsedResource(this.aggregateResource(firstNodeResource.getUsedResource(), secondNodeResource.getUsedResource()));
            aggregatedNodeResource.setLockedResource(this.aggregateResource(firstNodeResource.getLockedResource(), secondNodeResource.getLockedResource()));
            aggregatedNodeResource.setLeftResource(this.aggregateResource(firstNodeResource.getLeftResource(), secondNodeResource.getLeftResource()));
            return aggregatedNodeResource;
        }
        if (firstNodeResource == null && secondNodeResource == null) {
            return null;
        }
        if (firstNodeResource == null) {
            return (CommonNodeResource)secondNodeResource;
        }
        return (CommonNodeResource)firstNodeResource;
    }

    public Resource aggregateResource(Resource firstResource, Resource secondResource) {
        Tuple2 tuple2 = new Tuple2((Object)firstResource, (Object)secondResource);
        if (tuple2 != null) {
            Resource resource = (Resource)tuple2._1();
            Resource resource2 = (Resource)tuple2._2();
            if (resource == null && resource2 == null) {
                return null;
            }
        }
        if (tuple2 != null) {
            Resource resource = (Resource)tuple2._1();
            Resource secondResource2 = (Resource)tuple2._2();
            if (resource == null) {
                return secondResource2;
            }
        }
        if (tuple2 != null) {
            Resource firstResource2 = (Resource)tuple2._1();
            Resource resource = (Resource)tuple2._2();
            if (resource == null) {
                return firstResource2;
            }
        }
        if (tuple2 != null) {
            Resource firstResource3 = (Resource)tuple2._1();
            Resource secondResource3 = (Resource)tuple2._2();
            if (firstResource3.getClass().equals(secondResource3.getClass())) {
                return firstResource3.add(secondResource3);
            }
        }
        return null;
    }

    public String getResourceInfoMsg(String resourceType, String unitType, Object requestResource, Object availableResource, Object maxResource, String queueName) {
        String maxMsg;
        String reqMsg = requestResource == null ? new StringBuilder(4).append("null").append(unitType).toString() : RMUtils$.dealMemory$1(resourceType, unitType, requestResource);
        String availMsg = availableResource == null ? new StringBuilder(4).append("null").append(unitType).toString() : RMUtils$.dealMemory$1(resourceType, unitType, availableResource.toString());
        String string = maxMsg = maxResource == null ? new StringBuilder(4).append("null").append(unitType).toString() : RMUtils$.dealMemory$1(resourceType, unitType, maxResource.toString());
        if (StringUtils.isEmpty((CharSequence)queueName)) {
            return new StringBuilder(66).append(" use ").append(resourceType).append(", requestResource : ").append(reqMsg).append(" > availableResource : ").append(availMsg).append(",  maxResource : ").append(maxMsg).append(".").toString();
        }
        return new StringBuilder(80).append(" use ").append(resourceType).append(", requestResource : ").append(reqMsg).append(" > availableResource : ").append(availMsg).append(",  maxResource : ").append(maxMsg).append(", queueName : ").append(queueName).append(".").toString();
    }

    public String getResourceInfoMsg$default$6() {
        return "";
    }

    public String getECTicketID() {
        return UUID.randomUUID().toString();
    }

    public String getCombinedLabel() {
        if (this.COMBINED_USERCREATOR_ENGINETYPE() == null) {
            UserCreatorLabel userCreatorLabel = (UserCreatorLabel)LabelManagerUtils$.MODULE$.labelFactory().createLabel(UserCreatorLabel.class);
            EngineTypeLabel engineTypeLabel = (EngineTypeLabel)LabelManagerUtils$.MODULE$.labelFactory().createLabel(EngineTypeLabel.class);
            CombinedLabelBuilder combinedLabelBuilder = new CombinedLabelBuilder();
            Label combinedLabel = combinedLabelBuilder.build("", (Object)Lists.newArrayList((Object[])new GenericLabel[]{userCreatorLabel, engineTypeLabel}));
            this.COMBINED_USERCREATOR_ENGINETYPE_$eq(combinedLabel.getLabelKey());
            return this.COMBINED_USERCREATOR_ENGINETYPE();
        }
        return this.COMBINED_USERCREATOR_ENGINETYPE();
    }

    public HashMap<String, HashMap<String, Object>> getUserYarnResources(List<PersistenceResource> resources) {
        HashMap<String, HashMap<String, Object>> userResourceMap = new HashMap<String, HashMap<String, Object>>();
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(resources).asScala()).foreach((Function1 & Serializable & scala.Serializable)resource -> {
            UserResource userResource = ResourceUtils.fromPersistenceResourceAndUser((PersistenceResource)resource);
            userResourceMap.put("maxResource", MODULE$.getYarnResourceMap(userResource.getMaxResource()));
            userResourceMap.put("usedResource", MODULE$.getYarnResourceMap(userResource.getUsedResource()));
            userResourceMap.put("lockedResource", MODULE$.getYarnResourceMap(userResource.getLockedResource()));
            return userResourceMap.put("leftResource", MODULE$.getYarnResourceMap(userResource.getLeftResource()));
        });
        return userResourceMap;
    }

    public HashMap<String, HashMap<String, Object>> getLinkisResources(List<PersistenceResource> resources, String engineType) {
        HashMap<String, HashMap<String, Object>> userResourceMap = new HashMap<String, HashMap<String, Object>>();
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(resources).asScala()).foreach((Function1 & Serializable & scala.Serializable)resource -> {
            UserResource userResource = ResourceUtils.fromPersistenceResourceAndUser((PersistenceResource)resource);
            userResourceMap.put("maxResource", MODULE$.getEcmResourceMap(userResource.getMaxResource(), engineType));
            userResourceMap.put("usedResource", MODULE$.getEcmResourceMap(userResource.getUsedResource(), engineType));
            userResourceMap.put("lockedResource", MODULE$.getEcmResourceMap(userResource.getLockedResource(), engineType));
            return userResourceMap.put("leftResource", MODULE$.getEcmResourceMap(userResource.getLeftResource(), engineType));
        });
        return userResourceMap;
    }

    public HashMap<String, Object> getYarnResourceMap(Resource resource) {
        HashMap<String, Object> resourceMap = new HashMap<String, Object>();
        YarnResource yarnResource = ((DriverAndYarnResource)resource).getYarnResource();
        resourceMap.put("queueMemory", new StringBuilder(1).append(ByteTimeUtils.negativeByteStringAsGb((String)new StringBuilder(1).append(yarnResource.getQueueMemory()).append("b").toString())).append("G").toString());
        resourceMap.put("queueCpu", BoxesRunTime.boxToInteger((int)yarnResource.getQueueCores()));
        resourceMap.put("instance", BoxesRunTime.boxToInteger((int)yarnResource.getQueueInstances()));
        return resourceMap;
    }

    public HashMap<String, Object> getEcmResourceMap(Resource resource, String engineType) {
        HashMap<String, Object> resourceMap = new HashMap<String, Object>();
        LoadInstanceResource loadInstanceResource = new LoadInstanceResource(0L, 0, 0);
        loadInstanceResource = engineType.contains("spark") ? ((DriverAndYarnResource)resource).getLoadInstanceResource() : (LoadInstanceResource)resource;
        resourceMap.put("memory", new StringBuilder(1).append(ByteTimeUtils.negativeByteStringAsGb((String)new StringBuilder(1).append(loadInstanceResource.getMemory()).append("b").toString())).append("G").toString());
        resourceMap.put("core", BoxesRunTime.boxToInteger((int)loadInstanceResource.getCores()));
        return resourceMap;
    }

    public String getUserCreator(UserCreatorLabel userCreatorLabel) {
        return new StringBuilder(3).append("(").append(userCreatorLabel.getUser()).append(",").append(userCreatorLabel.getCreator()).append(")").toString();
    }

    public String getEngineType(EngineTypeLabel engineTypeLabel) {
        return new StringBuilder(3).append("(").append(engineTypeLabel.getEngineType()).append(",").append(engineTypeLabel.getVersion()).append(")").toString();
    }

    private static final String dealMemory$1(String resourceType, String unitType, Object resource) {
        if ("Memory".equals(resourceType) && "bytes".equals(unitType)) {
            return (String)Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> {
                if (MODULE$.logger().isDebugEnabled()) {
                    MODULE$.logger().debug(new StringBuilder(24).append("Will change ").append(resource.toString()).append(" from ").append(unitType).append(" to GB").toString());
                }
                return new StringBuilder(2).append(Long.toString(ByteTimeUtils.negativeByteStringAsGb((String)new StringBuilder(1).append(resource.toString()).append("b").toString()))).append("GB").toString();
            }, (Function1 & Serializable & scala.Serializable)x0$1 -> {
                Throwable throwable = x0$1;
                if (throwable instanceof Exception) {
                    Exception exception = (Exception)throwable;
                    MODULE$.logger().error(new StringBuilder(23).append("Cannot convert ").append(resource).append(" to Gb, ").append(exception.getMessage()).toString());
                    return new StringBuilder(0).append(resource.toString()).append(unitType).toString();
                }
                throw new MatchError((Object)throwable);
            });
        }
        return new StringBuilder(0).append(resource.toString()).append(unitType).toString();
    }

    private RMUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.jacksonUtil = JsonUtils$.MODULE$.jackson();
        this.MANAGER_KILL_ENGINE_EAIT = CommonVars$.MODULE$.apply("wds.linkis.manager.rm.kill.engine.wait", (Object)new TimeType("30s"));
        this.RM_REQUEST_ENABLE = CommonVars$.MODULE$.apply("wds.linkis.manager.rm.request.enable", (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.RM_RESOURCE_LOCK_WAIT_TIME = CommonVars$.MODULE$.apply("wds.linkis.manager.rm.lock.wait", (Object)BoxesRunTime.boxToInteger((int)300000));
        this.RM_DEBUG_ENABLE = CommonVars$.MODULE$.apply("wds.linkis.manager.rm.debug.enable", (Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.RM_DEBUG_LOG_PATH = CommonVars$.MODULE$.apply("wds.linkis.manager.rm.debug.log.path", (Object)"file:///tmp/linkis/rmLog");
        this.EXTERNAL_RESOURCE_REFRESH_TIME = CommonVars$.MODULE$.apply("wds.linkis.manager.rm.external.resource.regresh.time", (Object)new TimeType("30m"));
        this.ENGINE_TYPE = CommonVars$.MODULE$.apply("wds.linkis.configuration.engine.type", (Object)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(EngineType$.MODULE$.getAllEngineTypes()).asScala()).mkString(","));
        this.RM_RESOURCE_ACTION_RECORD = CommonVars$.MODULE$.apply("wds.linkis.manager.rm.resource.action.record", (Object)BoxesRunTime.boxToBoolean((boolean)true));
    }
}

