/*
 * Decompiled with CFR 0.152.
 */
package py4j;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.Socket;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import py4j.CallbackClient;
import py4j.ClientServerConnection;
import py4j.Gateway;
import py4j.GatewayServerListener;
import py4j.Py4JClientConnection;
import py4j.Py4JJavaServer;
import py4j.Py4JNetworkException;
import py4j.Py4JPythonClient;
import py4j.Py4JPythonClientPerThread;
import py4j.Py4JServerConnection;
import py4j.commands.Command;

public class PythonClient
extends CallbackClient
implements Py4JPythonClientPerThread,
GatewayServerListener {
    protected Gateway gateway;
    protected List<Class<? extends Command>> customCommands;
    protected final Logger logger = Logger.getLogger(PythonClient.class.getName());
    protected Py4JJavaServer javaServer;
    protected ThreadLocal<WeakReference<ClientServerConnection>> threadConnection;
    protected final int readTimeout;

    public PythonClient(Gateway gateway, List<Class<? extends Command>> customCommands, int pythonPort, InetAddress pythonAddress, long minConnectionTime, TimeUnit minConnectionTimeUnit, SocketFactory socketFactory, Py4JJavaServer javaServer) {
        this(gateway, customCommands, pythonPort, pythonAddress, minConnectionTime, minConnectionTimeUnit, socketFactory, javaServer, true, 0);
    }

    public PythonClient(Gateway gateway, List<Class<? extends Command>> customCommands, int pythonPort, InetAddress pythonAddress, long minConnectionTime, TimeUnit minConnectionTimeUnit, SocketFactory socketFactory, Py4JJavaServer javaServer, boolean enableMemoryManagement, int readTimeout) {
        super(pythonPort, pythonAddress, minConnectionTime, minConnectionTimeUnit, socketFactory, enableMemoryManagement);
        this.gateway = gateway;
        this.javaServer = javaServer;
        this.customCommands = customCommands;
        this.threadConnection = new ThreadLocal();
        this.readTimeout = readTimeout;
        this.setSelfListener();
    }

    private void setSelfListener() {
        if (this.javaServer != null) {
            this.javaServer.addListener(this);
        }
    }

    @Override
    public ClientServerConnection getPerThreadConnection() {
        ClientServerConnection connection = null;
        WeakReference<ClientServerConnection> weakConnection = this.threadConnection.get();
        if (weakConnection != null) {
            connection = (ClientServerConnection)weakConnection.get();
        }
        return connection;
    }

    @Override
    public void setPerThreadConnection(ClientServerConnection clientServerConnection) {
        this.threadConnection.set(new WeakReference<ClientServerConnection>(clientServerConnection));
    }

    @Override
    public Gateway getGateway() {
        return this.gateway;
    }

    @Override
    public void setGateway(Gateway gateway) {
        this.gateway = gateway;
    }

    @Override
    public Py4JJavaServer getJavaServer() {
        return this.javaServer;
    }

    @Override
    public void setJavaServer(Py4JJavaServer javaServer) {
        this.javaServer = javaServer;
        this.setSelfListener();
    }

    @Override
    public int getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    protected void setupCleaner() {
    }

    protected Socket startClientSocket() throws IOException {
        this.logger.info("Starting Python Client connection on " + this.address + " at " + this.port);
        Socket socket = this.socketFactory.createSocket(this.address, this.port);
        socket.setSoTimeout(this.readTimeout);
        return socket;
    }

    @Override
    protected Py4JClientConnection getConnection() throws IOException {
        ClientServerConnection connection = null;
        connection = this.getPerThreadConnection();
        if (connection != null) {
            this.connections.remove(connection);
        }
        if (connection == null || connection.getSocket() == null) {
            Socket socket = this.startClientSocket();
            connection = new ClientServerConnection(this.gateway, socket, this.customCommands, this, this.javaServer, this.readTimeout);
            connection.setInitiatedFromClient(true);
            connection.start();
            this.setPerThreadConnection(connection);
        }
        return connection;
    }

    @Override
    protected boolean shouldRetrySendCommand(Py4JClientConnection cc, Py4JNetworkException pne) {
        boolean shouldRetry = super.shouldRetrySendCommand(cc, pne);
        if (shouldRetry && cc instanceof ClientServerConnection) {
            ClientServerConnection csc = (ClientServerConnection)cc;
            shouldRetry = csc.isInitiatedFromClient();
        }
        return shouldRetry;
    }

    @Override
    protected void giveBackConnection(Py4JClientConnection cc) {
        this.connections.addLast(cc);
    }

    @Override
    public Py4JPythonClient copyWith(InetAddress pythonAddress, int pythonPort) {
        return new PythonClient(this.gateway, this.customCommands, pythonPort, pythonAddress, this.minConnectionTime, this.minConnectionTimeUnit, this.socketFactory, this.javaServer);
    }

    @Override
    public void connectionError(Exception e) {
    }

    @Override
    public void connectionStarted(Py4JServerConnection gatewayConnection) {
    }

    @Override
    public void connectionStopped(Py4JServerConnection gatewayConnection) {
        try {
            this.connections.remove(gatewayConnection);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void serverError(Exception e) {
    }

    @Override
    public void serverPostShutdown() {
    }

    @Override
    public void serverPreShutdown() {
    }

    @Override
    public void serverStarted() {
    }

    @Override
    public void serverStopped() {
    }
}

