/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.common.conf;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URL;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.conf.BDPConfiguration$;
import org.apache.linkis.common.conf.ByteType;
import org.apache.linkis.common.conf.CommonVars;
import org.apache.linkis.common.conf.TimeType;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.sys.SystemProperties;
import scala.sys.package$;

public final class BDPConfiguration$
implements Logging {
    public static BDPConfiguration$ MODULE$;
    private final String DEFAULT_PROPERTY_FILE_NAME;
    private final String DEFAULT_SERVER_CONF_FILE_NAME;
    private final long DEFAULT_CONFIG_HOT_LOAD_DELAY_MILLS;
    private final Properties extractConfig;
    private final Properties org$apache$linkis$common$conf$BDPConfiguration$$config;
    private final SystemProperties sysProps;
    private final Map<String, String> env;
    private final ArrayBuffer<String> org$apache$linkis$common$conf$BDPConfiguration$$configList;
    private final Properties org$apache$linkis$common$conf$BDPConfiguration$$configReload;
    private final ReentrantReadWriteLock org$apache$linkis$common$conf$BDPConfiguration$$lock;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new BDPConfiguration$();
    }

    @Override
    public void trace(Function0<String> message) {
        Logging.trace$(this, message);
    }

    @Override
    public void debug(Function0<String> message) {
        Logging.debug$(this, message);
    }

    @Override
    public void info(Function0<String> message) {
        Logging.info$(this, message);
    }

    @Override
    public void info(Function0<String> message, Throwable t) {
        Logging.info$(this, message, t);
    }

    @Override
    public void warn(Function0<String> message) {
        Logging.warn$(this, message);
    }

    @Override
    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$(this, message, t);
    }

    @Override
    public void error(Function0<String> message, Throwable t) {
        Logging.error$(this, message, t);
    }

    @Override
    public void error(Function0<String> message) {
        Logging.error$(this, message);
    }

    private Logger logger$lzycompute() {
        BDPConfiguration$ bDPConfiguration$ = this;
        synchronized (bDPConfiguration$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String DEFAULT_PROPERTY_FILE_NAME() {
        return this.DEFAULT_PROPERTY_FILE_NAME;
    }

    public String DEFAULT_SERVER_CONF_FILE_NAME() {
        return this.DEFAULT_SERVER_CONF_FILE_NAME;
    }

    public long DEFAULT_CONFIG_HOT_LOAD_DELAY_MILLS() {
        return this.DEFAULT_CONFIG_HOT_LOAD_DELAY_MILLS;
    }

    private Properties extractConfig() {
        return this.extractConfig;
    }

    public Properties org$apache$linkis$common$conf$BDPConfiguration$$config() {
        return this.org$apache$linkis$common$conf$BDPConfiguration$$config;
    }

    private SystemProperties sysProps() {
        return this.sysProps;
    }

    private Map<String, String> env() {
        return this.env;
    }

    public ArrayBuffer<String> org$apache$linkis$common$conf$BDPConfiguration$$configList() {
        return this.org$apache$linkis$common$conf$BDPConfiguration$$configList;
    }

    public Properties org$apache$linkis$common$conf$BDPConfiguration$$configReload() {
        return this.org$apache$linkis$common$conf$BDPConfiguration$$configReload;
    }

    public ReentrantReadWriteLock org$apache$linkis$common$conf$BDPConfiguration$$lock() {
        return this.org$apache$linkis$common$conf$BDPConfiguration$$lock;
    }

    private void init() {
        String propertyFile = (String)this.sysProps().getOrElse((Object)"wds.linkis.configuration", (Function0 & Serializable & scala.Serializable)() -> MODULE$.DEFAULT_PROPERTY_FILE_NAME());
        URL configFileURL = this.getClass().getClassLoader().getResource(propertyFile);
        if (configFileURL != null && new File(configFileURL.getPath()).exists()) {
            this.logger().info(new StringBuilder(83).append("******************* Notice: The Linkis configuration file is ").append(propertyFile).append(" ! *******************").toString());
            this.org$apache$linkis$common$conf$BDPConfiguration$$initConfig(this.org$apache$linkis$common$conf$BDPConfiguration$$config(), configFileURL.getPath());
            this.org$apache$linkis$common$conf$BDPConfiguration$$configList().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{configFileURL.getPath()}));
        } else {
            this.logger().warn(new StringBuilder(87).append("************ Notice: The Linkis configuration file ").append(propertyFile).append(" does not exist! *******************").toString());
        }
        String serverConf = (String)this.sysProps().getOrElse((Object)"wds.linkis.server.conf", (Function0 & Serializable & scala.Serializable)() -> MODULE$.DEFAULT_SERVER_CONF_FILE_NAME());
        URL serverConfFileURL = this.getClass().getClassLoader().getResource(serverConf);
        if (serverConfFileURL != null && new File(serverConfFileURL.getPath()).exists()) {
            this.logger().info(new StringBuilder(83).append("*********************** Notice: The Linkis serverConf file is ").append(serverConf).append(" ! ******************").toString());
            this.org$apache$linkis$common$conf$BDPConfiguration$$initConfig(this.org$apache$linkis$common$conf$BDPConfiguration$$config(), serverConfFileURL.getPath());
            this.org$apache$linkis$common$conf$BDPConfiguration$$configList().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{serverConfFileURL.getPath()}));
        } else {
            this.logger().warn(new StringBuilder(88).append("**************** Notice: The Linkis serverConf file ").append(serverConf).append(" does not exist! *******************").toString());
        }
        Option propertyFileOptions = this.sysProps().get("wds.linkis.server.confs");
        if (propertyFileOptions.isDefined()) {
            String[] propertyFiles = ((String)propertyFileOptions.get()).split(",");
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])propertyFiles)).foreach((Function1 & Serializable & scala.Serializable)propertyF -> {
                BDPConfiguration$.$anonfun$init$3(propertyF);
                return BoxedUnit.UNIT;
            });
        }
        Runnable hotLoadTask = new Runnable(){

            public void run() {
                ObjectRef tmpConfigPath = ObjectRef.create((Object)"");
                ObjectRef tmpConfig = ObjectRef.create((Object)new Properties());
                Utils$.MODULE$.tryCatch((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> BDPConfiguration$.MODULE$.org$apache$linkis$common$conf$BDPConfiguration$$configList().foreach((Function1 & Serializable & scala.Serializable)configPath -> {
                    anon.1.$anonfun$run$2(tmpConfigPath, tmpConfig, configPath);
                    return BoxedUnit.UNIT;
                }), (Function1 & Serializable & scala.Serializable)x0$1 -> {
                    anon.1.$anonfun$run$3(tmpConfigPath, tmpConfig, x0$1);
                    return BoxedUnit.UNIT;
                });
                BDPConfiguration$.MODULE$.org$apache$linkis$common$conf$BDPConfiguration$$lock().writeLock().lock();
                ((IterableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)tmpConfig.elem).asScala()).foreach((Function1 & Serializable & scala.Serializable)keyValue -> BDPConfiguration$.MODULE$.org$apache$linkis$common$conf$BDPConfiguration$$configReload().setProperty((String)keyValue._1(), (String)keyValue._2()));
                BDPConfiguration$.MODULE$.org$apache$linkis$common$conf$BDPConfiguration$$lock().writeLock().unlock();
            }

            public static final /* synthetic */ void $anonfun$run$2(ObjectRef tmpConfigPath$1, ObjectRef tmpConfig$1, String configPath) {
                if (BDPConfiguration$.MODULE$.logger().isDebugEnabled()) {
                    BDPConfiguration$.MODULE$.logger().debug(new StringBuilder(21).append("reload config file : ").append(configPath).toString());
                }
                tmpConfigPath$1.elem = configPath;
                BDPConfiguration$.MODULE$.org$apache$linkis$common$conf$BDPConfiguration$$initConfig((Properties)tmpConfig$1.elem, configPath);
            }

            public static final /* synthetic */ void $anonfun$run$3(ObjectRef tmpConfigPath$1, ObjectRef tmpConfig$1, Throwable x0$1) {
                Throwable throwable = x0$1;
                if (throwable instanceof Exception) {
                    Exception exception = (Exception)throwable;
                    BDPConfiguration$.MODULE$.logger().error(new StringBuilder(40).append("reload config file : ").append((String)tmpConfigPath$1.elem).append(" failed, because : ").append(exception.getMessage()).toString());
                    BDPConfiguration$.MODULE$.logger().warn("Will reset config to origin config.");
                    tmpConfig$1.elem = BDPConfiguration$.MODULE$.org$apache$linkis$common$conf$BDPConfiguration$$config();
                    return;
                }
                throw new MatchError((Object)throwable);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(scala.runtime.ObjectRef scala.runtime.ObjectRef ), $anonfun$run$3$adapted(scala.runtime.ObjectRef scala.runtime.ObjectRef java.lang.Throwable ), $anonfun$run$4(scala.Tuple2 ), $anonfun$run$2$adapted(scala.runtime.ObjectRef scala.runtime.ObjectRef java.lang.String )}, serializedLambda);
            }
        };
        Utils$.MODULE$.defaultScheduler().scheduleWithFixedDelay(hotLoadTask, 3000L, this.DEFAULT_CONFIG_HOT_LOAD_DELAY_MILLS(), TimeUnit.MILLISECONDS);
        this.logger().info("hotload config task inited.");
    }

    public void org$apache$linkis$common$conf$BDPConfiguration$$initConfig(Properties config, String filePath) {
        ObjectRef inputStream = ObjectRef.create(null);
        ObjectRef reader = ObjectRef.create(null);
        ObjectRef buff = ObjectRef.create(null);
        Utils$.MODULE$.tryFinally((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Utils$.MODULE$.tryCatch((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            inputStream$1.elem = new FileInputStream(filePath);
            reader$1.elem = new InputStreamReader((InputStream)inputStream$1.elem, "UTF-8");
            buff$1.elem = new BufferedReader((InputStreamReader)reader$1.elem);
            config.load((BufferedReader)buff$1.elem);
        }, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            BDPConfiguration$.$anonfun$initConfig$3(filePath, x0$1);
            return BoxedUnit.UNIT;
        }), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            IOUtils.closeQuietly((Reader)((BufferedReader)buff$1.elem));
            IOUtils.closeQuietly((Reader)((InputStreamReader)reader$1.elem));
            IOUtils.closeQuietly((InputStream)((InputStream)inputStream$1.elem));
        });
    }

    public Option<String> getOption(String key, boolean hotload) {
        if (this.extractConfig().containsKey(key)) {
            return new Some((Object)this.extractConfig().getProperty(key));
        }
        String value = "";
        if (hotload) {
            this.org$apache$linkis$common$conf$BDPConfiguration$$lock().readLock().lock();
            value = this.org$apache$linkis$common$conf$BDPConfiguration$$configReload().getProperty(key);
            this.org$apache$linkis$common$conf$BDPConfiguration$$lock().readLock().unlock();
        } else {
            value = this.org$apache$linkis$common$conf$BDPConfiguration$$config().getProperty(key);
        }
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            return new Some((Object)value);
        }
        Option propsValue = this.sysProps().get(key).orElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.props().get(key));
        if (propsValue.isDefined()) {
            return propsValue;
        }
        return this.env().get((Object)key);
    }

    public Properties properties() {
        Properties props = new Properties();
        this.mergePropertiesFromMap(props, this.env());
        this.mergePropertiesFromMap(props, (Map<String, String>)this.sysProps().toMap(Predef$.MODULE$.$conforms()));
        this.mergePropertiesFromMap(props, (Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(this.org$apache$linkis$common$conf$BDPConfiguration$$config()).asScala()).toMap(Predef$.MODULE$.$conforms()));
        this.mergePropertiesFromMap(props, (Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(this.extractConfig()).asScala()).toMap(Predef$.MODULE$.$conforms()));
        return props;
    }

    public Properties hotProperties() {
        Properties props = new Properties();
        this.mergePropertiesFromMap(props, this.env());
        this.mergePropertiesFromMap(props, (Map<String, String>)this.sysProps().toMap(Predef$.MODULE$.$conforms()));
        this.org$apache$linkis$common$conf$BDPConfiguration$$lock().readLock().lock();
        this.mergePropertiesFromMap(props, (Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(this.org$apache$linkis$common$conf$BDPConfiguration$$configReload()).asScala()).toMap(Predef$.MODULE$.$conforms()));
        this.org$apache$linkis$common$conf$BDPConfiguration$$lock().readLock().unlock();
        this.mergePropertiesFromMap(props, (Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(this.extractConfig()).asScala()).toMap(Predef$.MODULE$.$conforms()));
        return props;
    }

    public void mergePropertiesFromMap(Properties props, Map<String, String> mapProps) {
        mapProps.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return props.put(k, v);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public <T> Option<T> getOption(CommonVars<T> commonVars, boolean hotload) {
        if (hotload) {
            Option<String> value = this.getOption(commonVars.key(), true);
            if (value.isEmpty()) {
                return Option$.MODULE$.apply(commonVars.defaultValue());
            }
            return this.formatValue(commonVars.defaultValue(), value);
        }
        if (commonVars.value() != null) {
            return Option$.MODULE$.apply(commonVars.value());
        }
        Option<String> value = this.getOption(commonVars.key(), this.getOption$default$2());
        if (value.isEmpty()) {
            return Option$.MODULE$.apply(commonVars.defaultValue());
        }
        return this.formatValue(commonVars.defaultValue(), value);
    }

    public <T> Option<T> getOption(CommonVars<T> commonVars) {
        if (commonVars.value() != null) {
            return Option$.MODULE$.apply(commonVars.value());
        }
        Option<String> value = this.getOption(commonVars.key(), this.getOption$default$2());
        if (value.isEmpty()) {
            return Option$.MODULE$.apply(commonVars.defaultValue());
        }
        return this.formatValue(commonVars.defaultValue(), value);
    }

    public <T> Option<T> formatValue(T defaultValue, Option<String> value) {
        Option option;
        if (value.isEmpty() || value.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BDPConfiguration$.$anonfun$formatValue$1(x$1)))) {
            return Option$.MODULE$.apply(defaultValue);
        }
        Option trimValue = value.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.trim());
        T t = defaultValue;
        if (t instanceof String) {
            option = trimValue;
        } else if (t instanceof Byte) {
            option = trimValue.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToByte((byte)BDPConfiguration$.$anonfun$formatValue$3(x$2)));
        } else if (t instanceof Short) {
            option = trimValue.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToShort((short)BDPConfiguration$.$anonfun$formatValue$4(x$3)));
        } else if (t instanceof Character) {
            option = trimValue.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToCharacter((char)BDPConfiguration$.$anonfun$formatValue$5(x$4)));
        } else if (t instanceof Integer) {
            option = trimValue.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)BDPConfiguration$.$anonfun$formatValue$6(x$5)));
        } else if (t instanceof Long) {
            option = trimValue.map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)BDPConfiguration$.$anonfun$formatValue$7(x$6)));
        } else if (t instanceof Float) {
            option = trimValue.map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToFloat((float)BDPConfiguration$.$anonfun$formatValue$8(x$7)));
        } else if (t instanceof Double) {
            option = trimValue.map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToDouble((double)BDPConfiguration$.$anonfun$formatValue$9(x$8)));
        } else if (t instanceof Boolean) {
            option = trimValue.map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)BDPConfiguration$.$anonfun$formatValue$10(x$9)));
        } else if (t instanceof TimeType) {
            option = trimValue.map((Function1 & Serializable & scala.Serializable)x$10 -> new TimeType((String)x$10));
        } else if (t instanceof ByteType) {
            option = trimValue.map((Function1 & Serializable & scala.Serializable)x$11 -> new ByteType((String)x$11));
        } else if (t == null) {
            option = trimValue;
        } else {
            throw new MatchError(t);
        }
        Option formattedValue = option;
        return formattedValue;
    }

    public Object set(String key, String value) {
        return this.extractConfig().setProperty(key, value);
    }

    public Object setIfNotExists(String key, String value) {
        if (!this.org$apache$linkis$common$conf$BDPConfiguration$$config().containsKey(key)) {
            return this.set(key, value);
        }
        return BoxedUnit.UNIT;
    }

    public boolean getBoolean(String key, boolean bl, boolean hotload) {
        return BoxesRunTime.unboxToBoolean((Object)this.getOption(key, hotload).map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)BDPConfiguration$.$anonfun$getBoolean$1(x$12))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> bl));
    }

    public Option<Object> getBoolean(CommonVars<Object> commonVars) {
        return this.getOption(commonVars);
    }

    public String get(String key, String string) {
        return (String)this.getOption(key, false).getOrElse((Function0 & Serializable & scala.Serializable)() -> string);
    }

    public String get(String key, String string, boolean hotload) {
        return (String)this.getOption(key, hotload).getOrElse((Function0 & Serializable & scala.Serializable)() -> string);
    }

    public Option<String> get(CommonVars<String> commonVars) {
        return this.getOption(commonVars);
    }

    public String get(String key, boolean hotload) {
        return (String)this.getOption(key, hotload).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NoSuchElementException(key);
        });
    }

    public String get(String key) {
        return (String)this.getOption(key, this.getOption$default$2()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NoSuchElementException(key);
        });
    }

    public boolean getOption$default$2() {
        return false;
    }

    public boolean getBoolean$default$3() {
        return false;
    }

    public boolean get$default$2() {
        return false;
    }

    public int getInt(String key, int n, boolean hotload) {
        return BoxesRunTime.unboxToInt((Object)this.getOption(key, hotload).map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToInteger((int)BDPConfiguration$.$anonfun$getInt$1(x$13))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> n));
    }

    public Option<Object> getInt(CommonVars<Object> commonVars) {
        return this.getOption(commonVars);
    }

    public boolean getInt$default$3() {
        return false;
    }

    public boolean contains(String key) {
        return this.getOption(key, this.getOption$default$2()).isDefined();
    }

    public boolean contains(String key, boolean hotload) {
        return this.getOption(key, hotload).isDefined();
    }

    public boolean contains$default$2() {
        return false;
    }

    public static final /* synthetic */ void $anonfun$init$3(String propertyF) {
        URL configFileURL = MODULE$.getClass().getClassLoader().getResource(propertyF);
        if (configFileURL != null && new File(configFileURL.getPath()).exists()) {
            MODULE$.logger().info(new StringBuilder(73).append("************** Notice: The Linkis server.confs  is file ").append(propertyF).append(" ****************").toString());
            MODULE$.org$apache$linkis$common$conf$BDPConfiguration$$initConfig(MODULE$.org$apache$linkis$common$conf$BDPConfiguration$$config(), configFileURL.getPath());
            MODULE$.org$apache$linkis$common$conf$BDPConfiguration$$configList().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{configFileURL.getPath()}));
            return;
        }
        MODULE$.logger().warn(new StringBuilder(79).append("********** Notice: The Linkis server.confs file ").append(propertyF).append(" does not exist! **************").toString());
    }

    public static final /* synthetic */ void $anonfun$new$2(Throwable e) {
        MODULE$.logger().warn("Failed to init conf", e);
    }

    public static final /* synthetic */ void $anonfun$initConfig$3(String filePath$1, Throwable x0$1) {
        Throwable throwable = x0$1;
        if (throwable instanceof IOException) {
            IOException iOException = (IOException)throwable;
            MODULE$.logger().error(new StringBuilder(11).append("Can't load ").append(filePath$1).toString(), (Throwable)iOException);
            return;
        }
        throw new MatchError((Object)throwable);
    }

    public static final /* synthetic */ boolean $anonfun$formatValue$1(CharSequence x$1) {
        return StringUtils.isEmpty((CharSequence)x$1);
    }

    public static final /* synthetic */ byte $anonfun$formatValue$3(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toByte();
    }

    public static final /* synthetic */ short $anonfun$formatValue$4(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).toShort();
    }

    public static final /* synthetic */ char $anonfun$formatValue$5(String x$4) {
        return x$4.toCharArray()[0];
    }

    public static final /* synthetic */ int $anonfun$formatValue$6(String x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5)).toInt();
    }

    public static final /* synthetic */ long $anonfun$formatValue$7(String x$6) {
        return new StringOps(Predef$.MODULE$.augmentString(x$6)).toLong();
    }

    public static final /* synthetic */ float $anonfun$formatValue$8(String x$7) {
        return new StringOps(Predef$.MODULE$.augmentString(x$7)).toFloat();
    }

    public static final /* synthetic */ double $anonfun$formatValue$9(String x$8) {
        return new StringOps(Predef$.MODULE$.augmentString(x$8)).toDouble();
    }

    public static final /* synthetic */ boolean $anonfun$formatValue$10(String x$9) {
        return new StringOps(Predef$.MODULE$.augmentString(x$9)).toBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$getBoolean$1(String x$12) {
        return new StringOps(Predef$.MODULE$.augmentString(x$12)).toBoolean();
    }

    public static final /* synthetic */ int $anonfun$getInt$1(String x$13) {
        return new StringOps(Predef$.MODULE$.augmentString(x$13)).toInt();
    }

    private BDPConfiguration$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.DEFAULT_PROPERTY_FILE_NAME = "linkis.properties";
        this.DEFAULT_SERVER_CONF_FILE_NAME = "linkis-server.properties";
        this.DEFAULT_CONFIG_HOT_LOAD_DELAY_MILLS = 180000L;
        this.extractConfig = new Properties();
        this.org$apache$linkis$common$conf$BDPConfiguration$$config = new Properties();
        this.sysProps = package$.MODULE$.props();
        this.env = package$.MODULE$.env();
        this.org$apache$linkis$common$conf$BDPConfiguration$$configList = new ArrayBuffer();
        this.org$apache$linkis$common$conf$BDPConfiguration$$configReload = new Properties();
        this.org$apache$linkis$common$conf$BDPConfiguration$$lock = new ReentrantReadWriteLock();
        Utils$.MODULE$.tryCatch((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.init(), (Function1 & Serializable & scala.Serializable)e -> {
            BDPConfiguration$.$anonfun$new$2(e);
            return BoxedUnit.UNIT;
        });
    }
}

