/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.excel;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.apache.linkis.common.io.MetaData;
import org.apache.linkis.common.io.Record;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.storage.domain.BigDecimalType$;
import org.apache.linkis.storage.domain.BigIntType$;
import org.apache.linkis.storage.domain.CharType$;
import org.apache.linkis.storage.domain.Column;
import org.apache.linkis.storage.domain.DataType;
import org.apache.linkis.storage.domain.DataType$;
import org.apache.linkis.storage.domain.DateType$;
import org.apache.linkis.storage.domain.DecimalType$;
import org.apache.linkis.storage.domain.DoubleType$;
import org.apache.linkis.storage.domain.FloatType$;
import org.apache.linkis.storage.domain.IntType$;
import org.apache.linkis.storage.domain.LongType$;
import org.apache.linkis.storage.domain.ShortIntType$;
import org.apache.linkis.storage.domain.StringType$;
import org.apache.linkis.storage.domain.TimestampType$;
import org.apache.linkis.storage.domain.TinyIntType$;
import org.apache.linkis.storage.domain.VarcharType$;
import org.apache.linkis.storage.excel.ExcelFsWriter;
import org.apache.linkis.storage.resultset.table.TableMetaData;
import org.apache.linkis.storage.resultset.table.TableRecord;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t-e\u0001\u0002\u001b6\u0001\u0001C\u0001\"\u0014\u0001\u0003\u0006\u0004%\tA\u0014\u0005\t9\u0002\u0011\t\u0011)A\u0005\u001f\"AQ\f\u0001BC\u0002\u0013\u0005a\n\u0003\u0005_\u0001\t\u0005\t\u0015!\u0003P\u0011!y\u0006A!b\u0001\n\u0003q\u0005\u0002\u00031\u0001\u0005\u0003\u0005\u000b\u0011B(\t\u0011\u0005\u0004!Q1A\u0005\u0002\tD\u0001b\u001b\u0001\u0003\u0002\u0003\u0006Ia\u0019\u0005\tY\u0002\u0011)\u0019!C\u0001[\"A!\u000f\u0001B\u0001B\u0003%a\u000eC\u0003t\u0001\u0011\u0005A\u000fC\u0005|\u0001\u0001\u0007\t\u0019!C\ty\"Y\u0011q\u0002\u0001A\u0002\u0003\u0007I\u0011CA\t\u0011)\ti\u0002\u0001a\u0001\u0002\u0003\u0006K! \u0005\f\u0003?\u0001\u0001\u0019!a\u0001\n#\t\t\u0003C\u0006\u0002*\u0001\u0001\r\u00111A\u0005\u0012\u0005-\u0002bCA\u0018\u0001\u0001\u0007\t\u0011)Q\u0005\u0003GA1\"!\r\u0001\u0001\u0004\u0005\r\u0011\"\u0005\u00024!Y\u0011Q\t\u0001A\u0002\u0003\u0007I\u0011CA$\u0011-\tY\u0005\u0001a\u0001\u0002\u0003\u0006K!!\u000e\t\u0017\u00055\u0003\u00011AA\u0002\u0013E\u0011q\n\u0005\f\u0003G\u0002\u0001\u0019!a\u0001\n#\t)\u0007C\u0006\u0002j\u0001\u0001\r\u0011!Q!\n\u0005E\u0003\"CA6\u0001\u0001\u0007I\u0011CA7\u0011%\t)\b\u0001a\u0001\n#\t9\b\u0003\u0005\u0002|\u0001\u0001\u000b\u0015BA8\u0011%\ti\b\u0001a\u0001\n#\ti\u0007C\u0005\u0002\u0000\u0001\u0001\r\u0011\"\u0005\u0002\u0002\"A\u0011Q\u0011\u0001!B\u0013\ty\u0007C\u0005\u0002\b\u0002\u0011\r\u0011\"\u0005\u0002\n\"A\u0011Q\u0014\u0001!\u0002\u0013\tY\t\u0003\u0005\u0002 \u0002\u0001\r\u0011\"\u0005n\u0011%\t\t\u000b\u0001a\u0001\n#\t\u0019\u000bC\u0004\u0002(\u0002\u0001\u000b\u0015\u00028\t\u0013\u0005%\u0006A1A\u0005\u0012\u0005-\u0006\u0002CAZ\u0001\u0001\u0006I!!,\t\u0017\u0005U\u0006\u00011AA\u0002\u0013E\u0011q\u0017\u0005\f\u0003\u007f\u0003\u0001\u0019!a\u0001\n#\t\t\rC\u0006\u0002F\u0002\u0001\r\u0011!Q!\n\u0005e\u0006bBAd\u0001\u0011\u0005\u0011\u0011\u001a\u0005\b\u0003\u0017\u0004A\u0011AAg\u0011\u001d\ty\r\u0001C\u0001\u0003#Dq!!7\u0001\t\u0003\tY\u000eC\u0004\u0002b\u0002!\t!a9\t\u000f\u0005\u001d\b\u0001\"\u0011\u0002j\"9!1\b\u0001\u0005B\tu\u0002b\u0002B+\u0001\u0011%!q\u000b\u0005\b\u0005_\u0002A\u0011\u0002B9\u0011\u001d\u0011i\b\u0001C\u0005\u0005\u007fBqA!\"\u0001\t\u0003\u00129\tC\u0004\u0003\n\u0002!\tEa\"\u0003%M#xN]1hK\u0016C8-\u001a7Xe&$XM\u001d\u0006\u0003m]\nQ!\u001a=dK2T!\u0001O\u001d\u0002\u000fM$xN]1hK*\u0011!hO\u0001\u0007Y&t7.[:\u000b\u0005qj\u0014AB1qC\u000eDWMC\u0001?\u0003\ry'oZ\u0002\u0001'\r\u0001\u0011)\u0012\t\u0003\u0005\u000ek\u0011!N\u0005\u0003\tV\u0012Q\"\u0012=dK245o\u0016:ji\u0016\u0014\bC\u0001$L\u001b\u00059%B\u0001%J\u0003\u0015)H/\u001b7t\u0015\tQ\u0015(\u0001\u0004d_6lwN\\\u0005\u0003\u0019\u001e\u0013q\u0001T8hO&tw-A\u0004dQ\u0006\u00148/\u001a;\u0016\u0003=\u0003\"\u0001U-\u000f\u0005E;\u0006C\u0001*V\u001b\u0005\u0019&B\u0001+@\u0003\u0019a$o\\8u})\ta+A\u0003tG\u0006d\u0017-\u0003\u0002Y+\u00061\u0001K]3eK\u001aL!AW.\u0003\rM#(/\u001b8h\u0015\tAV+\u0001\u0005dQ\u0006\u00148/\u001a;!\u0003%\u0019\b.Z3u\u001d\u0006lW-\u0001\u0006tQ\u0016,GOT1nK\u0002\n!\u0002Z1uK\u001a{'/\\1u\u0003-!\u0017\r^3G_Jl\u0017\r\u001e\u0011\u0002\u0019=,H\u000f];u'R\u0014X-Y7\u0016\u0003\r\u0004\"\u0001Z5\u000e\u0003\u0015T!AZ4\u0002\u0005%|'\"\u00015\u0002\t)\fg/Y\u0005\u0003U\u0016\u0014AbT;uaV$8\u000b\u001e:fC6\fQb\\;uaV$8\u000b\u001e:fC6\u0004\u0013AC1vi>4uN]7biV\ta\u000e\u0005\u0002pa6\tQ+\u0003\u0002r+\n9!i\\8mK\u0006t\u0017aC1vi>4uN]7bi\u0002\na\u0001P5oSRtDCB;wobL(\u0010\u0005\u0002C\u0001!)Qj\u0003a\u0001\u001f\")Ql\u0003a\u0001\u001f\")ql\u0003a\u0001\u001f\")\u0011m\u0003a\u0001G\")An\u0003a\u0001]\u0006Aqo\u001c:l\u0005>|7.F\u0001~!\rq\u00181B\u0007\u0002\u007f*!\u0011\u0011AA\u0002\u0003%\u0019HO]3b[&twM\u0003\u0003\u0002\u0006\u0005\u001d\u0011\u0001\u0002=tg\u001aT1!!\u0003<\u0003\r\u0001x.[\u0005\u0004\u0003\u001by(!D*Y'N3uk\u001c:lE>|7.\u0001\u0007x_J\\'i\\8l?\u0012*\u0017\u000f\u0006\u0003\u0002\u0014\u0005e\u0001cA8\u0002\u0016%\u0019\u0011qC+\u0003\tUs\u0017\u000e\u001e\u0005\t\u00037i\u0011\u0011!a\u0001{\u0006\u0019\u0001\u0010J\u0019\u0002\u0013]|'o\u001b\"p_.\u0004\u0013!B:iK\u0016$XCAA\u0012!\rq\u0018QE\u0005\u0004\u0003Oy(AC*Y'N35\u000b[3fi\u0006I1\u000f[3fi~#S-\u001d\u000b\u0005\u0003'\ti\u0003C\u0005\u0002\u001cA\t\t\u00111\u0001\u0002$\u000511\u000f[3fi\u0002\naAZ8s[\u0006$XCAA\u001b!\u0011\t9$!\u0011\u000e\u0005\u0005e\"\u0002BA\u001e\u0003{\t\u0011\"^:fe6|G-\u001a7\u000b\t\u0005}\u0012qA\u0001\u0003gNLA!a\u0011\u0002:\tQA)\u0019;b\r>\u0014X.\u0019;\u0002\u0015\u0019|'/\\1u?\u0012*\u0017\u000f\u0006\u0003\u0002\u0014\u0005%\u0003\"CA\u000e'\u0005\u0005\t\u0019AA\u001b\u0003\u001d1wN]7bi\u0002\nQ\u0001^=qKN,\"!!\u0015\u0011\u000b=\f\u0019&a\u0016\n\u0007\u0005USKA\u0003BeJ\f\u0017\u0010\u0005\u0003\u0002Z\u0005}SBAA.\u0015\r\tifN\u0001\u0007I>l\u0017-\u001b8\n\t\u0005\u0005\u00141\f\u0002\t\t\u0006$\u0018\rV=qK\u0006IA/\u001f9fg~#S-\u001d\u000b\u0005\u0003'\t9\u0007C\u0005\u0002\u001cY\t\t\u00111\u0001\u0002R\u00051A/\u001f9fg\u0002\n\u0001B]8x!>Lg\u000e^\u000b\u0003\u0003_\u00022a\\A9\u0013\r\t\u0019(\u0016\u0002\u0004\u0013:$\u0018\u0001\u0004:poB{\u0017N\u001c;`I\u0015\fH\u0003BA\n\u0003sB\u0011\"a\u0007\u001a\u0003\u0003\u0005\r!a\u001c\u0002\u0013I|w\u000fU8j]R\u0004\u0013!D2pYVlgnQ8v]R,'/A\td_2,XN\\\"pk:$XM]0%KF$B!a\u0005\u0002\u0004\"I\u00111\u0004\u000f\u0002\u0002\u0003\u0007\u0011qN\u0001\u000fG>dW/\u001c8D_VtG/\u001a:!\u0003\u0019\u0019H/\u001f7fgV\u0011\u00111\u0012\t\b\u0003\u001b\u000b\u0019jTAL\u001b\t\tyIC\u0002\u0002\u0012\u001e\fA!\u001e;jY&!\u0011QSAH\u0005\u001dA\u0015m\u001d5NCB\u0004B!a\u000e\u0002\u001a&!\u00111TA\u001d\u0005%\u0019U\r\u001c7TifdW-A\u0004tifdWm\u001d\u0011\u0002\u000f%\u001ch\t\\;tQ\u0006Y\u0011n\u001d$mkNDw\fJ3r)\u0011\t\u0019\"!*\t\u0011\u0005m\u0011%!AA\u00029\f\u0001\"[:GYV\u001c\b\u000eI\u0001\u0003_N,\"!!,\u0011\u0007\u0011\fy+C\u0002\u00022\u0016\u0014QCQ=uK\u0006\u0013(/Y=PkR\u0004X\u000f^*ue\u0016\fW.A\u0002pg\u0002\n!![:\u0016\u0005\u0005e\u0006c\u00013\u0002<&\u0019\u0011QX3\u0003)\tKH/Z!se\u0006L\u0018J\u001c9viN#(/Z1n\u0003\u0019I7o\u0018\u0013fcR!\u00111CAb\u0011%\tYBJA\u0001\u0002\u0004\tI,A\u0002jg\u0002\nA!\u001b8jiV\u0011\u00111C\u0001\u0014O\u0016$H)\u001a4bk2$\b*Z1e'RLH.Z\u000b\u0003\u0003/\u000b1bZ3u/>\u00148NQ8pWV\u0011\u00111\u001b\t\u0005\u0003o\t).\u0003\u0003\u0002X\u0006e\"\u0001C,pe.\u0014wn\\6\u0002\u001f\r\u0014X-\u0019;f\u0007\u0016dGn\u0015;zY\u0016$B!a&\u0002^\"9\u0011q\\\u0016A\u0002\u0005]\u0013\u0001\u00033bi\u0006$\u0016\u0010]3\u0002\u0019\u001d,GoQ3mYN#\u0018\u0010\\3\u0015\t\u0005]\u0015Q\u001d\u0005\b\u0003?d\u0003\u0019AA,\u0003-\tG\rZ'fi\u0006$\u0015\r^1\u0015\t\u0005M\u00111\u001e\u0005\b\u0003[l\u0003\u0019AAx\u0003!iW\r^1ECR\f\u0007\u0003BAy\u0003kl!!a=\u000b\u0005\u0019L\u0015\u0002BA|\u0003g\u0014\u0001\"T3uC\u0012\u000bG/\u0019\u0015\u0006[\u0005m(q\u0001\t\u0006_\u0006u(\u0011A\u0005\u0004\u0003\u007f,&A\u0002;ie><8\u000fE\u0002e\u0005\u0007I1A!\u0002f\u0005-Iu*\u0012=dKB$\u0018n\u001c82\ryy%\u0011\u0002B\u001dc%\u0019#1\u0002B\t\u0005_\u0011\u0019\"F\u0002O\u0005\u001b!qAa\u0004@\u0005\u0004\u0011IBA\u0001U\u0013\u0011\u0011\u0019B!\u0006\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0015\r\u00119\"V\u0001\u0007i\"\u0014xn^:\u0012\t\tm!\u0011\u0005\t\u0004_\nu\u0011b\u0001B\u0010+\n9aj\u001c;iS:<\u0007\u0003\u0002B\u0012\u0005Sq1a\u001cB\u0013\u0013\r\u00119#V\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011YC!\f\u0003\u0013QC'o\\<bE2,'b\u0001B\u0014+FJ1E!\r\u00034\tU\"q\u0003\b\u0004_\nM\u0012b\u0001B\f+F*!e\\+\u00038\t)1oY1mCF\u001aaE!\u0001\u0002\u0013\u0005$GMU3d_J$G\u0003BA\n\u0005\u007fAqA!\u0011/\u0001\u0004\u0011\u0019%\u0001\u0004sK\u000e|'\u000f\u001a\t\u0005\u0003c\u0014)%\u0003\u0003\u0003H\u0005M(A\u0002*fG>\u0014H\rK\u0003/\u0003w\u0014Y%\r\u0004\u001f\u001f\n5#1K\u0019\nG\t-!\u0011\u0003B(\u0005'\t\u0014b\tB\u0019\u0005g\u0011\tFa\u00062\u000b\tzWKa\u000e2\u0007\u0019\u0012\t!\u0001\ttKR\u001cU\r\u001c7UsB,g+\u00197vKRA\u00111\u0003B-\u00057\u0012)\u0007C\u0004\u0002`>\u0002\r!a\u0016\t\u000f\tus\u00061\u0001\u0003`\u0005!Q\r\\3n!\ry'\u0011M\u0005\u0004\u0005G*&aA!os\"9!qM\u0018A\u0002\t%\u0014\u0001B2fY2\u00042A B6\u0013\r\u0011ig \u0002\n'b\u001b6KR\"fY2\fqaZ3u\t\u0006$X\r\u0006\u0003\u0003t\te\u0004\u0003BAG\u0005kJAAa\u001e\u0002\u0010\n!A)\u0019;f\u0011\u001d\u0011Y\b\ra\u0001\u0005?\nQA^1mk\u0016\f1\u0002Z8vE2,7\t[3dWR!\u00111\u0003BA\u0011\u0019\u0011\u0019)\ra\u0001\u001f\u0006IQ\r\\3n-\u0006dW/Z\u0001\u0006M2,8\u000f\u001b\u000b\u0003\u0003'\tQa\u00197pg\u0016\u0004")
public class StorageExcelWriter
extends ExcelFsWriter
implements Logging {
    private final String charset;
    private final String sheetName;
    private final String dateFormat;
    private final OutputStream outputStream;
    private final boolean autoFormat;
    private SXSSFWorkbook workBook;
    private SXSSFSheet sheet;
    private DataFormat format;
    private DataType[] types;
    private int rowPoint;
    private int columnCounter;
    private final HashMap<String, CellStyle> styles;
    private boolean isFlush;
    private final ByteArrayOutputStream os;
    private ByteArrayInputStream is;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        StorageExcelWriter storageExcelWriter = this;
        synchronized (storageExcelWriter) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String charset() {
        return this.charset;
    }

    @Override
    public String sheetName() {
        return this.sheetName;
    }

    @Override
    public String dateFormat() {
        return this.dateFormat;
    }

    public OutputStream outputStream() {
        return this.outputStream;
    }

    @Override
    public boolean autoFormat() {
        return this.autoFormat;
    }

    public SXSSFWorkbook workBook() {
        return this.workBook;
    }

    public void workBook_$eq(SXSSFWorkbook x$1) {
        this.workBook = x$1;
    }

    public SXSSFSheet sheet() {
        return this.sheet;
    }

    public void sheet_$eq(SXSSFSheet x$1) {
        this.sheet = x$1;
    }

    public DataFormat format() {
        return this.format;
    }

    public void format_$eq(DataFormat x$1) {
        this.format = x$1;
    }

    public DataType[] types() {
        return this.types;
    }

    public void types_$eq(DataType[] x$1) {
        this.types = x$1;
    }

    public int rowPoint() {
        return this.rowPoint;
    }

    public void rowPoint_$eq(int x$1) {
        this.rowPoint = x$1;
    }

    public int columnCounter() {
        return this.columnCounter;
    }

    public void columnCounter_$eq(int x$1) {
        this.columnCounter = x$1;
    }

    public HashMap<String, CellStyle> styles() {
        return this.styles;
    }

    public boolean isFlush() {
        return this.isFlush;
    }

    public void isFlush_$eq(boolean x$1) {
        this.isFlush = x$1;
    }

    public ByteArrayOutputStream os() {
        return this.os;
    }

    public ByteArrayInputStream is() {
        return this.is;
    }

    public void is_$eq(ByteArrayInputStream x$1) {
        this.is = x$1;
    }

    public void init() {
        this.workBook_$eq(new SXSSFWorkbook());
        this.sheet_$eq(this.workBook().createSheet(this.sheetName()));
    }

    public CellStyle getDefaultHeadStyle() {
        Font headerFont = this.workBook().createFont();
        headerFont.setBold(true);
        headerFont.setFontHeightInPoints((short)14);
        headerFont.setColor(IndexedColors.BLACK.getIndex());
        CellStyle headerCellStyle = this.workBook().createCellStyle();
        headerCellStyle.setFont(headerFont);
        return headerCellStyle;
    }

    public Workbook getWorkBook() {
        this.sheet().trackAllColumnsForAutoSizing();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), this.columnCounter()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)elem -> this.sheet().autoSizeColumn(elem));
        return this.workBook();
    }

    public CellStyle createCellStyle(DataType dataType) {
        CellStyle style;
        block28: {
            style = this.workBook().createCellStyle();
            this.format_$eq(this.workBook().createDataFormat());
            String string = dataType.toString();
            style.setDataFormat(this.format().getFormat("@"));
            if (!this.autoFormat()) break block28;
            DataType dataType2 = dataType;
            if (StringType$.MODULE$.equals(dataType2)) {
                style.setDataFormat(this.format().getFormat("@"));
            } else if (TinyIntType$.MODULE$.equals(dataType2)) {
                style.setDataFormat(this.format().getFormat("#"));
            } else if (ShortIntType$.MODULE$.equals(dataType2)) {
                style.setDataFormat(this.format().getFormat("#"));
            } else if (IntType$.MODULE$.equals(dataType2)) {
                style.setDataFormat(this.format().getFormat("#"));
            } else if (LongType$.MODULE$.equals(dataType2)) {
                style.setDataFormat(this.format().getFormat("#.##E+00"));
            } else if (BigIntType$.MODULE$.equals(dataType2)) {
                style.setDataFormat(this.format().getFormat("#.##E+00"));
            } else if (FloatType$.MODULE$.equals(dataType2)) {
                style.setDataFormat(this.format().getFormat("#.0000000000"));
            } else if (DoubleType$.MODULE$.equals(dataType2)) {
                style.setDataFormat(this.format().getFormat("#.0000000000"));
            } else if (CharType$.MODULE$.equals(dataType2)) {
                style.setDataFormat(this.format().getFormat("@"));
            } else if (VarcharType$.MODULE$.equals(dataType2)) {
                style.setDataFormat(this.format().getFormat("@"));
            } else if (DateType$.MODULE$.equals(dataType2)) {
                style.setDataFormat(this.format().getFormat("m/d/yy h:mm"));
            } else if (TimestampType$.MODULE$.equals(dataType2)) {
                style.setDataFormat(this.format().getFormat("m/d/yy h:mm"));
            } else if (DecimalType$.MODULE$.equals(dataType2)) {
                style.setDataFormat(this.format().getFormat("#.000000000"));
            } else if (BigDecimalType$.MODULE$.equals(dataType2)) {
                style.setDataFormat(this.format().getFormat("#.000000000"));
            } else {
                style.setDataFormat(this.format().getFormat("@"));
            }
        }
        return style;
    }

    public CellStyle getCellStyle(DataType dataType) {
        CellStyle style = this.styles().get(dataType.typeName());
        if (style == null) {
            CellStyle newStyle = this.createCellStyle(dataType);
            this.styles().put(dataType.typeName(), newStyle);
            return newStyle;
        }
        return style;
    }

    public void addMetaData(MetaData metaData) throws IOException {
        this.init();
        SXSSFRow tableHead = this.sheet().createRow(0);
        Column[] columns = ((TableMetaData)metaData).columns();
        ArrayBuffer columnType = new ArrayBuffer();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])columns)).foreach((Function1 & Serializable & scala.Serializable)elem -> {
            StorageExcelWriter.$anonfun$addMetaData$1(this, tableHead, columnType, elem);
            return BoxedUnit.UNIT;
        });
        this.types_$eq((DataType[])columnType.toArray(ClassTag$.MODULE$.apply(DataType.class)));
        this.rowPoint_$eq(this.rowPoint() + 1);
    }

    public void addRecord(Record record) throws IOException {
        SXSSFRow tableBody = this.sheet().createRow(this.rowPoint());
        IntRef colunmPoint = IntRef.create((int)0);
        Object[] excelRecord = ((TableRecord)record).row();
        Predef$.MODULE$.genericArrayOps((Object)excelRecord).foreach((Function1 & Serializable & scala.Serializable)elem -> {
            StorageExcelWriter.$anonfun$addRecord$1(this, tableBody, colunmPoint, elem);
            return BoxedUnit.UNIT;
        });
        this.rowPoint_$eq(this.rowPoint() + 1);
    }

    private void setCellTypeValue(DataType dataType, Object elem, SXSSFCell cell) {
        if (elem == null) {
            return;
        }
        Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            DataType dataType = dataType;
            if (StringType$.MODULE$.equals(dataType)) {
                cell.setCellValue(DataType$.MODULE$.valueToString(elem));
                return;
            }
            if (TinyIntType$.MODULE$.equals(dataType)) {
                cell.setCellValue((double)new StringOps(Predef$.MODULE$.augmentString(elem.toString())).toInt());
                return;
            }
            if (ShortIntType$.MODULE$.equals(dataType)) {
                cell.setCellValue((double)new StringOps(Predef$.MODULE$.augmentString(elem.toString())).toInt());
                return;
            }
            if (IntType$.MODULE$.equals(dataType)) {
                cell.setCellValue((double)new StringOps(Predef$.MODULE$.augmentString(elem.toString())).toInt());
                return;
            }
            if (LongType$.MODULE$.equals(dataType)) {
                cell.setCellValue((double)new StringOps(Predef$.MODULE$.augmentString(elem.toString())).toLong());
                return;
            }
            if (BigIntType$.MODULE$.equals(dataType)) {
                cell.setCellValue((double)new StringOps(Predef$.MODULE$.augmentString(elem.toString())).toLong());
                return;
            }
            if (FloatType$.MODULE$.equals(dataType)) {
                cell.setCellValue((double)new StringOps(Predef$.MODULE$.augmentString(elem.toString())).toFloat());
                return;
            }
            if (DoubleType$.MODULE$.equals(dataType)) {
                this.doubleCheck(elem.toString());
                cell.setCellValue(new StringOps(Predef$.MODULE$.augmentString(elem.toString())).toDouble());
                return;
            }
            if (CharType$.MODULE$.equals(dataType)) {
                cell.setCellValue(DataType$.MODULE$.valueToString(elem));
                return;
            }
            if (VarcharType$.MODULE$.equals(dataType)) {
                cell.setCellValue(DataType$.MODULE$.valueToString(elem));
                return;
            }
            if (DateType$.MODULE$.equals(dataType)) {
                cell.setCellValue(this.getDate(elem));
                return;
            }
            if (TimestampType$.MODULE$.equals(dataType)) {
                cell.setCellValue(this.getDate(elem));
                return;
            }
            if (DecimalType$.MODULE$.equals(dataType)) {
                this.doubleCheck(DataType$.MODULE$.valueToString(elem));
                cell.setCellValue(new StringOps(Predef$.MODULE$.augmentString(DataType$.MODULE$.valueToString(elem))).toDouble());
                return;
            }
            if (BigDecimalType$.MODULE$.equals(dataType)) {
                this.doubleCheck(DataType$.MODULE$.valueToString(elem));
                cell.setCellValue(new StringOps(Predef$.MODULE$.augmentString(DataType$.MODULE$.valueToString(elem))).toDouble());
                return;
            }
            String value = DataType$.MODULE$.valueToString(elem);
            cell.setCellValue(value);
        }, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            StorageExcelWriter.$anonfun$setCellTypeValue$2(cell, elem, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private Date getDate(Object value) {
        if (value instanceof Date) {
            return (Date)value;
        }
        throw new NumberFormatException(new StringBuilder(49).append("Value ").append(value).append(" with class : ").append(value.getClass().getName()).append(" is not a valid type of Date.").toString());
    }

    private void doubleCheck(String elemValue) {
        BigDecimal value = new BigDecimal(elemValue).stripTrailingZeros();
        if (value.precision() - value.scale() > 15) {
            throw new NumberFormatException(new StringBuilder(55).append("Value ").append(elemValue).append(" error : This data exceeds 15 significant digits.").toString());
        }
    }

    public void flush() {
        this.getWorkBook().write((OutputStream)this.os());
        byte[] content = this.os().toByteArray();
        this.is_$eq(new ByteArrayInputStream(content));
        byte[] buffer = new byte[1024];
        int bytesRead = 0;
        while (this.isFlush()) {
            bytesRead = this.is().read(buffer, 0, 1024);
            if (bytesRead == -1) {
                this.isFlush_$eq(false);
                continue;
            }
            this.outputStream().write(buffer, 0, bytesRead);
        }
    }

    public void close() {
        if (this.isFlush()) {
            this.flush();
        }
        IOUtils.closeQuietly((OutputStream)this.outputStream());
        IOUtils.closeQuietly((InputStream)this.is());
        IOUtils.closeQuietly((OutputStream)this.os());
        IOUtils.closeQuietly((Closeable)this.workBook());
    }

    public static final /* synthetic */ void $anonfun$addMetaData$1(StorageExcelWriter $this, SXSSFRow tableHead$1, ArrayBuffer columnType$1, Column elem) {
        SXSSFCell headCell = tableHead$1.createCell($this.columnCounter());
        headCell.setCellValue(elem.columnName());
        headCell.setCellStyle($this.getDefaultHeadStyle());
        columnType$1.$plus$eq((Object)elem.dataType());
        $this.columnCounter_$eq($this.columnCounter() + 1);
    }

    public static final /* synthetic */ void $anonfun$addRecord$1(StorageExcelWriter $this, SXSSFRow tableBody$1, IntRef colunmPoint$1, Object elem) {
        SXSSFCell cell = tableBody$1.createCell(colunmPoint$1.elem);
        DataType dataType = $this.types()[colunmPoint$1.elem];
        if ($this.autoFormat()) {
            $this.setCellTypeValue(dataType, elem, cell);
        } else {
            cell.setCellValue(DataType$.MODULE$.valueToString(elem));
        }
        cell.setCellStyle($this.getCellStyle(dataType));
        ++colunmPoint$1.elem;
    }

    public static final /* synthetic */ void $anonfun$setCellTypeValue$2(SXSSFCell cell$1, Object elem$1, Throwable x0$1) {
        Throwable throwable = x0$1;
        if (throwable instanceof Exception) {
            cell$1.setCellValue(DataType$.MODULE$.valueToString(elem$1));
            return;
        }
        throw new MatchError((Object)throwable);
    }

    public StorageExcelWriter(String charset, String sheetName, String dateFormat, OutputStream outputStream, boolean autoFormat) {
        this.charset = charset;
        this.sheetName = sheetName;
        this.dateFormat = dateFormat;
        this.outputStream = outputStream;
        this.autoFormat = autoFormat;
        Logging.$init$((Logging)this);
        this.rowPoint = 0;
        this.columnCounter = 0;
        this.styles = new HashMap();
        this.isFlush = true;
        this.os = new ByteArrayOutputStream();
    }
}

