/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.sparkmeasure;

import ch.cern.sparkmeasure.IOUtils;
import ch.cern.sparkmeasure.StageVals;
import ch.cern.sparkmeasure.TaskVals;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.module.scala.ClassTagExtensions;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import com.fasterxml.jackson.module.scala.JavaTypeable;
import com.fasterxml.jackson.module.scala.JavaTypeable$;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.nio.file.Paths;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class IOUtils$ {
    public static IOUtils$ MODULE$;
    private final ObjectMapper objectMapper;
    private final ObjectWriter objectWriter;

    static {
        new IOUtils$();
    }

    public ObjectMapper objectMapper() {
        return this.objectMapper;
    }

    public ObjectWriter objectWriter() {
        return this.objectWriter;
    }

    public <T> ListBuffer<T> readSerialized(String metricsFileName) {
        ListBuffer listBuffer;
        String fullPath = metricsFileName;
        try (IOUtils.ObjectInputStreamWithCustomClassLoader ois = new IOUtils.ObjectInputStreamWithCustomClassLoader(new FileInputStream(fullPath));){
            listBuffer = (ListBuffer)ois.readObject();
        }
        return listBuffer;
    }

    public void writeSerialized(String fullPath, Object metricsData) {
        try (ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(fullPath));){
            os.writeObject(metricsData);
        }
    }

    public ListBuffer<StageVals> readSerializedStageMetrics(String stageMetricsFileName) {
        return this.readSerialized(stageMetricsFileName);
    }

    public ListBuffer<TaskVals> readSerializedTaskMetrics(String stageMetricsFileName) {
        return this.readSerialized(stageMetricsFileName);
    }

    public void writeSerializedJSON(String fullPath, Object metricsData) {
        try (FileOutputStream os = new FileOutputStream(fullPath);){
            this.objectWriter().writeValue((OutputStream)os, metricsData);
        }
    }

    public void writeSerializedJSONToHadoop(String fullPath, Object metricsData, SparkConf conf) {
        URI fullPathUri = URI.create(fullPath);
        Path hdfswritepath = new Path(fullPath);
        Configuration hadoopConf = new Configuration();
        String keyId = System.getenv("AWS_ACCESS_KEY_ID");
        String accessKey = System.getenv("AWS_SECRET_ACCESS_KEY");
        if (keyId != null && accessKey != null) {
            hadoopConf.set("fs.s3.awsAccessKeyId", keyId);
            hadoopConf.set("fs.s3n.awsAccessKeyId", keyId);
            hadoopConf.set("fs.s3a.access.key", keyId);
            hadoopConf.set("fs.s3.awsSecretAccessKey", accessKey);
            hadoopConf.set("fs.s3n.awsSecretAccessKey", accessKey);
            hadoopConf.set("fs.s3a.secret.key", accessKey);
            String sessionToken = System.getenv("AWS_SESSION_TOKEN");
            if (sessionToken != null) {
                hadoopConf.set("fs.s3a.session.token", sessionToken);
            }
        }
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])conf.getAll())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)IOUtils$.$anonfun$writeSerializedJSONToHadoop$1(check$ifrefutable$1))).withFilter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)IOUtils$.$anonfun$writeSerializedJSONToHadoop$2(x$1))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            IOUtils$.$anonfun$writeSerializedJSONToHadoop$3(hadoopConf, x$2);
            return BoxedUnit.UNIT;
        });
        String serializedMetrics = this.writeToStringSerializedJSON(metricsData);
        FileSystem fs = FileSystem.get((URI)fullPathUri, (Configuration)hadoopConf);
        try (FSDataOutputStream outputStream = fs.create(hdfswritepath);){
            outputStream.writeBytes(serializedMetrics);
        }
    }

    public String writeToStringSerializedJSON(Object metricsData) {
        return this.objectWriter().writeValueAsString(metricsData);
    }

    public List<StageVals> readSerializedStageMetricsJSON(String stageMetricsFileName) {
        List list;
        String fullPath = ((Object)Paths.get(stageMetricsFileName, new String[0])).toString();
        try (FileInputStream is = new FileInputStream(fullPath);){
            list = (List)((ClassTagExtensions)this.objectMapper()).readValue((InputStream)is, JavaTypeable$.MODULE$.collectionJavaTypeable(JavaTypeable$.MODULE$.gen0JavaTypeable(ClassTag$.MODULE$.apply(StageVals.class)), ClassTag$.MODULE$.apply(List.class)));
        }
        return list;
    }

    public List<TaskVals> readSerializedTaskMetricsJSON(String taskMetricsFileName) {
        List list;
        String fullPath = ((Object)Paths.get(taskMetricsFileName, new String[0])).toString();
        try (FileInputStream is = new FileInputStream(fullPath);){
            list = (List)((ClassTagExtensions)this.objectMapper()).readValue((InputStream)is, JavaTypeable$.MODULE$.collectionJavaTypeable(JavaTypeable$.MODULE$.gen0JavaTypeable(ClassTag$.MODULE$.apply(TaskVals.class)), ClassTag$.MODULE$.apply(List.class)));
        }
        return list;
    }

    public static final /* synthetic */ boolean $anonfun$writeSerializedJSONToHadoop$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$writeSerializedJSONToHadoop$2(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            return key.startsWith("spark.hadoop.");
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$writeSerializedJSONToHadoop$3(Configuration hadoopConf$1, Tuple2 x$2) {
        Tuple2 tuple2 = x$2;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            hadoopConf$1.set(key.substring("spark.hadoop.".length()), value);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private IOUtils$() {
        MODULE$ = this;
        this.objectMapper = new ClassTagExtensions(){

            public final <Target, MixinSource> ObjectMapper addMixin(ClassTag<Target> evidence$1, ClassTag<MixinSource> evidence$2) {
                return ClassTagExtensions.addMixin$((ClassTagExtensions)this, evidence$1, evidence$2);
            }

            public final <T> Class<?> findMixInClassFor(ClassTag<T> evidence$3) {
                return ClassTagExtensions.findMixInClassFor$((ClassTagExtensions)this, evidence$3);
            }

            public <T> JavaType constructType(JavaTypeable<T> evidence$4) {
                return ClassTagExtensions.constructType$((ClassTagExtensions)this, evidence$4);
            }

            public <T> T readValue(JsonParser jp, JavaTypeable<T> evidence$5) {
                return (T)ClassTagExtensions.readValue$((ClassTagExtensions)this, (JsonParser)jp, evidence$5);
            }

            public <T> MappingIterator<T> readValues(JsonParser jp, JavaTypeable<T> evidence$6) {
                return ClassTagExtensions.readValues$((ClassTagExtensions)this, (JsonParser)jp, evidence$6);
            }

            public <T> T treeToValue(TreeNode n, JavaTypeable<T> evidence$7) {
                return (T)ClassTagExtensions.treeToValue$((ClassTagExtensions)this, (TreeNode)n, evidence$7);
            }

            public <T> T readValue(File src, JavaTypeable<T> evidence$8) {
                return (T)ClassTagExtensions.readValue$((ClassTagExtensions)this, (File)src, evidence$8);
            }

            public <T> T readValue(URL src, JavaTypeable<T> evidence$9) {
                return (T)ClassTagExtensions.readValue$((ClassTagExtensions)this, (URL)src, evidence$9);
            }

            public <T> T readValue(String content, JavaTypeable<T> evidence$10) {
                return (T)ClassTagExtensions.readValue$((ClassTagExtensions)this, (String)content, evidence$10);
            }

            public <T> T readValue(Reader src, JavaTypeable<T> evidence$11) {
                return (T)ClassTagExtensions.readValue$((ClassTagExtensions)this, (Reader)src, evidence$11);
            }

            public <T> T readValue(InputStream src, JavaTypeable<T> evidence$12) {
                return (T)ClassTagExtensions.readValue$((ClassTagExtensions)this, (InputStream)src, evidence$12);
            }

            public <T> T readValue(byte[] src, JavaTypeable<T> evidence$13) {
                return (T)ClassTagExtensions.readValue$((ClassTagExtensions)this, (byte[])src, evidence$13);
            }

            public <T> T readValue(byte[] src, int offset, int len, JavaTypeable<T> evidence$14) {
                return (T)ClassTagExtensions.readValue$((ClassTagExtensions)this, (byte[])src, (int)offset, (int)len, evidence$14);
            }

            public <T> T updateValue(T valueToUpdate, File src, JavaTypeable<T> evidence$15) {
                return (T)ClassTagExtensions.updateValue$((ClassTagExtensions)this, valueToUpdate, (File)src, evidence$15);
            }

            public <T> T updateValue(T valueToUpdate, URL src, JavaTypeable<T> evidence$16) {
                return (T)ClassTagExtensions.updateValue$((ClassTagExtensions)this, valueToUpdate, (URL)src, evidence$16);
            }

            public <T> T updateValue(T valueToUpdate, String content, JavaTypeable<T> evidence$17) {
                return (T)ClassTagExtensions.updateValue$((ClassTagExtensions)this, valueToUpdate, (String)content, evidence$17);
            }

            public <T> T updateValue(T valueToUpdate, Reader src, JavaTypeable<T> evidence$18) {
                return (T)ClassTagExtensions.updateValue$((ClassTagExtensions)this, valueToUpdate, (Reader)src, evidence$18);
            }

            public <T> T updateValue(T valueToUpdate, InputStream src, JavaTypeable<T> evidence$19) {
                return (T)ClassTagExtensions.updateValue$((ClassTagExtensions)this, valueToUpdate, (InputStream)src, evidence$19);
            }

            public <T> T updateValue(T valueToUpdate, byte[] src, JavaTypeable<T> evidence$20) {
                return (T)ClassTagExtensions.updateValue$((ClassTagExtensions)this, valueToUpdate, (byte[])src, evidence$20);
            }

            public <T> T updateValue(T valueToUpdate, byte[] src, int offset, int len, JavaTypeable<T> evidence$21) {
                return (T)ClassTagExtensions.updateValue$((ClassTagExtensions)this, valueToUpdate, (byte[])src, (int)offset, (int)len, evidence$21);
            }

            public <T> ObjectWriter writerWithView(ClassTag<T> evidence$23) {
                return ClassTagExtensions.writerWithView$((ClassTagExtensions)this, evidence$23);
            }

            public <T> ObjectWriter writerFor(JavaTypeable<T> evidence$24) {
                return ClassTagExtensions.writerFor$((ClassTagExtensions)this, evidence$24);
            }

            public <T> ObjectReader readerFor(JavaTypeable<T> evidence$25) {
                return ClassTagExtensions.readerFor$((ClassTagExtensions)this, evidence$25);
            }

            public <T> ObjectReader readerWithView(ClassTag<T> evidence$26) {
                return ClassTagExtensions.readerWithView$((ClassTagExtensions)this, evidence$26);
            }

            public <T> T convertValue(Object fromValue, JavaTypeable<T> evidence$27) {
                return (T)ClassTagExtensions.convertValue$((ClassTagExtensions)this, (Object)fromValue, evidence$27);
            }
            {
                ClassTagExtensions.$init$((ClassTagExtensions)this);
            }
        };
        this.objectMapper().registerModule((Module)DefaultScalaModule$.MODULE$);
        this.objectWriter = this.objectMapper().writer((PrettyPrinter)new DefaultPrettyPrinter());
    }
}

