/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.entrance.cli.heartbeat;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.entrance.cli.heartbeat.CliHeartbeatMonitor$;
import org.apache.linkis.entrance.cli.heartbeat.HeartbeatLossHandler;
import org.apache.linkis.entrance.conf.EntranceConfiguration$;
import org.apache.linkis.entrance.exception.EntranceErrorCode;
import org.apache.linkis.entrance.exception.EntranceErrorException;
import org.apache.linkis.entrance.execute.EntranceJob;
import org.apache.linkis.scheduler.queue.Job;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005eb\u0001\u0002\u000b\u0016\u0001\tB\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\u0006m\u0001!\ta\u000e\u0005\bu\u0001\u0011\r\u0011\"\u0003<\u0011\u00199\u0006\u0001)A\u0005y!9\u0001\f\u0001b\u0001\n\u0013I\u0006BB/\u0001A\u0003%!\fC\u0004_\u0001\t\u0007I\u0011B0\t\r\r\u0004\u0001\u0015!\u0003a\u0011\u0015!\u0007\u0001\"\u0001f\u0011\u0015\u0001\b\u0001\"\u0001r\u0011\u0015a\b\u0001\"\u0001~\u0011\u0019y\b\u0001\"\u0001\u0002\u0002!9\u0011Q\u0001\u0001\u0005\u0002\u0005\u001d\u0001bBA\u0005\u0001\u0011\u0005\u0011q\u0001\u0005\n\u0003\u0017\u0001!\u0019!C\u0005\u0003\u001bA\u0001\"a\b\u0001A\u0003%\u0011q\u0002\u0005\b\u0003C\u0001A\u0011BA\u0012\u0011\u001d\ti\u0003\u0001C\u0005\u0003_Aq!a\u000e\u0001\t\u0003\t9AA\nDY&DU-\u0019:uE\u0016\fG/T8oSR|'O\u0003\u0002\u0017/\u0005I\u0001.Z1si\n,\u0017\r\u001e\u0006\u00031e\t1a\u00197j\u0015\tQ2$\u0001\u0005f]R\u0014\u0018M\\2f\u0015\taR$\u0001\u0004mS:\\\u0017n\u001d\u0006\u0003=}\ta!\u00199bG\",'\"\u0001\u0011\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0019\u0013\u0006\u0005\u0002%O5\tQEC\u0001'\u0003\u0015\u00198-\u00197b\u0013\tASE\u0001\u0004B]f\u0014VM\u001a\t\u0003U=j\u0011a\u000b\u0006\u0003Y5\nQ!\u001e;jYNT!AL\u000e\u0002\r\r|W.\\8o\u0013\t\u00014FA\u0004M_\u001e<\u0017N\\4\u0002\u000f!\fg\u000e\u001a7feB\u00111\u0007N\u0007\u0002+%\u0011Q'\u0006\u0002\u0015\u0011\u0016\f'\u000f\u001e2fCRdun]:IC:$G.\u001a:\u0002\rqJg.\u001b;?)\tA\u0014\b\u0005\u00024\u0001!)\u0011G\u0001a\u0001e\u00059\u0011N\u001c4p\u001b\u0006\u0004X#\u0001\u001f\u0011\tu\"e)U\u0007\u0002})\u0011q\bQ\u0001\u000bG>t7-\u001e:sK:$(BA!C\u0003\u0011)H/\u001b7\u000b\u0003\r\u000bAA[1wC&\u0011QI\u0010\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\bCA$O\u001d\tAE\n\u0005\u0002JK5\t!J\u0003\u0002LC\u00051AH]8pizJ!!T\u0013\u0002\rA\u0013X\rZ3g\u0013\ty\u0005K\u0001\u0004TiJLgn\u001a\u0006\u0003\u001b\u0016\u0002\"AU+\u000e\u0003MS!\u0001V\r\u0002\u000f\u0015DXmY;uK&\u0011ak\u0015\u0002\f\u000b:$(/\u00198dK*{'-\u0001\u0005j]\u001a|W*\u00199!\u0003a\u0019G.[3oi\"+\u0017M\u001d;cK\u0006$H\u000b\u001b:fg\"|G\u000eZ\u000b\u00025B\u0011AeW\u0005\u00039\u0016\u0012A\u0001T8oO\u0006I2\r\\5f]RDU-\u0019:uE\u0016\fG\u000f\u00165sKNDw\u000e\u001c3!\u0003U\u0019G.[3oi\"+\u0017M\u001d;cK\u0006$H)Y3n_:,\u0012\u0001\u0019\t\u0003{\u0005L!A\u0019 \u00037M\u001b\u0007.\u001a3vY\u0016$G\u000b\u001b:fC\u0012\u0004vn\u001c7Fq\u0016\u001cW\u000f^8s\u0003Y\u0019G.[3oi\"+\u0017M\u001d;cK\u0006$H)Y3n_:\u0004\u0013a\u00039b]&\u001c\u0017J\u001a(vY2$2AZ5o!\t!s-\u0003\u0002iK\t!QK\\5u\u0011\u0015Q\u0017\u00021\u0001l\u0003\ry'M\u001b\t\u0003I1L!!\\\u0013\u0003\u0007\u0005s\u0017\u0010C\u0003p\u0013\u0001\u0007a)A\u0002ng\u001e\f\u0001C]3hSN$XM]%g\u00072L'j\u001c2\u0015\u0005\u0019\u0014\b\"B:\u000b\u0001\u0004!\u0018a\u00016pEB\u0011QO_\u0007\u0002m*\u0011q\u000f_\u0001\u0006cV,W/\u001a\u0006\u0003sn\t\u0011b]2iK\u0012,H.\u001a:\n\u0005m4(a\u0001&pE\u0006\u0011RO\u001c*fO&\u001cH/\u001a:JM\u000ec\u0017NS8c)\t1g\u0010C\u0003t\u0017\u0001\u0007A/A\fva\u0012\fG/\u001a%fCJ$(-Z1u\u0013\u001a\u001cE.\u001b&pER\u0019a-a\u0001\t\u000bMd\u0001\u0019\u0001;\u0002\u000bM$\u0018M\u001d;\u0015\u0003\u0019\f\u0001c]2b]>sW-\u0013;fe\u0006$\u0018n\u001c8\u0002\u001f5|g.\u001b;pe\u000e\u0013X-\u0019;peN,\"!a\u0004\u0011\u000b\u0011\n\t\"!\u0006\n\u0007\u0005MQEA\u0003BeJ\f\u0017\u0010\u0005\u0003\u0002\u0018\u0005uQBAA\r\u0015\r\tYBQ\u0001\u0005Y\u0006tw-C\u0002P\u00033\t\u0001#\\8oSR|'o\u0011:fCR|'o\u001d\u0011\u0002\u0011%\u001c8\t\\5K_\n$B!!\n\u0002,A\u0019A%a\n\n\u0007\u0005%REA\u0004C_>dW-\u00198\t\u000bM\f\u0002\u0019A)\u0002\u000f%\u001c\u0018\t\\5wKR1\u0011QEA\u0019\u0003kAa!a\r\u0013\u0001\u0004Q\u0016aC2veJ,g\u000e\u001e+j[\u0016DQa\u001d\nA\u0002E\u000b\u0001b\u001d5vi\u0012|wO\u001c")
public class CliHeartbeatMonitor
implements Logging {
    private final HeartbeatLossHandler handler;
    private final ConcurrentHashMap<String, EntranceJob> infoMap;
    private final long clientHeartbeatThreshold;
    private final ScheduledThreadPoolExecutor clientHeartbeatDaemon;
    private final String[] monitorCreators;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        CliHeartbeatMonitor cliHeartbeatMonitor = this;
        synchronized (cliHeartbeatMonitor) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private ConcurrentHashMap<String, EntranceJob> infoMap() {
        return this.infoMap;
    }

    private long clientHeartbeatThreshold() {
        return this.clientHeartbeatThreshold;
    }

    private ScheduledThreadPoolExecutor clientHeartbeatDaemon() {
        return this.clientHeartbeatDaemon;
    }

    public void panicIfNull(Object obj, String msg) {
        if (obj == null) {
            throw new EntranceErrorException(EntranceErrorCode.VARIABLE_NULL_EXCEPTION.getErrCode(), msg);
        }
    }

    public void registerIfCliJob(Job job) {
        Job job2 = job;
        if (job2 instanceof EntranceJob) {
            EntranceJob entranceJob = (EntranceJob)job2;
            if (this.isCliJob(entranceJob)) {
                String id = entranceJob.getJobRequest().getId().toString();
                if (this.infoMap().containsKey(id)) {
                    this.logger().error(new StringBuilder(35).append("registered duplicate job!! job id: ").append(id).toString());
                    return;
                }
                this.infoMap().put(id, entranceJob);
                this.logger().info(new StringBuilder(23).append("registered cli job id: ").append(id).toString());
                return;
            }
            return;
        }
    }

    public void unRegisterIfCliJob(Job job) {
        Job job2 = job;
        if (job2 instanceof EntranceJob) {
            EntranceJob entranceJob = (EntranceJob)job2;
            if (this.isCliJob(entranceJob)) {
                String id = entranceJob.getJobRequest().getId().toString();
                this.infoMap().remove(id);
                this.logger().info(new StringBuilder(25).append("unregistered cli job id: ").append(id).toString());
                return;
            }
            return;
        }
    }

    public void updateHeartbeatIfCliJob(Job job) {
        Job job2 = job;
        if (job2 instanceof EntranceJob) {
            EntranceJob entranceJob = (EntranceJob)job2;
            if (this.isCliJob(entranceJob)) {
                String id = entranceJob.getJobRequest().getId().toString();
                if (!this.infoMap().containsKey(id)) {
                    this.logger().error(new StringBuilder(40).append("heartbeat on non-existing job!! job id: ").append(id).toString());
                    return;
                }
                this.infoMap().get(id).updateNewestAccessByClientTimestamp();
                return;
            }
            return;
        }
    }

    public void start() {
        this.panicIfNull(this.handler, "handler should not be null");
        this.clientHeartbeatDaemon().scheduleAtFixedRate(new Runnable(this){
            private final /* synthetic */ CliHeartbeatMonitor $outer;

            public void run() {
                Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.$outer.scanOneIteration(), (Function1 & Serializable & scala.Serializable)t -> {
                    $anon$1.$anonfun$run$2(this, t);
                    return BoxedUnit.UNIT;
                });
            }

            public static final /* synthetic */ void $anonfun$run$2($anon$1 $this, Throwable t) {
                $this.$outer.logger().error("ClientHeartbeatMonitor failed to scan for one iteration", t);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.linkis.entrance.cli.heartbeat.CliHeartbeatMonitor$$anon$1 ), $anonfun$run$2$adapted(org.apache.linkis.entrance.cli.heartbeat.CliHeartbeatMonitor$$anon$1 java.lang.Throwable )}, serializedLambda);
            }
        }, 0L, 5L, TimeUnit.SECONDS);
        this.logger().info("started cliHeartbeatMonitor");
        Utils$.MODULE$.addShutdownHook((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxedUnit.UNIT);
            this.shutdown();
            Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, (Object)BoxedUnit.UNIT);
        });
    }

    public void scanOneIteration() {
        long currentTime = System.currentTimeMillis();
        Iterator<Map.Entry<String, EntranceJob>> entries = this.infoMap().entrySet().iterator();
        ArrayList<EntranceJob> problemJobs = new ArrayList<EntranceJob>();
        while (entries.hasNext()) {
            Object object;
            Map.Entry<String, EntranceJob> entry = entries.next();
            this.logger().debug(new StringBuilder(16).append("Scanned job id: ").append((Object)entry.getKey()).toString());
            if (!this.isAlive(currentTime, entry.getValue())) {
                this.logger().info(new StringBuilder(41).append("Found linkis-cli connection lost job id: ").append((Object)entry.getKey()).toString());
                object = BoxesRunTime.boxToBoolean((boolean)problemJobs.add(entry.getValue()));
                continue;
            }
            object = BoxedUnit.UNIT;
        }
        Iterator iterator = problemJobs.iterator();
        while (iterator.hasNext()) {
            this.infoMap().remove(iterator.next());
        }
        if (problemJobs.size() > 0) {
            this.handler.handle((List<EntranceJob>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(problemJobs).asScala()).toList());
        }
        this.logger().debug("ClientHeartbeatMonitor ends scanning for one iteration");
    }

    private String[] monitorCreators() {
        return this.monitorCreators;
    }

    private boolean isCliJob(EntranceJob job) {
        String string = job.getCreator();
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.monitorCreators())).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)string.equalsIgnoreCase(x$1)));
    }

    private boolean isAlive(long currentTime, EntranceJob job) {
        long lastAliveTime = job.getNewestAccessByClientTimestamp();
        return currentTime - lastAliveTime <= this.clientHeartbeatThreshold();
    }

    public void shutdown() {
        this.clientHeartbeatDaemon().shutdownNow();
    }

    public CliHeartbeatMonitor(HeartbeatLossHandler handler) {
        this.handler = handler;
        Logging.$init$((Logging)this);
        this.infoMap = new ConcurrentHashMap();
        this.clientHeartbeatThreshold = 1000L * EntranceConfiguration$.MODULE$.CLI_HEARTBEAT_THRESHOLD_SECONDS();
        this.clientHeartbeatDaemon = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("entrance-cli-heartbeat-%d").daemon(true).build());
        this.monitorCreators = ((String)EntranceConfiguration$.MODULE$.CLIENT_MONITOR_CREATOR().getValue()).split(",");
    }
}

