/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.entrance.execute.simple;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.entrance.exception.EntranceErrorCode;
import org.apache.linkis.entrance.exception.EntranceErrorException;
import org.apache.linkis.entrance.execute.EngineExecuteAsyncReturn;
import org.apache.linkis.entrance.execute.EntranceExecutor;
import org.apache.linkis.entrance.job.EntranceExecuteRequest;
import org.apache.linkis.governance.common.utils.LoggerUtils;
import org.apache.linkis.manager.label.entity.engine.CodeLanguageLabel;
import org.apache.linkis.manager.label.utils.LabelUtil$;
import org.apache.linkis.orchestrator.code.plans.ast.CodeJob;
import org.apache.linkis.orchestrator.code.plans.logical.CodeLogicalUnitTaskDesc;
import org.apache.linkis.orchestrator.computation.entity.ComputationJobReq;
import org.apache.linkis.orchestrator.computation.entity.ComputationJobReq$;
import org.apache.linkis.orchestrator.computation.physical.CodeLogicalUnitExecTask;
import org.apache.linkis.orchestrator.converter.ASTContextImpl$;
import org.apache.linkis.orchestrator.domain.JobReq;
import org.apache.linkis.orchestrator.execution.AsyncTaskResponse;
import org.apache.linkis.orchestrator.execution.FailedTaskResponse;
import org.apache.linkis.orchestrator.execution.SucceedTaskResponse;
import org.apache.linkis.orchestrator.execution.TaskResponse;
import org.apache.linkis.orchestrator.listener.OrchestratorListenerBusContext;
import org.apache.linkis.orchestrator.plans.ast.ASTContext;
import org.apache.linkis.orchestrator.plans.ast.Job;
import org.apache.linkis.orchestrator.plans.logical.TaskDesc;
import org.apache.linkis.orchestrator.plans.physical.ExecTask;
import org.apache.linkis.orchestrator.plans.physical.PhysicalContextImpl;
import org.apache.linkis.orchestrator.plans.unit.CodeLogicalUnit;
import org.apache.linkis.scheduler.executer.ErrorExecuteResponse;
import org.apache.linkis.scheduler.executer.ExecuteRequest;
import org.apache.linkis.scheduler.executer.ExecuteResponse;
import org.apache.linkis.scheduler.executer.SingleTaskOperateSupport;
import org.apache.linkis.scheduler.executer.SuccessExecuteResponse;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001q4A!\u0004\b\u00017!I\u0001\u0007\u0001B\u0001B\u0003%\u0011g\u000e\u0005\tq\u0001\u0011\t\u0011)A\u0005s!)\u0011\t\u0001C\u0001\u0005\"9q\t\u0001a\u0001\n\u0013A\u0005bB)\u0001\u0001\u0004%IA\u0015\u0005\u00071\u0002\u0001\u000b\u0015B%\t\u000be\u0003A\u0011\u000b.\t\u000b\r\u0004A\u0011\u00013\t\u000bM\u0004A\u0011\t;\t\u000ba\u0004A\u0011\t;\t\u000be\u0004A\u0011\t;\t\u000bi\u0004A\u0011I>\u0003-MKW\u000e\u001d7f\u000b:$(/\u00198dK\u0016CXmY;u_JT!a\u0004\t\u0002\rMLW\u000e\u001d7f\u0015\t\t\"#A\u0004fq\u0016\u001cW\u000f^3\u000b\u0005M!\u0012\u0001C3oiJ\fgnY3\u000b\u0005U1\u0012A\u00027j].L7O\u0003\u0002\u00181\u00051\u0011\r]1dQ\u0016T\u0011!G\u0001\u0004_J<7\u0001A\n\u0005\u0001q\u0001\u0003\u0006\u0005\u0002\u001e=5\t\u0001#\u0003\u0002 !\t\u0001RI\u001c;sC:\u001cW-\u0012=fGV$xN\u001d\t\u0003C\u0019j\u0011A\t\u0006\u0003G\u0011\n\u0001\"\u001a=fGV$XM\u001d\u0006\u0003KQ\t\u0011b]2iK\u0012,H.\u001a:\n\u0005\u001d\u0012#\u0001G*j]\u001edW\rV1tW>\u0003XM]1uKN+\b\u000f]8siB\u0011\u0011FL\u0007\u0002U)\u00111\u0006L\u0001\u0006kRLGn\u001d\u0006\u0003[Q\taaY8n[>t\u0017BA\u0018+\u0005\u001daunZ4j]\u001e\f!!\u001b3\u0011\u0005I*T\"A\u001a\u000b\u0003Q\nQa]2bY\u0006L!AN\u001a\u0003\t1{gnZ\u0005\u0003ay\tad\u001c:dQ\u0016\u001cHO]1u_Jd\u0015n\u001d;f]\u0016\u0014()^:D_:$X\r\u001f;\u0011\u0005izT\"A\u001e\u000b\u0005qj\u0014\u0001\u00037jgR,g.\u001a:\u000b\u0005y\"\u0012\u0001D8sG\",7\u000f\u001e:bi>\u0014\u0018B\u0001!<\u0005yy%o\u00195fgR\u0014\u0018\r^8s\u0019&\u001cH/\u001a8fe\n+8oQ8oi\u0016DH/\u0001\u0004=S:LGO\u0010\u000b\u0004\u0007\u00163\u0005C\u0001#\u0001\u001b\u0005q\u0001\"\u0002\u0019\u0004\u0001\u0004\t\u0004\"\u0002\u001d\u0004\u0001\u0004I\u0014\u0001E2pI\u0016,f.\u001b;Fq\u0016\u001cG+Y:l+\u0005I\u0005C\u0001&P\u001b\u0005Y%B\u0001'N\u0003!\u0001\b._:jG\u0006d'B\u0001(>\u0003-\u0019w.\u001c9vi\u0006$\u0018n\u001c8\n\u0005A[%aF\"pI\u0016dunZ5dC2,f.\u001b;Fq\u0016\u001cG+Y:l\u0003Q\u0019w\u000eZ3V]&$X\t_3d)\u0006\u001c8n\u0018\u0013fcR\u00111K\u0016\t\u0003eQK!!V\u001a\u0003\tUs\u0017\u000e\u001e\u0005\b/\u0016\t\t\u00111\u0001J\u0003\rAH%M\u0001\u0012G>$W-\u00168ji\u0016CXm\u0019+bg.\u0004\u0013aC2bY2,\u00050Z2vi\u0016$\"a\u00170\u0011\u0005\u0005b\u0016BA/#\u0005=)\u00050Z2vi\u0016\u0014Vm\u001d9p]N,\u0007\"B0\b\u0001\u0004\u0001\u0017a\u0002:fcV,7\u000f\u001e\t\u0003C\u0005L!A\u0019\u0012\u0003\u001d\u0015CXmY;uKJ+\u0017/^3ti\u0006Q\"/Z9vKN$Hk\\\"p[B,H/\u0019;j_:TuN\u0019*fcR\u0011Qm\u001b\t\u0003M&l\u0011a\u001a\u0006\u0003Q6\u000ba!\u001a8uSRL\u0018B\u00016h\u0005E\u0019u.\u001c9vi\u0006$\u0018n\u001c8K_\n\u0014V-\u001d\u0005\u0006Y\"\u0001\r!\\\u0001\u0017K:$(/\u00198dK\u0016CXmY;uKJ+\u0017/^3tiB\u0011a.]\u0007\u0002_*\u0011\u0001OE\u0001\u0004U>\u0014\u0017B\u0001:p\u0005Y)e\u000e\u001e:b]\u000e,W\t_3dkR,'+Z9vKN$\u0018\u0001B6jY2$\u0012!\u001e\t\u0003eYL!a^\u001a\u0003\u000f\t{w\u000e\\3b]\u0006)\u0001/Y;tK\u00061!/Z:v[\u0016\fQa\u00197pg\u0016$\u0012a\u0015")
public class SimpleEntranceExecutor
extends EntranceExecutor
implements SingleTaskOperateSupport {
    private final OrchestratorListenerBusContext orchestratorListenerBusContext;
    private CodeLogicalUnitExecTask codeUnitExecTask;

    private CodeLogicalUnitExecTask codeUnitExecTask() {
        return this.codeUnitExecTask;
    }

    private void codeUnitExecTask_$eq(CodeLogicalUnitExecTask x$1) {
        this.codeUnitExecTask = x$1;
    }

    @Override
    public ExecuteResponse callExecute(ExecuteRequest request) {
        TaskResponse response;
        ExecuteRequest executeRequest = request;
        if (!(executeRequest instanceof EntranceExecuteRequest)) {
            throw new EntranceErrorException(EntranceErrorCode.EXECUTE_REQUEST_INVALID.getErrCode(), new StringBuilder(33).append("Invalid entranceExecuteRequest : ").append(request.code()).toString());
        }
        EntranceExecuteRequest entranceExecuteRequest = (EntranceExecuteRequest)executeRequest;
        EntranceExecuteRequest entranceExecuteRequest2 = entranceExecuteRequest;
        ComputationJobReq computationJobReq = this.requestToComputationJobReq(entranceExecuteRequest2);
        CodeJob codeJob = new CodeJob(null, null);
        ASTContext astContext = ASTContextImpl$.MODULE$.newBuilder().setJobReq((JobReq)computationJobReq).build();
        codeJob.setAstContext(astContext);
        codeJob.setCodeLogicalUnit(computationJobReq.getCodeLogicalUnit());
        codeJob.setParams(computationJobReq.getParams());
        codeJob.setName(new StringBuilder(4).append(computationJobReq.getName()).append("_Job").toString());
        codeJob.setSubmitUser(computationJobReq.getSubmitUser());
        codeJob.setExecuteUser(computationJobReq.getExecuteUser());
        codeJob.setLabels(computationJobReq.getLabels());
        codeJob.setPriority(computationJobReq.getPriority());
        this.codeUnitExecTask_$eq(new CodeLogicalUnitExecTask((ExecTask[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(ExecTask.class)), (ExecTask[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(ExecTask.class))));
        this.codeUnitExecTask().setId(entranceExecuteRequest2.getJob().getId());
        this.codeUnitExecTask().setCodeLogicalUnit(computationJobReq.getCodeLogicalUnit());
        this.codeUnitExecTask().setTaskDesc((TaskDesc)new CodeLogicalUnitTaskDesc((Job)codeJob));
        PhysicalContextImpl context = new PhysicalContextImpl((ExecTask)this.codeUnitExecTask(), (ExecTask[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ExecTask.class)));
        context.setSyncBus(this.orchestratorListenerBusContext.getOrchestratorSyncListenerBus());
        context.setAsyncBus(this.orchestratorListenerBusContext.getOrchestratorAsyncListenerBus());
        TaskResponse taskResponse = response = this.codeUnitExecTask().execute();
        if (taskResponse instanceof AsyncTaskResponse) {
            return new EngineExecuteAsyncReturn(request, null);
        }
        if (taskResponse instanceof SucceedTaskResponse) {
            this.logger().info(new StringBuilder(29).append("Succeed to execute ExecTask(").append(this.getId()).append(")").toString());
            return new SuccessExecuteResponse();
        }
        if (taskResponse instanceof FailedTaskResponse) {
            FailedTaskResponse failedTaskResponse = (FailedTaskResponse)taskResponse;
            this.logger().info(new StringBuilder(28).append("Failed to execute ExecTask(").append(this.getId()).append(")").toString());
            return new ErrorExecuteResponse(failedTaskResponse.getErrorMsg(), failedTaskResponse.getCause());
        }
        this.logger().warn(new StringBuilder(24).append("ExecTask(").append(this.getId()).append(") need to retry").toString());
        return new ErrorExecuteResponse(new StringBuilder(18).append("unknown response: ").append(response).toString(), null);
    }

    public ComputationJobReq requestToComputationJobReq(EntranceExecuteRequest entranceExecuteRequest) {
        ComputationJobReq.ComputationJobReqBuilder jobReqBuilder = ComputationJobReq$.MODULE$.newBuilder();
        jobReqBuilder.setId(entranceExecuteRequest.jobId());
        jobReqBuilder.setSubmitUser(entranceExecuteRequest.submitUser());
        jobReqBuilder.setExecuteUser(entranceExecuteRequest.executeUser());
        CodeLanguageLabel codeTypeLabel = LabelUtil$.MODULE$.getCodeTypeLabel(entranceExecuteRequest.getLabels());
        if (codeTypeLabel == null) {
            throw new EntranceErrorException(EntranceErrorCode.EXECUTE_REQUEST_INVALID.getErrCode(), "code Type Label is needed");
        }
        ArrayList<String> codes = new ArrayList<String>();
        codes.add(entranceExecuteRequest.code());
        CodeLogicalUnit codeLogicalUnit = new CodeLogicalUnit(codes, codeTypeLabel);
        jobReqBuilder.setCodeLogicalUnit(codeLogicalUnit);
        jobReqBuilder.setLabels(entranceExecuteRequest.getLabels());
        jobReqBuilder.setExecuteUser(entranceExecuteRequest.executeUser());
        jobReqBuilder.setParams(entranceExecuteRequest.properties());
        return (ComputationJobReq)jobReqBuilder.build();
    }

    public boolean kill() {
        LoggerUtils.setJobIdMDC((String)Long.toString(this.getId()));
        this.logger().info("Entrance start to kill job {} invoke Orchestrator ", (Object)BoxesRunTime.boxToLong((long)this.getId()));
        Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (this.codeUnitExecTask() != null) {
                this.codeUnitExecTask().kill();
                return;
            }
        }, this.logger());
        LoggerUtils.removeJobIdMDC();
        return true;
    }

    public boolean pause() {
        return true;
    }

    public boolean resume() {
        return true;
    }

    public void close() {
        this.getEngineExecuteAsyncReturn().foreach((Function1 & Serializable & scala.Serializable)e -> {
            e.notifyError(new StringBuilder(40).append(this.toString()).append(" has already been completed with state ").append(this.state()).append(".").toString());
            return BoxedUnit.UNIT;
        });
    }

    public SimpleEntranceExecutor(long id, OrchestratorListenerBusContext orchestratorListenerBusContext) {
        this.orchestratorListenerBusContext = orchestratorListenerBusContext;
        super(id);
        this.codeUnitExecTask = null;
    }
}

