/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.entrance.log;

import java.sql.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.entrance.conf.EntranceConfiguration$;
import org.apache.linkis.entrance.log.AbstractLogWriter;
import org.apache.linkis.entrance.log.Cache;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001U3A\u0001D\u0007\u00011!AQ\u0004\u0001B\u0001B\u0003%a\u0004\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003\u001f\u0011!a\u0003A!A!\u0002\u0013i\u0003\u0002\u0003\u0019\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0010\t\u000bE\u0002A\u0011\u0001\u001a\t\u000fa\u0002!\u0019!C\u0001s!1!\t\u0001Q\u0001\niBQa\u0011\u0001\u0005\u0002\u0011CQ!\u0013\u0001\u0005\n)CQ\u0001\u0015\u0001\u0005BECQa\u0015\u0001\u0005BQ\u0013abQ1dQ\u0016dunZ,sSR,'O\u0003\u0002\u000f\u001f\u0005\u0019An\\4\u000b\u0005A\t\u0012\u0001C3oiJ\fgnY3\u000b\u0005I\u0019\u0012A\u00027j].L7O\u0003\u0002\u0015+\u00051\u0011\r]1dQ\u0016T\u0011AF\u0001\u0004_J<7\u0001A\n\u0003\u0001e\u0001\"AG\u000e\u000e\u00035I!\u0001H\u0007\u0003#\u0005\u00137\u000f\u001e:bGRdunZ,sSR,'/A\u0004m_\u001e\u0004\u0016\r\u001e5\u0011\u0005}AcB\u0001\u0011'!\t\tC%D\u0001#\u0015\t\u0019s#\u0001\u0004=e>|GO\u0010\u0006\u0002K\u0005)1oY1mC&\u0011q\u0005J\u0001\u0007!J,G-\u001a4\n\u0005%R#AB*ue&twM\u0003\u0002(I\u000591\r[1sg\u0016$\u0018aC:iCJ,GmQ1dQ\u0016\u0004\"A\u0007\u0018\n\u0005=j!!B\"bG\",\u0017\u0001B;tKJ\fa\u0001P5oSRtD#B\u001a5kY:\u0004C\u0001\u000e\u0001\u0011\u0015iR\u00011\u0001\u001f\u0011\u0015YS\u00011\u0001\u001f\u0011\u0015aS\u00011\u0001.\u0011\u0015\u0001T\u00011\u0001\u001f\u0003!\u0001Xo\u001d5US6,W#\u0001\u001e\u0011\u0005m\u0002U\"\u0001\u001f\u000b\u0005ur\u0014aA:rY*\tq(\u0001\u0003kCZ\f\u0017BA!=\u0005\u0011!\u0015\r^3\u0002\u0013A,8\u000f\u001b+j[\u0016\u0004\u0013\u0001C4fi\u000e\u000b7\r[3\u0016\u0003\u0015\u00032AR$.\u001b\u0005!\u0013B\u0001%%\u0005\u0019y\u0005\u000f^5p]\u0006)1-Y2iKR\u00111J\u0014\t\u0003\r2K!!\u0014\u0013\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u001f&\u0001\rAH\u0001\u0004[N<\u0017!B<sSR,GCA&S\u0011\u0015y%\u00021\u0001\u001f\u0003\u00151G.^:i)\u0005Y\u0005")
public class CacheLogWriter
extends AbstractLogWriter {
    private final Cache sharedCache;
    private final Date pushTime;

    public Date pushTime() {
        return this.pushTime;
    }

    public Option<Cache> getCache() {
        return new Some((Object)this.sharedCache);
    }

    private void cache(String msg) {
        if (this.sharedCache.cachedLogs() == null) {
            return;
        }
        CacheLogWriter cacheLogWriter = this;
        synchronized (cacheLogWriter) {
            boolean isNextOneEmpty = this.sharedCache.cachedLogs().isNextOneEmpty();
            Date currentTime = new Date(System.currentTimeMillis());
            if (!isNextOneEmpty || currentTime.after(this.pushTime())) {
                List<String> logs = this.sharedCache.cachedLogs().toList();
                StringBuilder sb = new StringBuilder();
                ((List)logs.filter((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CacheLogWriter.$anonfun$cache$1(x$1)))).foreach((Function1 & java.io.Serializable & Serializable)log -> sb.append(log).append("\n"));
                sb.append(msg);
                this.sharedCache.cachedLogs().fakeClear();
                super.write(sb.toString());
                this.pushTime().setTime(currentTime.getTime() + (long)BoxesRunTime.unboxToInt((Object)EntranceConfiguration$.MODULE$.LOG_PUSH_INTERVAL_TIME().getValue()));
            }
            this.sharedCache.cachedLogs().add(msg);
        }
    }

    @Override
    public void write(String msg) {
        if (StringUtils.isBlank((CharSequence)msg)) {
            this.cache("");
            return;
        }
        String[] rows = msg.split("\n");
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rows)).foreach((Function1 & java.io.Serializable & Serializable)row -> {
            CacheLogWriter.$anonfun$write$1(this, row);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void flush() {
        StringBuilder sb = new StringBuilder();
        if (this.sharedCache.cachedLogs() != null) {
            ((List)this.sharedCache.cachedLogs().toList().filter((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CacheLogWriter.$anonfun$flush$1(x$1)))).foreach((Function1 & java.io.Serializable & Serializable)x$2 -> sb.append(x$2).append("\n"));
            this.sharedCache.cachedLogs().clear();
        }
        super.write(sb.toString());
        super.flush();
    }

    public static final /* synthetic */ boolean $anonfun$cache$1(String x$1) {
        return x$1 != null;
    }

    public static final /* synthetic */ void $anonfun$write$1(CacheLogWriter $this, String row) {
        if (row == null) {
            $this.cache("");
            return;
        }
        $this.cache(row);
    }

    public static final /* synthetic */ boolean $anonfun$flush$1(CharSequence x$1) {
        return StringUtils.isNotEmpty((CharSequence)x$1);
    }

    public CacheLogWriter(String logPath, String charset, Cache sharedCache, String user) {
        this.sharedCache = sharedCache;
        super(logPath, user, charset);
        this.pushTime = new Date(System.currentTimeMillis() + (long)BoxesRunTime.unboxToInt((Object)EntranceConfiguration$.MODULE$.LOG_PUSH_INTERVAL_TIME().getValue()));
    }
}

