/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.entrance.parser;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.conf.Configuration$;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.entrance.conf.EntranceConfiguration$;
import org.apache.linkis.entrance.errorcode.EntranceErrorCodeSummary;
import org.apache.linkis.entrance.exception.EntranceErrorCode;
import org.apache.linkis.entrance.exception.EntranceIllegalParamException;
import org.apache.linkis.entrance.parser.AbstractEntranceParser;
import org.apache.linkis.entrance.persistence.PersistenceManager;
import org.apache.linkis.entrance.timeout.JobTimeoutManager$;
import org.apache.linkis.governance.common.entity.job.JobRequest;
import org.apache.linkis.manager.common.conf.RMConfiguration;
import org.apache.linkis.manager.label.builder.factory.LabelBuilderFactory;
import org.apache.linkis.manager.label.builder.factory.LabelBuilderFactoryContext;
import org.apache.linkis.manager.label.conf.LabelCommonConfig;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.entity.cluster.ClusterLabel;
import org.apache.linkis.manager.label.entity.engine.CodeLanguageLabel;
import org.apache.linkis.manager.label.entity.engine.EngineTypeLabel;
import org.apache.linkis.manager.label.entity.engine.UserCreatorLabel;
import org.apache.linkis.manager.label.utils.EngineTypeLabelCreator;
import org.apache.linkis.scheduler.queue.SchedulerEventState$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=d\u0001B\b\u0011\u0001mA\u0001\u0002\u000b\u0001\u0003\u0006\u0004%\t!\u000b\u0005\ta\u0001\u0011\t\u0011)A\u0005U!)\u0011\u0007\u0001C\u0001e!9Q\u0007\u0001b\u0001\n\u00131\u0004BB\"\u0001A\u0003%q\u0007C\u0003E\u0001\u0011ES\tC\u0003G\u0001\u0011\u0005s\tC\u0003o\u0001\u0011%q\u000eC\u0004\u0002\u0010\u0001!I!!\u0005\t\u000f\u0005\u0015\u0002\u0001\"\u0003\u0002(!9\u00111\b\u0001\u0005\n\u0005u\u0002bBA'\u0001\u0011%\u0011q\n\u0005\b\u0003'\u0002A\u0011BA+\u0011\u001d\t9\u0007\u0001C\u0005\u0003S\u0012AcQ8n[>tWI\u001c;sC:\u001cW\rU1sg\u0016\u0014(BA\t\u0013\u0003\u0019\u0001\u0018M]:fe*\u00111\u0003F\u0001\tK:$(/\u00198dK*\u0011QCF\u0001\u0007Y&t7.[:\u000b\u0005]A\u0012AB1qC\u000eDWMC\u0001\u001a\u0003\ry'oZ\u0002\u0001'\r\u0001A\u0004\t\t\u0003;yi\u0011\u0001E\u0005\u0003?A\u0011a#\u00112tiJ\f7\r^#oiJ\fgnY3QCJ\u001cXM\u001d\t\u0003C\u0019j\u0011A\t\u0006\u0003G\u0011\nQ!\u001e;jYNT!!\n\u000b\u0002\r\r|W.\\8o\u0013\t9#EA\u0004M_\u001e<\u0017N\\4\u0002%A,'o]5ti\u0016t7-Z'b]\u0006<WM]\u000b\u0002UA\u00111FL\u0007\u0002Y)\u0011QFE\u0001\fa\u0016\u00148/[:uK:\u001cW-\u0003\u00020Y\t\u0011\u0002+\u001a:tSN$XM\\2f\u001b\u0006t\u0017mZ3s\u0003M\u0001XM]:jgR,gnY3NC:\fw-\u001a:!\u0003\u0019a\u0014N\\5u}Q\u00111\u0007\u000e\t\u0003;\u0001AQ\u0001K\u0002A\u0002)\n1\u0003\\1cK2\u0014U/\u001b7eKJ4\u0015m\u0019;pef,\u0012a\u000e\t\u0003q\u0005k\u0011!\u000f\u0006\u0003um\nqAZ1di>\u0014\u0018P\u0003\u0002={\u00059!-^5mI\u0016\u0014(B\u0001 @\u0003\u0015a\u0017MY3m\u0015\t\u0001E#A\u0004nC:\fw-\u001a:\n\u0005\tK$a\u0005'bE\u0016d')^5mI\u0016\u0014h)Y2u_JL\u0018\u0001\u00067bE\u0016d')^5mI\u0016\u0014h)Y2u_JL\b%A\u000bhKR\u0004VM]:jgR,gnY3NC:\fw-\u001a:\u0015\u0003)\n1\u0002]1sg\u0016$v\u000eV1tWR\u0011\u0001j\u0015\t\u0003\u0013Fk\u0011A\u0013\u0006\u0003\u00172\u000b1A[8c\u0015\tie*\u0001\u0004f]RLG/\u001f\u0006\u0003K=S!\u0001\u0015\u000b\u0002\u0015\u001d|g/\u001a:oC:\u001cW-\u0003\u0002S\u0015\nQ!j\u001c2SKF,Xm\u001d;\t\u000bQ;\u0001\u0019A+\u0002\rA\f'/Y7t!\u001116,\u00186\u000e\u0003]S!\u0001W-\u0002\tU$\u0018\u000e\u001c\u0006\u00025\u0006!!.\u0019<b\u0013\tavKA\u0002NCB\u0004\"AX4\u000f\u0005}+\u0007C\u00011d\u001b\u0005\t'B\u00012\u001b\u0003\u0019a$o\\8u})\tA-A\u0003tG\u0006d\u0017-\u0003\u0002gG\u00061\u0001K]3eK\u001aL!\u0001[5\u0003\rM#(/\u001b8h\u0015\t17\r\u0005\u0002lY6\t1-\u0003\u0002nG\n1\u0011I\\=SK\u001a\fAc\u00195fG.,enZ5oKRK\b/\u001a'bE\u0016dGC\u00019t!\tY\u0017/\u0003\u0002sG\n!QK\\5u\u0011\u0015!\b\u00021\u0001v\u0003\u0019a\u0017MY3mgB!akW/wa\t9h\u0010E\u0002yurl\u0011!\u001f\u0006\u0003\u001bvJ!a_=\u0003\u000b1\u000b'-\u001a7\u0011\u0005utH\u0002\u0001\u0003\u000b\u007fN\f\t\u0011!A\u0003\u0002\u0005\u0005!aA0%gE!\u00111AA\u0005!\rY\u0017QA\u0005\u0004\u0003\u000f\u0019'a\u0002(pi\"Lgn\u001a\t\u0004W\u0006-\u0011bAA\u0007G\n\u0019\u0011I\\=\u0002E\u001d,g.\u001a:bi\u0016\fe\u000e\u001a,fe&4\u0017pQ8eK2\u000bgnZ;bO\u0016d\u0015MY3m)\u0015\u0001\u00181CA\f\u0011\u0019\t)\"\u0003a\u0001;\u00069!/\u001e8UsB,\u0007B\u0002;\n\u0001\u0004\tI\u0002E\u0003W7v\u000bY\u0002\r\u0003\u0002\u001e\u0005\u0005\u0002\u0003\u0002={\u0003?\u00012!`A\u0011\t1\t\u0019#a\u0006\u0002\u0002\u0003\u0005)\u0011AA\u0001\u0005\ryF\u0005N\u0001\"O\u0016tWM]1uK\u0006sGMV3sS\u001aLXk]3s\u0007J,\u0017\r^8s\u0019\u0006\u0014W\r\u001c\u000b\u0006a\u0006%\u0012Q\u0006\u0005\u0007\u0003WQ\u0001\u0019A/\u0002\u0017\u0015DXmY;uKV\u001bXM\u001d\u0005\u0007i*\u0001\r!a\f\u0011\u000bY[V,!\r1\t\u0005M\u0012q\u0007\t\u0005qj\f)\u0004E\u0002~\u0003o!A\"!\u000f\u0002.\u0005\u0005\t\u0011!B\u0001\u0003\u0003\u00111a\u0018\u00136\u0003u9WM\\3sCR,\u0017I\u001c3WKJLg-_\"mkN$XM\u001d'bE\u0016dGc\u00019\u0002@!1Ao\u0003a\u0001\u0003\u0003\u0002RAV.^\u0003\u0007\u0002D!!\u0012\u0002JA!\u0001P_A$!\ri\u0018\u0011\n\u0003\r\u0003\u0017\ny$!A\u0001\u0002\u000b\u0005\u0011\u0011\u0001\u0002\u0004?\u00122\u0014A\u00049beN,Gk\\(mIR\u000b7o\u001b\u000b\u0004\u0011\u0006E\u0003\"\u0002+\r\u0001\u0004)\u0016A\u00032vS2$G*\u00192fYR!\u0011qKA2!\u001516,XA-a\u0011\tY&a\u0018\u0011\taT\u0018Q\f\t\u0004{\u0006}CaCA1\u001b\u0005\u0005\t\u0011!B\u0001\u0003\u0003\u0011Aa\u0018\u00132c!1\u0011QM\u0007A\u0002U\u000b\u0001\u0002\\1cK2l\u0015\r]\u0001\u0007M>\u0014X.\u0019;\u0015\u0007u\u000bY\u0007\u0003\u0004\u0002n9\u0001\r!X\u0001\u0005G>$W\r")
public class CommonEntranceParser
extends AbstractEntranceParser
implements Logging {
    private final PersistenceManager persistenceManager;
    private final LabelBuilderFactory labelBuilderFactory;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        CommonEntranceParser commonEntranceParser = this;
        synchronized (commonEntranceParser) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public PersistenceManager persistenceManager() {
        return this.persistenceManager;
    }

    private LabelBuilderFactory labelBuilderFactory() {
        return this.labelBuilderFactory;
    }

    @Override
    public PersistenceManager getPersistenceManager() {
        return this.persistenceManager();
    }

    @Override
    public JobRequest parseToTask(Map<String, Object> params) {
        if (!params.containsKey("executionContent")) {
            return this.parseToOldTask(params);
        }
        JobRequest jobRequest = new JobRequest();
        jobRequest.setCreatedTime(new Date(System.currentTimeMillis()));
        String executeUser = (String)params.get("executeUser");
        String submitUser = (String)params.get("submitUser");
        jobRequest.setSubmitUser(submitUser);
        if (StringUtils.isBlank((CharSequence)executeUser)) {
            jobRequest.setExecuteUser(submitUser);
        } else {
            jobRequest.setExecuteUser(executeUser);
        }
        Map executionContent = params.getOrDefault("executionContent", new HashMap());
        Map configMap = params.getOrDefault("params", new HashMap());
        Map labelMap = params.getOrDefault("labels", new HashMap());
        Map source = params.getOrDefault("source", new HashMap());
        if (labelMap.isEmpty()) {
            throw new EntranceIllegalParamException(EntranceErrorCode.PARAM_CANNOT_EMPTY.getErrCode(), new StringBuilder(17).append(EntranceErrorCode.PARAM_CANNOT_EMPTY.getDesc()).append(",  labels is null").toString());
        }
        String code = null;
        String runType = null;
        if (executionContent.containsKey("code")) {
            code = (String)executionContent.get("code");
            runType = (String)executionContent.get("runType");
            if (StringUtils.isBlank((CharSequence)code)) {
                throw new EntranceIllegalParamException(EntranceErrorCodeSummary.PARAM_NOT_NULL.getErrorCode(), EntranceErrorCodeSummary.PARAM_NOT_NULL.getErrorDesc());
            }
        } else {
            throw new EntranceIllegalParamException(EntranceErrorCodeSummary.ONLY_CODE_SUPPORTED.getErrorCode(), EntranceErrorCodeSummary.PARAM_NOT_NULL.getErrorDesc());
        }
        boolean formatCode = BoxesRunTime.unboxToBoolean((Object)params.get("formatCode"));
        if (formatCode) {
            code = this.format(code);
        }
        jobRequest.setExecutionCode(code);
        Map<String, Label<?>> labels = this.buildLabel(labelMap);
        JobTimeoutManager$.MODULE$.checkTimeoutLabel(labels);
        this.checkEngineTypeLabel(labels);
        this.generateAndVerifyCodeLanguageLabel(runType, labels);
        this.generateAndVerifyUserCreatorLabel(executeUser, labels);
        this.generateAndVerifyClusterLabel(labels);
        jobRequest.setLabels(new ArrayList(labels.values()));
        jobRequest.setSource(source);
        jobRequest.setStatus(SchedulerEventState$.MODULE$.Inited().toString());
        jobRequest.setMetrics(new HashMap());
        jobRequest.getMetrics().put("submitTime", new Date(System.currentTimeMillis()));
        jobRequest.setParams(configMap);
        return jobRequest;
    }

    private void checkEngineTypeLabel(Map<String, Label<?>> labels) {
        Label engineTypeLabel = labels.getOrDefault("engineType", null);
        if (engineTypeLabel == null) {
            String msg = new StringBuilder(60).append("You need to specify engineTypeLabel in labels,").append("such as spark-").append(LabelCommonConfig.SPARK_ENGINE_VERSION.getValue()).toString();
            throw new EntranceIllegalParamException(EntranceErrorCode.LABEL_PARAMS_INVALID.getErrCode(), new StringBuilder(0).append(EntranceErrorCode.LABEL_PARAMS_INVALID.getDesc()).append(msg).toString());
        }
    }

    private void generateAndVerifyCodeLanguageLabel(String runType, Map<String, Label<?>> labels) {
        Label engineRunTypeLabel = labels.getOrDefault("codeType", null);
        if (StringUtils.isBlank((CharSequence)runType) && engineRunTypeLabel == null) {
            String msg = "You need to specify runType in execution content, such as sql";
            this.logger().warn(msg);
            throw new EntranceIllegalParamException(EntranceErrorCode.LABEL_PARAMS_INVALID.getErrCode(), new StringBuilder(0).append(EntranceErrorCode.LABEL_PARAMS_INVALID.getDesc()).append(msg).toString());
        }
        if (StringUtils.isNotBlank((CharSequence)runType)) {
            CodeLanguageLabel codeLanguageLabel = (CodeLanguageLabel)this.labelBuilderFactory().createLabel("codeType");
            codeLanguageLabel.setCodeType(runType);
            labels.put("codeType", (Label<?>)codeLanguageLabel);
            return;
        }
    }

    private void generateAndVerifyUserCreatorLabel(String executeUser, Map<String, Label<?>> labels) {
        UserCreatorLabel userCreatorLabel = labels.getOrDefault("userCreator", null);
        if (userCreatorLabel == null) {
            userCreatorLabel = (UserCreatorLabel)this.labelBuilderFactory().createLabel(UserCreatorLabel.class);
            String creator = (String)EntranceConfiguration$.MODULE$.DEFAULT_REQUEST_APPLICATION_NAME().getHotValue();
            userCreatorLabel.setUser(executeUser);
            userCreatorLabel.setCreator(creator);
            labels.put(userCreatorLabel.getLabelKey(), (Label<?>)userCreatorLabel);
            return;
        }
    }

    private void generateAndVerifyClusterLabel(Map<String, Label<?>> labels) {
        if (!Configuration$.MODULE$.IS_MULTIPLE_YARN_CLUSTER()) {
            return;
        }
        ClusterLabel clusterLabel = labels.getOrDefault("yarnCluster", null);
        if (clusterLabel == null) {
            clusterLabel = (ClusterLabel)LabelBuilderFactoryContext.getLabelBuilderFactory().createLabel(ClusterLabel.class);
            clusterLabel.setClusterName((String)RMConfiguration.DEFAULT_YARN_CLUSTER_NAME.getValue());
            clusterLabel.setClusterType((String)RMConfiguration.DEFAULT_YARN_TYPE.getValue());
            labels.put(clusterLabel.getLabelKey(), (Label<?>)clusterLabel);
            return;
        }
    }

    private JobRequest parseToOldTask(Map<String, Object> params) {
        Object object;
        Object _params;
        JobRequest jobReq = new JobRequest();
        jobReq.setCreatedTime(new Date(System.currentTimeMillis()));
        String umUser = (String)params.get("executeUser");
        String submitUser = (String)params.get("submitUser");
        jobReq.setSubmitUser(submitUser);
        if (StringUtils.isBlank((CharSequence)submitUser)) {
            jobReq.setSubmitUser(umUser);
        }
        if (umUser == null) {
            throw new EntranceIllegalParamException(EntranceErrorCodeSummary.EXECUTEUSER_NOT_NULL.getErrorCode(), EntranceErrorCodeSummary.EXECUTEUSER_NOT_NULL.getErrorDesc());
        }
        jobReq.setExecuteUser(umUser);
        String executionCode = (String)params.get("executionCode");
        Object object2 = _params = params.get("params");
        if (object2 instanceof Map) {
            Map map = (Map)object2;
            jobReq.setParams(map);
        }
        boolean formatCode = BoxesRunTime.unboxToBoolean((Object)params.get("formatCode"));
        String creator = (String)params.get("requestApplicationName");
        Map source = params.getOrDefault("source", new HashMap());
        String executeApplicationName = (String)params.get("executeApplicationName");
        if (StringUtils.isBlank((CharSequence)creator)) {
            creator = (String)EntranceConfiguration$.MODULE$.DEFAULT_REQUEST_APPLICATION_NAME().getHotValue();
        }
        if (((String)EntranceConfiguration$.MODULE$.DEFAULT_REQUEST_APPLICATION_NAME().getHotValue()).equals(creator) && StringUtils.isEmpty((CharSequence)((CharSequence)source.get("scriptPath"))) && StringUtils.isEmpty((CharSequence)executionCode)) {
            throw new EntranceIllegalParamException(EntranceErrorCodeSummary.EXEC_SCRIP_NOT_NULL.getErrorCode(), EntranceErrorCodeSummary.EXEC_SCRIP_NOT_NULL.getErrorDesc());
        }
        String runType = null;
        if (StringUtils.isNotEmpty((CharSequence)executionCode)) {
            runType = (String)params.get("runType");
            if (StringUtils.isEmpty((CharSequence)runType)) {
                runType = (String)EntranceConfiguration$.MODULE$.DEFAULT_RUN_TYPE().getHotValue();
            }
            if (formatCode) {
                executionCode = this.format(executionCode);
            }
            jobReq.setExecutionCode(executionCode);
        }
        EngineTypeLabel engineTypeLabel = EngineTypeLabelCreator.createEngineTypeLabel((String)executeApplicationName);
        Label runTypeLabel = this.labelBuilderFactory().createLabel("codeType", (Object)runType);
        Label userCreatorLabel = this.labelBuilderFactory().createLabel("userCreator", (Object)new StringBuilder(1).append(umUser).append("-").append(creator).toString());
        ArrayList<Object> labelList = new ArrayList<Object>(3);
        labelList.add(engineTypeLabel);
        labelList.add(runTypeLabel);
        labelList.add(userCreatorLabel);
        if (jobReq.getParams() != null) {
            Map labelMap = params.getOrDefault("labels", new HashMap());
            if (labelMap != null && !labelMap.isEmpty()) {
                List list = this.labelBuilderFactory().getLabels(labelMap);
                object = BoxesRunTime.boxToBoolean((boolean)labelList.addAll(list));
            } else {
                object = BoxedUnit.UNIT;
            }
        } else {
            object = BoxedUnit.UNIT;
        }
        jobReq.setProgress("0.0");
        jobReq.setSource(source);
        jobReq.setStatus(SchedulerEventState$.MODULE$.Inited().toString());
        jobReq.setLabels(labelList);
        jobReq.setMetrics(new HashMap());
        jobReq.getMetrics().put("submitTime", new Date(System.currentTimeMillis()));
        return jobReq;
    }

    private Map<String, Label<?>> buildLabel(Map<String, Object> labelMap) {
        HashMap labelKeyValueMap;
        block0: {
            List list;
            labelKeyValueMap = new HashMap();
            if (labelMap == null || labelMap.isEmpty() || (list = this.labelBuilderFactory().getLabels(labelMap)) == null) break block0;
            ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(list).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CommonEntranceParser.$anonfun$buildLabel$1(x$1)))).foreach((Function1 & Serializable & scala.Serializable)label -> labelKeyValueMap.put(label.getLabelKey(), (Label<?>)label));
        }
        return labelKeyValueMap;
    }

    private String format(String code) {
        return code;
    }

    public static final /* synthetic */ boolean $anonfun$buildLabel$1(Label x$1) {
        return x$1 != null;
    }

    public CommonEntranceParser(PersistenceManager persistenceManager) {
        this.persistenceManager = persistenceManager;
        Logging.$init$((Logging)this);
        this.labelBuilderFactory = LabelBuilderFactoryContext.getLabelBuilderFactory();
    }
}

