/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.client.utils;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.exception.ErrorException;
import org.apache.linkis.cs.client.service.DefaultSearchService;
import org.apache.linkis.cs.client.service.SearchService;
import org.apache.linkis.cs.client.utils.SerializeHelper;
import org.apache.linkis.cs.common.entity.enumeration.ContextScope;
import org.apache.linkis.cs.common.entity.enumeration.ContextType;
import org.apache.linkis.cs.common.entity.object.CSFlowInfos;
import org.apache.linkis.cs.common.entity.source.CombinedNodeIDContextID;
import org.apache.linkis.cs.common.entity.source.CommonContextKey;
import org.apache.linkis.cs.common.entity.source.ContextID;
import org.apache.linkis.cs.common.entity.source.ContextKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextServiceUtils {
    private static final Logger logger = LoggerFactory.getLogger(ContextServiceUtils.class);
    private static SearchService commonSearchService = DefaultSearchService.getInstance();

    public static String getContextIDStrByMap(Map<String, Object> map) {
        Object value;
        String contextIDStr = null;
        if (null != map && null != (value = map.get("contextID"))) {
            contextIDStr = value.toString();
            try {
                ContextID contextID = SerializeHelper.deserializeContextID(contextIDStr);
                if (contextID instanceof CombinedNodeIDContextID) {
                    contextIDStr = SerializeHelper.serializeContextID((ContextID)((CombinedNodeIDContextID)contextID).getLinkisHaWorkFlowContextID());
                }
            }
            catch (ErrorException e) {
                logger.info("Failed to deserializeContextID", (Throwable)e);
            }
        }
        return contextIDStr;
    }

    public static String getNodeNameStrByMap(Map<String, Object> map) {
        Object contextIDValue = map.get("contextID");
        if (null == contextIDValue) {
            return null;
        }
        String nodeName = null;
        try {
            Object value;
            if (null != map && null != (value = map.get("nodeName"))) {
                nodeName = value.toString();
            }
            if (StringUtils.isBlank(nodeName)) {
                nodeName = ContextServiceUtils.getNodeNameByCombinedNodeIDContextID(contextIDValue.toString());
            }
        }
        catch (Exception e) {
            logger.info("Failed to get nodeName", (Throwable)e);
        }
        map.put("nodeName", nodeName);
        return nodeName;
    }

    public static String getContextIDStrByProperties(Properties properties) {
        Object value;
        String contextIDStr = null;
        if (null != properties && null != (value = properties.get("contextID"))) {
            contextIDStr = value.toString();
            try {
                ContextID contextID = SerializeHelper.deserializeContextID(contextIDStr);
                if (contextID instanceof CombinedNodeIDContextID) {
                    contextIDStr = SerializeHelper.serializeContextID((ContextID)((CombinedNodeIDContextID)contextID).getLinkisHaWorkFlowContextID());
                }
            }
            catch (ErrorException e) {
                logger.info("Failed to deserializeContextID", (Throwable)e);
            }
        }
        return contextIDStr;
    }

    public static String getNodeNameStrByProperties(Properties properties) {
        Object value;
        Object contextIDValue = properties.get("contextID");
        if (null == contextIDValue) {
            return null;
        }
        String nodeName = null;
        if (null != properties && null != (value = properties.get("nodeName"))) {
            nodeName = value.toString();
        }
        if (StringUtils.isBlank(nodeName)) {
            nodeName = ContextServiceUtils.getNodeNameByCombinedNodeIDContextID(contextIDValue.toString());
        }
        properties.put("nodeName", nodeName);
        return nodeName;
    }

    public static String getNodeNameByCombinedNodeIDContextID(String contextIDStr) {
        String nodeName = null;
        try {
            ContextID contextID = SerializeHelper.deserializeContextID(contextIDStr);
            if (contextID instanceof CombinedNodeIDContextID) {
                logger.info("contextID{} is combinedNodeIDContextID", (Object)contextID.getContextId());
                String nodeID = ((CombinedNodeIDContextID)contextID).getNodeID();
                return ContextServiceUtils.getNodeNameByNodeID(SerializeHelper.serializeContextID((ContextID)((CombinedNodeIDContextID)contextID).getLinkisHaWorkFlowContextID()), nodeID);
            }
        }
        catch (Exception e) {
            logger.info("Failed to get nodeName", (Throwable)e);
        }
        return nodeName;
    }

    public static String getNodeNameByNodeID(String contextIDStr, String nodeID) {
        if (StringUtils.isBlank((CharSequence)contextIDStr) || StringUtils.isBlank((CharSequence)nodeID)) {
            return null;
        }
        try {
            Object idName;
            ContextID contextID = SerializeHelper.deserializeContextID(contextIDStr);
            CommonContextKey contextKey = new CommonContextKey();
            contextKey.setContextType(ContextType.OBJECT);
            contextKey.setContextScope(ContextScope.PUBLIC);
            contextKey.setKey("flow.infos");
            CSFlowInfos csFlowInfos = commonSearchService.getContextValue(contextID, (ContextKey)contextKey, CSFlowInfos.class);
            if (null != csFlowInfos && null != csFlowInfos.getInfos() && null != (idName = csFlowInfos.getInfos().get("id_nodeName"))) {
                return (String)((Map)idName).get(nodeID);
            }
        }
        catch (ErrorException e) {
            logger.info("Failed to get nodeName ", (Throwable)e);
        }
        return null;
    }

    public static String createCombinedNodeIDContextID(String contextIDStr, String nodeID) throws ErrorException {
        ContextID contextID;
        if (StringUtils.isNotBlank((CharSequence)contextIDStr) && StringUtils.isNotBlank((CharSequence)nodeID) && null != (contextID = SerializeHelper.deserializeContextID(contextIDStr))) {
            return SerializeHelper.serializeContextID((ContextID)new CombinedNodeIDContextID(contextID, nodeID));
        }
        return null;
    }
}

