/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.fs.impl;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazonaws.services.s3.model.Owner;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.storage.domain.FsPathListWithError;
import org.apache.linkis.storage.errorcode.LinkisStorageErrorCodeSummary;
import org.apache.linkis.storage.exception.StorageWarnException;
import org.apache.linkis.storage.fs.FileSystem;
import org.apache.linkis.storage.fs.stream.S3OutputStream;
import org.apache.linkis.storage.utils.StorageConfiguration;
import org.apache.linkis.storage.utils.StorageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3FileSystem
extends FileSystem {
    private static final Logger logger = LoggerFactory.getLogger(S3FileSystem.class);
    private String accessKey;
    private String secretKey;
    private String endPoint;
    private String region;
    private String bucket;
    private String label;
    private AmazonS3 s3Client;
    private static final String INIT_FILE_NAME = ".s3_dir_init";

    public void init(Map<String, String> properties) throws IOException {
        this.accessKey = (String)StorageConfiguration.S3_ACCESS_KEY().getValue(properties);
        this.secretKey = (String)StorageConfiguration.S3_SECRET_KEY().getValue(properties);
        this.endPoint = (String)StorageConfiguration.S3_ENDPOINT().getValue(properties);
        this.bucket = (String)StorageConfiguration.S3_BUCKET().getValue(properties);
        this.region = (String)StorageConfiguration.S3_REGION().getValue(properties);
        AwsClientBuilder.EndpointConfiguration endpointConfiguration = new AwsClientBuilder.EndpointConfiguration(this.endPoint, this.region);
        BasicAWSCredentials basicAWSCredentials = new BasicAWSCredentials(this.accessKey, this.secretKey);
        AWSStaticCredentialsProvider StaticCredentials = new AWSStaticCredentialsProvider((AWSCredentials)basicAWSCredentials);
        this.s3Client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withEndpointConfiguration(endpointConfiguration)).withPathStyleAccessEnabled(Boolean.valueOf(true))).withCredentials((AWSCredentialsProvider)StaticCredentials)).build();
    }

    public String fsName() {
        return StorageUtils.S3();
    }

    public String rootUserName() {
        return null;
    }

    public FsPath get(String dest) throws IOException {
        FsPath ret = new FsPath(dest);
        if (this.exists(ret)) {
            ret.setIsdir(this.isDir(this.buildKey(ret.getPath())));
            return ret;
        }
        logger.warn("File or folder does not exist or file name is garbled(\u6587\u4ef6\u6216\u8005\u6587\u4ef6\u5939\u4e0d\u5b58\u5728\u6216\u8005\u6587\u4ef6\u540d\u4e71\u7801)");
        throw new StorageWarnException(LinkisStorageErrorCodeSummary.TO_BE_UNKNOW.getErrorCode(), "File or folder does not exist or file name is garbled(\u6587\u4ef6\u6216\u8005\u6587\u4ef6\u5939\u4e0d\u5b58\u5728\u6216\u8005\u6587\u4ef6\u540d\u4e71\u7801)");
    }

    public InputStream read(FsPath dest) throws IOException {
        try {
            return this.s3Client.getObject(this.bucket, this.buildKey(dest.getPath())).getObjectContent();
        }
        catch (AmazonS3Exception e) {
            throw new IOException("You have not permission to access path " + dest.getPath());
        }
    }

    public OutputStream write(FsPath dest, boolean overwrite) throws IOException {
        S3OutputStream s3OutputStream;
        InputStream inputStream = null;
        try {
            if (!this.exists(dest)) {
                this.create(dest.getPath());
            }
            S3OutputStream outputStream = new S3OutputStream(this.s3Client, this.bucket, this.buildKey(dest.getPath()));
            if (!overwrite) {
                inputStream = this.read(dest);
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            s3OutputStream = outputStream;
        }
        catch (IOException e) {
            try {
                throw new IOException("You have not permission to access path " + dest.getPath());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return s3OutputStream;
    }

    public boolean create(String dest) throws IOException {
        if (this.exists(new FsPath(dest))) {
            return false;
        }
        this.s3Client.putObject(this.bucket, this.buildKey(dest), "");
        return true;
    }

    public List<FsPath> list(FsPath path) throws IOException {
        try {
            if (!StringUtils.isEmpty((CharSequence)path.getPath())) {
                ListObjectsV2Request listObjectsV2Request = new ListObjectsV2Request().withBucketName(this.bucket).withPrefix(this.buildKey(path.getPath()) + "/").withDelimiter("/");
                ListObjectsV2Result dirResult = this.s3Client.listObjectsV2(listObjectsV2Request);
                List s3ObjectSummaries = dirResult.getObjectSummaries();
                List commonPrefixes = dirResult.getCommonPrefixes();
                List<FsPath> fsPaths = s3ObjectSummaries.stream().filter(summary -> !this.isInitFile((S3ObjectSummary)summary)).map(summary -> {
                    FsPath newPath = new FsPath(this.buildPath(summary.getKey()));
                    return this.fillStorageFile(newPath, (S3ObjectSummary)summary);
                }).collect(Collectors.toList());
                if (commonPrefixes != null) {
                    for (String dir : commonPrefixes) {
                        FsPath newPath = new FsPath(this.buildPath(dir));
                        newPath.setIsdir(true);
                        fsPaths.add(newPath);
                    }
                }
                return fsPaths;
            }
        }
        catch (AmazonS3Exception e) {
            throw new IOException("You have not permission to access path " + path.getPath());
        }
        return new ArrayList<FsPath>();
    }

    @Override
    public FsPathListWithError listPathWithError(FsPath path) throws IOException {
        return this.listPathWithError(path, true);
    }

    public FsPathListWithError listPathWithError(FsPath path, boolean ignoreInitFile) throws IOException {
        ArrayList<FsPath> rtn = new ArrayList<FsPath>();
        try {
            if (!StringUtils.isEmpty((CharSequence)path.getPath())) {
                FsPath newPath;
                ListObjectsV2Request listObjectsV2Request = new ListObjectsV2Request().withBucketName(this.bucket).withPrefix(this.buildKey(path.getPath()) + "/").withDelimiter("/");
                ListObjectsV2Result dirResult = this.s3Client.listObjectsV2(listObjectsV2Request);
                List s3ObjectSummaries = dirResult.getObjectSummaries();
                List commonPrefixes = dirResult.getCommonPrefixes();
                if (s3ObjectSummaries != null) {
                    for (S3ObjectSummary summary : s3ObjectSummaries) {
                        if (this.isInitFile(summary) && ignoreInitFile) continue;
                        newPath = new FsPath(this.buildPath(summary.getKey()));
                        rtn.add(this.fillStorageFile(newPath, summary));
                    }
                }
                if (commonPrefixes != null) {
                    for (String dir : commonPrefixes) {
                        newPath = new FsPath(this.buildPath(dir));
                        newPath.setIsdir(true);
                        rtn.add(newPath);
                    }
                }
                return new FsPathListWithError(rtn, "");
            }
        }
        catch (AmazonS3Exception e) {
            throw new IOException("You have not permission to access path " + path.getPath());
        }
        return null;
    }

    public boolean exists(FsPath dest) throws IOException {
        try {
            if (dest == null) {
                return false;
            }
            ListObjectsV2Request listObjectsV2Request = new ListObjectsV2Request();
            listObjectsV2Request.withBucketName(this.bucket).withPrefix(this.buildKey(dest.getPath())).withMaxKeys(Integer.valueOf(1));
            return !this.s3Client.listObjectsV2(listObjectsV2Request).getObjectSummaries().isEmpty();
        }
        catch (AmazonS3Exception e) {
            return false;
        }
    }

    public boolean delete(FsPath dest) throws IOException {
        try {
            ArrayList<String> deleteKeys = new ArrayList<String>();
            this.delete(dest, deleteKeys);
            if (!deleteKeys.isEmpty()) {
                DeleteObjectsRequest deleteObjectsRequest = new DeleteObjectsRequest(this.bucket).withKeys(deleteKeys.toArray(new String[0]));
                this.s3Client.deleteObjects(deleteObjectsRequest);
            }
            return true;
        }
        catch (AmazonS3Exception e) {
            throw new IOException("You have not permission to access path " + dest.getPath());
        }
    }

    public void delete(FsPath dest, List<String> keys) throws IOException {
        if (this.isDir(this.buildKey(dest.getPath()))) {
            FsPathListWithError fsPathListWithError = this.listPathWithError(dest, false);
            List<FsPath> fsPaths = fsPathListWithError.getFsPaths();
            fsPaths.forEach(fsPath -> {
                try {
                    this.delete((FsPath)fsPath, keys);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        } else {
            keys.add(this.buildKey(dest.getPath()));
        }
    }

    public boolean renameTo(FsPath oldDest, FsPath newDest) throws IOException {
        try {
            String newOriginPath = this.buildKey(oldDest.getPath());
            String newDestPath = this.buildKey(newDest.getPath());
            ListObjectsV2Request listObjectsV2Request = new ListObjectsV2Request();
            listObjectsV2Request.withBucketName(this.bucket).withPrefix(newOriginPath);
            ListObjectsV2Result result = this.s3Client.listObjectsV2(listObjectsV2Request);
            List keyList = result.getObjectSummaries().stream().map(S3ObjectSummary::getKey).collect(Collectors.toList());
            List newKeyList = keyList.stream().map(key -> key.replaceFirst(newOriginPath, newDestPath)).collect(Collectors.toList());
            for (int i = 0; i < keyList.size(); ++i) {
                String key2 = (String)keyList.get(i);
                String newKey = (String)newKeyList.get(i);
                this.s3Client.copyObject(this.bucket, key2, this.bucket, newKey);
                this.s3Client.deleteObject(this.bucket, key2);
            }
            return true;
        }
        catch (AmazonS3Exception e) {
            this.s3Client.deleteObject(this.bucket, newDest.getPath());
            throw new IOException("You have not permission to access path " + oldDest.getPath() + " or " + newDest.getPath());
        }
    }

    @Override
    public boolean copy(String origin, String dest) throws IOException {
        try {
            String newOrigin = this.buildKey(origin);
            String newDest = this.buildKey(dest);
            ListObjectsV2Request listObjectsV2Request = new ListObjectsV2Request();
            listObjectsV2Request.withBucketName(this.bucket).withPrefix(newOrigin);
            ListObjectsV2Result result = this.s3Client.listObjectsV2(listObjectsV2Request);
            List keyList = result.getObjectSummaries().stream().map(S3ObjectSummary::getKey).collect(Collectors.toList());
            List newKeyList = keyList.stream().map(key -> key.replaceFirst(newOrigin, newDest)).collect(Collectors.toList());
            for (int i = 0; i < keyList.size(); ++i) {
                String key2 = (String)keyList.get(i);
                String newKey = (String)newKeyList.get(i);
                this.s3Client.copyObject(this.bucket, key2, this.bucket, newKey);
            }
            return true;
        }
        catch (AmazonS3Exception e) {
            throw new IOException("You have not permission to access path " + origin + " or " + dest);
        }
    }

    private boolean isDir(String key) {
        ListObjectsV2Request listObjectsV2Request = new ListObjectsV2Request();
        listObjectsV2Request.withBucketName(this.bucket).withPrefix(key + "/").withDelimiter("/").withMaxKeys(Integer.valueOf(1));
        return !this.s3Client.listObjectsV2(listObjectsV2Request).getCommonPrefixes().isEmpty() || !this.s3Client.listObjectsV2(listObjectsV2Request).getObjectSummaries().isEmpty();
    }

    private boolean isInitFile(S3ObjectSummary s3ObjectSummary) {
        return s3ObjectSummary.getKey().contains(INIT_FILE_NAME);
    }

    @Override
    public String listRoot() {
        return "/";
    }

    public boolean mkdir(FsPath dest) throws IOException {
        String path = new File(dest.getPath(), INIT_FILE_NAME).getPath();
        if (this.exists(new FsPath(path))) {
            return false;
        }
        return this.create(path);
    }

    public boolean mkdirs(FsPath dest) throws IOException {
        return this.mkdir(dest);
    }

    private FsPath fillStorageFile(FsPath fsPath, S3ObjectSummary s3ObjectSummary) {
        fsPath.setModification_time(s3ObjectSummary.getLastModified().getTime());
        Owner owner = s3ObjectSummary.getOwner();
        if (owner != null) {
            fsPath.setOwner(owner.getDisplayName());
        }
        try {
            fsPath.setIsdir(this.isDir(s3ObjectSummary.getKey()));
        }
        catch (Throwable e) {
            logger.warn("Failed to fill storage file\uff1a" + fsPath.getPath(), e);
        }
        if (fsPath.isdir()) {
            fsPath.setLength(0L);
        } else {
            fsPath.setLength(s3ObjectSummary.getSize());
        }
        return fsPath;
    }

    public boolean canRead(FsPath dest) {
        return true;
    }

    public boolean canRead(FsPath dest, String user) throws IOException {
        return true;
    }

    public boolean canWrite(FsPath dest) {
        return true;
    }

    @Override
    public long getTotalSpace(FsPath dest) {
        return 0L;
    }

    @Override
    public long getFreeSpace(FsPath dest) {
        return 0L;
    }

    @Override
    public long getUsableSpace(FsPath dest) {
        return 0L;
    }

    @Override
    public long getLength(FsPath dest) throws IOException {
        return this.s3Client.getObject(this.bucket, this.buildKey(dest.getPath())).getObjectMetadata().getContentLength();
    }

    @Override
    public String checkSum(FsPath dest) throws IOException {
        return null;
    }

    @Override
    public boolean canExecute(FsPath dest) {
        return true;
    }

    @Override
    public boolean setOwner(FsPath dest, String user, String group) {
        return false;
    }

    @Override
    public boolean setOwner(FsPath dest, String user) {
        return false;
    }

    @Override
    public boolean setGroup(FsPath dest, String group) {
        return false;
    }

    @Override
    public boolean setPermission(FsPath dest, String permission) {
        return false;
    }

    public void close() throws IOException {
        this.s3Client.shutdown();
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String buildPath(String path) {
        if (path == null || path.isEmpty()) {
            return "";
        }
        if (path.startsWith("/")) {
            return StorageUtils.S3_SCHEMA() + path;
        }
        return StorageUtils.S3_SCHEMA() + "/" + path;
    }

    public String buildKey(String path) {
        String res = path;
        if (path == null || path.isEmpty()) {
            return "";
        }
        if (path.startsWith("/")) {
            res = path.replaceFirst("/", "");
        }
        if (path.endsWith("/") && !res.isEmpty()) {
            res = res.substring(0, res.length() - 1);
        }
        return res;
    }
}

