/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.script.writer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.io.MetaData;
import org.apache.linkis.common.io.Record;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.storage.LineRecord;
import org.apache.linkis.storage.script.Compaction;
import org.apache.linkis.storage.script.Compaction$;
import org.apache.linkis.storage.script.ScriptFsWriter;
import org.apache.linkis.storage.script.ScriptMetaData;
import org.apache.linkis.storage.script.Variable;
import org.apache.linkis.storage.script.writer.StorageScriptFsWriter$;
import org.apache.linkis.storage.utils.StorageConfiguration$;
import org.apache.linkis.storage.utils.StorageUtils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001B\n\u0015\u0001\u0005B\u0001B\f\u0001\u0003\u0006\u0004%\ta\f\u0005\tm\u0001\u0011\t\u0011)A\u0005a!Aq\u0007\u0001BC\u0002\u0013\u0005\u0001\b\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003:\u0011!9\u0005A!A!\u0002\u0013A\u0005\"B(\u0001\t\u0003\u0001\u0006b\u0002,\u0001\u0005\u0004%Ia\u0016\u0005\u0007A\u0002\u0001\u000b\u0011\u0002-\t\u000b\u0005\u0004A\u0011\t2\t\u000f\u0005m\u0001\u0001\"\u0011\u0002\u001e!9\u0011Q\u0007\u0001\u0005B\u0005]\u0002bBA\u001d\u0001\u0011\u0005\u0013q\u0007\u0005\b\u0003w\u0001A\u0011AA\u001f\u0011\u001d\t)\u0005\u0001C\u0001\u0003\u000f:\u0011\"a\u0014\u0015\u0003\u0003E\t!!\u0015\u0007\u0011M!\u0012\u0011!E\u0001\u0003'Baa\u0014\t\u0005\u0002\u0005m\u0003\"CA/!E\u0005I\u0011AA0\u0005U\u0019Fo\u001c:bO\u0016\u001c6M]5qi\u001a\u001bxK]5uKJT!!\u0006\f\u0002\r]\u0014\u0018\u000e^3s\u0015\t9\u0002$\u0001\u0004tGJL\u0007\u000f\u001e\u0006\u00033i\tqa\u001d;pe\u0006<WM\u0003\u0002\u001c9\u00051A.\u001b8lSNT!!\b\u0010\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0012aA8sO\u000e\u00011c\u0001\u0001#MA\u00111\u0005J\u0007\u0002-%\u0011QE\u0006\u0002\u000f'\u000e\u0014\u0018\u000e\u001d;Gg^\u0013\u0018\u000e^3s!\t9C&D\u0001)\u0015\tI#&A\u0003vi&d7O\u0003\u0002,5\u000511m\\7n_:L!!\f\u0015\u0003\u000f1{wmZ5oO\u0006!\u0001/\u0019;i+\u0005\u0001\u0004CA\u00195\u001b\u0005\u0011$BA\u001a+\u0003\tIw.\u0003\u00026e\t1ai\u001d)bi\"\fQ\u0001]1uQ\u0002\nqa\u00195beN,G/F\u0001:!\tQ4I\u0004\u0002<\u0003B\u0011AhP\u0007\u0002{)\u0011a\bI\u0001\u0007yI|w\u000e\u001e \u000b\u0003\u0001\u000bQa]2bY\u0006L!AQ \u0002\rA\u0013X\rZ3g\u0013\t!UI\u0001\u0004TiJLgn\u001a\u0006\u0003\u0005~\n\u0001b\u00195beN,G\u000fI\u0001\r_V$\b/\u001e;TiJ,\u0017-\u001c\t\u0003\u00136k\u0011A\u0013\u0006\u0003g-S\u0011\u0001T\u0001\u0005U\u00064\u0018-\u0003\u0002O\u0015\naq*\u001e;qkR\u001cFO]3b[\u00061A(\u001b8jiz\"B!U*U+B\u0011!\u000bA\u0007\u0002)!)aF\u0002a\u0001a!)qG\u0002a\u0001s!9qI\u0002I\u0001\u0002\u0004A\u0015!D:ue&twMQ;jY\u0012,'/F\u0001Y!\tIf,D\u0001[\u0015\tYF,A\u0004nkR\f'\r\\3\u000b\u0005u{\u0014AC2pY2,7\r^5p]&\u0011qL\u0017\u0002\u000e'R\u0014\u0018N\\4Ck&dG-\u001a:\u0002\u001dM$(/\u001b8h\u0005VLG\u000eZ3sA\u0005Y\u0011\r\u001a3NKR\fG)\u0019;b)\t\u0019w\r\u0005\u0002eK6\tq(\u0003\u0002g\u007f\t!QK\\5u\u0011\u0015A\u0017\u00021\u0001j\u0003!iW\r^1ECR\f\u0007CA\u0019k\u0013\tY'G\u0001\u0005NKR\fG)\u0019;bQ\rIQn\u001d\t\u0004I:\u0004\u0018BA8@\u0005\u0019!\bN]8xgB\u0011\u0011*]\u0005\u0003e*\u00131\"S(Fq\u000e,\u0007\u000f^5p]F*a$\u000f;\u0002\u001aE21%\u001e=\u0002\u0010e,\"\u0001\u000f<\u0005\u000b]\u0004#\u0019\u0001?\u0003\u0003QK!!\u001f>\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0015\tYx(\u0001\u0004uQJ|wo]\t\u0004{\u0006\u0005\u0001C\u00013\u007f\u0013\tyxHA\u0004O_RD\u0017N\\4\u0011\t\u0005\r\u0011\u0011\u0002\b\u0004I\u0006\u0015\u0011bAA\u0004\u007f\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0006\u0003\u001b\u0011\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\u0005\u001dq(\r\u0005$\u0003#\t\u0019\"!\u0006|\u001d\r!\u00171C\u0005\u0003w~\nTA\t3@\u0003/\u0011Qa]2bY\u0006\f$A\n9\u0002\u0013\u0005$GMU3d_J$GcA2\u0002 !9\u0011\u0011\u0005\u0006A\u0002\u0005\r\u0012A\u0002:fG>\u0014H\rE\u00022\u0003KI1!a\n3\u0005\u0019\u0011VmY8sI\"\"!\"\\A\u0016c\u0019q\u0012(!\f\u00024E21%\u001e=\u00020e\f\u0004bIA\t\u0003'\t\td_\u0019\u0006E\u0011|\u0014qC\u0019\u0003MA\fQa\u00197pg\u0016$\u0012aY\u0001\u0006M2,8\u000f[\u0001\u000fO\u0016$\u0018J\u001c9viN#(/Z1n)\t\ty\u0004E\u0002J\u0003\u0003J1!a\u0011K\u0005-Ie\u000e];u'R\u0014X-Y7\u0002'\u001d,GoU2sSB$8i\\7qC\u000e$\u0018n\u001c8\u0015\u0005\u0005%\u0003cA\u0012\u0002L%\u0019\u0011Q\n\f\u0003\u0015\r{W\u000e]1di&|g.A\u000bTi>\u0014\u0018mZ3TGJL\u0007\u000f\u001e$t/JLG/\u001a:\u0011\u0005I\u00032c\u0001\t\u0002VA\u0019A-a\u0016\n\u0007\u0005esH\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0003#\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001aTCAA1U\rA\u00151M\u0016\u0003\u0003K\u0002B!a\u001a\u0002r5\u0011\u0011\u0011\u000e\u0006\u0005\u0003W\ni'A\u0005v]\u000eDWmY6fI*\u0019\u0011qN \u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002t\u0005%$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class StorageScriptFsWriter
extends ScriptFsWriter
implements Logging {
    private final FsPath path;
    private final String charset;
    private final OutputStream outputStream;
    private final scala.collection.mutable.StringBuilder stringBuilder;
    private Logger logger;
    private volatile boolean bitmap$0;

    public static OutputStream $lessinit$greater$default$3() {
        return StorageScriptFsWriter$.MODULE$.$lessinit$greater$default$3();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        StorageScriptFsWriter storageScriptFsWriter = this;
        synchronized (storageScriptFsWriter) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public FsPath path() {
        return this.path;
    }

    @Override
    public String charset() {
        return this.charset;
    }

    private scala.collection.mutable.StringBuilder stringBuilder() {
        return this.stringBuilder;
    }

    public void addMetaData(MetaData metaData) throws IOException {
        ArrayList<String> metadataLine = new ArrayList<String>();
        Compaction compaction = this.getScriptCompaction();
        if (compaction != null) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((ScriptMetaData)metaData).getMetaData())).map((Function1 & Serializable & scala.Serializable)variable -> compaction.compact((Variable)variable), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)metadataLine.add(x$1)));
            Object object = metadataLine.size() > 0 ? BoxesRunTime.boxToBoolean((boolean)metadataLine.add(compaction.getAnnotationSymbol())) : BoxedUnit.UNIT;
            if (this.outputStream != null) {
                IOUtils.writeLines(metadataLine, (String)"\n", (OutputStream)this.outputStream, (String)this.charset());
                return;
            }
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(metadataLine).asScala()).foreach((Function1 & Serializable & scala.Serializable)m -> this.stringBuilder().append(new StringBuilder(1).append((String)m).append("\n").toString()));
            return;
        }
    }

    public void addRecord(Record record) throws IOException {
        LineRecord scriptRecord = (LineRecord)record;
        if (this.outputStream != null) {
            IOUtils.write((String)scriptRecord.getLine(), (OutputStream)this.outputStream, (String)this.charset());
            return;
        }
        this.stringBuilder().append(scriptRecord.getLine());
    }

    public void close() {
        if (this.outputStream != null) {
            IOUtils.closeQuietly((OutputStream)this.outputStream);
            return;
        }
    }

    public void flush() {
        if (this.outputStream != null) {
            Utils$.MODULE$.tryAndWarnMsg((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                OutputStream outputStream = $this.outputStream;
                if (outputStream instanceof HdfsDataOutputStream) {
                    HdfsDataOutputStream hdfsDataOutputStream = (HdfsDataOutputStream)outputStream;
                    hdfsDataOutputStream.hflush();
                    return;
                }
                $this.outputStream.flush();
            }, "Error encounters when flush script ", this.logger());
            return;
        }
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.stringBuilder().toString().getBytes((String)StorageConfiguration$.MODULE$.STORAGE_RS_FILE_TYPE().getValue()));
    }

    public Compaction getScriptCompaction() {
        Compaction[] compactions = (Compaction[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Compaction$.MODULE$.listCompactions())).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)p.belongTo(StorageUtils$.MODULE$.pathToSuffix(this.path().getPath()))));
        if (compactions.length > 0) {
            return compactions[0];
        }
        return null;
    }

    public StorageScriptFsWriter(FsPath path, String charset, OutputStream outputStream) {
        this.path = path;
        this.charset = charset;
        this.outputStream = outputStream;
        Logging.$init$((Logging)this);
        this.stringBuilder = new scala.collection.mutable.StringBuilder();
    }
}

