/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.gateway.security.oauth;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.linkis.common.exception.LinkisCommonErrorException;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;

public final class HttpUtils$
implements Logging {
    public static HttpUtils$ MODULE$;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new HttpUtils$();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        HttpUtils$ httpUtils$ = this;
        synchronized (httpUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String get(String url, Map<String, String> headers, Map<String, String> params) {
        return (String)Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> {
            String string;
            int responseCode;
            String fullUrl = new StringBuilder(0).append(url).append((Object)(params.nonEmpty() ? new StringBuilder(1).append("?").append(((TraversableOnce)params.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    return new StringBuilder(1).append(key).append("=").append(value).toString();
                }
                throw new MatchError((Object)tuple2);
            }, Iterable$.MODULE$.canBuildFrom())).mkString("&")).toString() : "")).toString();
            HttpURLConnection connection = (HttpURLConnection)new URL(fullUrl).openConnection();
            connection.setRequestMethod("GET");
            headers.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                HttpUtils$.$anonfun$get$3(connection, x0$2);
                return BoxedUnit.UNIT;
            });
            if (!headers.contains((Object)"Accept")) {
                connection.setRequestProperty("Accept", "application/json");
            }
            if ((responseCode = connection.getResponseCode()) < 200 || responseCode >= 300) {
                throw new IOException(new StringBuilder(36).append("HTTP GET request failed for URL: ").append(url).append(" - ").append(responseCode).toString());
            }
            InputStream inputStream = connection.getInputStream();
            try {
                string = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
            }
            finally {
                inputStream.close();
                connection.disconnect();
            }
            return string;
        }, (Function1 & Serializable & scala.Serializable)t -> {
            MODULE$.logger().warn(new StringBuilder(38).append("Failed to execute HTTP GET request to ").append(url).toString(), t);
            throw new LinkisCommonErrorException(0, new StringBuilder(43).append("HTTP GET request failed for URL: ").append(url).append(", reason: ").append(t.getMessage()).toString());
        });
    }

    public Map<String, String> get$default$2() {
        return Predef$.MODULE$.Map().empty();
    }

    public Map<String, String> get$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    public String post(String url, String data, Map<String, String> headers) {
        return (String)Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> {
            String string;
            HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
            try {
                int responseCode;
                connection.setRequestMethod("POST");
                connection.setDoOutput(true);
                connection.setDoInput(true);
                headers.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    HttpUtils$.$anonfun$post$2(connection, x0$1);
                    return BoxedUnit.UNIT;
                });
                if (!headers.contains((Object)"Content-Type")) {
                    connection.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                }
                if (!headers.contains((Object)"Accept")) {
                    connection.setRequestProperty("Accept", "application/json");
                }
                if (data != null && new StringOps(Predef$.MODULE$.augmentString(data)).nonEmpty()) {
                    try (OutputStream outputStream = connection.getOutputStream();){
                        IOUtils.write((String)data, (OutputStream)outputStream, (String)"UTF-8");
                    }
                }
                if ((responseCode = connection.getResponseCode()) < 200 || responseCode >= 300) {
                    throw new IOException(new StringBuilder(37).append("HTTP POST request failed for URL: ").append(url).append(" - ").append(responseCode).toString());
                }
                try (InputStream inputStream = connection.getInputStream();){
                    string = inputStream != null ? IOUtils.toString((InputStream)inputStream, (String)"UTF-8") : "";
                }
            }
            finally {
                connection.disconnect();
            }
            return string;
        }, (Function1 & Serializable & scala.Serializable)t -> {
            MODULE$.logger().warn(new StringBuilder(39).append("Failed to execute HTTP POST request to ").append(url).toString(), t);
            throw new LinkisCommonErrorException(0, new StringBuilder(44).append("HTTP POST request failed for URL: ").append(url).append(", reason: ").append(t.getMessage()).toString());
        });
    }

    public Map<String, String> post$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    public static final /* synthetic */ void $anonfun$get$3(HttpURLConnection connection$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            connection$1.setRequestProperty(key, value);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$post$2(HttpURLConnection connection$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            connection$2.setRequestProperty(key, value);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private HttpUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

