/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.server;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.appinfo.LeaseInfo;
import com.netflix.discovery.converters.EurekaJacksonCodec;
import com.netflix.discovery.converters.wrappers.CodecWrappers;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.function.Supplier;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class CloudJacksonJson
extends CodecWrappers.LegacyJacksonJson {
    protected final CloudJacksonCodec codec = new CloudJacksonCodec();

    public CloudJacksonCodec getCodec() {
        return this.codec;
    }

    public String codecName() {
        return CodecWrappers.getCodecName(CodecWrappers.LegacyJacksonJson.class);
    }

    public <T> String encode(T object) throws IOException {
        return this.codec.writeToString(object);
    }

    public <T> void encode(T object, OutputStream outputStream) throws IOException {
        this.codec.writeTo(object, outputStream);
    }

    public <T> T decode(String textValue, Class<T> type) throws IOException {
        return (T)this.codec.readValue(type, textValue);
    }

    public <T> T decode(InputStream inputStream, Class<T> type) throws IOException {
        return (T)this.codec.readValue(type, inputStream);
    }

    static InstanceInfo updateIfNeeded(InstanceInfo info) {
        String instanceId;
        if (info.getInstanceId() == null && info.getMetadata() != null && StringUtils.hasText((String)(instanceId = (String)info.getMetadata().get("instanceId")))) {
            if (StringUtils.hasText((String)info.getHostName()) && !instanceId.startsWith(info.getHostName())) {
                instanceId = info.getHostName() + ":" + instanceId;
            }
            return new InstanceInfo.Builder(info).setInstanceId(instanceId).build();
        }
        return info;
    }

    static class CloudJacksonCodec
    extends EurekaJacksonCodec {
        private static final Version VERSION = new Version(1, 1, 0, null, null, null);

        CloudJacksonCodec() {
            ObjectMapper mapper = new ObjectMapper();
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            SimpleModule module = new SimpleModule("eureka1.x", VERSION);
            module.addSerializer(DataCenterInfo.class, (JsonSerializer)new EurekaJacksonCodec.DataCenterInfoSerializer());
            module.addSerializer(InstanceInfo.class, (JsonSerializer)new CloudInstanceInfoSerializer());
            module.addSerializer(Application.class, (JsonSerializer)new EurekaJacksonCodec.ApplicationSerializer());
            module.addSerializer(Applications.class, (JsonSerializer)new EurekaJacksonCodec.ApplicationsSerializer(this.getVersionDeltaKey(), this.getAppHashCodeKey()));
            module.addDeserializer(LeaseInfo.class, (JsonDeserializer)new EurekaJacksonCodec.LeaseInfoDeserializer());
            module.addDeserializer(InstanceInfo.class, (JsonDeserializer)new CloudInstanceInfoDeserializer(mapper));
            module.addDeserializer(Application.class, (JsonDeserializer)new EurekaJacksonCodec.ApplicationDeserializer(mapper));
            module.addDeserializer(Applications.class, (JsonDeserializer)new EurekaJacksonCodec.ApplicationsDeserializer(mapper, this.getVersionDeltaKey(), this.getAppHashCodeKey()));
            mapper.registerModule((Module)module);
            HashMap<Class<Applications>, Supplier<ObjectReader>> readers = new HashMap<Class<Applications>, Supplier<ObjectReader>>();
            readers.put(InstanceInfo.class, () -> mapper.reader().withType(InstanceInfo.class).withRootName("instance"));
            readers.put(Application.class, () -> mapper.reader().withType(Application.class).withRootName("application"));
            readers.put(Applications.class, () -> mapper.reader().withType(Applications.class).withRootName("applications"));
            this.setField("objectReaderByClass", readers);
            HashMap<Class<Applications>, ObjectWriter> writers = new HashMap<Class<Applications>, ObjectWriter>();
            writers.put(InstanceInfo.class, mapper.writer().withType(InstanceInfo.class).withRootName("instance"));
            writers.put(Application.class, mapper.writer().withType(Application.class).withRootName("application"));
            writers.put(Applications.class, mapper.writer().withType(Applications.class).withRootName("applications"));
            this.setField("objectWriterByClass", writers);
            this.setField("mapper", mapper);
        }

        void setField(String name, Object value) {
            Field field = ReflectionUtils.findField(EurekaJacksonCodec.class, (String)name);
            ReflectionUtils.makeAccessible((Field)field);
            ReflectionUtils.setField((Field)field, (Object)((Object)this), (Object)value);
        }
    }

    static class CloudInstanceInfoDeserializer
    extends EurekaJacksonCodec.InstanceInfoDeserializer {
        protected CloudInstanceInfoDeserializer(ObjectMapper mapper) {
            super(mapper);
        }

        public InstanceInfo deserialize(JsonParser jp, DeserializationContext context) throws IOException {
            InstanceInfo info = super.deserialize(jp, context);
            InstanceInfo updated = CloudJacksonJson.updateIfNeeded(info);
            return updated;
        }
    }

    static class CloudInstanceInfoSerializer
    extends EurekaJacksonCodec.InstanceInfoSerializer {
        CloudInstanceInfoSerializer() {
        }

        public void serialize(InstanceInfo info, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            InstanceInfo updated = CloudJacksonJson.updateIfNeeded(info);
            super.serialize(updated, jgen, provider);
        }
    }
}

