/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.common.search;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.linkis.cs.common.entity.enumeration.ContextScope;
import org.apache.linkis.cs.common.entity.enumeration.ContextType;

public class ContextSearchConditionMapBuilder {
    Map<Object, Object> contextTypeMap;
    Map<Object, Object> contextValueTypeMap;
    Map<Object, Object> contextScopeMap;
    Map<Object, Object> regexMap;
    Map<Object, Object> containsValueMap;
    boolean nearest = false;
    String nearestNode = "";
    Integer nearestNumber = 1;
    Boolean nearestUpstreamOnly = false;

    public static ContextSearchConditionMapBuilder newBuilder() {
        return new ContextSearchConditionMapBuilder();
    }

    public Map<Object, Object> build() {
        Map<Object, Object> conditionMap = null;
        if (this.contextTypeMap != null) {
            conditionMap = this.contextTypeMap;
        }
        if (this.contextValueTypeMap != null) {
            Map<Object, Object> map = conditionMap = conditionMap == null ? this.contextValueTypeMap : ContextSearchConditionMapBuilder.and(conditionMap, this.contextValueTypeMap);
        }
        if (this.contextScopeMap != null) {
            Map<Object, Object> map = conditionMap = conditionMap == null ? this.contextScopeMap : ContextSearchConditionMapBuilder.and(conditionMap, this.contextScopeMap);
        }
        if (this.regexMap != null) {
            Map<Object, Object> map = conditionMap = conditionMap == null ? this.regexMap : ContextSearchConditionMapBuilder.and(conditionMap, this.regexMap);
        }
        if (this.containsValueMap != null) {
            Map<Object, Object> map = conditionMap = conditionMap == null ? this.containsValueMap : ContextSearchConditionMapBuilder.and(conditionMap, this.containsValueMap);
        }
        if (this.nearest) {
            conditionMap = ContextSearchConditionMapBuilder.nearest(conditionMap, this.nearestNode, this.nearestNumber, this.nearestUpstreamOnly);
        }
        return conditionMap;
    }

    public ContextSearchConditionMapBuilder contextTypes(ContextType ... contextTypes) {
        for (ContextType contextType : contextTypes) {
            this.contextTypeMap = this.contextTypeMap == null ? this.getByContextType(contextType) : ContextSearchConditionMapBuilder.or(this.contextTypeMap, this.getByContextType(contextType));
        }
        return this;
    }

    public ContextSearchConditionMapBuilder contextValueTypes(Class ... contextValueTypes) {
        for (Class contextValueType : contextValueTypes) {
            this.contextValueTypeMap = this.contextValueTypeMap == null ? this.getByContextValueType(contextValueType) : ContextSearchConditionMapBuilder.or(this.contextValueTypeMap, this.getByContextValueType(contextValueType));
        }
        return this;
    }

    public ContextSearchConditionMapBuilder contextScopes(ContextScope ... contextScopes) {
        for (ContextScope contextScope : contextScopes) {
            this.contextScopeMap = this.contextScopeMap == null ? this.getByContextScope(contextScope) : ContextSearchConditionMapBuilder.or(this.contextScopeMap, this.getByContextScope(contextScope));
        }
        return this;
    }

    public ContextSearchConditionMapBuilder regex(String regex) {
        this.regexMap = this.getByRegex(regex);
        return this;
    }

    public ContextSearchConditionMapBuilder contains(String containsValue) {
        this.containsValueMap = this.getByContainsValue(containsValue);
        return this;
    }

    public ContextSearchConditionMapBuilder nearest(String currentNode, Integer number, Boolean upstreamOnly) {
        this.nearest = true;
        this.nearestNode = currentNode;
        this.nearestNumber = number;
        this.nearestUpstreamOnly = upstreamOnly;
        return this;
    }

    private Map<Object, Object> getByContextType(ContextType contextType) {
        HashMap conditionMap = Maps.newHashMap();
        conditionMap.put("type", "ContextType");
        conditionMap.put("contextType", contextType.toString());
        return conditionMap;
    }

    private Map<Object, Object> getByContextValueType(Class contextValueType) {
        HashMap conditionMap = Maps.newHashMap();
        conditionMap.put("type", "ContextValueType");
        conditionMap.put("contextValueType", contextValueType.getName());
        return conditionMap;
    }

    private Map<Object, Object> getByContextScope(ContextScope contextScope) {
        HashMap conditionMap = Maps.newHashMap();
        conditionMap.put("type", "ContextScope");
        conditionMap.put("contextScope", contextScope.toString());
        return conditionMap;
    }

    private Map<Object, Object> getByRegex(String regex) {
        HashMap conditionMap = Maps.newHashMap();
        conditionMap.put("type", "Regex");
        conditionMap.put("regex", regex);
        return conditionMap;
    }

    private Map<Object, Object> getByContainsValue(String value) {
        HashMap conditionMap = Maps.newHashMap();
        conditionMap.put("type", "Contains");
        conditionMap.put("value", value);
        return conditionMap;
    }

    public static Map<Object, Object> nearest(Map<Object, Object> origin, String currentNode, Integer number, Boolean upstreamOnly) {
        HashMap conditionMap = Maps.newHashMap();
        conditionMap.put("type", "Nearest");
        conditionMap.put("origin", origin);
        conditionMap.put("currentNode", currentNode);
        conditionMap.put("number", number);
        conditionMap.put("upstreamOnly", upstreamOnly);
        return conditionMap;
    }

    public static Map<Object, Object> not(Map<Object, Object> origin) {
        HashMap conditionMap = Maps.newHashMap();
        conditionMap.put("type", "Not");
        conditionMap.put("origin", origin);
        return conditionMap;
    }

    public static Map<Object, Object> and(Map<Object, Object> left, Map<Object, Object> right) {
        HashMap conditionMap = Maps.newHashMap();
        conditionMap.put("type", "And");
        conditionMap.put("left", left);
        conditionMap.put("right", right);
        return conditionMap;
    }

    public static Map<Object, Object> or(Map<Object, Object> left, Map<Object, Object> right) {
        HashMap conditionMap = Maps.newHashMap();
        conditionMap.put("type", "Or");
        conditionMap.put("left", left);
        conditionMap.put("right", right);
        return conditionMap;
    }
}

