/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cli.application.utils;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class SchedulerManager {
    private static ExecutorService fixedThreadPool;
    private static ThreadPoolExecutor cachedThreadPool;
    private static int THREAD_NUM;
    private static String THREAD_NAME;
    private static Boolean IS_DEAMON;

    public static ThreadFactory threadFactory(final String threadName, final Boolean isDaemon) {
        return new ThreadFactory(){
            AtomicInteger num = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setDaemon(isDaemon);
                t.setName(threadName + this.num.incrementAndGet());
                return t;
            }
        };
    }

    public static ThreadPoolExecutor newCachedThreadPool(int threadNum, String threadName, Boolean isDaemon) {
        ThreadPoolExecutor threadPool = new ThreadPoolExecutor(threadNum, threadNum, 120L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(10 * threadNum), SchedulerManager.threadFactory(threadName, isDaemon));
        threadPool.allowCoreThreadTimeOut(true);
        return threadPool;
    }

    public static ExecutorService newFixedThreadPool(int threadNum, String threadName, Boolean isDaemon) {
        return Executors.newFixedThreadPool(threadNum, SchedulerManager.threadFactory(threadName, isDaemon));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ThreadPoolExecutor getCachedThreadPoolExecutor() {
        if (cachedThreadPool != null) return cachedThreadPool;
        Class<SchedulerManager> clazz = SchedulerManager.class;
        synchronized (SchedulerManager.class) {
            if (cachedThreadPool != null) return cachedThreadPool;
            cachedThreadPool = SchedulerManager.newCachedThreadPool(THREAD_NUM, THREAD_NAME, IS_DEAMON);
            // ** MonitorExit[var0] (shouldn't be in output)
            return cachedThreadPool;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExecutorService getFixedThreadPool() {
        if (fixedThreadPool != null) return fixedThreadPool;
        Class<SchedulerManager> clazz = SchedulerManager.class;
        synchronized (SchedulerManager.class) {
            if (fixedThreadPool != null) return fixedThreadPool;
            fixedThreadPool = SchedulerManager.newFixedThreadPool(THREAD_NUM, THREAD_NAME, IS_DEAMON);
            // ** MonitorExit[var0] (shouldn't be in output)
            return fixedThreadPool;
        }
    }

    public static void shutDown() {
        if (fixedThreadPool != null) {
            fixedThreadPool.shutdownNow();
        }
        if (cachedThreadPool != null) {
            cachedThreadPool.shutdownNow();
        }
    }

    static {
        THREAD_NUM = 5;
        THREAD_NAME = "LinkisCli-Scheduler";
        IS_DEAMON = false;
    }
}

