/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconn.acessible.executor.service;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.linkis.common.conf.TimeType;
import org.apache.linkis.common.listener.Event;
import org.apache.linkis.common.listener.EventListener;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.engineconn.acessible.executor.conf.AccessibleExecutorConfiguration$;
import org.apache.linkis.engineconn.acessible.executor.info.NodeHealthyInfoManager;
import org.apache.linkis.engineconn.acessible.executor.info.NodeHeartbeatMsgManager;
import org.apache.linkis.engineconn.acessible.executor.info.NodeOverLoadInfoManager;
import org.apache.linkis.engineconn.acessible.executor.listener.NodeHealthyListener;
import org.apache.linkis.engineconn.acessible.executor.listener.event.NodeHealthyUpdateEvent;
import org.apache.linkis.engineconn.acessible.executor.service.ExecutorHeartbeatService;
import org.apache.linkis.engineconn.acessible.executor.service.ExecutorHeartbeatServiceHolder$;
import org.apache.linkis.engineconn.core.EngineConnObject$;
import org.apache.linkis.engineconn.core.executor.ExecutorManager$;
import org.apache.linkis.engineconn.executor.entity.Executor;
import org.apache.linkis.engineconn.executor.entity.ResourceExecutor;
import org.apache.linkis.engineconn.executor.entity.SensibleExecutor;
import org.apache.linkis.engineconn.executor.listener.EngineConnAsyncListenerBus;
import org.apache.linkis.engineconn.executor.listener.ExecutorListenerBusContext$;
import org.apache.linkis.engineconn.executor.listener.event.EngineConnAsyncEvent;
import org.apache.linkis.engineconn.executor.service.ManagerService$;
import org.apache.linkis.manager.common.entity.enumeration.NodeHealthy;
import org.apache.linkis.manager.common.entity.enumeration.NodeStatus;
import org.apache.linkis.manager.common.entity.metrics.NodeHealthyInfo;
import org.apache.linkis.manager.common.protocol.node.NodeHealthyRequest;
import org.apache.linkis.manager.common.protocol.node.NodeHeartbeatMsg;
import org.apache.linkis.manager.common.protocol.node.NodeHeartbeatRequest;
import org.apache.linkis.rpc.Sender$;
import org.apache.linkis.rpc.message.annotation.Receiver;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@Service
@ScalaSignature(bytes="\u0006\u0001\u0005\rh\u0001\u0002\r\u001a\u0001!BQ!\u0011\u0001\u0005\u0002\tC\u0011\u0002\u0012\u0001A\u0002\u0003\u0007I\u0011B#\t\u00131\u0003\u0001\u0019!a\u0001\n\u0013i\u0005\"C*\u0001\u0001\u0004\u0005\t\u0015)\u0003G\u0011%\t\u0007\u00011AA\u0002\u0013%!\rC\u0005g\u0001\u0001\u0007\t\u0019!C\u0005O\"I\u0011\u000e\u0001a\u0001\u0002\u0003\u0006Ka\u0019\u0005\nW\u0002\u0001\r\u00111A\u0005\n1D\u0011\u0002\u001d\u0001A\u0002\u0003\u0007I\u0011B9\t\u0013M\u0004\u0001\u0019!A!B\u0013i\u0007bB<\u0001\u0005\u0004%I\u0001\u001f\u0005\u0007\u007f\u0002\u0001\u000b\u0011B=\t\u0013\u0005\u0005\u0001A1A\u0005\n\u0005\r\u0001\u0002CA\u000b\u0001\u0001\u0006I!!\u0002\t\u000f\u0005]\u0001\u0001\"\u0003\u0002\u001a!9\u00111\u0006\u0001\u0005B\u00055\u0002\"CA\u001f\u0001E\u0005I\u0011AA \u0011\u001d\t\u0019\u0006\u0001C!\u0003+Bq!a#\u0001\t\u0003\ti\tC\u0004\u0002\u001c\u0002!\t%!(\t\u000f\u0005=\u0006\u0001\"\u0011\u00022\"I\u0011Q\u0017\u0001\u0012\u0002\u0013\u0005\u0011q\b\u0005\b\u0003o\u0003A\u0011IA]\u0005}!UMZ1vYR,\u00050Z2vi>\u0014\b*Z1si\n,\u0017\r^*feZL7-\u001a\u0006\u00035m\tqa]3sm&\u001cWM\u0003\u0002\u001d;\u0005AQ\r_3dkR|'O\u0003\u0002\u001f?\u0005I\u0011mY3tg&\u0014G.\u001a\u0006\u0003A\u0005\n!\"\u001a8hS:,7m\u001c8o\u0015\t\u00113%\u0001\u0004mS:\\\u0017n\u001d\u0006\u0003I\u0015\na!\u00199bG\",'\"\u0001\u0014\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001IsfM\u001d\u0011\u0005)jS\"A\u0016\u000b\u00031\nQa]2bY\u0006L!AL\u0016\u0003\r\u0005s\u0017PU3g!\t\u0001\u0014'D\u0001\u001a\u0013\t\u0011\u0014D\u0001\rFq\u0016\u001cW\u000f^8s\u0011\u0016\f'\u000f\u001e2fCR\u001cVM\u001d<jG\u0016\u0004\"\u0001N\u001c\u000e\u0003UR!AN\u000e\u0002\u00111L7\u000f^3oKJL!\u0001O\u001b\u0003'9{G-\u001a%fC2$\b.\u001f'jgR,g.\u001a:\u0011\u0005izT\"A\u001e\u000b\u0005qj\u0014!B;uS2\u001c(B\u0001 \"\u0003\u0019\u0019w.\\7p]&\u0011\u0001i\u000f\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\t1\t\u0005\u00021\u0001\u00051bn\u001c3f\u0011\u0016\fG\u000e\u001e5z\u0013:4w.T1oC\u001e,'/F\u0001G!\t9%*D\u0001I\u0015\tI5$\u0001\u0003j]\u001a|\u0017BA&I\u0005Yqu\u000eZ3IK\u0006dG\u000f[=J]\u001a|W*\u00198bO\u0016\u0014\u0018A\u00078pI\u0016DU-\u00197uQfLeNZ8NC:\fw-\u001a:`I\u0015\fHC\u0001(R!\tQs*\u0003\u0002QW\t!QK\\5u\u0011\u001d\u00116!!AA\u0002\u0019\u000b1\u0001\u001f\u00132\u0003]qw\u000eZ3IK\u0006dG\u000f[=J]\u001a|W*\u00198bO\u0016\u0014\b\u0005\u000b\u0002\u0005+B\u0011akX\u0007\u0002/*\u0011\u0001,W\u0001\u000bC:tw\u000e^1uS>t'B\u0001.\\\u0003\u001d1\u0017m\u0019;pefT!\u0001X/\u0002\u000b\t,\u0017M\\:\u000b\u0005y+\u0013aD:qe&twM\u001a:b[\u0016<xN]6\n\u0005\u0001<&!C!vi><\u0018N]3e\u0003]qw\u000eZ3Pm\u0016\u0014Hj\\1e\u0013:4w.T1oC\u001e,'/F\u0001d!\t9E-\u0003\u0002f\u0011\n9bj\u001c3f\u001fZ,'\u000fT8bI&sgm\\'b]\u0006<WM]\u0001\u001c]>$Wm\u0014<fe2{\u0017\rZ%oM>l\u0015M\\1hKJ|F%Z9\u0015\u00059C\u0007b\u0002*\u0007\u0003\u0003\u0005\raY\u0001\u0019]>$Wm\u0014<fe2{\u0017\rZ%oM>l\u0015M\\1hKJ\u0004\u0003FA\u0004V\u0003]qw\u000eZ3IK\u0006\u0014HOY3bi6\u001bx-T1oC\u001e,'/F\u0001n!\t9e.\u0003\u0002p\u0011\n9bj\u001c3f\u0011\u0016\f'\u000f\u001e2fCRl5oZ'b]\u0006<WM]\u0001\u001c]>$W\rS3beR\u0014W-\u0019;Ng\u001el\u0015M\\1hKJ|F%Z9\u0015\u00059\u0013\bb\u0002*\n\u0003\u0003\u0005\r!\\\u0001\u0019]>$W\rS3beR\u0014W-\u0019;Ng\u001el\u0015M\\1hKJ\u0004\u0003\u0006\u0002\u0006VkZ\f\u0001B]3rk&\u0014X\rZ\r\u0002\u0001\u00059\u0012m]=oG2K7\u000f^3oKJ\u0014Uo]\"p]R,\u0007\u0010^\u000b\u0002sB\u0011!0`\u0007\u0002w*\u0011a\u0007 \u0006\u00039}I!A`>\u00035\u0015sw-\u001b8f\u0007>tg.Q:z]\u000ed\u0015n\u001d;f]\u0016\u0014()^:\u00021\u0005\u001c\u0018P\\2MSN$XM\\3s\u0005V\u001c8i\u001c8uKb$\b%A\u0006iK\u0006dG\u000f[=M_\u000e\\WCAA\u0003!\u0011\t9!!\u0005\u000e\u0005\u0005%!\u0002BA\u0006\u0003\u001b\tA\u0001\\1oO*\u0011\u0011qB\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0014\u0005%!AB(cU\u0016\u001cG/\u0001\u0007iK\u0006dG\u000f[=M_\u000e\\\u0007%\u0001\u0003j]&$H#\u0001()\u0007=\ti\u0002\u0005\u0003\u0002 \u0005\u001dRBAA\u0011\u0015\rA\u00161\u0005\u0006\u0003\u0003K\tQA[1wCbLA!!\u000b\u0002\"\ti\u0001k\\:u\u0007>t7\u000f\u001e:vGR\f!C]3q_J$\b*Z1si\n+\u0017\r^'tOR\u0019a*a\f\t\u0011q\u0001\u0002\u0013!a\u0001\u0003c\u0001B!a\r\u0002:5\u0011\u0011Q\u0007\u0006\u0004\u0003oa\u0018AB3oi&$\u00180\u0003\u0003\u0002<\u0005U\"\u0001C#yK\u000e,Ho\u001c:\u00029I,\u0007o\u001c:u\u0011\u0016\f'\u000f\u001e\"fCRl5o\u001a\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\t\u0016\u0005\u0003c\t\u0019e\u000b\u0002\u0002FA!\u0011qIA(\u001b\t\tIE\u0003\u0003\u0002L\u00055\u0013!C;oG\",7m[3e\u0015\tA6&\u0003\u0003\u0002R\u0005%#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006AB-Z1m\u001d>$W\rS3beR\u0014W-\u0019;SKF,Xm\u001d;\u0015\t\u0005]\u0013Q\u000e\t\u0005\u00033\nI'\u0004\u0002\u0002\\)!\u0011QLA0\u0003\u0011qw\u000eZ3\u000b\t\u0005\u0005\u00141M\u0001\taJ|Go\\2pY*\u0019a(!\u001a\u000b\u0007\u0005\u001d\u0014%A\u0004nC:\fw-\u001a:\n\t\u0005-\u00141\f\u0002\u0011\u001d>$W\rS3beR\u0014W-\u0019;Ng\u001eDq!a\u001c\u0013\u0001\u0004\t\t(\u0001\u000bo_\u0012,\u0007*Z1si\n,\u0017\r\u001e*fcV,7\u000f\u001e\t\u0005\u00033\n\u0019(\u0003\u0003\u0002v\u0005m#\u0001\u0006(pI\u0016DU-\u0019:uE\u0016\fGOU3rk\u0016\u001cH\u000fK\u0002\u0013\u0003s\u0002B!a\u001f\u0002\b6\u0011\u0011Q\u0010\u0006\u00041\u0006}$\u0002BAA\u0003\u0007\u000bq!\\3tg\u0006<WMC\u0002\u0002\u0006\u0006\n1A\u001d9d\u0013\u0011\tI)! \u0003\u0011I+7-Z5wKJ\fa\u0003Z3bY:{G-\u001a%fC2$\b.\u001f*fcV,7\u000f\u001e\u000b\u0004\u001d\u0006=\u0005bBAI'\u0001\u0007\u00111S\u0001\u0013]>$W\rS3bYRD\u0017PU3rk\u0016\u001cH\u000f\u0005\u0003\u0002Z\u0005U\u0015\u0002BAL\u00037\u0012!CT8eK\"+\u0017\r\u001c;isJ+\u0017/^3ti\"\u001a1#!\u001f\u0002'=tgj\u001c3f\u0011\u0016\fG\u000e\u001e5z+B$\u0017\r^3\u0015\u00079\u000by\nC\u0004\u0002\"R\u0001\r!a)\u0002-9|G-\u001a%fC2$\b._+qI\u0006$X-\u0012<f]R\u0004B!!*\u0002,6\u0011\u0011q\u0015\u0006\u0004\u0003S+\u0014!B3wK:$\u0018\u0002BAW\u0003O\u0013aCT8eK\"+\u0017\r\u001c;isV\u0003H-\u0019;f\u000bZ,g\u000e^\u0001\u0015O\u0016tWM]1uK\"+\u0017M\u001d;CK\u0006$Xj]4\u0015\t\u0005]\u00131\u0017\u0005\t9U\u0001\n\u00111\u0001\u00022\u0005qr-\u001a8fe\u0006$X\rS3beR\u0014U-\u0019;Ng\u001e$C-\u001a4bk2$H%M\u0001\u0011g\u0016$8+\u001a7g+:DW-\u00197uQf$2ATA^\u0011\u001d\til\u0006a\u0001\u0003\u007f\u000baA]3bg>t\u0007\u0003BAa\u0003\u001ftA!a1\u0002LB\u0019\u0011QY\u0016\u000e\u0005\u0005\u001d'bAAeO\u00051AH]8pizJ1!!4,\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011[Aj\u0005\u0019\u0019FO]5oO*\u0019\u0011QZ\u0016)\u0007\u0001\t9\u000e\u0005\u0003\u0002Z\u0006}WBAAn\u0015\r\ti.X\u0001\u000bgR,'/Z8usB,\u0017\u0002BAq\u00037\u0014qaU3sm&\u001cW\r")
public class DefaultExecutorHeartbeatService
implements ExecutorHeartbeatService,
NodeHealthyListener,
Logging {
    @Autowired
    private NodeHealthyInfoManager nodeHealthyInfoManager;
    @Autowired
    private NodeOverLoadInfoManager nodeOverLoadInfoManager;
    @Autowired(required=false)
    private NodeHeartbeatMsgManager nodeHeartbeatMsgManager;
    private final EngineConnAsyncListenerBus asyncListenerBusContext;
    private final Object healthyLock;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    @Override
    public void onEvent(EngineConnAsyncEvent event) {
        NodeHealthyListener.onEvent$(this, event);
    }

    @Override
    public void onEventError(Event event, Throwable t) {
        NodeHealthyListener.onEventError$(this, event, t);
    }

    private Logger logger$lzycompute() {
        DefaultExecutorHeartbeatService defaultExecutorHeartbeatService = this;
        synchronized (defaultExecutorHeartbeatService) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private NodeHealthyInfoManager nodeHealthyInfoManager() {
        return this.nodeHealthyInfoManager;
    }

    private void nodeHealthyInfoManager_$eq(NodeHealthyInfoManager x$1) {
        this.nodeHealthyInfoManager = x$1;
    }

    private NodeOverLoadInfoManager nodeOverLoadInfoManager() {
        return this.nodeOverLoadInfoManager;
    }

    private void nodeOverLoadInfoManager_$eq(NodeOverLoadInfoManager x$1) {
        this.nodeOverLoadInfoManager = x$1;
    }

    private NodeHeartbeatMsgManager nodeHeartbeatMsgManager() {
        return this.nodeHeartbeatMsgManager;
    }

    private void nodeHeartbeatMsgManager_$eq(NodeHeartbeatMsgManager x$1) {
        this.nodeHeartbeatMsgManager = x$1;
    }

    private EngineConnAsyncListenerBus asyncListenerBusContext() {
        return this.asyncListenerBusContext;
    }

    private Object healthyLock() {
        return this.healthyLock;
    }

    @PostConstruct
    private void init() {
        this.asyncListenerBusContext().addListener((EventListener)this);
        long heartbeatTime = ((TimeType)AccessibleExecutorConfiguration$.MODULE$.ENGINECONN_HEARTBEAT_TIME().getValue()).toLong();
        Utils$.MODULE$.defaultScheduler().scheduleAtFixedRate(new Runnable(this){
            private final /* synthetic */ DefaultExecutorHeartbeatService $outer;

            public void run() {
                Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    if (EngineConnObject$.MODULE$.isReady()) {
                        Executor executor = ExecutorManager$.MODULE$.getInstance().getReportExecutor();
                        $this.$outer.reportHeartBeatMsg(executor);
                        return;
                    }
                }, this.$outer.logger());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.linkis.engineconn.acessible.executor.service.DefaultExecutorHeartbeatService$$anon$1 )}, serializedLambda);
            }
        }, 180000L, heartbeatTime, TimeUnit.MILLISECONDS);
        ExecutorHeartbeatServiceHolder$.MODULE$.registerHeartBeatService(this);
    }

    @Override
    public void reportHeartBeatMsg(Executor executor) {
        ManagerService$.MODULE$.getManagerService().heartbeatReport(this.generateHeartBeatMsg(executor));
    }

    public Executor reportHeartBeatMsg$default$1() {
        return null;
    }

    @Override
    @Receiver
    public NodeHeartbeatMsg dealNodeHeartbeatRequest(NodeHeartbeatRequest nodeHeartbeatRequest) {
        return this.generateHeartBeatMsg(null);
    }

    @Receiver
    public void dealNodeHealthyRequest(NodeHealthyRequest nodeHealthyRequest) {
        Object object = this.healthyLock();
        synchronized (object) {
            NodeHealthy toHealthy = nodeHealthyRequest.getNodeHealthy();
            NodeHealthyInfo healthyInfo = this.nodeHealthyInfoManager().getNodeHealthyInfo();
            this.logger().info(new StringBuilder(28).append("engine nodeHealthy from ").append(healthyInfo.getNodeHealthy()).append(" to ").append(toHealthy).toString());
            this.nodeHealthyInfoManager().setByManager(true);
            this.nodeHealthyInfoManager().setNodeHealthy(toHealthy);
        }
    }

    @Override
    public void onNodeHealthyUpdate(NodeHealthyUpdateEvent nodeHealthyUpdateEvent) {
        this.logger().warn("node healthy update, tiger heartbeatReport");
        this.reportHeartBeatMsg(this.reportHeartBeatMsg$default$1());
    }

    @Override
    public NodeHeartbeatMsg generateHeartBeatMsg(Executor executor) {
        Executor realExecutor = executor == null ? (EngineConnObject$.MODULE$.isReady() ? ExecutorManager$.MODULE$.getInstance().getReportExecutor() : null) : executor;
        NodeHeartbeatMsg nodeHeartbeatMsg = new NodeHeartbeatMsg();
        nodeHeartbeatMsg.setServiceInstance(Sender$.MODULE$.getThisServiceInstance());
        if (realExecutor == null) {
            nodeHeartbeatMsg.setStatus(NodeStatus.Starting);
            return nodeHeartbeatMsg;
        }
        nodeHeartbeatMsg.setOverLoadInfo(this.nodeOverLoadInfoManager().getNodeOverLoadInfo());
        nodeHeartbeatMsg.setHealthyInfo(this.nodeHealthyInfoManager().getNodeHealthyInfo());
        Executor executor2 = realExecutor;
        if (executor2 instanceof SensibleExecutor) {
            SensibleExecutor sensibleExecutor = (SensibleExecutor)executor2;
            nodeHeartbeatMsg.setStatus(sensibleExecutor.getStatus());
        }
        Executor executor3 = realExecutor;
        if (executor3 instanceof ResourceExecutor) {
            ResourceExecutor resourceExecutor = (ResourceExecutor)executor3;
            nodeHeartbeatMsg.setNodeResource(resourceExecutor.getCurrentNodeResource());
        }
        Object object = this.nodeHeartbeatMsgManager() != null ? nodeHeartbeatMsg.setHeartBeatMsg(this.nodeHeartbeatMsgManager().getHeartBeatMsg(realExecutor)) : BoxedUnit.UNIT;
        return nodeHeartbeatMsg;
    }

    public Executor generateHeartBeatMsg$default$1() {
        return null;
    }

    @Override
    public void setSelfUnhealthy(String reason) {
        Object object = this.healthyLock();
        synchronized (object) {
            this.logger().info(new StringBuilder(53).append("Set self to unhealthy to automatically exit, reason: ").append(reason).toString());
            if (EngineConnObject$.MODULE$.isReady()) {
                NodeHealthyInfo nodeHealthyInfo = this.nodeHealthyInfoManager().getNodeHealthyInfo();
                NodeHealthy nodeHealthy = nodeHealthyInfo.getNodeHealthy();
                NodeHealthy nodeHealthy2 = NodeHealthy.UnHealthy;
                if (nodeHealthy == null ? nodeHealthy2 != null : !nodeHealthy.equals(nodeHealthy2)) {
                    this.nodeHealthyInfoManager().setNodeHealthy(NodeHealthy.UnHealthy);
                    this.nodeHealthyInfoManager().setByManager(true);
                }
            }
        }
    }

    public DefaultExecutorHeartbeatService() {
        NodeHealthyListener.$init$(this);
        Logging.$init$((Logging)this);
        this.asyncListenerBusContext = ExecutorListenerBusContext$.MODULE$.getExecutorListenerBusContext().getEngineConnAsyncListenerBus();
        this.healthyLock = new Object();
    }
}

