/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.configuration.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import org.apache.linkis.configuration.util.ConfigurationConfiguration;
import org.apache.linkis.server.BDPJettyServerHelper;

public class CommonUtils {
    public static boolean ipCheck(String str) {
        if (str != null && !str.isEmpty()) {
            String pattern = ConfigurationConfiguration.IPCHECK;
            return str.matches(pattern);
        }
        return false;
    }

    public static String ruleMap2String(String startTime, String endTime, String crossQueue, String priorityCluster, String targetCPUThreshold, String targetMemoryThreshold, String targetCPUPercentageThreshold, String targetMemoryPercentageThreshold, String originCPUPercentageThreshold, String originMemoryPercentageThreshold) throws JsonProcessingException {
        HashMap<String, String> timeRuleMap = new HashMap<String, String>();
        HashMap<String, String> queueRuleMap = new HashMap<String, String>();
        HashMap<String, String> targetClusterRuleMap = new HashMap<String, String>();
        HashMap<String, String> originClusterRuleMap = new HashMap<String, String>();
        HashMap<String, String> priorityClusterRuleMap = new HashMap<String, String>();
        HashMap<String, HashMap<String, String>> ruleMap = new HashMap<String, HashMap<String, String>>();
        timeRuleMap.put("startTime", startTime);
        timeRuleMap.put("endTime", endTime);
        queueRuleMap.put("crossQueue", crossQueue);
        targetClusterRuleMap.put("targetCPUThreshold", targetCPUThreshold);
        targetClusterRuleMap.put("targetMemoryThreshold", targetMemoryThreshold);
        targetClusterRuleMap.put("targetCPUPercentageThreshold", targetCPUPercentageThreshold);
        targetClusterRuleMap.put("targetMemoryPercentageThreshold", targetMemoryPercentageThreshold);
        originClusterRuleMap.put("originCPUPercentageThreshold", originCPUPercentageThreshold);
        originClusterRuleMap.put("originMemoryPercentageThreshold", originMemoryPercentageThreshold);
        priorityClusterRuleMap.put("priorityCluster", priorityCluster);
        ruleMap.put("timeRule", timeRuleMap);
        ruleMap.put("queueRule", queueRuleMap);
        ruleMap.put("targetClusterRule", targetClusterRuleMap);
        ruleMap.put("originClusterRule", originClusterRuleMap);
        ruleMap.put("priorityClusterRule", priorityClusterRuleMap);
        ObjectMapper map2Json = BDPJettyServerHelper.jacksonJson();
        String rules = map2Json.writeValueAsString(ruleMap);
        return rules;
    }

    public static String concatQueue(String crossQueue) {
        return String.format("\"crossQueue\":\"%s\"", crossQueue);
    }
}

