/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleColumnBetween;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.DynamicValue;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterDoubleColumnBetweenDynamicValue
extends FilterDoubleColumnBetween {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(FilterDoubleColumnBetweenDynamicValue.class);
    protected final DynamicValue leftDynamicValue;
    protected final DynamicValue rightDynamicValue;
    protected transient boolean initialized;
    protected transient boolean isLeftOrRightNull;

    public FilterDoubleColumnBetweenDynamicValue(int colNum, DynamicValue leftValue, DynamicValue rightValue) {
        super(colNum, 0.0, 0.0);
        this.leftDynamicValue = leftValue;
        this.rightDynamicValue = rightValue;
    }

    public FilterDoubleColumnBetweenDynamicValue() {
        this.leftDynamicValue = null;
        this.rightDynamicValue = null;
    }

    @Override
    public void transientInit() throws HiveException {
        super.transientInit();
        this.initialized = false;
        this.isLeftOrRightNull = false;
    }

    public DynamicValue getLeftDynamicValue() {
        return this.leftDynamicValue;
    }

    public DynamicValue getRightDynamicValue() {
        return this.rightDynamicValue;
    }

    @Override
    public void init(Configuration conf) {
        super.init(conf);
        this.leftDynamicValue.setConf(conf);
        this.rightDynamicValue.setConf(conf);
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (!this.initialized) {
            Object lVal = this.leftDynamicValue.getValue();
            Object rVal = this.rightDynamicValue.getValue();
            if (lVal == null || rVal == null) {
                this.isLeftOrRightNull = true;
            } else {
                double min = PrimitiveObjectInspectorUtils.getDouble(lVal, this.leftDynamicValue.getObjectInspector());
                this.setLeftValue(min);
                double max = PrimitiveObjectInspectorUtils.getDouble(rVal, this.rightDynamicValue.getObjectInspector());
                this.setRightValue(max);
            }
            this.initialized = true;
        }
        if (this.isLeftOrRightNull) {
            batch.size = 0;
        }
        super.evaluate(batch);
    }
}

