/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.orchestrator.computation.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.linkis.orchestrator.plans.physical.ExecTask;

public class TaskTreeUtil {
    public static <T> List<T> getAllTask(List<Object> list, Class<T> classT) throws IllegalArgumentException {
        if (null == classT) {
            throw new IllegalArgumentException("classT cannot be null.");
        }
        ArrayList<Object> rsList = new ArrayList<Object>();
        for (Object o : list) {
            if (!classT.isInstance(o)) continue;
            rsList.add(o);
        }
        return rsList;
    }

    public static <T> List<T> getAllTaskRecursive(ExecTask root, Class<T> classT) throws IllegalArgumentException {
        if (null == root || null == classT) {
            throw new IllegalArgumentException("classT cannot be null.");
        }
        ArrayList rsList = new ArrayList();
        Function<Object, Integer> visitFunc = o -> {
            if (classT.isInstance(o)) {
                rsList.add(classT.cast(o));
            }
            return 0;
        };
        TaskTreeUtil.traverseTask(root, visitFunc);
        return rsList;
    }

    private static void traverseTask(ExecTask root, Function<Object, Integer> visitFunc) {
        if (null != root) {
            visitFunc.apply(root);
            if (null != root.getChildren()) {
                for (ExecTask node : (ExecTask[])root.getChildren()) {
                    TaskTreeUtil.traverseTask(node, visitFunc);
                }
            }
        }
    }
}

