/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.engineplugin.shell.executor;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.listener.Event;
import org.apache.linkis.common.log.LogUtils$;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.engineconn.acessible.executor.listener.event.TaskLogUpdateEvent;
import org.apache.linkis.engineconn.computation.executor.conf.ComputationExecutorConf$;
import org.apache.linkis.engineconn.computation.executor.execute.ConcurrentComputationExecutor;
import org.apache.linkis.engineconn.computation.executor.execute.ConcurrentComputationExecutor$;
import org.apache.linkis.engineconn.computation.executor.execute.EngineExecutionContext;
import org.apache.linkis.engineconn.core.EngineConnObject$;
import org.apache.linkis.engineconn.executor.listener.ExecutorListenerBusContext;
import org.apache.linkis.engineconn.executor.listener.ExecutorListenerBusContext$;
import org.apache.linkis.governance.common.constant.ec.ECConstants$;
import org.apache.linkis.governance.common.utils.GovernanceUtils$;
import org.apache.linkis.governance.common.utils.JobUtils$;
import org.apache.linkis.manager.common.entity.resource.CommonNodeResource;
import org.apache.linkis.manager.common.entity.resource.NodeResource;
import org.apache.linkis.manager.common.entity.resource.Resource;
import org.apache.linkis.manager.engineplugin.common.util.NodeResourceUtils$;
import org.apache.linkis.manager.engineplugin.shell.common.ShellEngineConnPluginConst$;
import org.apache.linkis.manager.engineplugin.shell.conf.ShellEngineConnConf$;
import org.apache.linkis.manager.engineplugin.shell.exception.ShellCodeErrorException;
import org.apache.linkis.manager.engineplugin.shell.executor.ReaderThread;
import org.apache.linkis.manager.engineplugin.shell.executor.ShellECTaskInfo;
import org.apache.linkis.manager.engineplugin.shell.executor.YarnAppIdExtractor;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.protocol.engine.JobProgressInfo;
import org.apache.linkis.rpc.Sender$;
import org.apache.linkis.scheduler.executer.ErrorExecuteResponse;
import org.apache.linkis.scheduler.executer.ExecuteResponse;
import org.apache.linkis.scheduler.executer.SuccessExecuteResponse;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.ExecutionContextExecutorService;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t%a\u0001\u0002\u0010 \u00019B\u0001B\u0011\u0001\u0003\u0002\u0003\u0006Ia\u0011\u0005\u0006\u0013\u0002!\tA\u0013\u0005\n\u001d\u0002\u0001\r\u00111A\u0005\n=C\u0011b\u0015\u0001A\u0002\u0003\u0007I\u0011\u0002+\t\u0013i\u0003\u0001\u0019!A!B\u0013\u0001\u0006bB.\u0001\u0005\u0004%I\u0001\u0018\u0005\u0007e\u0002\u0001\u000b\u0011B/\t\u000fi\u0004!\u0019!C\u0005w\"9\u00111\u0004\u0001!\u0002\u0013a\b\"CA\u000f\u0001\t\u0007I1BA\u0010\u0011!\ti\u0003\u0001Q\u0001\n\u0005\u0005\u0002bBA\u0018\u0001\u0011\u0005\u0013\u0011\u0007\u0005\b\u0003g\u0001A\u0011IA\u001b\u0011\u001d\t\t\u0006\u0001C!\u0003'Bq!!\u0017\u0001\t\u0013\tY\u0006C\u0004\u0002h\u0001!I!!\u001b\t\u000f\u0005M\u0004\u0001\"\u0003\u0002v!9\u0011Q\u0010\u0001\u0005B\u0005}\u0004bBAA\u0001\u0011\u0005\u00131\u0011\u0005\b\u00037\u0003A\u0011IAO\u0011\u001d\t9\u000b\u0001C!\u0003SCq!a+\u0001\t\u0003\ni\u000bC\u0004\u0002D\u0002!\t%!2\t\u000f\u0005\u001d\u0007\u0001\"\u0011\u0002J\"9\u0011q\u001b\u0001\u0005B\u0005e\u0007bBAv\u0001\u0011\u0005\u0013Q\u001e\u0005\b\u0003c\u0004A\u0011BAz\u0011\u001d\u0011)\u0001\u0001C!\u0003cAqAa\u0002\u0001\t\u0003\n\tDA\u0011TQ\u0016dG.\u00128hS:,7i\u001c8o\u0007>t7-\u001e:sK:$X\t_3dkR|'O\u0003\u0002!C\u0005AQ\r_3dkR|'O\u0003\u0002#G\u0005)1\u000f[3mY*\u0011A%J\u0001\rK:<\u0017N\\3qYV<\u0017N\u001c\u0006\u0003M\u001d\nq!\\1oC\u001e,'O\u0003\u0002)S\u00051A.\u001b8lSNT!AK\u0016\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0013aA8sO\u000e\u00011c\u0001\u00010uA\u0011\u0001\u0007O\u0007\u0002c)\u0011!gM\u0001\bKb,7-\u001e;f\u0015\t\u0001CG\u0003\u00026m\u0005Y1m\\7qkR\fG/[8o\u0015\t9t%\u0001\u0006f]\u001eLg.Z2p]:L!!O\u0019\u0003;\r{gnY;se\u0016tGoQ8naV$\u0018\r^5p]\u0016CXmY;u_J\u0004\"a\u000f!\u000e\u0003qR!!\u0010 \u0002\u000bU$\u0018\u000e\\:\u000b\u0005}:\u0013AB2p[6|g.\u0003\u0002By\t9Aj\\4hS:<\u0017AA5e!\t!u)D\u0001F\u0015\u00051\u0015!B:dC2\f\u0017B\u0001%F\u0005\rIe\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005-k\u0005C\u0001'\u0001\u001b\u0005y\u0002\"\u0002\"\u0003\u0001\u0004\u0019\u0015AF3oO&tW-\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0016\u0003A\u0003\"\u0001M)\n\u0005I\u000b$AF#oO&tW-\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u00025\u0015tw-\u001b8f\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR|F%Z9\u0015\u0005UC\u0006C\u0001#W\u0013\t9VI\u0001\u0003V]&$\bbB-\u0005\u0003\u0003\u0005\r\u0001U\u0001\u0004q\u0012\n\u0014aF3oO&tW-\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;!\u00039)\u00070Z2vi>\u0014H*\u00192fYN,\u0012!\u0018\t\u0004=\u000e,W\"A0\u000b\u0005\u0001\f\u0017\u0001B;uS2T\u0011AY\u0001\u0005U\u00064\u0018-\u0003\u0002e?\n!A*[:ua\t1\u0007\u000fE\u0002hY:l\u0011\u0001\u001b\u0006\u0003S*\fa!\u001a8uSRL(BA6&\u0003\u0015a\u0017MY3m\u0013\ti\u0007NA\u0003MC\n,G\u000e\u0005\u0002pa2\u0001A!C9\b\u0003\u0003\u0005\tQ!\u0001t\u0005\ryF%M\u0001\u0010Kb,7-\u001e;pe2\u000b'-\u001a7tAE\u0011Ao\u001e\t\u0003\tVL!A^#\u0003\u000f9{G\u000f[5oOB\u0011A\t_\u0005\u0003s\u0016\u00131!\u00118z\u0003Q\u0019\b.\u001a7m\u000b\u000e#\u0016m]6J]\u001a|7)Y2iKV\tA\u0010E\u0003_{~\f)\"\u0003\u0002\u007f?\n\u0019Q*\u00199\u0011\t\u0005\u0005\u0011q\u0002\b\u0005\u0003\u0007\tY\u0001E\u0002\u0002\u0006\u0015k!!a\u0002\u000b\u0007\u0005%Q&\u0001\u0004=e>|GOP\u0005\u0004\u0003\u001b)\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0012\u0005M!AB*ue&twMC\u0002\u0002\u000e\u0015\u00032\u0001TA\f\u0013\r\tIb\b\u0002\u0010'\",G\u000e\\#D)\u0006\u001c8.\u00138g_\u0006)2\u000f[3mY\u0016\u001bE+Y:l\u0013:4wnQ1dQ\u0016\u0004\u0013a\u00047pO\u0006\u001b\u0018P\\2TKJ4\u0018nY3\u0016\u0005\u0005\u0005\u0002\u0003BA\u0012\u0003Si!!!\n\u000b\u0007\u0005\u001dR)\u0001\u0006d_:\u001cWO\u001d:f]RLA!a\u000b\u0002&\tyR\t_3dkRLwN\\\"p]R,\u0007\u0010^#yK\u000e,Ho\u001c:TKJ4\u0018nY3\u0002!1|w-Q:z]\u000e\u001cVM\u001d<jG\u0016\u0004\u0013\u0001B5oSR$\u0012!V\u0001\u0012Kb,7-\u001e;f\u0007>l\u0007\u000f\\3uK2LH\u0003CA\u001c\u0003\u000f\nI%!\u0014\u0011\t\u0005e\u00121I\u0007\u0003\u0003wQA!!\u0010\u0002@\u0005AQ\r_3dkR,'OC\u0002\u0002B\u001d\n\u0011b]2iK\u0012,H.\u001a:\n\t\u0005\u0015\u00131\b\u0002\u0010\u000bb,7-\u001e;f%\u0016\u001c\bo\u001c8tK\")a*\u0004a\u0001!\"1\u00111J\u0007A\u0002}\fAaY8eK\"1\u0011qJ\u0007A\u0002}\fQbY8na2,G/\u001a3MS:,\u0017aC3yK\u000e,H/\u001a'j]\u0016$b!a\u000e\u0002V\u0005]\u0003\"\u0002(\u000f\u0001\u0004\u0001\u0006BBA&\u001d\u0001\u0007q0\u0001\njg\u0016CXmY;uKB\u000bG\u000f[#ySN$H\u0003BA/\u0003G\u00022\u0001RA0\u0013\r\t\t'\u0012\u0002\b\u0005>|G.Z1o\u0011\u0019\t)g\u0004a\u0001\u007f\u0006YQ\r_3dkR,\u0007+\u0019;i\u0003=9WM\\3sCR,'+\u001e8D_\u0012,G\u0003BA6\u0003c\u0002B\u0001RA7\u007f&\u0019\u0011qN#\u0003\u000b\u0005\u0013(/Y=\t\r\u0005-\u0003\u00031\u0001\u0000\u0003]9WM\\3sCR,'+\u001e8D_\u0012,w+\u001b;i\u0003J<7\u000f\u0006\u0004\u0002l\u0005]\u0014\u0011\u0010\u0005\u0007\u0003\u0017\n\u0002\u0019A@\t\u000f\u0005m\u0014\u00031\u0001\u0002l\u0005!\u0011M]4t\u0003\u00159W\r^%e)\u0005y\u0018aD4fiB\u0013xn\u001a:fgNLeNZ8\u0015\t\u0005\u0015\u0015q\u0013\t\u0006\t\u00065\u0014q\u0011\t\u0005\u0003\u0013\u000b\u0019*\u0004\u0002\u0002\f*!\u0011QRAH\u0003\u0019)gnZ5oK*\u0019\u0011\u0011S\u0014\u0002\u0011A\u0014x\u000e^8d_2LA!!&\u0002\f\ny!j\u001c2Qe><'/Z:t\u0013:4w\u000e\u0003\u0004\u0002\u001aN\u0001\ra`\u0001\u0007i\u0006\u001c8.\u0013#\u0002\u0011A\u0014xn\u001a:fgN$B!a(\u0002&B\u0019A)!)\n\u0007\u0005\rVIA\u0003GY>\fG\u000f\u0003\u0004\u0002\u001aR\u0001\ra`\u0001\u0014gV\u0004\bo\u001c:u\u0007\u0006dGNQ1dW2{wm\u001d\u000b\u0003\u0003;\nqC]3rk\u0016\u001cH/\u0012=qK\u000e$X\r\u001a*fg>,(oY3\u0015\t\u0005=\u0016q\u0018\t\u0005\u0003c\u000bY,\u0004\u0002\u00024*!\u0011QWA\\\u0003!\u0011Xm]8ve\u000e,'bA5\u0002:*\u0011q(J\u0005\u0005\u0003{\u000b\u0019L\u0001\u0007O_\u0012,'+Z:pkJ\u001cW\rC\u0004\u0002BZ\u0001\r!a,\u0002!\u0015D\b/Z2uK\u0012\u0014Vm]8ve\u000e,\u0017AF4fi\u000e+(O]3oi:{G-\u001a*fg>,(oY3\u0015\u0005\u0005=\u0016!E4fi\u0016CXmY;u_Jd\u0015MY3mgR\u0011\u00111\u001a\t\u0005=\u000e\fi\r\r\u0003\u0002P\u0006M\u0007\u0003B4m\u0003#\u00042a\\Aj\t)\t)\u000eGA\u0001\u0002\u0003\u0015\ta\u001d\u0002\u0004?\u0012\u001a\u0014!E:fi\u0016CXmY;u_Jd\u0015MY3mgR\u0019Q+a7\t\u000f\u0005u\u0017\u00041\u0001\u0002`\u00061A.\u00192fYN\u0004BAX2\u0002bB\"\u00111]At!\u00119G.!:\u0011\u0007=\f9\u000fB\u0006\u0002j\u0006m\u0017\u0011!A\u0001\u0006\u0003\u0019(aA0%i\u0005A1.\u001b7m)\u0006\u001c8\u000eF\u0002V\u0003_Da!!'\u001b\u0001\u0004y\u0018AB4fiBKG\rF\u0002D\u0003kDq!a>\u001c\u0001\u0004\tI0A\u0004qe>\u001cWm]:\u0011\t\u0005m(\u0011A\u0007\u0003\u0003{T1!a@b\u0003\u0011a\u0017M\\4\n\t\t\r\u0011Q \u0002\b!J|7-Z:t\u0003\u0015\u0019Gn\\:f\u0003\u001dY\u0017\u000e\u001c7BY2\u0004")
public class ShellEngineConnConcurrentExecutor
extends ConcurrentComputationExecutor {
    private final int id;
    private EngineExecutionContext engineExecutionContext;
    private final List<Label<?>> executorLabels;
    private final Map<String, ShellECTaskInfo> shellECTaskInfoCache;
    private final ExecutionContextExecutorService logAsyncService;

    private EngineExecutionContext engineExecutionContext() {
        return this.engineExecutionContext;
    }

    private void engineExecutionContext_$eq(EngineExecutionContext x$1) {
        this.engineExecutionContext = x$1;
    }

    private List<Label<?>> executorLabels() {
        return this.executorLabels;
    }

    private Map<String, ShellECTaskInfo> shellECTaskInfoCache() {
        return this.shellECTaskInfoCache;
    }

    private ExecutionContextExecutorService logAsyncService() {
        return this.logAsyncService;
    }

    public void init() {
        this.logger().info("Ready to change engine state!");
        super.init();
    }

    public ExecuteResponse executeCompletely(EngineExecutionContext engineExecutionContext, String code, String completedLine) {
        String newcode = new StringBuilder(0).append(completedLine).append(code).toString();
        this.logger().debug(new StringBuilder(11).append("newcode is ").append(newcode).toString());
        return this.executeLine(engineExecutionContext, newcode);
    }

    public ExecuteResponse executeLine(EngineExecutionContext engineExecutionContext, String code) {
        ErrorExecuteResponse errorExecuteResponse;
        block14: {
            if (engineExecutionContext != null) {
                this.engineExecutionContext_$eq(engineExecutionContext);
                this.logger().info("Shell executor reset new engineExecutionContext!");
            }
            if (engineExecutionContext.getJobId().isEmpty()) {
                return new ErrorExecuteResponse("taskID is null", null);
            }
            String taskId = (String)engineExecutionContext.getJobId().get();
            BufferedReader bufferedReader = null;
            BufferedReader errorsReader = null;
            AtomicBoolean completed = new AtomicBoolean(false);
            ReaderThread errReaderThread = null;
            ReaderThread inputReaderThread = null;
            try {
                try {
                    Object object;
                    Object object2;
                    engineExecutionContext.appendStdout(new StringBuilder(4).append(this.getId()).append(" >> ").append(code.trim()).toString());
                    String[] argsArr = engineExecutionContext.getTotalParagraph() == 1 && engineExecutionContext.getProperties() != null && engineExecutionContext.getProperties().containsKey(ShellEngineConnPluginConst$.MODULE$.RUNTIME_ARGS_KEY()) ? (String[])Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> {
                        ArrayList argsList = (ArrayList)engineExecutionContext.getProperties().get(ShellEngineConnPluginConst$.MODULE$.RUNTIME_ARGS_KEY());
                        this.logger().info(new StringBuilder(57).append("Will execute shell task with user-specified arguments: '").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(argsList.toArray((Object[])new String[argsList.size()]))).mkString("' '")).append("'").toString());
                        return (String[])argsList.toArray((Object[])new String[argsList.size()]);
                    }, (Function1 & Serializable & scala.Serializable)t -> {
                        this.logger().warn("Cannot read user-input shell arguments. Will execute shell task without them.", t);
                        return null;
                    }) : null;
                    String workingDirectory = engineExecutionContext.getTotalParagraph() == 1 && engineExecutionContext.getProperties() != null && engineExecutionContext.getProperties().containsKey(ShellEngineConnPluginConst$.MODULE$.SHELL_RUNTIME_WORKING_DIRECTORY()) ? (String)Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> {
                        String wdStr = (String)engineExecutionContext.getProperties().get(ShellEngineConnPluginConst$.MODULE$.SHELL_RUNTIME_WORKING_DIRECTORY());
                        if (this.isExecutePathExist(wdStr)) {
                            this.logger().info(new StringBuilder(65).append("Will execute shell task under user-specified working-directory: '").append(wdStr).toString());
                            return wdStr;
                        }
                        this.logger().warn(new StringBuilder(183).append("User-specified working-directory: '").append(wdStr).append("' does not exist or user does not have access permission. ").append("Will execute shell task under default working-directory. Please contact the administrator!").toString());
                        return null;
                    }, (Function1 & Serializable & scala.Serializable)t -> {
                        this.logger().warn("Cannot read user-input working-directory. Will execute shell task under default working-directory.", t);
                        return null;
                    }) : null;
                    String[] generatedCode = argsArr == null || new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])argsArr)).isEmpty() ? this.generateRunCode(code) : this.generateRunCodeWithArgs(code, argsArr);
                    ProcessBuilder processBuilder = new ProcessBuilder(generatedCode);
                    Object object3 = StringUtils.isNotBlank((CharSequence)workingDirectory) ? processBuilder.directory(new File(workingDirectory)) : BoxedUnit.UNIT;
                    Map<String, String> env = processBuilder.environment();
                    String jobTags = JobUtils$.MODULE$.getJobSourceTagsFromObjectMap(engineExecutionContext.getProperties());
                    String jobId = JobUtils$.MODULE$.getJobIdFromMap(engineExecutionContext.getProperties());
                    if (StringUtils.isNotBlank((CharSequence)jobId)) {
                        this.logger().info(new StringBuilder(16).append("set env job id ").append(jobId).append(".").toString());
                        object2 = env.put(ComputationExecutorConf$.MODULE$.JOB_ID_TO_ENV_KEY(), jobId);
                    } else {
                        object2 = BoxedUnit.UNIT;
                    }
                    if (StringUtils.isAsciiPrintable((CharSequence)jobTags)) {
                        env.put(ECConstants$.MODULE$.HIVE_OPTS(), new StringBuilder(31).append(" --hiveconf mapreduce.job.tags=").append(jobTags).toString());
                        object = env.put(ECConstants$.MODULE$.SPARK_SUBMIT_OPTS(), new StringBuilder(19).append(" -Dspark.yarn.tags=").append(jobTags).toString());
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                    processBuilder.redirectErrorStream(false);
                    YarnAppIdExtractor extractor = new YarnAppIdExtractor();
                    Process process = processBuilder.start();
                    bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    errorsReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                    this.shellECTaskInfoCache().put(taskId, new ShellECTaskInfo(taskId, process, extractor));
                    CountDownLatch counter = new CountDownLatch(2);
                    inputReaderThread = new ReaderThread(engineExecutionContext, bufferedReader, extractor, true, counter);
                    errReaderThread = new ReaderThread(engineExecutionContext, errorsReader, extractor, false, counter);
                    this.logAsyncService().execute((Runnable)inputReaderThread);
                    this.logAsyncService().execute((Runnable)errReaderThread);
                    int exitCode = process.waitFor();
                    counter.await();
                    completed.set(true);
                    if (exitCode != 0) {
                        errorExecuteResponse = new ErrorExecuteResponse(new StringBuilder(30).append("run shell failed with error:\n ").append(errReaderThread.getOutString()).toString(), (Throwable)((Object)new ShellCodeErrorException()));
                        break block14;
                    }
                    errorExecuteResponse = new SuccessExecuteResponse();
                }
                catch (Exception e) {
                    this.logger().error("Execute shell code failed, reason:", (Throwable)e);
                    errorExecuteResponse = new ErrorExecuteResponse("run shell failed", (Throwable)e);
                }
            }
            finally {
                if (errorsReader != null) {
                    inputReaderThread.onDestroy();
                }
                if (inputReaderThread != null) {
                    errReaderThread.onDestroy();
                }
                this.shellECTaskInfoCache().remove(taskId);
            }
        }
        return errorExecuteResponse;
    }

    private boolean isExecutePathExist(String executePath) {
        File etlHomeDir = new File(executePath);
        return etlHomeDir.exists() && etlHomeDir.isDirectory();
    }

    private String[] generateRunCode(String code) {
        return (String[])((Object[])new String[]{"sh", "-c", code});
    }

    private String[] generateRunCodeWithArgs(String code, String[] args) {
        return (String[])((Object[])new String[]{"sh", "-c", new StringBuilder(30).append("echo \"dummy ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).mkString(" ")).append("\" | xargs sh -c '").append(code).append("'").toString()});
    }

    public String getId() {
        return new StringBuilder(1).append(Sender$.MODULE$.getThisServiceInstance().getInstance()).append("_").append(this.id).toString();
    }

    public JobProgressInfo[] getProgressInfo(String taskID) {
        ArrayBuffer jobProgressInfo = new ArrayBuffer();
        if (this.engineExecutionContext() == null) {
            return (JobProgressInfo[])jobProgressInfo.toArray(ClassTag$.MODULE$.apply(JobProgressInfo.class));
        }
        ArrayBuffer arrayBuffer = 0.0f == this.progress(taskID) ? jobProgressInfo.$plus$eq((Object)new JobProgressInfo((String)this.engineExecutionContext().getJobId().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), 1, 1, 0, 0)) : jobProgressInfo.$plus$eq((Object)new JobProgressInfo((String)this.engineExecutionContext().getJobId().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), 1, 0, 0, 1));
        return (JobProgressInfo[])jobProgressInfo.toArray(ClassTag$.MODULE$.apply(JobProgressInfo.class));
    }

    public float progress(String taskID) {
        if (this.engineExecutionContext() != null) {
            return (float)this.engineExecutionContext().getCurrentParagraph() / (float)this.engineExecutionContext().getTotalParagraph();
        }
        return 0.0f;
    }

    public boolean supportCallBackLogs() {
        return true;
    }

    public NodeResource requestExpectedResource(NodeResource expectedResource) {
        return null;
    }

    public NodeResource getCurrentNodeResource() {
        CommonNodeResource resource = new CommonNodeResource();
        resource.setUsedResource((Resource)NodeResourceUtils$.MODULE$.applyAsLoadInstanceResource(EngineConnObject$.MODULE$.getEngineCreationContext().getOptions()));
        return resource;
    }

    public List<Label<?>> getExecutorLabels() {
        return this.executorLabels();
    }

    public void setExecutorLabels(List<Label<?>> labels) {
        if (labels != null) {
            this.executorLabels().clear();
            this.executorLabels().addAll(labels);
            return;
        }
    }

    public void killTask(String taskID) {
        ShellECTaskInfo shellECTaskInfo = this.shellECTaskInfoCache().remove(taskID);
        if (shellECTaskInfo == null) {
            return;
        }
        int pid = this.getPid(shellECTaskInfo.process());
        GovernanceUtils$.MODULE$.killProcess(String.valueOf(pid), new StringBuilder(18).append("kill task ").append(taskID).append(" process").toString(), false);
        List<String> yarnAppIds = shellECTaskInfo.yarnAppIdExtractor().getExtractedYarnAppIds();
        GovernanceUtils$.MODULE$.killYarnJobApp(yarnAppIds);
        this.logger().info(new StringBuilder(69).append("Finished kill yarn app ids in the engine of (").append(this.getId()).append("). The yarn app ids are ").append(yarnAppIds).toString());
        super.killTask(taskID);
    }

    private int getPid(Process process) {
        return BoxesRunTime.unboxToInt((Object)Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
            Class<?> clazz = Class.forName("java.lang.UNIXProcess");
            Field field = clazz.getDeclaredField("pid");
            field.setAccessible(true);
            return BoxesRunTime.unboxToInt((Object)field.get(process));
        }, (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToInteger((int)ShellEngineConnConcurrentExecutor.$anonfun$getPid$2(this, t))));
    }

    public void close() {
        ExecutorListenerBusContext lbs = ExecutorListenerBusContext$.MODULE$.getExecutorListenerBusContext();
        Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            for (ShellECTaskInfo shellECTaskInfo : this.shellECTaskInfoCache().values()) {
                Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> lbs.getEngineConnSyncListenerBus().postToAll((Event)new TaskLogUpdateEvent(shellECTaskInfo.taskId(), LogUtils$.MODULE$.generateERROR("EC exits unexpectedly and actively kills the task"))), this.logger());
                Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.killTask(shellECTaskInfo.taskId()), this.logger());
            }
            this.logAsyncService().shutdown();
        }, (Function1 & Serializable & scala.Serializable)t -> {
            ShellEngineConnConcurrentExecutor.$anonfun$close$4(this, t);
            return BoxedUnit.UNIT;
        });
        super.close();
    }

    public void killAll() {
        for (ShellECTaskInfo shellECTaskInfo : this.shellECTaskInfoCache().values()) {
            Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.killTask(shellECTaskInfo.taskId()), this.logger());
        }
        this.shellECTaskInfoCache().clear();
    }

    public static final /* synthetic */ int $anonfun$getPid$2(ShellEngineConnConcurrentExecutor $this, Throwable t) {
        $this.logger().warn("Failed to acquire pid for shell process");
        return -1;
    }

    public static final /* synthetic */ void $anonfun$close$4(ShellEngineConnConcurrentExecutor $this, Throwable t) {
        $this.logger().error("Shell ec failed to close ", t);
    }

    public ShellEngineConnConcurrentExecutor(int id) {
        this.id = id;
        super(ConcurrentComputationExecutor$.MODULE$.$lessinit$greater$default$1());
        this.executorLabels = new ArrayList();
        this.shellECTaskInfoCache = new ConcurrentHashMap<String, ShellECTaskInfo>();
        this.logAsyncService = Utils$.MODULE$.newCachedExecutionContext(ShellEngineConnConf$.MODULE$.LOG_SERVICE_MAX_THREAD_SIZE(), "ShelLogService-Thread-", Utils$.MODULE$.newCachedExecutionContext$default$3());
    }
}

