/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.rpc.utils;

import feign.RetryableException;
import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.ConnectException;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.common.ServiceInstance$;
import org.apache.linkis.rpc.BaseRPCSender;
import org.apache.linkis.rpc.Sender;
import org.apache.linkis.rpc.conf.RPCConfiguration$;
import org.apache.linkis.rpc.exception.NoInstanceExistsException;
import org.apache.linkis.rpc.sender.SpringCloudFeignConfigurationCache$;
import org.apache.linkis.rpc.sender.SpringMVCRPCSender;
import org.springframework.cloud.client.loadbalancer.RetryableStatusCodeException;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;

public final class RPCUtils$ {
    public static RPCUtils$ MODULE$;

    static {
        new RPCUtils$();
    }

    public boolean isReceiverNotExists(Throwable t) {
        Throwable throwable = t;
        if (throwable instanceof ConnectException) {
            ConnectException connectException = (ConnectException)throwable;
            return connectException.getMessage() != null && connectException.getMessage().contains("Connection refused");
        }
        if (throwable instanceof NoInstanceExistsException) {
            return true;
        }
        if (throwable instanceof UndeclaredThrowableException) {
            UndeclaredThrowableException undeclaredThrowableException = (UndeclaredThrowableException)throwable;
            Throwable throwable2 = undeclaredThrowableException.getCause();
            return throwable2 instanceof NoInstanceExistsException;
        }
        if (throwable instanceof RetryableException) {
            RetryableException retryableException = (RetryableException)throwable;
            Throwable throwable3 = retryableException.getCause();
            if (throwable3 instanceof ConnectException) {
                ConnectException connectException = (ConnectException)throwable3;
                return connectException.getMessage() != null && connectException.getMessage().contains("Connection refused");
            }
            return false;
        }
        if (throwable instanceof RuntimeException) {
            RuntimeException runtimeException = (RuntimeException)throwable;
            Throwable throwable4 = runtimeException.getCause();
            if (throwable4 instanceof RetryableStatusCodeException) {
                RetryableStatusCodeException retryableStatusCodeException = (RetryableStatusCodeException)throwable4;
                return StringUtils.isNotBlank((CharSequence)retryableStatusCodeException.getMessage()) && retryableStatusCodeException.getMessage().contains("Load balancer does not have available server for client");
            }
            return false;
        }
        return false;
    }

    public Option<String> findService(String parsedServiceId, Function1<List<String>, Option<String>> tooManyDeal) {
        List services = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(SpringCloudFeignConfigurationCache$.MODULE$.getDiscoveryClient().getServices()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)RPCUtils$.$anonfun$findService$1(parsedServiceId, x$1)))).toList();
        if (services.length() == 1) {
            return new Some(services.head());
        }
        if (services.length() > 1) {
            return (Option)tooManyDeal.apply((Object)services);
        }
        return None$.MODULE$;
    }

    public ServiceInstance getServiceInstanceFromSender(Sender sender) {
        Sender sender2 = sender;
        if (sender2 instanceof SpringMVCRPCSender) {
            SpringMVCRPCSender springMVCRPCSender = (SpringMVCRPCSender)sender2;
            return springMVCRPCSender.serviceInstance();
        }
        if (sender2 instanceof BaseRPCSender) {
            BaseRPCSender baseRPCSender = (BaseRPCSender)sender2;
            return ServiceInstance$.MODULE$.apply(baseRPCSender.getApplicationName(), null);
        }
        return null;
    }

    public boolean isPublicService(String appName) {
        if (!BoxesRunTime.unboxToBoolean((Object)RPCConfiguration$.MODULE$.ENABLE_PUBLIC_SERVICE().getValue()) || StringUtils.isBlank((CharSequence)appName)) {
            return false;
        }
        String appNameLower = appName.toLowerCase();
        if (appNameLower.startsWith(RPCConfiguration$.MODULE$.PUBLIC_SERVICE_APP_PREFIX())) {
            String serviceName = appNameLower.replaceFirst(RPCConfiguration$.MODULE$.PUBLIC_SERVICE_APP_PREFIX(), "");
            return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])RPCConfiguration$.MODULE$.PUBLIC_SERVICE_LIST())).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.equalsIgnoreCase(serviceName)));
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$findService$1(String parsedServiceId$1, String x$1) {
        return x$1.toLowerCase(Locale.getDefault()).contains(parsedServiceId$1.toLowerCase(Locale.getDefault()));
    }

    private RPCUtils$() {
        MODULE$ = this;
    }
}

