/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.graph.visitor;

import java.util.function.Consumer;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.util.graph.visitor.AbstractDependencyNodeConsumerVisitor;
import org.eclipse.aether.util.graph.visitor.Stack;

public final class PostorderDependencyNodeConsumerVisitor
extends AbstractDependencyNodeConsumerVisitor {
    public static final String NAME = "postOrder";
    private final Stack<Boolean> visits = new Stack();

    public PostorderDependencyNodeConsumerVisitor(Consumer<DependencyNode> nodeConsumer) {
        this(nodeConsumer, null);
    }

    public PostorderDependencyNodeConsumerVisitor(Consumer<DependencyNode> nodeConsumer, DependencyFilter filter) {
        super(nodeConsumer, filter);
    }

    @Override
    protected boolean doVisitEnter(DependencyNode node) {
        boolean visited = !this.setVisited(node);
        this.visits.push(visited);
        return !visited;
    }

    @Override
    protected boolean doVisitLeave(DependencyNode node) {
        Boolean visited = this.visits.pop();
        if (visited.booleanValue()) {
            return true;
        }
        if (this.acceptNode(node)) {
            this.consumeNode(node);
        }
        return true;
    }
}

