/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.secdispatcher.internal.dispatchers;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.codehaus.plexus.components.secdispatcher.CipherException;
import org.codehaus.plexus.components.secdispatcher.Dispatcher;
import org.codehaus.plexus.components.secdispatcher.DispatcherMeta;
import org.codehaus.plexus.components.secdispatcher.SecDispatcher;
import org.codehaus.plexus.components.secdispatcher.SecDispatcherException;
import org.xml.sax.InputSource;

@Singleton
@Named(value="legacy")
public class LegacyDispatcher
implements Dispatcher,
DispatcherMeta {
    public static final String NAME = "legacy";
    private static final String MASTER_MASTER_PASSWORD = "settings.security";
    private final LegacyCipher legacyCipher = new LegacyCipher();

    @Inject
    public LegacyDispatcher() {
    }

    @Override
    public boolean isHidden() {
        return true;
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public String displayName() {
        return "LEGACY (for migration purposes only; can only decrypt)";
    }

    @Override
    public Collection<DispatcherMeta.Field> fields() {
        return List.of();
    }

    @Override
    public Dispatcher.EncryptPayload encrypt(String str, Map<String, String> attributes, Map<String, String> config) throws SecDispatcherException {
        throw new SecDispatcherException("legacy dispatcher MUST not be used for encryption; is inherently insecure and broken");
    }

    @Override
    public String decrypt(String str, Map<String, String> attributes, Map<String, String> config) throws SecDispatcherException {
        String masterPassword = this.getMasterPassword();
        if (masterPassword == null) {
            throw new SecDispatcherException("Master password could not be obtained");
        }
        return this.legacyCipher.decrypt64(str, masterPassword);
    }

    @Override
    public SecDispatcher.ValidationResponse validateConfiguration(Map<String, String> config) {
        HashMap<SecDispatcher.ValidationResponse.Level, List<String>> report = new HashMap<SecDispatcher.ValidationResponse.Level, List<String>>();
        boolean valid = false;
        try {
            String mpe = this.getMasterMasterPasswordFromSettingsSecurityXml();
            if (mpe == null) {
                report.computeIfAbsent(SecDispatcher.ValidationResponse.Level.ERROR, k -> new ArrayList()).add("Legacy configuration not found or does not contains encrypted master password");
            } else {
                report.computeIfAbsent(SecDispatcher.ValidationResponse.Level.INFO, k -> new ArrayList()).add("Legacy configuration found with encrypted master password");
                String mp = this.getMasterPassword();
                if (mp == null) {
                    report.computeIfAbsent(SecDispatcher.ValidationResponse.Level.ERROR, k -> new ArrayList()).add("Legacy master password not found");
                } else {
                    report.computeIfAbsent(SecDispatcher.ValidationResponse.Level.INFO, k -> new ArrayList()).add("Legacy master password successfully decrypted");
                    valid = true;
                }
            }
        }
        catch (CipherException e) {
            report.computeIfAbsent(SecDispatcher.ValidationResponse.Level.ERROR, k -> new ArrayList()).add("Legacy master password decryption failed");
        }
        return new SecDispatcher.ValidationResponse(this.getClass().getSimpleName(), valid, report, List.of());
    }

    private String getMasterPassword() throws SecDispatcherException {
        String masterPassword = this.getMasterMasterPasswordFromSettingsSecurityXml();
        if (masterPassword == null) {
            return null;
        }
        if (masterPassword.startsWith("{") && masterPassword.endsWith("}")) {
            return this.legacyCipher.decrypt64(masterPassword.substring(1, masterPassword.length() - 1), MASTER_MASTER_PASSWORD);
        }
        return masterPassword;
    }

    private String getMasterMasterPasswordFromSettingsSecurityXml() {
        String override = System.getProperty(MASTER_MASTER_PASSWORD);
        Path xml = override != null ? Paths.get(override, new String[0]) : Paths.get(System.getProperty("user.home"), ".m2", "settings-security.xml");
        if (Files.exists(xml, new LinkOption[0])) {
            String string;
            block10: {
                InputStream is = Files.newInputStream(xml, new OpenOption[0]);
                try {
                    String result = (String)XPathFactory.newInstance().newXPath().evaluate("//master", new InputSource(is), XPathConstants.STRING);
                    if (result != null) {
                        result = result.trim();
                    }
                    string = result;
                    if (is == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                is.close();
            }
            return string;
        }
        return null;
    }

    private static final class LegacyCipher {
        private static final String STRING_ENCODING = "UTF8";
        private static final int SPICE_SIZE = 16;
        private static final int SALT_SIZE = 8;
        private static final String DIGEST_ALG = "SHA-256";
        private static final String KEY_ALG = "AES";
        private static final String CIPHER_ALG = "AES/CBC/PKCS5Padding";

        private LegacyCipher() {
        }

        private String decrypt64(String encryptedText, String password) throws CipherException {
            try {
                byte[] allEncryptedBytes = Base64.getDecoder().decode(encryptedText.getBytes());
                int totalLen = allEncryptedBytes.length;
                byte[] salt = new byte[8];
                System.arraycopy(allEncryptedBytes, 0, salt, 0, 8);
                byte padLen = allEncryptedBytes[8];
                byte[] encryptedBytes = new byte[totalLen - 8 - 1 - padLen];
                System.arraycopy(allEncryptedBytes, 9, encryptedBytes, 0, encryptedBytes.length);
                Cipher cipher = this.createCipher(password.getBytes(STRING_ENCODING), salt, 2);
                byte[] clearBytes = cipher.doFinal(encryptedBytes);
                return new String(clearBytes, STRING_ENCODING);
            }
            catch (Exception e) {
                throw new CipherException("Error decrypting", e);
            }
        }

        private Cipher createCipher(byte[] pwdAsBytes, byte[] salt, int mode) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
            MessageDigest _digester = MessageDigest.getInstance(DIGEST_ALG);
            byte[] keyAndIv = new byte[32];
            if (salt == null || salt.length == 0) {
                salt = null;
            }
            int currentPos = 0;
            while (currentPos < keyAndIv.length) {
                int stillNeed;
                byte[] result;
                _digester.update(pwdAsBytes);
                if (salt != null) {
                    _digester.update(salt, 0, 8);
                }
                if ((result = _digester.digest()).length > (stillNeed = keyAndIv.length - currentPos)) {
                    byte[] b = new byte[stillNeed];
                    System.arraycopy(result, 0, b, 0, b.length);
                    result = b;
                }
                System.arraycopy(result, 0, keyAndIv, currentPos, result.length);
                if ((currentPos += result.length) >= keyAndIv.length) continue;
                _digester.reset();
                _digester.update(result);
            }
            byte[] key = new byte[16];
            byte[] iv = new byte[16];
            System.arraycopy(keyAndIv, 0, key, 0, key.length);
            System.arraycopy(keyAndIv, key.length, iv, 0, iv.length);
            Cipher cipher = Cipher.getInstance(CIPHER_ALG);
            cipher.init(mode, (Key)new SecretKeySpec(key, KEY_ALG), new IvParameterSpec(iv));
            return cipher;
        }
    }
}

