/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.parameter;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.nifi.parameter.AbstractParameterParser;
import org.apache.nifi.parameter.ParameterParser;
import org.apache.nifi.parameter.ParameterToken;
import org.apache.nifi.parameter.ParameterTokenList;
import org.apache.nifi.parameter.StandardParameterTokenList;

public class ExpressionLanguageAwareParameterParser
extends AbstractParameterParser
implements ParameterParser {
    private static final char DOLLAR_SIGN = '$';

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public ParameterTokenList parseTokens(String input) {
        if (input == null || input.isEmpty()) {
            return new StandardParameterTokenList(input, Collections.emptyList());
        }
        ArrayList<ParameterToken> tokens = new ArrayList<ParameterToken>();
        int sequentialStartTags = 0;
        boolean oddDollarCount = false;
        int lastChar = 0;
        int embeddedElCount = 0;
        int expressionStart = -1;
        int i = 0;
        while (true) {
            block14: {
                if (i >= input.length()) {
                    return new StandardParameterTokenList(input, tokens);
                }
                char c = input.charAt(i);
                switch (c) {
                    case '#': {
                        ++sequentialStartTags;
                        break;
                    }
                    case '{': {
                        if (oddDollarCount && lastChar == 36 && embeddedElCount == 0) {
                            expressionStart = i - 1;
                        }
                        if (expressionStart > -1) {
                            ++embeddedElCount;
                            break block14;
                        } else {
                            ParameterToken token;
                            if (sequentialStartTags <= 0 || (token = this.parseParameterToken(input, i, sequentialStartTags, tokens)) == null) break;
                            i = token.getEndOffset();
                            break;
                        }
                    }
                    case '}': {
                        if (embeddedElCount > 0) {
                            if (--embeddedElCount != 0) break;
                            expressionStart = -1;
                            oddDollarCount = false;
                            break;
                        }
                        break block14;
                    }
                    case '$': {
                        oddDollarCount = !oddDollarCount;
                    }
                }
                if (c != '#') {
                    sequentialStartTags = 0;
                }
                lastChar = c;
            }
            ++i;
        }
    }
}

