/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class FilterStringGroupColLessEqualStringGroupColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private final int colNum1;
    private final int colNum2;

    public FilterStringGroupColLessEqualStringGroupColumn(int colNum1, int colNum2) {
        this.colNum1 = colNum1;
        this.colNum2 = colNum2;
    }

    public FilterStringGroupColLessEqualStringGroupColumn() {
        this.colNum1 = -1;
        this.colNum2 = -1;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        BytesColumnVector inputColVector1 = (BytesColumnVector)batch.cols[this.colNum1];
        BytesColumnVector inputColVector2 = (BytesColumnVector)batch.cols[this.colNum2];
        int[] sel = batch.selected;
        boolean[] nullPos1 = inputColVector1.isNull;
        boolean[] nullPos2 = inputColVector2.isNull;
        byte[][] vector1 = inputColVector1.vector;
        byte[][] vector2 = inputColVector2.vector;
        int[] start1 = inputColVector1.start;
        int[] start2 = inputColVector2.start;
        int[] length1 = inputColVector1.length;
        int[] length2 = inputColVector2.length;
        if (inputColVector1.noNulls && inputColVector2.noNulls) {
            if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
                if (StringExpr.compare((byte[])vector1[0], (int)start1[0], (int)length1[0], (byte[])vector2[0], (int)start2[0], (int)length2[0]) > 0) {
                    batch.size = 0;
                }
            } else if (inputColVector1.isRepeating) {
                if (batch.selectedInUse) {
                    int newSize = 0;
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        if (StringExpr.compare((byte[])vector1[0], (int)start1[0], (int)length1[0], (byte[])vector2[i], (int)start2[i], (int)length2[i]) > 0) continue;
                        sel[newSize++] = i;
                    }
                    batch.size = newSize;
                } else {
                    int newSize = 0;
                    for (int i = 0; i != n; ++i) {
                        if (StringExpr.compare((byte[])vector1[0], (int)start1[0], (int)length1[0], (byte[])vector2[i], (int)start2[i], (int)length2[i]) > 0) continue;
                        sel[newSize++] = i;
                    }
                    if (newSize < batch.size) {
                        batch.size = newSize;
                        batch.selectedInUse = true;
                    }
                }
            } else if (inputColVector2.isRepeating) {
                if (batch.selectedInUse) {
                    int newSize = 0;
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        if (StringExpr.compare((byte[])vector1[i], (int)start1[i], (int)length1[i], (byte[])vector2[0], (int)start2[0], (int)length2[0]) > 0) continue;
                        sel[newSize++] = i;
                    }
                    batch.size = newSize;
                } else {
                    int newSize = 0;
                    for (int i = 0; i != n; ++i) {
                        if (StringExpr.compare((byte[])vector1[i], (int)start1[i], (int)length1[i], (byte[])vector2[0], (int)start2[0], (int)length2[0]) > 0) continue;
                        sel[newSize++] = i;
                    }
                    if (newSize < batch.size) {
                        batch.size = newSize;
                        batch.selectedInUse = true;
                    }
                }
            } else if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (StringExpr.compare((byte[])vector1[i], (int)start1[i], (int)length1[i], (byte[])vector2[i], (int)start2[i], (int)length2[i]) > 0) continue;
                    sel[newSize++] = i;
                }
                batch.size = newSize;
            } else {
                int newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (StringExpr.compare((byte[])vector1[i], (int)start1[i], (int)length1[i], (byte[])vector2[i], (int)start2[i], (int)length2[i]) > 0) continue;
                    sel[newSize++] = i;
                }
                if (newSize < batch.size) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (inputColVector1.noNulls) {
            if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
                if (nullPos2[0] || StringExpr.compare((byte[])vector1[0], (int)start1[0], (int)length1[0], (byte[])vector2[0], (int)start2[0], (int)length2[0]) > 0) {
                    batch.size = 0;
                }
            } else if (inputColVector1.isRepeating) {
                if (batch.selectedInUse) {
                    int newSize = 0;
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        if (nullPos2[i] || StringExpr.compare((byte[])vector1[0], (int)start1[0], (int)length1[0], (byte[])vector2[i], (int)start2[i], (int)length2[i]) > 0) continue;
                        sel[newSize++] = i;
                    }
                    batch.size = newSize;
                } else {
                    int newSize = 0;
                    for (int i = 0; i != n; ++i) {
                        if (nullPos2[i] || StringExpr.compare((byte[])vector1[0], (int)start1[0], (int)length1[0], (byte[])vector2[i], (int)start2[i], (int)length2[i]) > 0) continue;
                        sel[newSize++] = i;
                    }
                    if (newSize < batch.size) {
                        batch.size = newSize;
                        batch.selectedInUse = true;
                    }
                }
            } else if (inputColVector2.isRepeating) {
                if (nullPos2[0]) {
                    batch.size = 0;
                    return;
                }
                if (batch.selectedInUse) {
                    int newSize = 0;
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        if (StringExpr.compare((byte[])vector1[i], (int)start1[i], (int)length1[i], (byte[])vector2[0], (int)start2[0], (int)length2[0]) > 0) continue;
                        sel[newSize++] = i;
                    }
                    batch.size = newSize;
                } else {
                    int newSize = 0;
                    for (int i = 0; i != n; ++i) {
                        if (StringExpr.compare((byte[])vector1[i], (int)start1[i], (int)length1[i], (byte[])vector2[0], (int)start2[0], (int)length2[0]) > 0) continue;
                        sel[newSize++] = i;
                    }
                    if (newSize < batch.size) {
                        batch.size = newSize;
                        batch.selectedInUse = true;
                    }
                }
            } else if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (nullPos2[i] || StringExpr.compare((byte[])vector1[i], (int)start1[i], (int)length1[i], (byte[])vector2[i], (int)start2[i], (int)length2[i]) > 0) continue;
                    sel[newSize++] = i;
                }
                batch.size = newSize;
            } else {
                int newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (nullPos2[i] || StringExpr.compare((byte[])vector1[i], (int)start1[i], (int)length1[i], (byte[])vector2[i], (int)start2[i], (int)length2[i]) > 0) continue;
                    sel[newSize++] = i;
                }
                if (newSize < batch.size) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (inputColVector2.noNulls) {
            if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
                if (nullPos1[0] || StringExpr.compare((byte[])vector1[0], (int)start1[0], (int)length1[0], (byte[])vector2[0], (int)start2[0], (int)length2[0]) > 0) {
                    batch.size = 0;
                    return;
                }
            } else if (inputColVector1.isRepeating) {
                if (nullPos1[0]) {
                    batch.size = 0;
                    return;
                }
                if (batch.selectedInUse) {
                    int newSize = 0;
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        if (StringExpr.compare((byte[])vector1[0], (int)start1[0], (int)length1[0], (byte[])vector2[i], (int)start2[i], (int)length2[i]) > 0) continue;
                        sel[newSize++] = i;
                    }
                    batch.size = newSize;
                } else {
                    int newSize = 0;
                    for (int i = 0; i != n; ++i) {
                        if (StringExpr.compare((byte[])vector1[0], (int)start1[0], (int)length1[0], (byte[])vector2[i], (int)start2[i], (int)length2[i]) > 0) continue;
                        sel[newSize++] = i;
                    }
                    if (newSize < batch.size) {
                        batch.size = newSize;
                        batch.selectedInUse = true;
                    }
                }
            } else if (inputColVector2.isRepeating) {
                if (batch.selectedInUse) {
                    int newSize = 0;
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        if (nullPos1[i] || StringExpr.compare((byte[])vector1[i], (int)start1[i], (int)length1[i], (byte[])vector2[0], (int)start2[0], (int)length2[0]) > 0) continue;
                        sel[newSize++] = i;
                    }
                    batch.size = newSize;
                } else {
                    int newSize = 0;
                    for (int i = 0; i != n; ++i) {
                        if (nullPos1[i] || StringExpr.compare((byte[])vector1[i], (int)start1[i], (int)length1[i], (byte[])vector2[0], (int)start2[0], (int)length2[0]) > 0) continue;
                        sel[newSize++] = i;
                    }
                    if (newSize < batch.size) {
                        batch.size = newSize;
                        batch.selectedInUse = true;
                    }
                }
            } else if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (nullPos1[i] || StringExpr.compare((byte[])vector1[i], (int)start1[i], (int)length1[i], (byte[])vector2[i], (int)start2[i], (int)length2[i]) > 0) continue;
                    sel[newSize++] = i;
                }
                batch.size = newSize;
            } else {
                int newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (nullPos1[i] || StringExpr.compare((byte[])vector1[i], (int)start1[i], (int)length1[i], (byte[])vector2[i], (int)start2[i], (int)length2[i]) > 0) continue;
                    sel[newSize++] = i;
                }
                if (newSize < batch.size) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
            if (nullPos1[0] || nullPos2[0] || StringExpr.compare((byte[])vector1[0], (int)start1[0], (int)length1[0], (byte[])vector2[0], (int)start2[0], (int)length2[0]) > 0) {
                batch.size = 0;
            }
        } else if (inputColVector1.isRepeating) {
            if (nullPos1[0]) {
                batch.size = 0;
                return;
            }
            if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (nullPos2[i] || StringExpr.compare((byte[])vector1[0], (int)start1[0], (int)length1[0], (byte[])vector2[i], (int)start2[i], (int)length2[i]) > 0) continue;
                    sel[newSize++] = i;
                }
                batch.size = newSize;
            } else {
                int newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (nullPos2[i] || StringExpr.compare((byte[])vector1[0], (int)start1[0], (int)length1[0], (byte[])vector2[i], (int)start2[i], (int)length2[i]) > 0) continue;
                    sel[newSize++] = i;
                }
                if (newSize < batch.size) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (inputColVector2.isRepeating) {
            if (nullPos2[0]) {
                batch.size = 0;
                return;
            }
            if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (nullPos1[i] || StringExpr.compare((byte[])vector1[i], (int)start1[i], (int)length1[i], (byte[])vector2[0], (int)start2[0], (int)length2[0]) > 0) continue;
                    sel[newSize++] = i;
                }
                batch.size = newSize;
            } else {
                int newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (nullPos1[i] || StringExpr.compare((byte[])vector1[i], (int)start1[i], (int)length1[i], (byte[])vector2[0], (int)start2[0], (int)length2[0]) > 0) continue;
                    sel[newSize++] = i;
                }
                if (newSize < batch.size) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (batch.selectedInUse) {
            int newSize = 0;
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (nullPos1[i] || nullPos2[i] || StringExpr.compare((byte[])vector1[i], (int)start1[i], (int)length1[i], (byte[])vector2[i], (int)start2[i], (int)length2[i]) > 0) continue;
                sel[newSize++] = i;
            }
            batch.size = newSize;
        } else {
            int newSize = 0;
            for (int i = 0; i != n; ++i) {
                if (nullPos1[i] || nullPos2[i] || StringExpr.compare((byte[])vector1[i], (int)start1[i], (int)length1[i], (byte[])vector2[i], (int)start2[i], (int)length2[i]) > 0) continue;
                sel[newSize++] = i;
            }
            if (newSize < batch.size) {
                batch.size = newSize;
                batch.selectedInUse = true;
            }
        }
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.colNum1) + ", " + this.getColumnParamString(1, this.colNum2);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.FILTER).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.STRING_FAMILY, VectorExpressionDescriptor.ArgumentType.STRING_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

